; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_DATA         SEGMENT  DATA

              PUBLIC   Address
              PUBLIC   D
              PUBLIC   Ad

              PUBLIC   Check_EEPROM_Status
              PUBLIC   WriteByteToEEPROM
              PUBLIC   ReadByteFromEEPROM
              PUBLIC   ReadBytesFromEEPROM

; {
;     This file is part of the Turbo51 examples.
;     Copyright (C) 2008 - 2011 by Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit E24C32;
; 
; Interface
; 
; Uses I2C;
              EXTRN    DATA  (Data2Send)
              EXTRN    BIT   (Ack)

              EXTRN    CODE  (Start_I2C)
              EXTRN    CODE  (Send_I2C_Byte)
              EXTRN    CODE  (Stop_I2C)
              EXTRN    CODE  (Receive_I2C_Byte)
              EXTRN    CODE  (Send_I2C_Ack)
              EXTRN    CODE  (Send_I2C_ClockPulse)

; 
; Procedure Check_EEPROM_Status;
; Procedure WriteByteToEEPROM (Address: Word; D: Byte);

RSEG _DATA

Address:                        DS       2
D:                              DS       1

; Function ReadByteFromEEPROM (Ad: Word): Byte;
ReadByteFromEEPROM_Result:      DS       1
Ad:                             DS       2

; Function ReadBytesFromEEPROM: LongInt;
ReadBytesFromEEPROM_Result:     DS       4

; 
; Implementation
; 
; Const I2C_24C32 = $A2;

RSEG _CONST

; 
; Procedure Check_EEPROM_Status;
; Var EEPROM_Counter: Word;

RSEG _DATA

EEPROM_Counter:                 DS       2

USING 0

Check_EEPROM_Status:
; begin
;   For EEPROM_Counter := 1 to 2000 do
              CLR       A
              MOV       R4, A
              MOV       R5, A
L_0003:
              INC       R4
              CJNE      R4, #0, L_0008
              INC       R5
L_0008:

;     begin
;       Start_I2C;
              LCALL     Start_I2C

;       Send_I2C_Byte (I2C_24C32);
              MOV       Data2Send, #$A2
              LCALL     Send_I2C_Byte

;       If Ack then Exit;
              JB        Ack, L_001C

;       Asm
;         NOP
              NOP

;         NOP
              NOP

;       end;
;     end;
              CJNE      R4, #LOW  ($07D0), L_0003
              CJNE      R5, #HIGH ($07D0), L_0003

; end;
L_001C:
              RET

; 
; Procedure WriteByteToEEPROM (Address: Word; D: Byte);

WriteByteToEEPROM:
; begin
;   Check_EEPROM_Status;
              LCALL     Check_EEPROM_Status

;   Send_I2C_Byte (Hi (Address));
              MOV       Data2Send, Address+1
              LCALL     Send_I2C_Byte

;   Send_I2C_Byte (Lo (Address));
              MOV       Data2Send, Address
              LCALL     Send_I2C_Byte

;   Send_I2C_Byte (D);
              MOV       Data2Send, D
              LCALL     Send_I2C_Byte

;   Stop_I2C;
              LJMP      Stop_I2C

; end;
; 
; Function ReadByteFromEEPROM (Ad: Word): Byte;

ReadByteFromEEPROM:
; begin
;   Check_EEPROM_Status;
              LCALL     Check_EEPROM_Status

;   Send_I2C_Byte (Hi (Ad));
              MOV       Data2Send, Ad+1
              LCALL     Send_I2C_Byte

;   Send_I2C_Byte (Lo (Ad));
              MOV       Data2Send, Ad
              LCALL     Send_I2C_Byte

;   Start_I2C;
              LCALL     Start_I2C

;   Send_I2C_Byte (I2C_24C32 or $01);
              MOV       Data2Send, #$A3
              LCALL     Send_I2C_Byte

;   ReadByteFromEEPROM := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       ReadByteFromEEPROM_Result, A

;   Stop_I2C;
              LCALL     Stop_I2C

; end;
              MOV       A, ReadByteFromEEPROM_Result
              RET

; 
; Function ReadBytesFromEEPROM: LongInt; Assembler;

ReadBytesFromEEPROM:
; Asm
;   LCALL     Check_EEPROM_Status
              LCALL     Check_EEPROM_Status

; 
;   MOV       Send_I2C_Byte.Data2Send, DPH
              MOV       Send_I2C_Byte.Data2Send, DPH

;   LCALL     Send_I2C_Byte
              LCALL     Send_I2C_Byte

; 
;   MOV       Send_I2C_Byte.Data2Send, DPL
              MOV       Send_I2C_Byte.Data2Send, DPL

;   LCALL     Send_I2C_Byte
              LCALL     Send_I2C_Byte

; 
;   LCALL     Start_I2C
              LCALL     Start_I2C

; 
;   MOV       Send_I2C_Byte.Data2Send, #0A3H
              MOV       Send_I2C_Byte.Data2Send, #$A3

;   LCALL     Send_I2C_Byte
              LCALL     Send_I2C_Byte

; 
;   LCALL     Receive_I2C_Byte
              LCALL     Receive_I2C_Byte

;   MOV       R0, A
              MOV       R0, A

;   LCALL     Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   LCALL     Receive_I2C_Byte
              LCALL     Receive_I2C_Byte

;   MOV       R1, A
              MOV       R1, A

;   LCALL     Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   LCALL     Receive_I2C_Byte
              LCALL     Receive_I2C_Byte

;   MOV       R4, A
              MOV       R4, A

;   LCALL     Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   LCALL     Receive_I2C_Byte
              LCALL     Receive_I2C_Byte

;   MOV       R5, A
              MOV       R5, A

;   LCALL     Send_I2C_ClockPulse;
              LCALL     Send_I2C_ClockPulse

;   MOV       R2, AR0
              MOV       R2, AR0

;   MOV       R3, AR1
              MOV       R3, AR1

; 
;   LCALL     Stop_I2C
              LCALL     Stop_I2C

; end;
              RET

RSEG _CONST

; 
; end.

              END

