{
    This file is part of the Turbo51 examples.
    Copyright (C) 2008 - 2011 by Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit E24C32;

Interface

Uses I2C;

Procedure Check_EEPROM_Status;
Procedure WriteByteToEEPROM (Address: Word; D: Byte);
Function ReadByteFromEEPROM (Ad: Word): Byte;
Function ReadBytesFromEEPROM: LongInt;

Implementation

Const I2C_24C32 = $A2;

Procedure Check_EEPROM_Status;
Var EEPROM_Counter: Word;
begin
  For EEPROM_Counter := 1 to 2000 do
    begin
      Start_I2C;
      Send_I2C_Byte (I2C_24C32);
      If Ack then Exit;
      Asm
        NOP
        NOP
      end;
    end;
end;

Procedure WriteByteToEEPROM (Address: Word; D: Byte);
begin
  Check_EEPROM_Status;
  Send_I2C_Byte (Hi (Address));
  Send_I2C_Byte (Lo (Address));
  Send_I2C_Byte (D);
  Stop_I2C;
end;

Function ReadByteFromEEPROM (Ad: Word): Byte;
begin
  Check_EEPROM_Status;
  Send_I2C_Byte (Hi (Ad));
  Send_I2C_Byte (Lo (Ad));
  Start_I2C;
  Send_I2C_Byte (I2C_24C32 or $01);
  ReadByteFromEEPROM := Receive_I2C_Byte;
  Stop_I2C;
end;

Function ReadBytesFromEEPROM: LongInt; Assembler;
Asm
  LCALL     Check_EEPROM_Status

  MOV       Send_I2C_Byte.Data2Send, DPH
  LCALL     Send_I2C_Byte

  MOV       Send_I2C_Byte.Data2Send, DPL
  LCALL     Send_I2C_Byte

  LCALL     Start_I2C

  MOV       Send_I2C_Byte.Data2Send, #0A3H
  LCALL     Send_I2C_Byte

  LCALL     Receive_I2C_Byte
  MOV       R0, A
  LCALL     Send_I2C_Ack;
  LCALL     Receive_I2C_Byte
  MOV       R1, A
  LCALL     Send_I2C_Ack;
  LCALL     Receive_I2C_Byte
  MOV       R4, A
  LCALL     Send_I2C_Ack;
  LCALL     Receive_I2C_Byte
  MOV       R5, A
  LCALL     Send_I2C_ClockPulse;
  MOV       R2, AR0
  MOV       R3, AR1

  LCALL     Stop_I2C
end;

end.
