; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0, 1, 2, 3)

_CODE         SEGMENT  CODE
_CONST        SEGMENT  CODE
_DATA         SEGMENT  DATA
_IDATA        SEGMENT  IDATA
_BIT          SEGMENT  BIT

              PUBLIC   SCL
              PUBLIC   SDA

              EXTRN    DATA  (R8)
              EXTRN    IDATA (StackStart)

              EXTRN    CODE  (sysDecWord_IDATA)
              EXTRN    CODE  (sysWordMultiplication)
              EXTRN    CODE  (sysIncWord_IDATA_R3R2)
              EXTRN    CODE  (sysIncWord_IDATA)
              EXTRN    CODE  (sysWordShiftRight)
              EXTRN    CODE  (sysWordDivision)

; {
;     This file is part of the Turbo51 examples.
;     Copyright (C) 2008 - 2011 by Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; {$IDATA }
; 
; Program Example3;
; 
; Uses I2C, E24C32;
              EXTRN    DATA  (Ad)
              EXTRN    DATA  (Address)
              EXTRN    DATA  (D)

              EXTRN    CODE  (ReadByteFromEEPROM)
              EXTRN    CODE  (WriteByteToEEPROM)
              EXTRN    CODE  (ReadBytesFromEEPROM)

; 
; Type  Word_ = Record
;                 Case Boolean of
;                   True:  (L: Byte; H: Byte);
;                   False: (W: Word);
;               end;
; 
;       LongInt_ = Record
;                    Case Boolean of
;                      True:  (WL: Word_; WH: Word_);
;                      False: (L: LongInt);
;                  end;
; 
; 
;      TEEprom = Record
;                  EE_Signature:             Word; {  2 Bytes }
;                  EE_NumberOfLearnedKeysLo: Byte; {  1 Byte  }
;                  EE_ModuleAddress:         Byte; {  1 Byte  }
;                  EE_RelayTime:             Array [1..4] of Word_; {  4 * 2 Bytes }
;                  EE_ModuleType:            Byte; {  1 byte  }
;                  EE_ModuleFlags:           Byte; {  1 byte  }
;                  EE_Spare1:                Word; {  2 bytes }
;                  EE_ChannelConfig:         Array [1..15] of Byte; {  15 bytes }
;                  EE_NumberOfLearnedKeysHi: Byte; {  1 byte  }
;                  EE_TXKeyData:             Byte;
;                end;
; 
;      TxData = Record
;                 tdKey:          Array [0..7] of Byte;
;                 tdSerialNumber: Array [0..3] of Byte;
;                 tdCounter:      Word_;
;               end;
; 
; Const VersionHi = $01;

RSEG _CONST

;       VersionLo = $00;
; 
;       Signature = $FECA;
; 
;       Greeting = 'TURBO51'#0;
;       GreetingString: Array [0..Length (Greeting) - 1] of Char = Greeting;
GreetingString:                 DB        'TURBO51', 0
; 
;       ManufacturerKeyData: Array [0..7] of Byte = ($CA, $FE, $00, $00, $03, $3D, $B5, $CA);
ManufacturerKeyData:            DB        $CA                         ; $CA = 202
                                DB        $FE                         ; $FE = 254
                                DB        0                           ; $00 = 0
                                DB        0                           ; $00 = 0
                                DB        3                           ; $03 = 3
                                DB        $3D                         ; $3D = 61
                                DB        $B5                         ; $B5 = 181
                                DB        $CA                         ; $CA = 202
; 
;       TimerConst = $C7AF;
;       Const1ms   = $F8CD;
; 
;       BaudRateTimerValue = Word (- 22118400 div 32 div 9600);
; 
;       LedTime         =    30;
;       RS485_Time      =     2;
;       SetupTime       = 30000;
;       NoKeyTime       =   100;
; 
;       DafaultRelayLongPulseTime  =   30000 div 32;
;       DafaultLightPulseTime      = 1800000 div 32;
;       DefaultRelayShortPulseTime =     384 div 32;
;       DefaultRelayOffPulseTime   =    1500 div 32;
; 
;       Relay_ON  = LowLevel;
;       Relay_OFF = HighLevel;
; 
;       MotorUp = 1;
;       MotorDown = 0;
; 
;       Segments: Array [' '..'U'] of Byte = (
Segments:                       
;         %00000000, { ' ' }
                                DB        0                           ; $00 = 0
;         %00000000, { '!' }
                                DB        0                           ; $00 = 0
;         %00100010, { '"' }
                                DB        $22                         ; $22 = 34
;         %00000000, { '#' }
                                DB        0                           ; $00 = 0
;         %00000000, { '$' }
                                DB        0                           ; $00 = 0
;         %00000000, { '%' }
                                DB        0                           ; $00 = 0
;         %00000000, { '&' }
                                DB        0                           ; $00 = 0
;         %00000000, { ''' }
                                DB        0                           ; $00 = 0
;         %00111001, { '(' }
                                DB        $39                         ; $39 = 57
;         %00001111, { ')' }
                                DB        $0F                         ; $0F = 15
;         %00000000, { '*' }
                                DB        0                           ; $00 = 0
;         %00000000, { '+' }
                                DB        0                           ; $00 = 0
;         %00000000, { ',' }
                                DB        0                           ; $00 = 0
;         %01000000, { '-' }
                                DB        $40                         ; $40 = 64
;         %00000000, { '.' }
                                DB        0                           ; $00 = 0
;         %01001001, { '/' }
                                DB        $49                         ; $49 = 73
;         %00111111, { '0' }
                                DB        $3F                         ; $3F = 63
;         %00000110, { '1' }
                                DB        6                           ; $06 = 6
;         %01011011, { '2' }
                                DB        $5B                         ; $5B = 91
;         %01001111, { '3' }
                                DB        $4F                         ; $4F = 79
;         %01100110, { '4' }
                                DB        $66                         ; $66 = 102
;         %01101101, { '5' }
                                DB        $6D                         ; $6D = 109
;         %01111101, { '6' }
                                DB        $7D                         ; $7D = 125
;         %00100111, { '7' }
                                DB        $27                         ; $27 = 39
;         %01111111, { '8' }
                                DB        $7F                         ; $7F = 127
;         %01101111, { '9' }
                                DB        $6F                         ; $6F = 111
;         %00000000, { ':' }
                                DB        0                           ; $00 = 0
;         %00000000, { ';' }
                                DB        0                           ; $00 = 0
;         %00000000, { '<' }
                                DB        0                           ; $00 = 0
;         %01001000, { '=' }
                                DB        $48                         ; $48 = 72
;         %00000000, { '>' }
                                DB        0                           ; $00 = 0
;         %00000000, { '?' }
                                DB        0                           ; $00 = 0
;         %00000000, { '@' }
                                DB        0                           ; $00 = 0
;         %01110111, { 'A' }
                                DB        $77                         ; $77 = 119
;         %01111100, { 'B' }
                                DB        $7C                         ; $7C = 124
;         %00111001, { 'C' }
                                DB        $39                         ; $39 = 57
;         %01011110, { 'D' }
                                DB        $5E                         ; $5E = 94
;         %01111001, { 'E' }
                                DB        $79                         ; $79 = 121
;         %01110001, { 'F' }
                                DB        $71                         ; $71 = 113
;         %00000000, { 'G' }
                                DB        0                           ; $00 = 0
;         %01110110, { 'H' }
                                DB        $76                         ; $76 = 118
;         %00000000, { 'I' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'J' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'K' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'L' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'M' }
                                DB        0                           ; $00 = 0
;         %01010100, { 'N' }
                                DB        $54                         ; $54 = 84
;         %01011100, { 'O' }
                                DB        $5C                         ; $5C = 92
;         %01110011, { 'P' }
                                DB        $73                         ; $73 = 115
;         %01010111, { 'Q' }
                                DB        $57                         ; $57 = 87
;         %01010000, { 'R' }
                                DB        $50                         ; $50 = 80
;         %01101101, { 'S' }
                                DB        $6D                         ; $6D = 109
;         %01111000, { 'T' }
                                DB        $78                         ; $78 = 120
;         %00011100);{ 'U' }
                                DB        $1C                         ; $1C = 28
; 
;       HexChar: Array [0..15] of Char = '0123456789ABCDEF';
HexChar:                        DB        '0123456789ABCDEF'
; 
;       BlockStart = $AA;
;       BlockStartLNG = $CA;
; 
;       bpBlockStart         = 0;
;       bpDestinationAddress = 1;
;       bpcommand            = 2;
;       bpParameter1         = 3;
;       bpParameter2         = 4;
;       bpSourceAddress      = 5;
;       bpChecksum           = 6;
; 
;       bpParameter3         = 7;
;       bpParameter4         = 8;
;       bpParameter5         = 9;
;       bpParameter6         = 10;
;       bpParameter7         = 11;
;       bpParameter8         = 12;
;       bpParameter9         = 13;
;       bpParameter10        = 14;
;       bpParameter11        = 15;
;       bpParameter12        = 16;
; 
;       LNG_ModuleID         = $A0;
; 
;       Cmd_Relay                 = $21;
;       Cmd_RelayTime             = $22;
;       Cmd_GetData               = $31;
;       Cmd_StatusRequest         = $40;
;       Cmd_Status                = $41;
;       Cmd_SoftwareVersion       = $4F;
;       Cmd_ActivateOutput        = $54;
;       Cmd_ChangeAddress         = $55;
;       Cmd_LNG_Tx                = $57;
;       Cmd_LearnLNG_Tx           = $58;
;       Cmd_Cfg                   = $59;
; 
; Type  Bits64 = Array [0..7] of Byte;
;       Bits32 = Array [0..3] of Byte;
; 
;       TXKeyData = Record
;                     DecriptionKey: Bits64;
;                     SerialNum: Bits32;
;                     KeyCounter: Word;
;                   end;
; 
;       TSetup = (None, LearnKey, LearnKey2, SetModuleType, SetChannel, SetChannelType, SetTxKey, SetBlindsMode, SetTime);
; 
;       TBlindsMode = (bmNone, bmCh12, bmCh34, bmCh1234);
; 
;       TKbd = (kNone, kEnter, kCancel, kUp, kDown);
; 
;       TChType = (chFollow, chToggle, chPulse);
; 
;       TModuleType = (mtNormal, mtCrawford, mtDoor, mtAlarm);
; 
;       TModuleFlags = (mfBlinds12, mfBlinds34);
; 
;       TBlindsState = (bsIdle, bsOut1, bsIdleBetween, bsOut2);
; 
;       TModuleFlagsSet = Set of TModuleFlags;
; 
;       TDoorState = (dsStop, dsUp, dsDown);
; 
; Const KeyTable: Array [kNone..kDown] of Byte = (
KeyTable:                       
;         $0F,
                                DB        $0F                         ; $0F = 15
;         $07,
                                DB        7                           ; $07 = 7
;         $0B,
                                DB        $0B                         ; $0B = 11
;         $0D,
                                DB        $0D                         ; $0D = 13
;         $0E);
                                DB        $0E                         ; $0E = 14
; 
; Var   RS485_TX:         Boolean absolute P3.3; Volatile;
RS485_TX                        BIT      P3.3

;       I2C.SCL:          Boolean absolute P3.4; Volatile;
SCL                             BIT      P3.4

;       I2C.SDA:          Boolean absolute P3.5; Volatile;
SDA                             BIT      P3.5

;       Strobe:           Boolean absolute P3.6; Volatile;
Strobe                          BIT      P3.6

;       Key_Down:         Boolean absolute P2.0; Volatile;
Key_Down                        BIT      P2.0

;       Key_Up:           Boolean absolute P2.1; Volatile;
Key_Up                          BIT      P2.1

;       Key_Cancel:       Boolean absolute P2.2; Volatile;
Key_Cancel                      BIT      P2.2

;       Key_Enter:        Boolean absolute P2.3; Volatile;
Key_Enter                       BIT      P2.3

;       IN5:              Boolean absolute P2.5; Volatile;
IN5                             BIT      P2.5

;       IN6:              Boolean absolute P2.7; Volatile;
IN6                             BIT      P2.7

;       Aux_Strobe:       Boolean absolute P0.2; Volatile;
Aux_Strobe                      BIT      P0.2

;       Aux_SDA:          Boolean absolute P0.1; Volatile;
Aux_SDA                         BIT      P0.1

;       Aux_SCL:          Boolean absolute P0.0; Volatile;
Aux_SCL                         BIT      P0.0

;       IN1:              Boolean absolute P1.0; Volatile;
IN1                             BIT      P1.0

;       IN2:              Boolean absolute P1.1; Volatile;
IN2                             BIT      P1.1

;       IN3:              Boolean absolute P1.2; Volatile;
IN3                             BIT      P1.2

;       IN4:              Boolean absolute P1.3; Volatile;
IN4                             BIT      P1.3

;       OUT1:             Boolean absolute P1.6; Volatile;
OUT1                            BIT      P1.6

;       OUT2:             Boolean absolute P1.4; Volatile;
OUT2                            BIT      P1.4

;       OUT3:             Boolean absolute P1.7; Volatile;
OUT3                            BIT      P1.7

;       OUT4:             Boolean absolute P1.5; Volatile;
OUT4                            BIT      P1.5

;       RF_Data:          Boolean absolute P3.2; Volatile;
RF_Data                         BIT      P3.2

;       AuxModule:        Boolean absolute P2.4; Volatile;
AuxModule                       BIT      P2.4

;       WatchDogReset:    Boolean absolute SCL;  Volatile;
WatchDogReset                   BIT      P3.4

;       AutoSaveDisabled: Boolean absolute IN5;
AutoSaveDisabled                BIT      P2.5

;       CounterCheck:     Boolean absolute IN6;
CounterCheck                    BIT      P2.7

; 
;       T2CON:    Byte absolute $C8; Volatile;
T2CON                           EQU      $C8

;       T2MOD:    Byte absolute $C9; Volatile;
T2MOD                           EQU      $C9

;       RCAP2L:   Byte absolute $CA; Volatile;
RCAP2L                          EQU      $CA

;       RCAP2H:   Byte absolute $CB; Volatile;
RCAP2H                          EQU      $CB

;       TL2:      Byte absolute $CC; Volatile;
TL2                             EQU      $CC

;       TH2:      Byte absolute $CD; Volatile;
TH2                             EQU      $CD

; 
;     { T2CON }
;       TF2:      Boolean absolute T2CON.7; Volatile;
TF2                             BIT      $C8.7

;       EXF2:     Boolean absolute T2CON.6; Volatile;
EXF2                            BIT      $C8.6

;       RCLK:     Boolean absolute T2CON.5; Volatile;
RCLK                            BIT      $C8.5

;       TCLK:     Boolean absolute T2CON.4; Volatile;
TCLK                            BIT      $C8.4

;       EXEN2:    Boolean absolute T2CON.3; Volatile;
EXEN2                           BIT      $C8.3

;       TR2:      Boolean absolute T2CON.2; Volatile;
TR2                             BIT      $C8.2

;       C_T2:     Boolean absolute T2CON.1; Volatile;
C_T2                            BIT      $C8.1

;       CP_RL2:   Boolean absolute T2CON.0; Volatile;
CP_RL2                          BIT      $C8.0

; 
;     { IE}
;       ET2:      Boolean absolute IE.5; Volatile;
ET2                             BIT      IE.5

; 
;     { IP }
;       PT2:      Boolean absolute IP.5; Volatile;
PT2                             BIT      IP.5

; 
;     { P1 }
;       T2EX:     Boolean absolute P1.1; Volatile;
T2EX                            BIT      P1.1

;       T2:       Boolean absolute P1.0; Volatile;
T2                              BIT      P1.0

; 
;       NewBit,
;       KeyPacketReceived:          Boolean;

RSEG _BIT

NewBit:                         DBIT     1
KeyPacketReceived:              DBIT     1

;       Timer:                      Word_; Volatile;

RSEG _DATA

Timer:                          DS       2

;       TempWord:                   Word_;
TempWord:                       DS       2

;       TempCounter:                Word_;
TempCounter:                    DS       2

;       TempByte:                   Byte;
TempByte:                       DS       1

;       BitCounter:                 Byte;
BitCounter:                     DS       1

;       TE:                         Word_ IDATA;

RSEG _IDATA

TE:                             DS       2

;       CounterDifference:          Word_ absolute TE;
CounterDifference               EQU      TE

;       EncryptedCode:              Bits32 IDATA;
EncryptedCode:                  DS       4

;       SerialNumber:               Bits32 IDATA;
SerialNumber:                   DS       4

;       DataByte:                   Bits64 absolute EncryptedCode;
DataByte                        EQU      EncryptedCode

;       Counter:                    Word_  absolute EncryptedCode;
Counter                         EQU      EncryptedCode

;       Key:                        Bits64 IDATA;
Key:                            DS       8

;       CalculatedKey:              Bits64 IDATA;
CalculatedKey:                  DS       8

;       I:                          Byte;

RSEG _DATA

I:                              DS       1

;       KeyProcessingTimer:         Word; Volatile;
KeyProcessingTimer:             DS       2

;       Vlow, RPT, DecryptOK:       Boolean;

RSEG _BIT

Vlow:                           DBIT     1
RPT:                            DBIT     1
DecryptOK:                      DBIT     1

;       PreambleTimer:              Word; Volatile;

RSEG _DATA

PreambleTimer:                  DS       2

;       Threshold, EquilizingTime:  Word IDATA;

RSEG _IDATA

Threshold:                      DS       2
EquilizingTime:                 DS       2

;       NumberOfLearnedKeys:        Word IDATA;
NumberOfLearnedKeys:            DS       2

;       BlinkTimer:                 Word_; Volatile;

RSEG _DATA

BlinkTimer:                     DS       2

;       TempBits32:                 Bits32 IDATA;

RSEG _IDATA

TempBits32:                     DS       4

;       Blinds12State, Blinds34State: TBlindsState;

RSEG _DATA

Blinds12State:                  DS       1
Blinds34State:                  DS       1

; 
;       Display:                    Char;
Display:                        DS       1

;       RF_led:                     Boolean;

RSEG _BIT

RF_led:                         DBIT     1

;       RX_Led:                     Boolean;
RX_Led:                         DBIT     1

;       TX_Led:                     Boolean;
TX_Led:                         DBIT     1

;       Sending,
;       BlockReceived:              Boolean;
Sending:                        DBIT     1
BlockReceived:                  DBIT     1

;       RX_Counter,
;       TX_Counter,
;       RX_Checksum:                Byte;

RSEG _DATA

RX_Counter:                     DS       1
TX_Counter:                     DS       1
RX_Checksum:                    DS       1

;       RX_Buffer,
;       TX_Buffer:                  Array [0..16] of Byte IDATA;

RSEG _IDATA

RX_Buffer:                      DS       17
TX_Buffer:                      DS       17

;       RS485_Timer,
;       RX_LedTimer,
;       TX_LedTimer:                Byte; Volatile;

RSEG _DATA

RS485_Timer:                    DS       1
RX_LedTimer:                    DS       1
TX_LedTimer:                    DS       1

;       ModuleAddress:              Byte;
ModuleAddress:                  DS       1

;       DelayTimer:                 Word IDATA; Volatile;

RSEG _IDATA

DelayTimer:                     DS       2

;       Relay:                      Array [1..15] of Byte;

RSEG _DATA

Relay:                          DS       15

;       RelayTimer:                 Array [1..4] of Word; Volatile;
RelayTimer:                     DS       8

;       RelayTime:                  Array [1..4] of Word_ IDATA;

RSEG _IDATA

RelayTime:                      DS       8

;       RelayTimeBlock:             Array [0..7] of Byte absolute RelayTime;
RelayTimeBlock                  EQU      RelayTime

; 
;       Setup:                      TSetup;

RSEG _DATA

Setup:                          DS       1

;       BlindsMode, TempBlindsMode: TBlindsMode;
BlindsMode:                     DS       1
TempBlindsMode:                 DS       1

;       SetupTimer:                 Word; Volatile;
SetupTimer:                     DS       2

;       TempSet:                    Boolean;

RSEG _BIT

TempSet:                        DBIT     1

;       TempTime:                   Byte;

RSEG _DATA

TempTime:                       DS       1

;       Kbd:                        TKbd;
Kbd:                            DS       1

;       KeyBits,
;       LastKeyBits:                Byte;
KeyBits:                        DS       1
LastKeyBits:                    DS       1

;       ModuleType:                 TModuleType;
ModuleType:                     DS       1

;       ModuleFlags:                TModuleFlagsSet IDATA;

RSEG _IDATA

ModuleFlags:                    DS       1

;       ChData:                     Array [1..15] of Byte IDATA;
ChData:                         DS       15

;       ChDataBlock:                Array [0..14] of Byte absolute ChData;
ChDataBlock                     EQU      ChData

;       TxKeyBits,
;       LastTxKeyBits:              Byte;

RSEG _DATA

TxKeyBits:                      DS       1
LastTxKeyBits:                  DS       1

;       ClsTimer:                   Word IDATA; Volatile;

RSEG _IDATA

ClsTimer:                       DS       2

;       LastInput1,
;       LastInput2,
;       LastInput3,
;       LastInput4:                 Boolean;

RSEG _BIT

LastInput1:                     DBIT     1
LastInput2:                     DBIT     1
LastInput3:                     DBIT     1
LastInput4:                     DBIT     1

;       Input1,
;       Input2,
;       Input3,
;       Input4:                     Boolean;
Input1:                         DBIT     1
Input2:                         DBIT     1
Input3:                         DBIT     1
Input4:                         DBIT     1

;       DoorState:                  TDoorState;

RSEG _DATA

DoorState:                      DS       1

;       LastDoorState:              TDoorState IDATA;

RSEG _IDATA

LastDoorState:                  DS       1

;       TempModuleType:             TModuleType;

RSEG _DATA

TempModuleType:                 DS       1

;       Channel:                    Byte;
Channel:                        DS       1

;       TempChannelType:            TChType;
TempChannelType:                DS       1

;       BlockSize:                  Byte;
BlockSize:                      DS       1

;       NoKeyTimer:                 Word; Volatile;
NoKeyTimer:                     DS       2

;       Latch:                      Word_ IDATA;

RSEG _IDATA

Latch:                          DS       2

;       Mask:                       Byte IDATA;
Mask:                           DS       1

;       Relay5_15Timer:             Byte IDATA; Volatile;
Relay5_15Timer:                 DS       1

;       Relay5_15:                  Byte IDATA;
Relay5_15:                      DS       1

;       LowThreshold,
;       HighThreshold:              Word IDATA;
LowThreshold:                   DS       2
HighThreshold:                  DS       2

;       TXPositionInEEprom:         Word IDATA;
TXPositionInEEprom:             DS       2

; 
; Procedure TimerProc; Interrupt Timer0; Using 2; { 1 ms interrupt }


CSEG AT $000B

              AJMP     TimerProc

RSEG _CODE

USING 2

TimerProc:
; begin
              PUSH      PSW
              MOV       PSW, #$10
              PUSH      ACC

;   TL0 :=  Lo (Const1ms);
              MOV       TL0, #$CD

;   TH0 :=  Hi (Const1ms);
              MOV       TH0, #$F8

; 
;   Inc (BlinkTimer.W);
              INC       BlinkTimer
              MOV       A, BlinkTimer
              JNZ       L_00B9
              INC       BlinkTimer+1
L_00B9:

; 
;   Inc (KeyProcessingTimer);
              INC       KeyProcessingTimer
              MOV       A, KeyProcessingTimer
              JNZ       L_00C1
              INC       KeyProcessingTimer+1
L_00C1:

;   If DelayTimer <> 0 then Dec (DelayTimer);
              MOV       R0, #DelayTimer+1
              MOV       A, @R0
              DEC       R0
              ORL       A, @R0
              JZ        L_00CB
              LCALL     sysDecWord_IDATA
L_00CB:

;   If RS485_Timer <> 0 then Dec (RS485_Timer) else RS485_TX := False;
              MOV       A, RS485_Timer
              JZ        L_00D3
              DEC       RS485_Timer
              SJMP      L_00D5
L_00D3:
              CLR       P3.3
L_00D5:

;   If RX_LedTimer <> 0 then Dec (RX_LedTimer) else RX_Led := False;
              MOV       A, RX_LedTimer
              JZ        L_00DD
              DEC       RX_LedTimer
              SJMP      L_00DF
L_00DD:
              CLR       RX_Led
L_00DF:

;   If TX_LedTimer <> 0 then Dec (TX_LedTimer) else TX_Led := False;
              MOV       A, TX_LedTimer
              JZ        L_00E7
              DEC       TX_LedTimer
              SJMP      L_00E9
L_00E7:
              CLR       TX_Led
L_00E9:

; 
;   If NoKeyTimer <> 0 then Dec (NoKeyTimer);
              MOV       A, NoKeyTimer+1
              ORL       A, NoKeyTimer
              JZ        L_00F8
              DEC       NoKeyTimer
              MOV       A, NoKeyTimer
              CJNE      A, #-1, L_00F8
              DEC       NoKeyTimer+1
L_00F8:

; 
;   If SetupTimer <> 0 then
              MOV       A, SetupTimer+1
              ORL       A, SetupTimer
              JZ        L_010F

;     begin
;       Dec (SetupTimer);
              DEC       SetupTimer
              MOV       A, SetupTimer
              CJNE      A, #-1, L_0107
              DEC       SetupTimer+1
L_0107:

;       If SetupTimer = 0 then Setup := None;
              MOV       A, SetupTimer+1
              ORL       A, SetupTimer
              JNZ       L_010F
              MOV       Setup, A

;     end;
L_010F:
; 
;   If ClsTimer <> 0 then Dec (ClsTimer);
              MOV       R0, #ClsTimer+1
              MOV       A, @R0
              DEC       R0
              ORL       A, @R0
              JZ        L_0119
              LCALL     sysDecWord_IDATA
L_0119:

; 
;   If BlinkTimer.L and $1F = 0 then
              MOV       A, BlinkTimer
              ANL       A, #$1F
              JZ        L_0122
              LJMP      L_01BB
L_0122:

;     begin
;       If Relay5_15Timer <> 0 then
              MOV       R0, #Relay5_15Timer
              MOV       A, @R0
              JZ        L_0133

;         begin
;           Dec (Relay5_15Timer);
              DEC       @R0

;           If Relay5_15Timer = 0 then
              CJNE      @R0, #0, L_0133

;             Relay [Relay5_15] := Byte (Relay_OFF);
              MOV       R0, #Relay5_15
              MOV       A, @R0
              ADD       A, #Relay-1
              MOV       R0, A
              MOV       @R0, #1

;         end;
L_0133:
; 
;       If RelayTimer [1] <> 0 then
              MOV       A, RelayTimer+1
              ORL       A, RelayTimer
              JZ        L_0155

;         begin
;           Dec (RelayTimer [1]);
              DEC       RelayTimer
              MOV       A, RelayTimer
              CJNE      A, #-1, L_0142
              DEC       RelayTimer+1
L_0142:

;           If RelayTimer [1] = 0 then
              MOV       A, RelayTimer+1
              ORL       A, RelayTimer
              JNZ       L_0155

;             begin
;               Relay [1] := Byte (Relay_OFF);
              MOV       Relay, #1

;               OUT1 := Relay_OFF;
              SETB      P1.6

;               If Blinds12State = bsOut1 then Blinds12State := bsIdleBetween;
              MOV       A, Blinds12State
              CJNE      A, #1, L_0155
              MOV       Blinds12State, #2

;             end;
;         end;
L_0155:
; 
;       If RelayTimer [2] <> 0 then
              MOV       A, RelayTimer+3
              ORL       A, RelayTimer+2
              JZ        L_0177

;         begin
;           Dec (RelayTimer [2]);
              DEC       RelayTimer+2
              MOV       A, RelayTimer+2
              CJNE      A, #-1, L_0164
              DEC       RelayTimer+3
L_0164:

;           If RelayTimer [2] = 0 then
              MOV       A, RelayTimer+3
              ORL       A, RelayTimer+2
              JNZ       L_0177

;             begin
;               Relay [2] := Byte (Relay_OFF);
              MOV       Relay+1, #1

;               OUT2 := Relay_OFF;
              SETB      P1.4

;               If Blinds12State = bsOut2 then Blinds12State := bsIdle;
              MOV       A, Blinds12State
              CJNE      A, #3, L_0177
              MOV       Blinds12State, #0

;             end;
;         end;
L_0177:
; 
;       If RelayTimer [3] <> 0 then
              MOV       A, RelayTimer+5
              ORL       A, RelayTimer+4
              JZ        L_0199

;         begin
;           Dec (RelayTimer [3]);
              DEC       RelayTimer+4
              MOV       A, RelayTimer+4
              CJNE      A, #-1, L_0186
              DEC       RelayTimer+5
L_0186:

;           If RelayTimer [3] = 0 then
              MOV       A, RelayTimer+5
              ORL       A, RelayTimer+4
              JNZ       L_0199

;             begin
;               Relay [3] := Byte (Relay_OFF);
              MOV       Relay+2, #1

;               OUT3 := Relay_OFF;
              SETB      P1.7

;               If Blinds34State = bsOut1 then Blinds34State := bsIdleBetween;
              MOV       A, Blinds34State
              CJNE      A, #1, L_0199
              MOV       Blinds34State, #2

;             end;
;         end;
L_0199:
; 
;       If RelayTimer [4] <> 0 then
              MOV       A, RelayTimer+7
              ORL       A, RelayTimer+6
              JZ        L_01BB

;         begin
;           Dec (RelayTimer [4]);
              DEC       RelayTimer+6
              MOV       A, RelayTimer+6
              CJNE      A, #-1, L_01A8
              DEC       RelayTimer+7
L_01A8:

;           If RelayTimer [4] = 0 then
              MOV       A, RelayTimer+7
              ORL       A, RelayTimer+6
              JNZ       L_01BB

;             begin
;               Relay [4] := Byte (Relay_OFF);
              MOV       Relay+3, #1

;               OUT4 := Relay_OFF;
              SETB      P1.5

;               If Blinds34State = bsOut2 then Blinds34State := bsIdle;
              MOV       A, Blinds34State
              CJNE      A, #3, L_01BB
              MOV       Blinds34State, #0

;             end;
;         end;
;     end;
L_01BB:
; end;
              POP       ACC
              POP       PSW
              RETI

; 
; Procedure Timer1Proc; Interrupt Timer1; { Time after pulse received, 8 ms interrupt if no RF data pulse }


CSEG AT $001B

              AJMP     Timer1Proc

RSEG _CODE

USING 0

Timer1Proc:
; begin
              PUSH      PSW
              MOV       PSW, #0
              PUSH      ACC

;   TL1 :=  Lo (TimerConst);
              MOV       TL1, #$AF

;   TH1 :=  Hi (TimerConst);
              MOV       TH1, #$C7

;   RF_Led := False;
              CLR       RF_led

;   BitCounter := 0;
              CLR       A
              MOV       BitCounter, A

;   PreambleTimer := 0;
              MOV       PreambleTimer, A
              MOV       PreambleTimer+1, A

; end;
              POP       ACC
              POP       PSW
              RETI

; 
; Procedure Int0Proc; Interrupt External0; Using 1; { RF Data Input }


CSEG AT 3

              AJMP     Int0Proc

RSEG _CODE

USING 1

Int0Proc:
; begin
              PUSH      PSW
              MOV       PSW, #8

;   TR1 := False;
;   Timer.L := TL1;
              MOV       Timer, TL1

;   Timer.H := TH1;
              MOV       Timer+1, TH1

;   TL1 :=  Lo (TimerConst);
              MOV       TL1, #$AF

;   TH1 :=  Hi (TimerConst);
              MOV       TH1, #$C7

;   TR1 := True;
              SETB      TCON.6

;   NewBit := True;
              SETB      NewBit

; end;
              POP       PSW
              RETI

; 
; Procedure SerialProc; Interrupt Serial; Using 3; { RS485 }
; Var Ch: Byte;


CSEG AT $0023

USING 3

SerialProc:
; begin
              PUSH      PSW
              MOV       PSW, #$18
              PUSH      ACC

;   If TI then
              JNB       SCON.1, L_0049

;     begin
;       TI := False;
              CLR       SCON.1

;       If TX_Counter < BlockSize then
              MOV       A, TX_Counter
              CLR       C
              SUBB      A, BlockSize
              JNC       L_0047

;         begin
;           TX_LedTimer := LedTime;
              MOV       TX_LedTimer, #$1E

;           RS485_Timer := RS485_Time;
              MOV       RS485_Timer, #2

;           SBUF := TX_Buffer [TX_Counter];
              MOV       A, TX_Counter
              ADD       A, #TX_Buffer
              MOV       R0, A
              MOV       SBUF, @R0

;           Inc (TX_Counter);
              INC       TX_Counter

;         end else Sending := False;
              SJMP      L_0049
L_0047:
              CLR       Sending

; 
;     end;
L_0049:
; 
;   If RI then
              JNB       SCON.0, L_009F

;     begin
;       RI := False;
              CLR       SCON.0

;       If Sending or BlockReceived then Exit;
              JB        Sending, L_0054
              JNB       BlockReceived, L_0056
L_0054:
              SJMP      L_009F
L_0056:

;       RX_LedTimer := LedTime;
              MOV       RX_LedTimer, #$1E

;       RX_Led := True;
              SETB      RX_Led

;       If ClsTimer <> 0 then Exit;
              MOV       R0, #ClsTimer+1
              MOV       A, @R0
              DEC       R0
              ORL       A, @R0
              JNZ       L_009F

;       Ch := SBUF;
              MOV       R3, SBUF

;       If (RX_Counter = bpBlockStart) then
              MOV       A, RX_Counter
              JNZ       L_007A

;         Case Ch of
;           BlockStart: BlockSize := 7;
              CJNE      R3, #$AA, L_0070
              MOV       BlockSize, #7
              SJMP      L_007A
L_0070:

;           BlockStartLNG: BlockSize := 17;
              CJNE      R3, #$CA, L_0078
              MOV       BlockSize, #$11
              SJMP      L_007A
L_0078:

;           else Exit;
              SJMP      L_009F
L_007A:

;         end;
;       RX_Buffer [RX_Counter] := Ch;
              ADD       A, #RX_Buffer
              MOV       R0, A
              MOV       @R0, AR3

;       Inc (RX_Counter);
              INC       RX_Counter

;       RX_Checksum := RX_Checksum xor Ch;
              MOV       A, R3
              XRL       RX_Checksum, A

;       If RX_Counter = BlockSize then
              MOV       A, RX_Counter
              CJNE      A, BlockSize, L_009F

;         begin
;           If ((RX_Buffer [bpDestinationAddress] = $FF) or (RX_Buffer [bpDestinationAddress] = ModuleAddress))
;             and (RX_Checksum = 0) then BlockReceived := True;
              MOV       R0, #RX_Buffer+1
              MOV       A, @R0
              CPL       A
              JZ        L_0093
              MOV       A, @R0
              CJNE      A, ModuleAddress, L_0099
L_0093:
              MOV       A, RX_Checksum
              JNZ       L_0099
              SETB      BlockReceived
L_0099:

;           RX_Counter := 0;
              MOV       RX_Counter, #0

;           RX_Checksum := 0;
              MOV       RX_Checksum, #0

;         end;
;     end;
; end;
L_009F:
              POP       ACC
              POP       PSW
              RETI

; 
; Function HighNib (Value: Byte): Byte;

RSEG _DATA

Value:                          DS       1


RSEG _CODE

USING 0

HighNib:
; begin
;   HighNib := Value shr 4;
              MOV       A, Value
              SWAP      A
              ANL       A, #$0F

; end;
              RET

; 
; Function LowNib (Value: Byte): Byte;

RSEG _DATA

Value:                          DS       1


RSEG _CODE

LowNib:
; begin
;   LowNib := Value and $0F;
              MOV       A, Value
              ANL       A, #$0F

; end;
              RET

; 
; Function NibToByte (Hi, Lo: Byte): Byte;

RSEG _DATA

Hi:                             DS       1
Lo:                             DS       1


RSEG _CODE

NibToByte:
; begin
;   NibToByte := Hi shl 4 or Lo and $0F;
              MOV       A, Lo
              ANL       A, #$0F
              MOV       R1, A
              MOV       A, Hi
              SWAP      A
              ANL       A, #$F0
              ORL       A, R1

; end;
              RET

; 
; Function ManufacturerKey (Pos: Byte): Byte;

RSEG _DATA

Pos:                            DS       1


RSEG _CODE

ManufacturerKey:
; begin
;   ManufacturerKey := Byte (ManufacturerKeyData [Pos xor $07]);
              MOV       A, Pos
              XRL       A, #7
              MOV       DPTR, #ManufacturerKeyData
              MOVC      A, @A + DPTR

; end;
              RET

; 
; Procedure RestartWatchDog;

RestartWatchDog:
; begin
;   WatchDogReset := LowLevel;
              CLR       P3.4

;   Asm
;     NOP
              NOP

;     NOP
              NOP

;   end;
;   WatchDogReset := HighLevel;
              SETB      P3.4

; end;
              RET

; 
; Procedure WriteDisplay;
; Var Nw: Byte;

WriteDisplay:
; begin
;   Latch.W := Segments [Display];
              MOV       A, Display
              MOV       DPTR, #Segments-32
              MOVC      A, @A + DPTR
              MOV       R0, #Latch
              MOV       @R0, A
              INC       R0
              MOV       @R0, #0

;   If Setup = None then
              MOV       A, Setup
              JNZ       L_0222

;     begin
;       If (BlinkTimer.H and $2) = 0 then Latch.L := Latch.L or $80;
              MOV       A, BlinkTimer+1
              JB        ACC.1, L_0220
              DEC       R0
              MOV       A, @R0
              ORL       A, #$80
              MOV       @R0, A
L_0220:

;     end else If (BlinkTimer.L and $80) = 0 then Latch.L := Latch.L or $80;
              SJMP      L_022D
L_0222:
              MOV       A, BlinkTimer
              JB        ACC.7, L_022D
              MOV       R0, #Latch
              MOV       A, @R0
              ORL       A, #$80
              MOV       @R0, A
L_022D:

;   If RF_Led then Latch.H := Latch.H or $04;
              JNB       RF_led, L_0234
              MOV       R0, #Latch+1
              MOV       @R0, #4
L_0234:

;   If RX_Led then Latch.H := Latch.H or $02;
              JNB       RX_Led, L_023D
              MOV       R0, #Latch+1
              MOV       A, @R0
              ORL       A, #2
              MOV       @R0, A
L_023D:

;   If TX_Led then Latch.H := Latch.H or $01;
              JNB       TX_Led, L_0246
              MOV       R0, #Latch+1
              MOV       A, @R0
              ORL       A, #1
              MOV       @R0, A
L_0246:

;   Latch.H := Latch.H xor $FF;
              MOV       R0, #Latch+1
              MOV       A, @R0
              CPL       A
              MOV       @R0, A

;   Latch.L := Latch.L xor $FF;
              DEC       R0
              MOV       A, @R0
              CPL       A
              MOV       @R0, A

; 
;   SCL := LowLevel;
              CLR       P3.4

;   SCL := HighLevel;
              SETB      P3.4

;   Asm
;     NOP
              NOP

;   end;
;   SCL := LowLevel;
              CLR       P3.4

;   SDA := False;
              CLR       P3.5

; 
;   For Nw := 1 to 16 do
              MOV       R3, #0
L_025A:
              INC       R3

;     begin
;       SDA := (Latch.H and $80) <> 0;
              MOV       R0, #Latch+1
              MOV       A, @R0
              RLC       A
              MOV       P3.5, C

;       SCL := HighLevel;
              SETB      P3.4

;       Asm
;         NOP
              NOP

;       end;
;       SCL := LowLevel;
              CLR       P3.4

;       Latch.W := Latch.W + Latch.W;
              MOV       R0, #Latch
              MOV       A, @R0
              MOV       R1, #Latch
              ADD       A, @R1
              MOV       R2, A
              INC       R0
              MOV       A, @R0
              ADDC      A, @R0
              DEC       R0
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, A

;     end;
              CJNE      R3, #$10, L_025A

;   Strobe := HighLevel;
              SETB      P3.6

;   Asm
;     NOP
              NOP

;   end;
;   Strobe := LowLevel;
              CLR       P3.6

;   SCL := HighLevel;
              SETB      P3.4

; end;
              RET

; 
; Procedure Delay (Dl: Word);

RSEG _DATA

Dl:                             DS       2


RSEG _CODE

Delay:
; begin
;   DelayTimer := Dl;
              MOV       R0, #DelayTimer
              MOV       @R0, Dl
              INC       R0
              MOV       @R0, Dl+1

;   Repeat
L_0287:
;     WriteDisplay;
              LCALL     WriteDisplay

;   until DelayTimer = 0;
              MOV       R0, #DelayTimer+1
              MOV       A, @R0
              DEC       R0
              ORL       A, @R0
              JNZ       L_0287

; end;
              RET

; 
; Procedure Send;

Send:
; begin
;   TX_Counter := 0;
              MOV       TX_Counter, #0

;   RS485_Timer := RS485_Time;
              MOV       RS485_Timer, #2

;   RS485_TX := True;
              SETB      P3.3

;   TX_LedTimer := LedTime;
              MOV       TX_LedTimer, #$1E

;   TX_Led := True;
              SETB      TX_Led

;   Repeat
L_029F:
;     WriteDisplay;
              LCALL     WriteDisplay

;   until RS485_Timer <= 1;
              MOV       A, RS485_Timer
              ADD       A, #-2
              JC        L_029F

;   TI := True;
              SETB      SCON.1

; end;
              RET

; 
; Procedure SendBlock;
; Var M, K: Byte;

SendBlock:
; begin
;   While Sending do WriteDisplay;
              SJMP      L_02B0
L_02AD:
              LCALL     WriteDisplay
L_02B0:
;   While Sending do WriteDisplay;
              JB        Sending, L_02AD

;   Sending := True;
              SETB      Sending

;   TX_Buffer [bpSourceAddress] := ModuleAddress;
              MOV       R0, #TX_Buffer+5
              MOV       @R0, ModuleAddress

;   TX_Buffer [bpBlockStart] := BlockStart;
              MOV       R0, #TX_Buffer
              MOV       @R0, #$AA

;   M := 0;
              MOV       R4, #0

;   For K := 0 to 5 do M := M xor TX_Buffer [K];
              MOV       R2, #$FF
L_02C1:
              INC       R2
              MOV       A, R2
              ADD       A, #TX_Buffer
              MOV       R0, A
              MOV       A, R4
              XRL       A, @R0
              MOV       R4, A
              CJNE      R2, #5, L_02C1

;   TX_Buffer [bpChecksum] := M;
              MOV       R0, #TX_Buffer+6
              MOV       @R0, A

;   BlockSize := 7;
              MOV       BlockSize, #7

;   Send;
              LJMP      Send

; end;
; 
; Procedure SendLNGBlock;
; Var M, K: Byte;

SendLNGBlock:
; begin
;   While Sending do WriteDisplay;
              SJMP      L_02DA
L_02D7:
              LCALL     WriteDisplay
L_02DA:
;   While Sending do WriteDisplay;
              JB        Sending, L_02D7

;   Sending := True;
              SETB      Sending

;   TX_Buffer [bpSourceAddress] := ModuleAddress;
              MOV       R0, #TX_Buffer+5
              MOV       @R0, ModuleAddress

;   TX_Buffer [bpBlockStart] := BlockStartLNG;
              MOV       R0, #TX_Buffer
              MOV       @R0, #$CA

;   TX_Buffer [bpChecksum] := 0;
              MOV       R0, #TX_Buffer+6
              MOV       @R0, #0

;   M := 0;
              MOV       R4, #0

;   For K := 0 to 16 do M := M xor TX_Buffer [K];
              MOV       R2, #$FF
L_02EF:
              INC       R2
              MOV       A, R2
              ADD       A, #TX_Buffer
              MOV       R0, A
              MOV       A, R4
              XRL       A, @R0
              MOV       R4, A
              CJNE      R2, #$10, L_02EF

;   TX_Buffer [bpChecksum] := M;
              MOV       R0, #TX_Buffer+6
              MOV       @R0, A

;   BlockSize := 17;
              MOV       BlockSize, #$11

;   Send;
              LJMP      Send

; end;
; 
; Procedure SendToAuxModule;
; Var Nw: Byte;

SendToAuxModule:
; begin
;   Aux_SCL := LowLevel;
              CLR       P0.0

;   Asm
;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;   end;
;   Aux_SCL := HighLevel;
              SETB      P0.0

;   Asm
;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;   end;
; 
;   For Nw := 5 to 15 do
              MOV       R2, #4
L_0311:
              INC       R2

;     begin
;       Aux_SDA := Relay [Nw] = Byte (Relay_ON);
              MOV       A, R2
              ADD       A, #Relay-1
              MOV       R0, A
              MOV       A, @R0
              ADD       A, #$FF
              CPL       C
              MOV       P0.1, C

;       Asm
;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;       end;
;       WatchDogReset := LowLevel;
              CLR       P3.4

;       Asm
;         NOP
              NOP

;       end;
;       WatchDogReset := HighLevel;
              SETB      P3.4

;       Aux_SCL := LowLevel;
              CLR       P0.0

;       Asm
;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;       end;
;       Aux_SCL := HighLevel;
              SETB      P0.0

;     end;
              CJNE      R2, #$0F, L_0311

; 
;   Asm
;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;   end;
;   Aux_Strobe := LowLevel;
              CLR       P0.2

;   Asm
;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;   end;
;   Aux_Strobe := HighLevel;
              SETB      P0.2

; end;
              RET

; 
; Procedure SendStatus;

SendStatus:
; begin
;   TX_Buffer [bpCommand] := Cmd_Status;
              MOV       R0, #TX_Buffer+2
              MOV       @R0, #$41

;   If (Setup = LearnKey) or (Setup = LearnKey2) then
              MOV       A, Setup
              XRL       A, #1
              JZ        L_034C
              MOV       A, Setup
              CJNE      A, #2, L_0352
L_034C:

;     TX_Buffer [bpParameter2] := LNG_ModuleID or $01 else
              MOV       R0, #TX_Buffer+4
              MOV       @R0, #$A1
              SJMP      L_0356
L_0352:

;       TX_Buffer [bpParameter2] := LNG_ModuleID;
              MOV       R0, #TX_Buffer+4
              MOV       @R0, #$A0
L_0356:

;   If Hi (NumberOfLearnedKeys) = 0 then
              MOV       R0, #NumberOfLearnedKeys+1
              CJNE      @R0, #0, L_0363

;     TX_Buffer [bpParameter1] := Lo (NumberOfLearnedKeys) else
              MOV       R1, #NumberOfLearnedKeys
              MOV       R0, #TX_Buffer+3
              MOV       A, @R1
              MOV       @R0, A
              SJMP      L_0367
L_0363:

;       TX_Buffer [bpParameter1] := 255;
              MOV       R0, #TX_Buffer+3
              MOV       @R0, #$FF
L_0367:

;   SendBlock;
              LJMP      SendBlock

; end;
; 
; Procedure SendToTerminal;
; Var LRC: Byte;

RSEG _DATA

LRC:                            DS       1

; 
;   Procedure SendByteToTerminal (BCR: Byte);
BCR:                            DS       1

;   Var TempByte: Byte;


RSEG _CODE

SendByteToTerminal:
;   begin
;     LRC := LRC xor BCR;
              MOV       A, LRC
              XRL       A, BCR
              MOV       LRC, A

;     If BCR < $80 then
              MOV       A, BCR
              ADD       A, #-128
              JC        L_0381

;       begin
;         BCR := BCR and $0F;
              ANL       BCR, #$0F

;         Asm
;           MOV   A, BCR;
              MOV       A, BCR

;         end;
;         If not P then BCR := BCR or $10;
              JB        PSW.0, L_0381
              ORL       BCR, #$10

;       end;
L_0381:
;     For TempByte := 1 to 5 do
              MOV       R5, #LOW  (1)
              MOV       R6, #HIGH (1)
              MOV       R4, #5
L_0387:

;       begin
;         Aux_SDA := BCR and $01 <> $00;
              MOV       A, BCR
              RRC       A
              MOV       P0.1, C

;         Delay (1);
              MOV       Dl, R5
              MOV       Dl+1, R6
              LCALL     Delay

;         Aux_SCL := HighLevel;
              SETB      P0.0

;         Delay (1);
              MOV       Dl, R5
              MOV       Dl+1, R6
              LCALL     Delay

;         Aux_SCL := LowLevel;
              CLR       P0.0

;         Delay (1);
              MOV       Dl, R5
              MOV       Dl+1, R6
              LCALL     Delay

;         BCR := BCR shr 1;
              MOV       A, BCR
              CLR       C
              RRC       A
              MOV       BCR, A

;       end;
              DJNZ      R4, L_0387

;   end;
              RET

; 
;   Procedure SendManufacturerKey;

SendManufacturerKey:
;   begin
;     SendByteToTerminal (HighNib (I));
              MOV       Value, I
              LCALL     HighNib
              MOV       BCR, A
              LCALL     SendByteToTerminal

;     SendByteToTerminal (LowNib  (I));
              MOV       Value, I
              LCALL     LowNib
              MOV       BCR, A
              LJMP      SendByteToTerminal

;   end;

SendToTerminal:
; 
; begin
;   Aux_Strobe := HighLevel;
              SETB      P0.2

;   Delay (1);
              MOV       Dl, #LOW  (1)
              MOV       Dl+1, #HIGH (1)
              LCALL     Delay

;   LRC := 0;
              MOV       LRC, #0

; 
;   SendByteToTerminal ($80);
              MOV       BCR, #$80
              LCALL     SendByteToTerminal

;   SendByteToTerminal ($80);
              MOV       BCR, #$80
              LCALL     SendByteToTerminal

; 
;   SendByteToTerminal ($B);
              MOV       BCR, #$0B
              LCALL     SendByteToTerminal

; 
;   I := ManufacturerKey (7);
              MOV       Pos, #7
              LCALL     ManufacturerKey
              MOV       I, A

;   SendManufacturerKey;
              LCALL     SendManufacturerKey

;   I := ManufacturerKey (6);
              MOV       Pos, #6
              LCALL     ManufacturerKey
              MOV       I, A

;   SendManufacturerKey;
              LCALL     SendManufacturerKey

;   I := ManufacturerKey (5);
              MOV       Pos, #5
              LCALL     ManufacturerKey
              MOV       I, A

;   SendManufacturerKey;
              LCALL     SendManufacturerKey

; 
;   SendByteToTerminal ($D);
              MOV       BCR, #$0D
              LCALL     SendByteToTerminal

;   SendByteToTerminal (HighNib (SerialNumber [2]));
              MOV       R0, #SerialNumber+2
              MOV       Value, @R0
              LCALL     HighNib
              MOV       BCR, A
              LCALL     SendByteToTerminal

;   SendByteToTerminal (LowNib  (SerialNumber [2]));
              MOV       R0, #SerialNumber+2
              MOV       Value, @R0
              LCALL     LowNib
              MOV       BCR, A
              LCALL     SendByteToTerminal

;   SendByteToTerminal (HighNib (SerialNumber [1]));
              MOV       R0, #SerialNumber+1
              MOV       Value, @R0
              LCALL     HighNib
              MOV       BCR, A
              LCALL     SendByteToTerminal

;   SendByteToTerminal (LowNib  (SerialNumber [1]));
              MOV       R0, #SerialNumber+1
              MOV       Value, @R0
              LCALL     LowNib
              MOV       BCR, A
              LCALL     SendByteToTerminal

;   SendByteToTerminal (HighNib (SerialNumber [0]));
              MOV       R0, #SerialNumber
              MOV       Value, @R0
              LCALL     HighNib
              MOV       BCR, A
              LCALL     SendByteToTerminal

;   SendByteToTerminal (LowNib  (SerialNumber [0]));
              MOV       R0, #SerialNumber
              MOV       Value, @R0
              LCALL     LowNib
              MOV       BCR, A
              LCALL     SendByteToTerminal

;   SendByteToTerminal ($D);
              MOV       BCR, #$0D
              LCALL     SendByteToTerminal

;   SendByteToTerminal (TxKeyBits div 10);
              MOV       A, TxKeyBits
              MOV       B, #$0A
              DIV       AB
              MOV       BCR, A
              LCALL     SendByteToTerminal

;   SendByteToTerminal (TxKeyBits mod 10);
              MOV       A, TxKeyBits
              MOV       B, #$0A
              DIV       AB
              MOV       BCR, B
              LCALL     SendByteToTerminal

; 
;   SendByteToTerminal ($D);
              MOV       BCR, #$0D
              LCALL     SendByteToTerminal

;   SendByteToTerminal (Byte (not Vlow));
              MOV       C, Vlow
              CPL       C
              CLR       A
              RLC       A
              MOV       BCR, A
              LCALL     SendByteToTerminal

; 
;   SendByteToTerminal ($F);
              MOV       BCR, #$0F
              LCALL     SendByteToTerminal

;   SendByteToTerminal (LRC and $0F);
              MOV       A, LRC
              ANL       A, #$0F
              MOV       BCR, A
              LCALL     SendByteToTerminal

; 
;   Delay (1);
              MOV       Dl, #LOW  (1)
              MOV       Dl+1, #HIGH (1)
              LCALL     Delay

;   Aux_Strobe := LowLevel;
              CLR       P0.2

;   Aux_SDA := LowLevel;
              CLR       P0.1

; end;
              RET

; 
; Function Check_EEPROM_Signature: Boolean;

RSEG _BIT

Check_EEPROM_Signature_Result:  DBIT     1


RSEG _CODE

Check_EEPROM_Signature:
; begin
;   Check_EEPROM_Signature := False;
              CLR       Check_EEPROM_Signature_Result

;   If ReadByteFromEEPROM (Ofs (TEEprom.EE_Signature) + 0) <> Lo (Signature) then Exit;
              CLR       A
              MOV       Ad, A
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              CJNE      A, #$CA, L_04B8

;   If ReadByteFromEEPROM (Ofs (TEEprom.EE_Signature) + 1) <> Hi (Signature) then Exit;
              MOV       Ad, #LOW  (1)
              MOV       Ad+1, #HIGH (1)
              LCALL     ReadByteFromEEPROM
              CJNE      A, #$FE, L_04B8

;   Check_EEPROM_Signature := True;
              SETB      Check_EEPROM_Signature_Result

; end;
L_04B8:
              MOV       C, Check_EEPROM_Signature_Result
              RET

; 
; Procedure WriteRelayTimesToEEPROM;
; Var TempByte: Byte;

WriteRelayTimesToEEPROM:
; begin
;   For TempByte := 0 to 7 do
              MOV       R6, #$FF
              MOV       R7, #0
L_04BF:
              INC       R6

;     WriteByteToEEPROM (Ofs (TEEprom.EE_RelayTime [1]) + TempByte, RelayTimeBlock [TempByte]);
              MOV       A, R6
              ADD       A, #4
              MOV       Address, A
              MOV       Address+1, R7
              MOV       A, R6
              ADD       A, #RelayTime
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM
              CJNE      R6, #7, L_04BF

; end;
              RET

; 
; Procedure InitNormalModuleType;
; Var TempByte: Byte;

InitNormalModuleType:
; begin
;   ModuleType := mtNormal;
              MOV       ModuleType, #0

;   ModuleFlags := [];
              MOV       R0, #ModuleFlags
              MOV       @R0, #0

;   For TempByte := 1 to 15 do ChData [TempByte] := TempByte shl 4;
              MOV       R2, #0
L_04DD:
              INC       R2
              MOV       A, R2
              SWAP      A
              ANL       A, #$F0
              MOV       R1, A
              MOV       A, R2
              ADD       A, #ChData-1
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R2, #$0F, L_04DD

;   RelayTime [1].W := DafaultRelayLongPulseTime;
              MOV       R0, #RelayTime
              MOV       @R0, #LOW  ($03A9)
              INC       R0
              MOV       @R0, #HIGH ($03A9)

;   RelayTime [2].W := DafaultRelayLongPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($03A9)
              INC       R0
              MOV       @R0, #HIGH ($03A9)

;   RelayTime [3].W := DafaultRelayLongPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($03A9)
              INC       R0
              MOV       @R0, #HIGH ($03A9)

;   RelayTime [4].W := DafaultRelayLongPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($03A9)
              INC       R0
              MOV       @R0, #HIGH ($03A9)

;   WriteRelayTimesToEEPROM;
              LJMP      WriteRelayTimesToEEPROM

; end;
; 
; Procedure WriteModuleConfig;
; Var TempByte: Byte;

WriteModuleConfig:
; begin
;   WriteByteToEEPROM (Ofs (TEEprom.EE_ModuleType), Byte (ModuleType));
              MOV       Address, #LOW  ($000C)
              MOV       Address+1, #HIGH ($000C)
              MOV       D, ModuleType
              LCALL     WriteByteToEEPROM

;   WriteByteToEEPROM (Ofs (TEEprom.EE_ModuleFlags), Byte (ModuleFlags));
              MOV       Address, #LOW  ($000D)
              MOV       Address+1, #HIGH ($000D)
              MOV       R0, #ModuleFlags
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;   For TempByte := 0 to 14 do
              MOV       R6, #$FF
              MOV       R7, #0
L_0525:
              INC       R6

;     WriteByteToEEPROM (Ofs (TEEprom.EE_ChannelConfig) + TempByte, ChDataBlock [TempByte]);
              MOV       A, R6
              ADD       A, #$10
              MOV       Address, A
              MOV       Address+1, R7
              MOV       A, R6
              ADD       A, #ChData
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM
              CJNE      R6, #$0E, L_0525

; end;
              RET

; 
; Procedure Init_EEPROM;

Init_EEPROM:
; begin
;   WriteByteToEEPROM (Ofs (TEEprom.EE_Signature) + 0, Lo (Signature));
              CLR       A
              MOV       Address, A
              MOV       Address+1, A
              MOV       D, #$CA
              LCALL     WriteByteToEEPROM

;   WriteByteToEEPROM (Ofs (TEEprom.EE_Signature) + 1, Hi (Signature));
              MOV       Address, #LOW  (1)
              MOV       Address+1, #HIGH (1)
              MOV       D, #$FE
              LCALL     WriteByteToEEPROM

;   NumberOfLearnedKeys := 0;
              CLR       A
              MOV       R0, #NumberOfLearnedKeys
              MOV       @R0, A
              INC       R0
              MOV       @R0, A

;   WriteByteToEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysLo), 0);
              MOV       Address, #LOW  (2)
              MOV       Address+1, A
              MOV       D, A
              LCALL     WriteByteToEEPROM

;   WriteByteToEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysHi), 0);
              MOV       Address, #LOW  ($001F)
              MOV       Address+1, #HIGH ($001F)
              MOV       D, #0
              LCALL     WriteByteToEEPROM

;   ModuleAddress := $90;
              MOV       ModuleAddress, #$90

;   WriteByteToEEPROM (Ofs (TEEprom.EE_ModuleAddress), ModuleAddress);
              MOV       Address, #LOW  (3)
              MOV       Address+1, #HIGH (3)
              MOV       D, #$90
              LCALL     WriteByteToEEPROM

;   InitNormalModuleType;
              LCALL     InitNormalModuleType

;   WriteModuleConfig;
              LJMP      WriteModuleConfig

; end;
; 
; Procedure Read_EEPROM;
; Var TempByte: Byte;

Read_EEPROM:
; begin
;   Lo (NumberOfLearnedKeys) := ReadByteFromEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysLo));
              MOV       Ad, #LOW  (2)
              MOV       Ad+1, #HIGH (2)
              LCALL     ReadByteFromEEPROM
              MOV       R0, #NumberOfLearnedKeys
              MOV       @R0, A

;   Hi (NumberOfLearnedKeys) := ReadByteFromEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysHi));
              MOV       Ad, #LOW  ($001F)
              MOV       Ad+1, #HIGH ($001F)
              LCALL     ReadByteFromEEPROM
              INC       R0
              MOV       @R0, A

; 
;   ModuleAddress := ReadByteFromEEPROM (Ofs (TEEprom.EE_ModuleAddress));
              MOV       Ad, #LOW  (3)
              MOV       Ad+1, #HIGH (3)
              LCALL     ReadByteFromEEPROM
              MOV       ModuleAddress, A

;   For TempByte := 0 to 7 do
              MOV       R6, #$FF
              MOV       R7, #0
L_05A8:
              INC       R6

;     RelayTimeBlock [TempByte] := ReadByteFromEEPROM (Ofs (TEEprom.EE_RelayTime [1]) + TempByte);
              MOV       A, R6
              ADD       A, #4
              MOV       Ad, A
              MOV       Ad+1, R7
              LCALL     ReadByteFromEEPROM
              MOV       R1, A
              MOV       A, R6
              ADD       A, #RelayTime
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R6, #7, L_05A8

; 
;   ModuleType := TModuleType (ReadByteFromEEPROM (Ofs (TEEprom.EE_ModuleType)));
              MOV       Ad, #LOW  ($000C)
              MOV       Ad+1, #HIGH ($000C)
              LCALL     ReadByteFromEEPROM
              MOV       ModuleType, A

;   Byte (ModuleFlags) := ReadByteFromEEPROM (Ofs (TEEprom.EE_ModuleFlags));
              MOV       Ad, #LOW  ($000D)
              MOV       Ad+1, #HIGH ($000D)
              LCALL     ReadByteFromEEPROM
              MOV       R0, #ModuleFlags
              MOV       @R0, A

;   For TempByte := 0 to 14 do
              MOV       R6, #$FF
              MOV       R7, #0
L_05D8:
              INC       R6

;     ChDataBlock [TempByte] := ReadByteFromEEPROM (Ofs (TEEprom.EE_ChannelConfig) + TempByte);
              MOV       A, R6
              ADD       A, #$10
              MOV       Ad, A
              MOV       Ad+1, R7
              LCALL     ReadByteFromEEPROM
              MOV       R1, A
              MOV       A, R6
              ADD       A, #ChData
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R6, #$0E, L_05D8

; end;
              RET

; 
; Procedure Init;
; Var K: Byte;
;     TempByte: Byte;

Init:
; begin
;   RS485_TX := LowLevel;
              CLR       P3.3

;   RF_Led := False;
              CLR       RF_led

;   RX_Led := False;
              CLR       RX_Led

;   TX_Led := False;
              CLR       TX_Led

;   For TempByte := 1 to 15 do
              MOV       R2, #0
L_05F8:
              INC       R2

;     Relay [TempByte] := Byte (Relay_OFF);
              MOV       A, R2
              ADD       A, #Relay-1
              MOV       R0, A
              MOV       @R0, #1
              CJNE      R2, #$0F, L_05F8

;   Strobe := LowLevel;
              CLR       P3.6

;   Aux_SDA := LowLevel;        { Inverted output is HIGH to comply with ISO Track 2 standard }
              CLR       P0.1

;   Aux_SCL := LowLevel;
              CLR       P0.0

;   Aux_Strobe := AuxModule;
              MOV       C, P2.4
              MOV       P0.2, C

;   If AuxModule then
              JNB       P2.4, L_0615

;     begin
;       Mask := $0F
              MOV       R0, #Mask
              MOV       @R0, #$0F

;     end else
              SJMP      L_0619
L_0615:

;       begin
;         Mask := $03;
              MOV       R0, #Mask
              MOV       @R0, #3

;       end;
L_0619:
; 
;   LastKeyBits := $0F;
              MOV       LastKeyBits, #$0F

;   RelayTimer [1] := 0;
              CLR       A
              MOV       RelayTimer, A
              MOV       RelayTimer+1, A

;   RelayTimer [2] := 0;
              MOV       RelayTimer+2, A
              MOV       RelayTimer+3, A

;   RelayTimer [3] := 0;
              MOV       RelayTimer+4, A
              MOV       RelayTimer+5, A

;   RelayTimer [3] := 0;
              MOV       RelayTimer+4, A
              MOV       RelayTimer+5, A

;   Relay5_15Timer := 0;
              MOV       R0, #Relay5_15Timer
              MOV       @R0, A

; 
;   Sending := False;
              CLR       Sending

;   BlockReceived := False;
              CLR       BlockReceived

;   RX_Counter := 0;
              MOV       RX_Counter, A

;   TX_Counter := 0;
              MOV       TX_Counter, A

;   RX_Checksum := 0;
              MOV       RX_Checksum, A

;   Setup := None;
              MOV       Setup, A

;   SetupTimer := 0;
              MOV       SetupTimer, A
              MOV       SetupTimer+1, A

;   Blinds12State  := bsIdle;
              MOV       Blinds12State, A

;   Blinds34State  := bsIdle;
              MOV       Blinds34State, A

;   ClsTimer := 0;
              MOV       R0, #ClsTimer
              MOV       @R0, A
              INC       R0
              MOV       @R0, A

;   DoorState := dsStop;
              MOV       DoorState, A

;   LastDoorState := dsUp;
              MOV       R0, #LastDoorState
              MOV       @R0, #1

; 
;   NewBit := False;
              CLR       NewBit

;   KeyPacketReceived := False;
              CLR       KeyPacketReceived

;   BitCounter := 0;
              MOV       BitCounter, A

;   PreambleTimer := 0;
              MOV       PreambleTimer, A
              MOV       PreambleTimer+1, A

; 
;   TL0 :=  Lo (Const1ms);
              MOV       TL0, #$CD

;   TH0 :=  Hi (Const1ms);
              MOV       TH0, #$F8

;   TL1 :=  Lo (TimerConst);
              MOV       TL1, #$AF

;   TH1 :=  Hi (TimerConst);
              MOV       TH1, #$C7

; 
;   RCAP2L :=  Lo (BaudRateTimerValue);
              MOV       $CA, #$B8

;   RCAP2H :=  Hi (BaudRateTimerValue);
              MOV       $CB, #$FF

;   TMOD := %00010001; { Timer1: no GATE, Timer, 16 bit timer }
              MOV       TMOD, #$11

;                      { Timer0: no GATE, Timer, 16 bit timer }
;   TCON := %01010101; { Timer 1 run, Timer 0 run }
              MOV       TCON, #$55

;                      { Int1 falling edge, Int0 falling edge }
;   T2CON := %00110100;{ Baud rate generator, Run }
              MOV       $C8, #$34

;   IE    := %10011011;{ Serial, Timer1, Timer0, Int0 }
              MOV       IE, #$9B

;   PX0 := True;       { External Interrupt 0 Priority }
              SETB      IP.0

; 
;   SCON := %01010000; { Serial Mode 1, Enable Reception }
              MOV       SCON, #$50

; 
;   Display := ' ';
              MOV       Display, #' '

;   WriteDisplay;
              LCALL     WriteDisplay

;   If AuxModule then SendToAuxModule;
              JNB       P2.4, L_0688
              LCALL     SendToAuxModule
L_0688:

;   Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

; 
;   If Key_Cancel = LowLevel then Init_EEPROM
              JB        P2.2, L_0699
              LCALL     Init_EEPROM
              SJMP      L_06B9
L_0699:

;     else begin
;            If Check_EEPROM_Signature then Read_EEPROM
              LCALL     Check_EEPROM_Signature
              JNC       L_06A3
              LCALL     Read_EEPROM
              SJMP      L_06B9
L_06A3:

;              else begin
;                     Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

;                     If Check_EEPROM_Signature then Read_EEPROM
              LCALL     Check_EEPROM_Signature
              JNC       L_06B6
              LCALL     Read_EEPROM
              SJMP      L_06B9
L_06B6:

;                       else Init_EEPROM;
              LCALL     Init_EEPROM

;                   end;
;          end;
L_06B9:
;   Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

; 
;   If not Check_EEPROM_Signature then
              LCALL     Check_EEPROM_Signature
              JC        L_06D0
              MOV       R4, #'E'

;     Repeat
L_06C9:
;       Display := 'E';
              MOV       Display, R4

;       WriteDisplay;
              LCALL     WriteDisplay

;     until False;
              SJMP      L_06C9
L_06D0:

; 
;   Delay (200);
              MOV       Dl, #LOW  ($00C8)
              MOV       Dl+1, #HIGH ($00C8)
              LCALL     Delay

; 
;   K := 0;
              MOV       R4, #0
              MOV       R6, #LOW  ($012C)
              MOV       R7, #HIGH ($012C)

;   Repeat
L_06DF:
;     TempByte := Byte (GreetingString [K]);
              MOV       A, R4
              MOV       DPTR, #GreetingString
              MOVC      A, @A + DPTR
              MOV       R5, A

;     Inc (K);
              INC       R4

;     If TempByte <> 0 then
              JZ        L_06FD

;       begin
;         Display := Char (TempByte);
              MOV       Display, A

;         Delay (300);
              MOV       Dl, R6
              MOV       Dl+1, R7
              LCALL     Delay

;         Display := ' ';
              MOV       Display, #' '

;         Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

;       end;
L_06FD:
;   until TempByte = 0;
              CJNE      R5, #0, L_06DF

;   Delay (500);
              MOV       Dl, #LOW  ($01F4)
              MOV       Dl+1, #HIGH ($01F4)
              LCALL     Delay

;   Display := HexChar [LowNib (VersionHi)];
              MOV       Value, #1
              LCALL     LowNib
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;   Delay (300);
              MOV       Dl, R6
              MOV       Dl+1, R7
              LCALL     Delay

;   Display := ' ';
              MOV       Display, #' '

;   Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

;   Display := HexChar [HighNib (VersionLo)];
              MOV       Value, #0
              LCALL     HighNib
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;   Delay (300);
              MOV       Dl, R6
              MOV       Dl+1, R7
              LCALL     Delay

;   Display := ' ';
              MOV       Display, #' '

;   Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

;   Display := HexChar [LowNib (VersionLo)];
              MOV       Value, #0
              LCALL     LowNib
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;   Delay (300);
              MOV       Dl, R6
              MOV       Dl+1, R7
              LCALL     Delay

;   Display := ' ';
              MOV       Display, #' '

; end;
              RET

; 
; Procedure SetManufacturerKey;
; Var I: Byte;

SetManufacturerKey:
; begin
;   For I := 0 to 7 do Key [I] := ManufacturerKey (I);
              MOV       R2, #$FF
L_0760:
              INC       R2
              MOV       Pos, R2
              LCALL     ManufacturerKey
              MOV       R1, A
              MOV       A, R2
              ADD       A, #Key
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R2, #7, L_0760

; end;
              RET

; 
; Procedure SetCalculatedKey;
; Var I: Byte;

SetCalculatedKey:
; begin
;   For I := 0 to 7 do Key [I] := CalculatedKey [I];
              MOV       R2, #$FF
L_0773:
              INC       R2
              MOV       A, R2
              ADD       A, #CalculatedKey
              MOV       R0, A
              MOV       AR1, @R0
              MOV       A, R2
              ADD       A, #Key
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R2, #7, L_0773

; end;
              RET

; 
; Function CalcBit: Boolean;

RSEG _BIT

CalcBit_Result:                 DBIT     1

; Var PulseDuraton: Word;


RSEG _CODE

CalcBit:
; begin
;   PulseDuraton := Timer.W - TimerConst - EquilizingTime;
              MOV       A, Timer
              ADD       A, #LOW  (14417)
              MOV       R2, A
              MOV       A, Timer+1
              ADDC      A, #HIGH (14417)
              MOV       R3, A
              MOV       A, R2
              MOV       R0, #EquilizingTime
              CLR       C
              SUBB      A, @R0
              MOV       R4, A
              INC       R0
              MOV       A, R3
              SUBB      A, @R0
              MOV       R2, A

;   If (PulseDuraton < LowThreshold) or (PulseDuraton > HighThreshold) then
              MOV       R0, #LowThreshold
              MOV       A, @R0
              SETB      C
              SUBB      A, R4
              INC       R0
              MOV       A, @R0
              SUBB      A, R2
              JNC       L_07AC
              MOV       R0, #HighThreshold
              MOV       A, @R0
              CLR       C
              SUBB      A, R4
              INC       R0
              MOV       A, @R0
              SUBB      A, R2
              JNC       L_07B7
L_07AC:

;     begin
;       RF_Led := False;
              CLR       RF_led

;       BitCounter := 0;
              CLR       A
              MOV       BitCounter, A

;       PreambleTimer := 0;
              MOV       PreambleTimer, A
              MOV       PreambleTimer+1, A

;       Exit;
              SJMP      L_07D9

;     end;
L_07B7:
;   RF_Led := True;
              SETB      RF_led

;   Result := PulseDuraton < Threshold;
              MOV       R0, #Threshold
              MOV       A, @R0
              SETB      C
              SUBB      A, R4
              INC       R0
              MOV       A, @R0
              SUBB      A, R2
              CPL       C
              MOV       CalcBit_Result, C

;   If Result then EquilizingTime := TE.W else EquilizingTime := 0;
              JNB       CalcBit_Result, L_07D3
              MOV       R1, #TE
              MOV       R0, #EquilizingTime
              MOV       A, @R1
              MOV       @R0, A
              INC       R0
              INC       R1
              MOV       A, @R1
              MOV       @R0, A
              SJMP      L_07D9
L_07D3:
              CLR       A
              MOV       R0, #EquilizingTime
              MOV       @R0, A
              INC       R0
              MOV       @R0, A

; end;
L_07D9:
              MOV       C, CalcBit_Result
              RET

; 
; Procedure SetBit (B0: Byte);

RSEG _DATA

B0:                             DS       1

; Var ByteCounter: Byte;


RSEG _CODE

SetBit:
; begin
;   ByteCounter := B0 shr 3;
              MOV       A, B0
              RRC       A
              RRC       A
              RRC       A
              ANL       A, #$1F
              MOV       R5, A

;   DataByte [ByteCounter] := DataByte [ByteCounter] shr 1;
              ADD       A, #EncryptedCode
              MOV       R0, A
              MOV       A, @R0
              CLR       C
              RRC       A
              MOV       R1, A
              MOV       A, R5
              ADD       A, #EncryptedCode
              MOV       R0, A
              MOV       @R0, AR1

;   If CalcBit then DataByte [ByteCounter] := DataByte [ByteCounter] or $80;
              LCALL     CalcBit
              JNC       L_07FE
              MOV       A, R5
              ADD       A, #EncryptedCode
              MOV       R0, A
              MOV       A, @R0
              ORL       A, #$80
              MOV       @R0, A
L_07FE:

; end;
              RET

; 
; Procedure StoreBit;

StoreBit:
; begin
;   Inc (BitCounter);
              INC       BitCounter

;   Case BitCounter of
              MOV       R2, BitCounter

;     5..12: PreambleTimer := PreambleTimer + (Timer.W - TimerConst);
              MOV       A, R2
              ADD       A, #-5
              JNC       L_0823
              ADD       A, #-8
              JC        L_0823
              MOV       A, Timer
              ADD       A, #LOW  (14417)
              MOV       R2, A
              MOV       A, Timer+1
              ADDC      A, #HIGH (14417)
              MOV       R3, A
              MOV       A, R2
              ADD       A, PreambleTimer
              MOV       PreambleTimer, A
              MOV       A, R3
              ADDC      A, PreambleTimer+1
              MOV       PreambleTimer+1, A
              LJMP      L_08F3
L_0823:

;     13: begin
              MOV       A, R2
              XRL       A, #$0D
              JZ        L_082B
              LJMP      L_08BF
L_082B:

;           TE.H := HighNib (Hi (PreambleTimer));
              MOV       Value, PreambleTimer+1
              LCALL     HighNib
              MOV       R0, #TE+1
              MOV       @R0, A

;           TE.L := NibToByte (LowNib (Hi (PreambleTimer)), HighNib (Lo (PreambleTimer)));   { Divide by 16 }
              MOV       Value, PreambleTimer+1
              LCALL     LowNib
              MOV       Hi, A
              MOV       Value, PreambleTimer
              LCALL     HighNib
              MOV       Lo, A
              LCALL     NibToByte
              DEC       R0
              MOV       @R0, A

;           LowThreshold  := TE.W + TE.W div 2;
              INC       R0
              MOV       A, @R0
              CLR       C
              RRC       A
              MOV       R3, A
              DEC       R0
              MOV       A, @R0
              RRC       A
              ADD       A, @R0
              MOV       R2, A
              INC       R0
              MOV       A, R3
              ADDC      A, @R0
              MOV       R0, #LowThreshold
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, A

;           HighThreshold := TE.W * 3 + TE.W div 2;
              MOV       R0, #TE+1
              MOV       A, @R0
              CLR       C
              RRC       A
              MOV       R5, A
              DEC       R0
              MOV       A, @R0
              RRC       A
              MOV       R4, A
              MOV       AR2, @R0
              INC       R0
              MOV       AR3, @R0
              MOV       R6, #LOW  (3)
              MOV       R7, #HIGH (3)
              LCALL     sysWordMultiplication
              MOV       A, R2
              ADD       A, R4
              MOV       R2, A
              MOV       A, R3
              ADDC      A, R5
              MOV       R0, #HighThreshold
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, A

;           Threshold := TE.W + TE.W + TE.W shr 1;
              MOV       R0, #TE+1
              MOV       A, @R0
              CLR       C
              RRC       A
              MOV       R5, A
              DEC       R0
              MOV       A, @R0
              RRC       A
              MOV       R4, A
              MOV       A, @R0
              MOV       R1, #TE
              ADD       A, @R1
              MOV       R2, A
              INC       R0
              MOV       A, @R0
              ADDC      A, @R0
              MOV       R3, A
              MOV       A, R2
              ADD       A, R4
              MOV       R2, A
              MOV       A, R3
              ADDC      A, R5
              MOV       R0, #Threshold
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, A

;           EquilizingTime := TE.W + TE.W;
              MOV       R0, #TE
              MOV       A, @R0
              ADD       A, @R1
              MOV       R0, #EquilizingTime
              MOV       @R0, A

;           EquilizingTime := EquilizingTime + EquilizingTime;
              ADD       A, @R0
              MOV       @R0, A

;           EquilizingTime := EquilizingTime + EquilizingTime;
              ADD       A, @R0

;           EquilizingTime := EquilizingTime +  TE.W;
              ADD       A, @R1
              MOV       R2, A
              MOV       R0, #EquilizingTime+2
              MOV       A, @R0
              MOV       R0, #TE+1
              ADDC      A, @R0
              MOV       R0, #EquilizingTime
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, A

;           SetBit (0);
              MOV       B0, #0
              LCALL     SetBit

;           DataByte [7] := 0;
              MOV       R0, #EncryptedCode+7
              MOV       @R0, #0

;         end;
              SJMP      L_08F3
L_08BF:

;     14..76: SetBit (BitCounter - 13);
              MOV       A, R2
              ADD       A, #-14
              JNC       L_08D2
              ADD       A, #-63
              JC        L_08D2
              MOV       A, R2
              ADD       A, #-13
              MOV       B0, A
              LCALL     SetBit
              SJMP      L_08F3
L_08D2:

;     77: begin
              CJNE      R2, #$4D, L_08DC

;           Vlow := CalcBit;
              LCALL     CalcBit
              MOV       Vlow, C

;        end;
              SJMP      L_08F3
L_08DC:

;     78: begin
              CJNE      R2, #$4E, L_08F3

;           RPT := CalcBit;
              LCALL     CalcBit
              MOV       RPT, C

;           BitCounter := 0;
              CLR       A
              MOV       BitCounter, A

;           PreambleTimer := 0;
              MOV       PreambleTimer, A
              MOV       PreambleTimer+1, A

;           KeyPacketReceived := True;
              SETB      KeyPacketReceived

;           ET0 := False;
;           KeyProcessingTimer := 0;
              MOV       KeyProcessingTimer, A
              MOV       KeyProcessingTimer+1, A

;           ET0 := True;
              SETB      IE.1

;         end;
L_08F3:
;   end;
;   NewBit := False;
              CLR       NewBit

; end;
              RET

; 
; Procedure SetRelay (R, Status: Byte);

RSEG _DATA

R:                              DS       1
Status:                         DS       1

; Var BoolSt: Boolean;

RSEG _BIT

BoolSt:                         DBIT     1


RSEG _CODE

SetRelay:
; begin
;   Case Status of
              MOV       R2, Status

;     0: begin
              CJNE      R2, #0, L_091A

;          BoolSt := Relay_OFF;
              SETB      BoolSt

;          Case R of
;            1..4: RelayTimer [R] := 0;
              MOV       R3, R
              MOV       A, R3
              ADD       A, #-1
              JNC       L_0914
              ADD       A, #-4
              JC        L_0914
              MOV       A, R3
              ADD       A, ACC
              ADD       A, #RelayTimer-2
              MOV       R0, A
              CLR       A
              MOV       @R0, A
              INC       R0
              MOV       @R0, A
              SJMP      L_0918
L_0914:

;            else Relay5_15Timer := 0;
              MOV       R0, #Relay5_15Timer
              MOV       @R0, #0
L_0918:

;          end;
;        end;
              SJMP      L_0932
L_091A:

;     1: BoolSt := Relay_ON;
              CJNE      R2, #1, L_0923
              CLR       BoolSt
              MOV       R3, R
              SJMP      L_0932
L_0923:
              MOV       R3, R

;     2: BoolSt := not Boolean (Relay [R]);
              CJNE      R2, #2, L_0932
              MOV       A, R3
              ADD       A, #Relay-1
              MOV       R0, A
              MOV       A, @R0
              ADD       A, #$FF
              CPL       C
              MOV       BoolSt, C
L_0932:

;   end;
;   Relay [R] := Byte (BoolSt);
              MOV       C, BoolSt
              CLR       A
              RLC       A
              MOV       R1, A
              MOV       A, R3
              ADD       A, #Relay-1
              MOV       R0, A
              MOV       @R0, AR1

;   Case R of
;     1: OUT1 := BoolSt;
              CJNE      R3, #1, L_0945
              MOV       C, BoolSt
              MOV       P1.6, C
              RET
L_0945:

;     2: OUT2 := BoolSt;
              CJNE      R3, #2, L_094D
              MOV       C, BoolSt
              MOV       P1.4, C
              RET
L_094D:

;     3: OUT3 := BoolSt;
              CJNE      R3, #3, L_0955
              MOV       C, BoolSt
              MOV       P1.7, C
              RET
L_0955:

;     4: OUT4 := BoolSt;
              CJNE      R3, #4, L_095C
              MOV       C, BoolSt
              MOV       P1.5, C
L_095C:

;   end;
; end;
              RET

; 
; Procedure  Decrypt;
; Const Table: Array [0..31] of Boolean = (

RSEG _CONST

Table:                          
;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         False,
                                DB        0                           ; $00 = 0

;         False,
                                DB        0                           ; $00 = 0

;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         False,
                                DB        0                           ; $00 = 0

;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         True,
                                DB        1                           ; $01 = 1

;         False,
                                DB        0                           ; $00 = 0

;         False);
                                DB        0                           ; $00 = 0

; 
; Var Count: Word;
;     Index: Byte;
;     Carry: Boolean;

RSEG _BIT

Carry:                          DBIT     1


RSEG _CODE

Decrypt:
; begin
;   DecryptOK := False;
              CLR       DecryptOK

;   For Count := 0 to 528 - 1 do
              MOV       R4, #LOW  ($FFFF)
              MOV       R5, #HIGH ($FFFF)
L_0963:
              INC       R4
              CJNE      R4, #0, L_0968
              INC       R5
L_0968:

;     begin
;       WatchDogReset := LowLevel;
              CLR       P3.4

;       Asm
;         NOP
              NOP

;       end;
;       WatchDogReset := HighLevel;
              SETB      P3.4

;       Index := 0;
              MOV       R2, #0

; 
;       If EncryptedCode [0] and $01 <> 0 then Index := Index or $01;
              MOV       R0, #EncryptedCode
              MOV       A, @R0
              JNB       ACC.0, L_0978
              ORL       AR2, #1
L_0978:

;       If EncryptedCode [1] and $01 <> 0 then Index := Index or $02;
              MOV       R0, #EncryptedCode+1
              MOV       A, @R0
              JNB       ACC.0, L_0981
              ORL       AR2, #2
L_0981:

;       If EncryptedCode [2] and $08 <> 0 then Index := Index or $04;
              MOV       R0, #EncryptedCode+2
              MOV       A, @R0
              JNB       ACC.3, L_098A
              ORL       AR2, #4
L_098A:

;       If EncryptedCode [3] and $02 <> 0 then Index := Index or $08;
              MOV       R0, #EncryptedCode+3
              MOV       A, @R0
              JNB       ACC.1, L_0993
              ORL       AR2, #8
L_0993:

;       If EncryptedCode [3] and $40 <> 0 then Index := Index or $10;
              MOV       R0, #EncryptedCode+3
              MOV       A, @R0
              JNB       ACC.6, L_099C
              ORL       AR2, #$10
L_099C:

; 
;       Carry := (EncryptedCode [1] and $80 <> 0) xor
;                (EncryptedCode [3] and $80 <> 0) xor
;                (Key [1] and $80 <> 0) xor Table [Index];
              MOV       A, R2
              MOV       DPTR, #Table
              MOVC      A, @A + DPTR
              JZ        L_09A5
              MOV       A, #1
L_09A5:
              MOV       R3, A
              MOV       R0, #Key+1
              MOV       A, @R0
              ANL       A, #$80
              JZ        L_09AF
              MOV       A, #1
L_09AF:
              MOV       R2, A
              MOV       R0, #EncryptedCode+3
              MOV       A, @R0
              ANL       A, #$80
              JZ        L_09B9
              MOV       A, #1
L_09B9:
              MOV       R1, A
              MOV       R0, #EncryptedCode+1
              MOV       A, @R0
              ANL       A, #$80
              JZ        L_09C3
              MOV       A, #1
L_09C3:
              XRL       A, R1
              XRL       A, R2
              XRL       A, R3
              RRC       A
              MOV       Carry, C

; 
;       Asm
;         MOV    C, Carry
              MOV       C, Carry

;         MOV    R0, #EncryptedCode
              MOV       R0, #EncryptedCode

;         MOV    B, #4
              MOV       B, #4

; @LOOP_1:
L_09D0:
;         MOV    A, @R0
              MOV       A, @R0

;         RLC    A
              RLC       A

;         MOV    @R0, A
              MOV       @R0, A

;         INC    R0
              INC       R0

;         DJNZ   B, @LOOP_1
              DJNZ      B, L_09D0

; 
;         MOV    R0, #Key + 7
              MOV       R0, #Key+7

;         MOV    A, @R0
              MOV       A, @R0

;         RLC    A
              RLC       A

;         MOV    R0, #Key + 0
              MOV       R0, #Key

;         MOV    B, #8
              MOV       B, #8

; @LOOP_2:
L_09E0:
;         MOV    A, @R0
              MOV       A, @R0

;         RLC    A
              RLC       A

;         MOV    @R0, A
              MOV       @R0, A

;         INC    R0
              INC       R0

;         DJNZ   B, @LOOP_2
              DJNZ      B, L_09E0

;       end;
;     end;
              MOV       A, R4
              XRL       A, #LOW  ($020F)
              JZ        L_09EF
              LJMP      L_0963
L_09EF:
              MOV       A, R5
              XRL       A, #HIGH ($020F)
              JZ        L_09F7
              LJMP      L_0963
L_09F7:

;   If EncryptedCode [3] and $F0 <> SerialNumber [3] and $F0 then Exit;       { Check if both key sets are equal }
              MOV       R0, #SerialNumber+3
              MOV       A, @R0
              ANL       A, #$F0
              MOV       R1, A
              MOV       R0, #EncryptedCode+3
              MOV       A, @R0
              ANL       A, #$F0
              CJNE      A, AR1, L_0A07

;   DecryptOK := True;
              SETB      DecryptOK

; end;
L_0A07:
              RET

; 
; Procedure GenerateKey;

GenerateKey:
; begin
;   EncryptedCode [0] := SerialNumber [0];
              MOV       R1, #SerialNumber
              MOV       R0, #EncryptedCode
              MOV       A, @R1
              MOV       @R0, A

;   EncryptedCode [1] := SerialNumber [1];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   EncryptedCode [2] := SerialNumber [2];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   EncryptedCode [3] := (SerialNumber [3] and $0F) or $20;
              MOV       R0, #SerialNumber+3
              MOV       A, @R0
              ANL       A, #$0F
              ORL       A, #$20
              MOV       R0, #EncryptedCode+3
              MOV       @R0, A

;   SetManufacturerKey;
              LCALL     SetManufacturerKey

;   Decrypt;
              LCALL     Decrypt

;   CalculatedKey [0] := EncryptedCode [0];
              MOV       R1, #EncryptedCode
              MOV       R0, #CalculatedKey
              MOV       A, @R1
              MOV       @R0, A

;   CalculatedKey [1] := EncryptedCode [1];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   CalculatedKey [2] := EncryptedCode [2];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   CalculatedKey [3] := EncryptedCode [3];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

; 
;   EncryptedCode [0] := SerialNumber [0];
              MOV       R1, #SerialNumber
              MOV       R0, #EncryptedCode
              MOV       A, @R1
              MOV       @R0, A

;   EncryptedCode [1] := SerialNumber [1];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   EncryptedCode [2] := SerialNumber [2];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   EncryptedCode [3] := (SerialNumber [3] and $0F) or $60;
              MOV       R0, #SerialNumber+3
              MOV       A, @R0
              ANL       A, #$0F
              ORL       A, #$60
              MOV       R0, #EncryptedCode+3
              MOV       @R0, A

;   SetManufacturerKey;
              LCALL     SetManufacturerKey

;   Decrypt;
              LCALL     Decrypt

;   CalculatedKey [4] := EncryptedCode [0];
              MOV       R1, #EncryptedCode
              MOV       R0, #CalculatedKey+4
              MOV       A, @R1
              MOV       @R0, A

;   CalculatedKey [5] := EncryptedCode [1];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   CalculatedKey [6] := EncryptedCode [2];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;   CalculatedKey [7] := EncryptedCode [3];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

; end;
              RET

; 
; Function TXInEEprom: Boolean;

RSEG _BIT

TXInEEprom_Result:              DBIT     1

; Var I: Word;


RSEG _CODE

TXInEEprom:
; Label NoMatch;
; begin
;   TXInEEprom := False;
              CLR       TXInEEprom_Result

;   TempWord.W := Ofs (TEEprom.EE_TXKeyData);
              MOV       TempWord, #LOW  ($0020)
              MOV       TempWord+1, #HIGH ($0020)

;   I := 1;
              MOV       R6, #LOW  (1)
              MOV       R7, #HIGH (1)

;   While I <= NumberOfLearnedKeys do
              SJMP      L_0AB6
L_0A77:

;     begin
;       Asm
;         MOV       A, TempWord
              MOV       A, TempWord

;         ADD       A, #LOW  (8)
              ADD       A, #8

;         MOV       DPL, A
              MOV       DPL, A

;         MOV       A, TempWord+1
              MOV       A, TempWord+1

;         ADDC      A, #HIGH (8)
              ADDC      A, #0

;         MOV       DPH, A
              MOV       DPH, A

;         LCALL     ReadBytesFromEEPROM
              LCALL     ReadBytesFromEEPROM

;         MOV       R0, #SerialNumber
              MOV       R0, #SerialNumber

;         MOV       A, R2
              MOV       A, R2

;         XRL       A, @R0
              XRL       A, @R0

;         JNZ       NoMatch
              JNZ       L_0AA8

;         INC       R0
              INC       R0

;         MOV       A, R3
              MOV       A, R3

;         XRL       A, @R0
              XRL       A, @R0

;         JNZ       NoMatch
              JNZ       L_0AA8

;         INC       R0
              INC       R0

;         MOV       A, R4
              MOV       A, R4

;         XRL       A, @R0
              XRL       A, @R0

;         JNZ       NoMatch
              JNZ       L_0AA8

;         INC       R0
              INC       R0

;         MOV       A, R5
              MOV       A, R5

;         XRL       A, @R0
              XRL       A, @R0

;         ANL       A, #$0F
              ANL       A, #$0F

;         JNZ       NoMatch
              JNZ       L_0AA8

;       end;
; 
;       TXInEEprom := True;
              SETB      TXInEEprom_Result

;       TXPositionInEEprom := I;
              MOV       R0, #TXPositionInEEprom
              MOV       @R0, AR6
              INC       R0
              MOV       @R0, AR7

;       Break;
              SJMP      L_0AC0

; 
; NoMatch:
L_0AA8:
; 
;       Inc (TempWord.W, SizeOf (TxData));
              MOV       R0, #TempWord
              MOV       R2, #LOW  ($000E)
              MOV       R3, #HIGH ($000E)
              LCALL     sysIncWord_IDATA_R3R2

;       Inc (I);
              INC       R6
              CJNE      R6, #0, L_0AB6
              INC       R7

;     end;
L_0AB6:
;   While I <= NumberOfLearnedKeys do
              MOV       R0, #NumberOfLearnedKeys
              MOV       A, @R0
              CLR       C
              SUBB      A, R6
              INC       R0
              MOV       A, @R0
              SUBB      A, R7
              JNC       L_0A77
L_0AC0:

; end;
              MOV       C, TXInEEprom_Result
              RET

; 
; Function SaveTxToEEprom: Boolean;

RSEG _BIT

SaveTxToEEprom_Result:          DBIT     1

; Var I: Byte;


RSEG _CODE

SaveTxToEEprom:
; begin
;   SaveTxToEEprom := True;
              SETB      SaveTxToEEprom_Result

;   If not TXInEEprom then
              LCALL     TXInEEprom
              JNC       L_0ACD
              LJMP      L_0B81
L_0ACD:

;     begin
;       TempWord.W := Ofs (TEEprom.EE_TXKeyData) + SizeOf (TxData) * NumberOfLearnedKeys;
              MOV       R0, #NumberOfLearnedKeys
              MOV       AR2, @R0
              INC       R0
              MOV       AR3, @R0
              MOV       R6, #LOW  ($000E)
              MOV       R7, #HIGH ($000E)
              LCALL     sysWordMultiplication
              MOV       A, R2
              ADD       A, #LOW  ($0020)
              MOV       TempWord, A
              MOV       A, R3
              ADDC      A, #HIGH ($0020)
              MOV       TempWord+1, A

; 
;      { Try to write to the EEPROM at the last location for new key }
; 
;       WriteByteToEEPROM (TempWord.W + SizeOf (TxData) - 1, $55);
              MOV       A, TempWord
              ADD       A, #LOW  ($000E)
              MOV       R2, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000E)
              MOV       R3, A
              MOV       A, R2
              ADD       A, #LOW  (-1)
              MOV       Address, A
              MOV       A, R3
              ADDC      A, #HIGH (-1)
              MOV       Address+1, A
              MOV       D, #$55
              LCALL     WriteByteToEEPROM

;       SaveTxToEEprom := ReadByteFromEEprom (TempWord.W + SizeOf (TxData) - 1) = $55;
              MOV       A, TempWord
              ADD       A, #LOW  ($000E)
              MOV       R2, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000E)
              MOV       R3, A
              MOV       A, R2
              ADD       A, #LOW  (-1)
              MOV       Ad, A
              MOV       A, R3
              ADDC      A, #HIGH (-1)
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              XRL       A, #$55
              ADD       A, #$FF
              CPL       C
              MOV       SaveTxToEEprom_Result, C

;       Delay (3);
              MOV       Dl, #LOW  (3)
              MOV       Dl+1, #HIGH (3)
              LCALL     Delay

;       If Result then
              JNB       SaveTxToEEprom_Result, L_0B6A

;         begin
;           WriteByteToEEPROM (TempWord.W + SizeOf (TxData) - 1, $AA);
              MOV       A, TempWord
              ADD       A, #LOW  ($000E)
              MOV       R2, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000E)
              MOV       R3, A
              MOV       A, R2
              ADD       A, #LOW  (-1)
              MOV       Address, A
              MOV       A, R3
              ADDC      A, #HIGH (-1)
              MOV       Address+1, A
              MOV       D, #$AA
              LCALL     WriteByteToEEPROM

;           SaveTxToEEprom := ReadByteFromEEprom (TempWord.W + SizeOf (TxData) - 1) = $AA;
              MOV       A, TempWord
              ADD       A, #LOW  ($000E)
              MOV       R2, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000E)
              MOV       R3, A
              MOV       A, R2
              ADD       A, #LOW  (-1)
              MOV       Ad, A
              MOV       A, R3
              ADDC      A, #HIGH (-1)
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              XRL       A, #$AA
              ADD       A, #$FF
              CPL       C
              MOV       SaveTxToEEprom_Result, C

;           Delay (3);
              MOV       Dl, #LOW  (3)
              MOV       Dl+1, #HIGH (3)
              LCALL     Delay

;         end;
L_0B6A:
; 
;       If not Result then
              JB        SaveTxToEEprom_Result, L_0B7C

;         begin
;           Display := 'F';
              MOV       Display, #'F'

;           Delay (500);
              MOV       Dl, #LOW  ($01F4)
              MOV       Dl+1, #HIGH ($01F4)
              LCALL     Delay

;           Exit;
              LJMP      L_0C10

;         end;
L_0B7C:
; 
;       Inc (NumberOfLearnedKeys);
              MOV       R0, #NumberOfLearnedKeys
              LCALL     sysIncWord_IDATA

;     end;
L_0B81:
;   For I := 0 to 7 do WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdKey)              + I, CalculatedKey [I]);
              MOV       R6, #$FF
L_0B83:
              INC       R6
              MOV       A, R6
              ADD       A, TempWord
              MOV       Address, A
              CLR       A
              ADDC      A, TempWord+1
              MOV       Address+1, A
              MOV       A, R6
              ADD       A, #CalculatedKey
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM
              CJNE      R6, #7, L_0B83

;   For I := 0 to 2 do WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdSerialNumber [0]) + I, SerialNumber [I]);
              MOV       R6, #$FF
L_0B9C:
              INC       R6
              MOV       A, TempWord
              ADD       A, #LOW  (8)
              MOV       R2, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH (8)
              MOV       R3, A
              MOV       A, R2
              ADD       A, R6
              MOV       Address, A
              MOV       A, R3
              ADDC      A, #0
              MOV       Address+1, A
              MOV       A, R6
              ADD       A, #SerialNumber
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM
              CJNE      R6, #2, L_0B9C

;   WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdSerialNumber [3]), SerialNumber [3] and $0F);
              MOV       A, TempWord
              ADD       A, #LOW  ($000B)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000B)
              MOV       Address+1, A
              MOV       R0, #SerialNumber+3
              MOV       A, @R0
              ANL       A, #$0F
              MOV       D, A
              LCALL     WriteByteToEEPROM

;   WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdCounter.L), Counter.L);
              MOV       A, TempWord
              ADD       A, #LOW  ($000C)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000C)
              MOV       Address+1, A
              MOV       R0, #EncryptedCode
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;   WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdCounter.H), Counter.H);
              MOV       A, TempWord
              ADD       A, #LOW  ($000D)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000D)
              MOV       Address+1, A
              INC       R0
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

; 
;   WriteByteToEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysLo), Lo (NumberOfLearnedKeys));
              MOV       Address, #LOW  (2)
              MOV       Address+1, #HIGH (2)
              MOV       R0, #NumberOfLearnedKeys
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;   WriteByteToEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysHi), Hi (NumberOfLearnedKeys));
              MOV       Address, #LOW  ($001F)
              MOV       Address+1, #HIGH ($001F)
              INC       R0
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

; end;
L_0C10:
              MOV       C, SaveTxToEEprom_Result
              RET

; 
; Procedure RemoveTx;
; Var LastTxAddress: Word;
;     I: Byte;

RemoveTx:
; begin
;   If not TXInEEprom then Exit;
              LCALL     TXInEEprom
              JC        L_0C19
              RET
L_0C19:

;   Display := 'D';
              MOV       Display, #'D'

;   WriteDisplay;
              LCALL     WriteDisplay

;   If NumberOfLearnedKeys > 1 then If TXPositionInEEprom <> NumberOfLearnedKeys then
              MOV       R0, #NumberOfLearnedKeys
              MOV       A, @R0
              ADD       A, #LOW  (-2)
              INC       R0
              MOV       A, @R0
              ADDC      A, #HIGH (-2)
              JNC       L_0C74
              DEC       R0
              MOV       A, @R0
              MOV       R1, #TXPositionInEEprom
              XRL       A, @R1
              JNZ       L_0C38
              INC       R0
              MOV       A, @R0
              MOV       R0, #TXPositionInEEprom+1
              XRL       A, @R0
              JZ        L_0C74
L_0C38:

;     begin
;       LastTxAddress := Ofs (TEEprom.EE_TXKeyData) + SizeOf (TxData) * Word (NumberOfLearnedKeys - 1);
              MOV       R0, #NumberOfLearnedKeys
              MOV       A, @R0
              ADD       A, #LOW  (-1)
              MOV       R2, A
              INC       R0
              MOV       A, @R0
              ADDC      A, #HIGH (-1)
              MOV       R3, A
              MOV       R6, #LOW  ($000E)
              MOV       R7, #HIGH ($000E)
              LCALL     sysWordMultiplication
              MOV       A, R2
              ADD       A, #LOW  ($0020)
              MOV       R1, A
              MOV       A, R3
              ADDC      A, #HIGH ($0020)
              MOV       R8, A

;       For I := 0 to 13 do
              MOV       R0, #$FF
L_0C55:
              INC       R0

;         WriteByteToEEPROM (TempWord.W + I, ReadByteFromEEPROM (LastTxAddress + I));
              MOV       A, R0
              ADD       A, TempWord
              MOV       Address, A
              CLR       A
              ADDC      A, TempWord+1
              MOV       Address+1, A
              MOV       A, R0
              ADD       A, R1
              MOV       Ad, A
              CLR       A
              ADDC      A, R8
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              MOV       D, A
              LCALL     WriteByteToEEPROM
              CJNE      R0, #$0D, L_0C55

;     end;
L_0C74:
;   Dec (NumberOfLearnedKeys);
              MOV       R0, #NumberOfLearnedKeys
              LCALL     sysDecWord_IDATA

;   WriteByteToEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysLo), Lo (NumberOfLearnedKeys));
              MOV       Address, #LOW  (2)
              MOV       Address+1, #HIGH (2)
              MOV       R0, #NumberOfLearnedKeys
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;   WriteByteToEEPROM (Ofs (TEEprom.EE_NumberOfLearnedKeysHi), Hi (NumberOfLearnedKeys));
              MOV       Address, #LOW  ($001F)
              MOV       Address+1, #HIGH ($001F)
              INC       R0
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;   Delay (20);
              MOV       Dl, #LOW  ($0014)
              MOV       Dl+1, #HIGH ($0014)
              LCALL     Delay
              MOV       R4, #LOW  (1)
              MOV       R5, #HIGH (1)

;   Repeat
L_0C9F:
;     Delay (1);
              MOV       Dl, R4
              MOV       Dl+1, R5
              LCALL     Delay

;   until not Sending;
              JB        Sending, L_0C9F

;   Delay (2);
              MOV       Dl, #LOW  (2)
              MOV       Dl+1, #HIGH (2)
              LCALL     Delay

;   TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;   SendStatus;
              LCALL     SendStatus

;   Delay (200);
              MOV       Dl, #LOW  ($00C8)
              MOV       Dl+1, #HIGH ($00C8)
              LJMP      Delay

; end;
; 
; Procedure DelayRelayTime1;

DelayRelayTime1:
; begin
;   Delay (32 * RelayTime [1].W);
              MOV       R0, #RelayTime
              MOV       AR2, @R0
              INC       R0
              MOV       AR3, @R0
              MOV       R6, #LOW  ($0020)
              MOV       R7, #HIGH ($0020)
              LCALL     sysWordMultiplication
              MOV       Dl, R2
              MOV       Dl+1, R3
              LJMP      Delay

; end;
; 
; Procedure DelayRelayTime2;

DelayRelayTime2:
; begin
;   Delay (32 * RelayTime [2].W);
              MOV       R0, #RelayTime+2
              MOV       AR2, @R0
              INC       R0
              MOV       AR3, @R0
              MOV       R6, #LOW  ($0020)
              MOV       R7, #HIGH ($0020)
              LCALL     sysWordMultiplication
              MOV       Dl, R2
              MOV       Dl+1, R3
              LJMP      Delay

; end;
; 
; Procedure DoorMotorOff;

DoorMotorOff:
; begin
;   SetRelay (2, 0); { Motor Off }
              MOV       R, #2
              MOV       Status, #0
              LCALL     SetRelay

;   DelayRelayTime1;
              LCALL     DelayRelayTime1

;   SetRelay (3, 0); { Lock Off }
              MOV       R, #3
              MOV       Status, #0
              LJMP      SetRelay

; end;
; 
; Procedure LightOnAndDelay;

LightOnAndDelay:
; begin
;   If Relay [4] = Byte (Relay_ON) then Exit;
              MOV       A, Relay+3
              JZ        L_0D18

;   RelayTimer [4] := RelayTime [4].W;
              MOV       R0, #RelayTime+6
              MOV       RelayTimer+6, @R0
              INC       R0
              MOV       RelayTimer+7, @R0

;   SetRelay (4, 1);
              MOV       R, #4
              MOV       Status, #1
              LCALL     SetRelay

;   DelayRelayTime2;
              LCALL     DelayRelayTime2

; end;
L_0D18:
              RET

; 
; Procedure ProcessDoor;

ProcessDoor:
; begin
;   Case DoorState of
;     dsStop: begin
              MOV       A, DoorState
              JZ        L_0D20
              LJMP      L_0E50
L_0D20:

;               If IN4 = LowLevel then
              JB        P1.3, L_0D68

;                 If IN2 = LowLevel then { Open Switch and LightCell = OK }
              JB        P1.1, L_0D68

;                   begin
;                     Case ModuleType of
              MOV       R2, ModuleType

;                       mtCrawford: begin
              CJNE      R2, #1, L_0D40

;                                     LightOnAndDelay;
              LCALL     LightOnAndDelay

;                                     RelayTimer [3] := RelayTime [1].W; { Down }
              MOV       R0, #RelayTime
              MOV       RelayTimer+4, @R0
              INC       R0
              MOV       RelayTimer+5, @R0

;                                     SetRelay (3, 1);
              MOV       R, #3
              MOV       Status, #1
              LCALL     SetRelay

;                                   end;
              SJMP      L_0D61
L_0D40:

;                       mtDoor: begin
              CJNE      R2, #2, L_0D61

;                                 SetRelay (1, MotorDown); { Direction Down }
              MOV       R, #1
              MOV       Status, #0
              LCALL     SetRelay

;                                 SetRelay (3, 1); { Lock Off }
              MOV       R, #3
              MOV       Status, #1
              LCALL     SetRelay

;                                 DelayRelayTime1;
              LCALL     DelayRelayTime1

;                                 SetRelay (2, 1); { Motor On }
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                               end;
L_0D61:
;                     end;
;                     DoorState := dsDown;
              MOV       DoorState, #2

;                     LastDoorState := dsDown;
              MOV       R0, #LastDoorState
              MOV       @R0, #2

;                   end;
L_0D68:
;               If IN3 = LowLevel then { Closed Switch }
              JB        P1.2, L_0DAD

;                 begin
;                   Case ModuleType of
              MOV       R2, ModuleType

;                     mtCrawford: begin
              CJNE      R2, #1, L_0D85

;                                   LightOnAndDelay;
              LCALL     LightOnAndDelay

;                                   RelayTimer [1] := RelayTime [1].W; { Up }
              MOV       R0, #RelayTime
              MOV       RelayTimer, @R0
              INC       R0
              MOV       RelayTimer+1, @R0

;                                   SetRelay (1, 1);
              MOV       R, #1
              MOV       Status, #1
              LCALL     SetRelay

;                                 end;
              SJMP      L_0DA6
L_0D85:

;                     mtDoor: begin
              CJNE      R2, #2, L_0DA6

;                               SetRelay (1, MotorUp); { Direction Up }
              MOV       R, #1
              MOV       Status, #1
              LCALL     SetRelay

;                               SetRelay (3, 1); { Lock Off }
              MOV       R, #3
              MOV       Status, #1
              LCALL     SetRelay

;                               DelayRelayTime1;
              LCALL     DelayRelayTime1

;                               SetRelay (2, 1); { Motor On }
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                             end;
L_0DA6:
;                   end;
;                   DoorState := dsUp;
              MOV       DoorState, #1

;                   LastDoorState := dsUp;
              MOV       R0, #LastDoorState
              MOV       @R0, #1

;                 end;
L_0DAD:
;               If IN3 = HighLevel then
              JB        P1.2, L_0DB3
              LJMP      L_0E4E
L_0DB3:

;                 If IN4 = HighLevel then { No Switch }
              JB        P1.3, L_0DB9
              LJMP      L_0E4E
L_0DB9:

;                   begin
;                     If IN2 = HighLevel then LastDoorState := dsDown;
              JNB       P1.1, L_0DC0
              MOV       R0, #LastDoorState
              MOV       @R0, #2
L_0DC0:

;                       Case LastDoorState of
              MOV       R0, #LastDoorState

;                         dsUp: If IN2 = LowLevel then
              CJNE      @R0, #1, L_0E0C
              JB        P1.1, L_0E0A

;                                 begin { now Down }
;                                   Case ModuleType of
              MOV       R2, ModuleType

;                                     mtCrawford: begin
              CJNE      R2, #1, L_0DE2

;                                                   LightOnAndDelay;
              LCALL     LightOnAndDelay

;                                                   RelayTimer [3] := RelayTime [1].W; { Down }
              MOV       R0, #RelayTime
              MOV       RelayTimer+4, @R0
              INC       R0
              MOV       RelayTimer+5, @R0

;                                                   SetRelay (3, 1);
              MOV       R, #3
              MOV       Status, #1
              LCALL     SetRelay

;                                                 end;
              SJMP      L_0E03
L_0DE2:

;                                     mtDoor: begin
              CJNE      R2, #2, L_0E03

;                                               SetRelay (1, MotorDown); { Direction Down }
              MOV       R, #1
              MOV       Status, #0
              LCALL     SetRelay

;                                               SetRelay (3, 1); { Lock Off }
              MOV       R, #3
              MOV       Status, #1
              LCALL     SetRelay

;                                               DelayRelayTime1;
              LCALL     DelayRelayTime1

;                                               SetRelay (2, 1); { Motor On }
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                                             end;
L_0E03:
;                                   end;
;                                   DoorState := dsDown;
              MOV       DoorState, #2

;                                   LastDoorState := dsDown;
              MOV       R0, #LastDoorState
              MOV       @R0, #2

;                                 end;
L_0E0A:
              SJMP      L_0E4E
L_0E0C:

;                         else begin
;                                Case ModuleType of
              MOV       R2, ModuleType

;                                  mtCrawford: begin
              CJNE      R2, #1, L_0E26

;                                                LightOnAndDelay;
              LCALL     LightOnAndDelay

;                                                RelayTimer [1] := RelayTime [1].W; { Up }
              MOV       R0, #RelayTime
              MOV       RelayTimer, @R0
              INC       R0
              MOV       RelayTimer+1, @R0

;                                                SetRelay (1, 1);
              MOV       R, #1
              MOV       Status, #1
              LCALL     SetRelay

;                                              end;
              SJMP      L_0E47
L_0E26:

;                                  mtDoor: begin
              CJNE      R2, #2, L_0E47

;                                            SetRelay (1, MotorUp); { Direction Up }
              MOV       R, #1
              MOV       Status, #1
              LCALL     SetRelay

;                                            SetRelay (3, 1); { Lock Off }
              MOV       R, #3
              MOV       Status, #1
              LCALL     SetRelay

;                                            DelayRelayTime1;
              LCALL     DelayRelayTime1

;                                            SetRelay (2, 1); { Motor On }
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                                          end;
L_0E47:
;                                end;
;                                DoorState := dsUp;
              MOV       DoorState, #1

;                                LastDoorState := dsUp;
              MOV       R0, #LastDoorState
              MOV       @R0, #1

;                              end;
;                       end
;                   end;
L_0E4E:
;             end;
              SJMP      L_0E70
L_0E50:

;     else begin { Up or Down }
;            Case ModuleType of
              MOV       R2, ModuleType

;              mtCrawford: begin
              CJNE      R2, #1, L_0E67

;                            RelayTimer [2] := RelayTime [1].W; { Stop }
              MOV       R0, #RelayTime
              MOV       RelayTimer+2, @R0
              INC       R0
              MOV       RelayTimer+3, @R0

;                            SetRelay (2, 1);
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                          end;
              SJMP      L_0E6D
L_0E67:

;              mtDoor: DoorMotorOff;
              CJNE      R2, #2, L_0E6D
              LCALL     DoorMotorOff
L_0E6D:

;            end;
;            DoorState := dsStop;
              MOV       DoorState, #0

;          end
L_0E70:
;   end;
;   RelayTimer [4] := RelayTime [4].W;
              MOV       R0, #RelayTime+6
              MOV       RelayTimer+6, @R0
              INC       R0
              MOV       RelayTimer+7, @R0

;   SetRelay (4, 1);
              MOV       R, #4
              MOV       Status, #1
              LJMP      SetRelay

; end;
; 
; Procedure SetRelayTimer;

SetRelayTimer:
; begin
;   RelayTimer [TempByte] := RelayTime [TempByte].W;
              MOV       A, TempByte
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       AR2, @R0
              INC       R0
              MOV       AR3, @R0
              MOV       A, TempByte
              ADD       A, ACC
              ADD       A, #RelayTimer-2
              MOV       R0, A
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, AR3

; end;
              RET

; 
; Procedure ProcessNormalTxKey;

ProcessNormalTxKey:
; begin
;   If HighNib (ChData [TempByte]) = TxKeyBits then
              MOV       A, TempByte
              ADD       A, #ChData-1
              MOV       R0, A
              MOV       Value, @R0
              LCALL     HighNib
              CJNE      A, TxKeyBits, L_0F1B

;     Case TChType (ChData [TempByte] and $0F) of
              MOV       A, TempByte
              ADD       A, #ChData-1
              MOV       R0, A
              MOV       A, @R0
              ANL       A, #$0F

;       chFollow: begin
              JNZ       L_0ED9

;                   Case TempByte of
;                     1..4: RelayTimer [TempByte] := TempWord.L;
              MOV       A, TempByte
              ADD       A, #-1
              JNC       L_0EC8
              ADD       A, #-4
              JC        L_0EC8
              MOV       A, TempByte
              ADD       A, ACC
              ADD       A, #RelayTimer-2
              MOV       R0, A
              MOV       @R0, TempWord
              INC       R0
              MOV       @R0, #0
              SJMP      L_0ED0
L_0EC8:

;                     else begin
;                            Relay5_15 := TempByte;
              MOV       R0, #Relay5_15
              MOV       @R0, TempByte

;                            Relay5_15Timer := TempWord.L;
              MOV       R0, #Relay5_15Timer
              MOV       @R0, TempWord

;                          end;
L_0ED0:
;                   end;
;                   SetRelay (TempByte, 1);
              MOV       R, TempByte
              MOV       Status, #1
              LJMP      SetRelay

;                 end;
L_0ED9:
;       chToggle: begin
              CJNE      A, #1, L_0EE8

;                   If RPT then Exit;
              JB        RPT, L_0F1B

;                   SetRelay (TempByte, 2);
              MOV       R, TempByte
              MOV       Status, #2
              LJMP      SetRelay

;                 end;
L_0EE8:
;       chPulse: If TempByte <= 4 then
              CJNE      A, #2, L_0F1B
              MOV       A, TempByte
              ADD       A, #-5
              JC        L_0F1B

;                 Case Boolean (Relay [TempByte]) of
              MOV       A, TempByte
              ADD       A, #Relay-1
              MOV       R0, A
              MOV       A, @R0

;                   Relay_OFF: If not RPT then
              JZ        L_0F09
              JB        RPT, L_0F08

;                                begin
;                                  SetRelayTimer;
              LCALL     SetRelayTimer

;                                  SetRelay (TempByte, 1);
              MOV       R, TempByte
              MOV       Status, #1
              LCALL     SetRelay

;                                end;
L_0F08:
              RET
L_0F09:

;                   Relay_ON: begin
;                               If RPT then SetRelayTimer;
              JNB       RPT, L_0F0F
              LCALL     SetRelayTimer
L_0F0F:

;                               SetRelay (TempByte, Byte (RPT));
              MOV       R, TempByte
              MOV       C, RPT
              CLR       A
              RLC       A
              MOV       Status, A
              LCALL     SetRelay

;                             end;
;                 end;
;     end;
; end;
L_0F1B:
              RET

; 
; Procedure ProcessBlinds12State;

ProcessBlinds12State:
; begin
;   If RPT then Exit;
              JB        RPT, L_0F7E

;   Case Blinds12State of
              MOV       R2, Blinds12State

;     bsIdle:        begin
              CJNE      R2, #0, L_0F40

;                      SetRelay (2, 0);   { Just in case }
              MOV       R, #2
              MOV       Status, #0
              LCALL     SetRelay

;                      TempByte := 1;
              MOV       TempByte, #1

;                      SetRelayTimer;
              LCALL     SetRelayTimer

;                      SetRelay (1, 1);
              MOV       R, #1
              MOV       Status, #1
              LCALL     SetRelay

;                      Blinds12State := bsOut1;
              MOV       Blinds12State, #1

;                    end;
              RET
L_0F40:

;     bsOut1:        begin
              CJNE      R2, #1, L_0F50

;                      SetRelay (1, 0);
              MOV       R, #1
              MOV       Status, #0
              LCALL     SetRelay

;                      Blinds12State := bsIdleBetween;
              MOV       Blinds12State, #2

;                    end;
              RET
L_0F50:

;     bsIdleBetween: begin
              CJNE      R2, #2, L_0F6F

;                      SetRelay (1, 0);   { Just in case }
              MOV       R, #1
              MOV       Status, #0
              LCALL     SetRelay

;                      TempByte := 2;
              MOV       TempByte, #2

;                      SetRelayTimer;
              LCALL     SetRelayTimer

;                      SetRelay (2, 1);
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                      Blinds12State := bsOut2;
              MOV       Blinds12State, #3

;                    end;
              RET
L_0F6F:

;     bsOut2:        begin
              CJNE      R2, #3, L_0F7E

;                      SetRelay (2, 0);
              MOV       R, #2
              MOV       Status, #0
              LCALL     SetRelay

;                      Blinds12State := bsIdle;
              MOV       Blinds12State, #0

;                    end;
;   end;
; end;
L_0F7E:
              RET

; 
; Procedure ProcessBlinds34State;

ProcessBlinds34State:
; begin
;   If RPT then Exit;
              JB        RPT, L_0FE1

;   Case Blinds34State of
              MOV       R2, Blinds34State

;     bsIdle:        begin
              CJNE      R2, #0, L_0FA3

;                      SetRelay (4, 0);   { Just in case }
              MOV       R, #4
              MOV       Status, #0
              LCALL     SetRelay

;                      TempByte := 3;
              MOV       TempByte, #3

;                      SetRelayTimer;
              LCALL     SetRelayTimer

;                      SetRelay (3, 1);
              MOV       R, #3
              MOV       Status, #1
              LCALL     SetRelay

;                      Blinds34State := bsOut1;
              MOV       Blinds34State, #1

;                    end;
              RET
L_0FA3:

;     bsOut1:        begin
              CJNE      R2, #1, L_0FB3

;                      SetRelay (3, 0);
              MOV       R, #3
              MOV       Status, #0
              LCALL     SetRelay

;                      Blinds34State := bsIdleBetween;
              MOV       Blinds34State, #2

;                    end;
              RET
L_0FB3:

;     bsIdleBetween: begin
              CJNE      R2, #2, L_0FD2

;                      SetRelay (3, 0);   { Just in case }
              MOV       R, #3
              MOV       Status, #0
              LCALL     SetRelay

;                      TempByte := 4;
              MOV       TempByte, #4

;                      SetRelayTimer;
              LCALL     SetRelayTimer

;                      SetRelay (4, 1);
              MOV       R, #4
              MOV       Status, #1
              LCALL     SetRelay

;                      Blinds34State := bsOut2;
              MOV       Blinds34State, #3

;                    end;
              RET
L_0FD2:

;     bsOut2:        begin
              CJNE      R2, #3, L_0FE1

;                      SetRelay (4, 0);
              MOV       R, #4
              MOV       Status, #0
              LCALL     SetRelay

;                      Blinds34State := bsIdle;
              MOV       Blinds34State, #0

;                    end;
;   end;
; end;
L_0FE1:
              RET

; 
; Procedure ProcessTxKey;
; 
;   Procedure DelayRelay2;

DelayRelay2:
;   begin
;     RelayTimer [2] := RelayTime [1].W;
              MOV       R0, #RelayTime
              MOV       RelayTimer+2, @R0
              INC       R0
              MOV       RelayTimer+3, @R0

;     Repeat
L_0FE9:
;       WriteDisplay;
              LCALL     WriteDisplay

;     until RelayTimer [2] = 0;
              MOV       A, RelayTimer+3
              ORL       A, RelayTimer+2
              JNZ       L_0FE9

;   end;
              RET

; 
;   Procedure ProcessModuleType;

ProcessModuleType:
;   begin
;     Case ModuleType of
              MOV       R2, ModuleType

;       mtNormal: begin
              CJNE      R2, #0, L_1048

;                   Case mfBlinds12 in ModuleFlags of
              MOV       R0, #ModuleFlags
              MOV       A, @R0

;                     True: If HighNib (ChData [1]) = TxKeyBits then ProcessBlinds12State;
              JNB       ACC.0, L_100D
              MOV       R0, #ChData
              MOV       Value, @R0
              LCALL     HighNib
              CJNE      A, TxKeyBits, L_100B
              LCALL     ProcessBlinds12State
L_100B:
              SJMP      L_1019
L_100D:

;                     else
;                       TempByte := 1;
              MOV       TempByte, #1

;                       ProcessNormalTxKey;
              LCALL     ProcessNormalTxKey

;                       TempByte := 2;
              MOV       TempByte, #2

;                       ProcessNormalTxKey;
              LCALL     ProcessNormalTxKey
L_1019:

;                   end;
;                   Case mfBlinds34 in ModuleFlags of
              MOV       R0, #ModuleFlags
              MOV       A, @R0

;                     True: If HighNib (ChData [3]) = TxKeyBits then ProcessBlinds34State;
              JNB       ACC.1, L_102E
              MOV       R0, #ChData+2
              MOV       Value, @R0
              LCALL     HighNib
              CJNE      A, TxKeyBits, L_102C
              LCALL     ProcessBlinds34State
L_102C:
              SJMP      L_103A
L_102E:

;                     else
;                       TempByte := 3;
              MOV       TempByte, #3

;                       ProcessNormalTxKey;
              LCALL     ProcessNormalTxKey

;                       TempByte := 4;
              MOV       TempByte, #4

;                       ProcessNormalTxKey;
              LCALL     ProcessNormalTxKey
L_103A:

;                   end;
;                   For TempByte := 5 to 15 do ProcessNormalTxKey;
              MOV       TempByte, #4
L_103D:
              INC       TempByte
              LCALL     ProcessNormalTxKey
              MOV       A, TempByte
              CJNE      A, #$0F, L_103D

;                 end;
              RET
L_1048:

; 
;       mtCrawford,
              MOV       A, R2
              XRL       A, #1
              JZ        L_1050
              CJNE      R2, #2, L_106F
L_1050:

;       mtDoor:     begin
;                     If HighNib (ChData [1]) <> TxKeyBits then Exit;
              MOV       R0, #ChData
              MOV       Value, @R0
              LCALL     HighNib
              XRL       A, TxKeyBits
              JZ        L_105C
              RET
L_105C:

;                     If RPT then Exit;
              JB        RPT, L_10D7

;                     If NoKeyTimer = 0 then ProcessDoor;
              MOV       A, NoKeyTimer+1
              ORL       A, NoKeyTimer
              JNZ       L_1068
              LCALL     ProcessDoor
L_1068:

;                     NoKeyTimer := NoKeyTime;
              MOV       NoKeyTimer, #LOW  ($0064)
              MOV       NoKeyTimer+1, #HIGH ($0064)

;                   end;
              RET
L_106F:

;       mtAlarm: begin
              CJNE      R2, #3, L_10D7

;                  For TempByte := 3 to 4 do ProcessNormalTxKey;
              MOV       TempByte, #2
L_1075:
              INC       TempByte
              LCALL     ProcessNormalTxKey
              MOV       A, TempByte
              CJNE      A, #4, L_1075

;                  If HighNib (ChData [1]) <> TxKeyBits then Exit;
              MOV       R0, #ChData
              MOV       Value, @R0
              LCALL     HighNib
              CJNE      A, TxKeyBits, L_10D7

;                  If RPT then Exit;
              JB        RPT, L_10D7

;                  SetRelay (1, 2);
              MOV       R, #1
              MOV       Status, #2
              LCALL     SetRelay

;                  Case Boolean (Relay [1]) of
              MOV       A, Relay

;                    Relay_OFF: begin
              JZ        L_10A9

;                                 RelayTimer [2] := RelayTime [2].W;
              MOV       R0, #RelayTime+2
              MOV       RelayTimer+2, @R0
              INC       R0
              MOV       RelayTimer+3, @R0

;                                 SetRelay (2, 1);
              MOV       R, #2
              MOV       Status, #1
              LJMP      SetRelay

;                               end;
L_10A9:
;                    Relay_ON: begin
;                                 SetRelay (2, 1);
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                                 DelayRelay2;
              LCALL     DelayRelay2

;                                 DelayRelay2;
              LCALL     DelayRelay2

;                                 SetRelay (2, 1);
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                                 DelayRelay2;
              LCALL     DelayRelay2

;                                 DelayRelay2;
              LCALL     DelayRelay2

;                                 SetRelay (2, 1);
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                                 RelayTimer [2] := RelayTime [1].W;
              MOV       R0, #RelayTime
              MOV       RelayTimer+2, @R0
              INC       R0
              MOV       RelayTimer+3, @R0

;                              end;
;                  end;
;                end;
;     end;
;   end;
L_10D7:
              RET

ProcessTxKey:
; 
; begin
;   Display := HexChar [TxKeyBits];
              MOV       A, TxKeyBits
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;   Case ModuleType of
;     mtDoor: ClsTimer := 600;
              MOV       A, ModuleType
              CJNE      A, #2, L_10EE
              MOV       R0, #ClsTimer
              MOV       @R0, #LOW  ($0258)
              INC       R0
              MOV       @R0, #HIGH ($0258)
              SJMP      L_10F5
L_10EE:

;     else ClsTimer := 600;
              MOV       R0, #ClsTimer
              MOV       @R0, #LOW  ($0258)
              INC       R0
              MOV       @R0, #HIGH ($0258)
L_10F5:

;   end;
;   If ReadByteFromEEPROM (TempWord.W + Ofs (TxData.tdSerialNumber [3])) and $10 = 0 then
              MOV       A, TempWord
              ADD       A, #LOW  ($000B)
              MOV       Ad, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000B)
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              JB        ACC.4, L_1128

;     begin                                        { Not disabled }
;       ET0 := False;
              CLR       IE.1

;       TempWord.L := KeyProcessingTimer div 32;
              MOV       R2, KeyProcessingTimer
              MOV       R3, KeyProcessingTimer+1
              MOV       R1, #5
              LCALL     sysWordShiftRight

;       ET0 := True;
              SETB      IE.1

;       Inc (TempWord.L, 10);
              MOV       A, R2
              ADD       A, #$0A
              MOV       TempWord, A

;       If TxKeyBits <> LastTxKeyBits then
              MOV       A, TxKeyBits
              XRL       A, LastTxKeyBits
              JZ        L_1125

;         TempWord.L := 2 * TempWord.L;
              MOV       A, TempWord
              ADD       A, ACC
              MOV       TempWord, A
L_1125:

;       ProcessModuleType;
              LCALL     ProcessModuleType

;     end;
L_1128:
;   If TxKeyBits <> LastTxKeyBits then
              MOV       A, TxKeyBits
              XRL       A, LastTxKeyBits
              JZ        L_1183

;     begin
;       If not AuxModule then SendToTerminal;
              JB        P2.4, L_1134
              LCALL     SendToTerminal
L_1134:

;       DelayTimer := (ModuleAddress and $03) * 10;
              MOV       A, ModuleAddress
              ANL       A, #3
              MOV       B, #$0A
              MUL       AB
              MOV       R0, #DelayTimer
              MOV       @R0, A
              INC       R0
              MOV       @R0, #0

;       Repeat
L_1142:
;         WriteDisplay;
              LCALL     WriteDisplay

;       until DelayTimer = 0;
              MOV       R0, #DelayTimer+1
              MOV       A, @R0
              DEC       R0
              ORL       A, @R0
              JNZ       L_1142

;       Repeat until not Sending;
L_114C:
              JB        Sending, L_114C

;       TX_Buffer [bpCommand] := Cmd_LNG_Tx;
              MOV       R0, #TX_Buffer+2
              MOV       @R0, #$57

;       TX_Buffer [bpDestinationAddress] := $FF;
              DEC       R0
              MOV       @R0, #$FF

;       TX_Buffer [bpParameter1] := Counter.H;
              MOV       R1, #EncryptedCode+1
              MOV       R0, #TX_Buffer+3
              MOV       A, @R1
              MOV       @R0, A

;       TX_Buffer [bpParameter2] := Counter.L;
              DEC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;       TX_Buffer [bpParameter3] := SerialNumber [3] and $0F or TempWord.H;
              MOV       R0, #SerialNumber+3
              MOV       A, @R0
              ANL       A, #$0F
              ORL       A, TempWord+1
              MOV       R0, #TX_Buffer+7
              MOV       @R0, A

;       TX_Buffer [bpParameter4] := SerialNumber [2];
              MOV       R1, #SerialNumber+2
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;       TX_Buffer [bpParameter5] := SerialNumber [1];
              DEC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;       TX_Buffer [bpParameter6] := SerialNumber [0];
              DEC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;       TX_Buffer [bpParameter7] := TxKeyBits;
              INC       R0
              MOV       @R0, TxKeyBits

;       TX_Buffer [bpParameter8] := Byte (VLow);
              MOV       C, Vlow
              CLR       A
              RLC       A
              INC       R0
              MOV       @R0, A

;       SendLNGBlock;
              LCALL     SendLNGBlock

;     end;
L_1183:
;   LastTxKeyBits := TxKeyBits;
              MOV       LastTxKeyBits, TxKeyBits

; end;
              RET

; 
; 
; Procedure ProcessTxPacket;
; Var I: Byte;
; 
;   Function CheckPgmKey: Boolean;

RSEG _BIT

CheckPgmKey_Result:             DBIT     1


RSEG _CODE

CheckPgmKey:
;   begin
;     CheckPgmKey := False;
              CLR       CheckPgmKey_Result

;     If SerialNumber [3] and $0F <> $0B then Exit;
              MOV       R0, #SerialNumber+3
              MOV       A, @R0
              ANL       A, #$0F
              CJNE      A, #$0B, L_119F

;     If SerialNumber [2] <> $EE then Exit;
              DEC       R0
              CJNE      @R0, #$EE, L_119F

;     If SerialNumber [1] <> $00 then Exit;
              DEC       R0
              CJNE      @R0, #0, L_119F

;     If SerialNumber [0] <> $01 then Exit;
              DEC       R0
              CJNE      @R0, #1, L_119F

;     CheckPgmKey := True;
              SETB      CheckPgmKey_Result

;   end;
L_119F:
              MOV       C, CheckPgmKey_Result
              RET

; 
;   Procedure UpdateCounter;

UpdateCounter:
;   begin
;     WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdCounter.L), Counter.L);
              MOV       A, TempWord
              ADD       A, #LOW  ($000C)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000C)
              MOV       Address+1, A
              MOV       R0, #EncryptedCode
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;     WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdCounter.H), Counter.H);
              MOV       A, TempWord
              ADD       A, #LOW  ($000D)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000D)
              MOV       Address+1, A
              INC       R0
              MOV       D, @R0
              LJMP      WriteByteToEEPROM

;   end;
; 
; 
;   Procedure GenerateKeyAndDecrypt;

GenerateKeyAndDecrypt:
;   begin
;     TempBits32 [0] := EncryptedCode [0];
              MOV       R1, #EncryptedCode
              MOV       R0, #TempBits32
              MOV       A, @R1
              MOV       @R0, A

;     TempBits32 [1] := EncryptedCode [1];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;     TempBits32 [2] := EncryptedCode [2];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;     TempBits32 [3] := EncryptedCode [3];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;     GenerateKey;
              LCALL     GenerateKey

;     EncryptedCode [0] := TempBits32 [0];
              MOV       R1, #TempBits32
              MOV       R0, #EncryptedCode
              MOV       A, @R1
              MOV       @R0, A

;     EncryptedCode [1] := TempBits32 [1];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;     EncryptedCode [2] := TempBits32 [2];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;     EncryptedCode [3] := TempBits32 [3];
              INC       R1
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;     SetCalculatedKey;
              LCALL     SetCalculatedKey

;     Decrypt;
              LJMP      Decrypt

;   end;

ProcessTxPacket:
; 
; begin
;   TxKeyBits := (DataByte [7] shr 5) and $07;
              MOV       R0, #EncryptedCode+7
              MOV       A, @R0
              SWAP      A
              RRC       A
              ANL       A, #7
              MOV       TxKeyBits, A

;   If (DataByte [7] and $10) <> 0 then TxKeyBits := TxKeyBits or $08;
              MOV       A, @R0
              JNB       ACC.4, L_1204
              ORL       TxKeyBits, #8
L_1204:

;   KeyPacketReceived := False;
              CLR       KeyPacketReceived

;   If TxKeyBits = 0 then Exit;
              MOV       A, TxKeyBits
              JNZ       L_120B
              RET
L_120B:

;   Case Setup of
              MOV       R2, Setup

;     None: begin
              MOV       A, R2
              JZ        L_1213
              LJMP      L_137E
L_1213:

;             If RPT then
              JNB       RPT, L_1221

;               If not TempSet then
              JB        TempSet, L_1221

;                 begin
;                   If TxKeyBits <> LastTxKeyBits then RPT := False;
              MOV       A, TxKeyBits
              XRL       A, LastTxKeyBits
              JZ        L_1221
              CLR       RPT

;                 end;
L_1221:
;             If Key_Enter = LowLevel then
              JB        P2.3, L_1236

;               begin
;                 KeyPacketReceived := True;
              SETB      KeyPacketReceived

;                 Setup := LearnKey;
              MOV       Setup, #1

;                 TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;                 Repeat
L_122D:
;                   RestartWatchDog;
              LCALL     RestartWatchDog

;                 until not Sending;
              JB        Sending, L_122D

;                 SendStatus;
              LJMP      SendStatus

;                 Exit;
;               end;
L_1236:
; 
;             If not TXInEEprom then
              LCALL     TXInEEprom
              JC        L_1269

;               Case AutoSaveDisabled of
;                 True: begin
              JNB       P2.5, L_125C

;                         If not AuxModule then
              JB        P2.4, L_125B

;                           begin
; 
;                           { Send to terminal if TX is not in EEPROM }
; 
;                             GenerateKeyAndDecrypt;
              LCALL     GenerateKeyAndDecrypt

;                             If not DecryptOK then Exit;
              JB        DecryptOK, L_1248
              RET
L_1248:

;                             If TxKeyBits <> LastTxKeyBits then SendToTerminal;
              MOV       A, TxKeyBits
              XRL       A, LastTxKeyBits
              JZ        L_1251
              LCALL     SendToTerminal
L_1251:

;                             LastTxKeyBits := TxKeyBits;
              MOV       LastTxKeyBits, TxKeyBits

;                             ClsTimer := 600;                             { Delay before LastTxKeyBits is cleared }
              MOV       R0, #ClsTimer
              MOV       @R0, #LOW  ($0258)
              INC       R0
              MOV       @R0, #HIGH ($0258)

;                           end;
L_125B:
; 
;                         Exit;
              RET

;                       end;
L_125C:
;                 else
;                   GenerateKeyAndDecrypt;
              LCALL     GenerateKeyAndDecrypt

;                   If not DecryptOK then Exit;
              JB        DecryptOK, L_1263
              RET
L_1263:

;                   If not SaveTxToEEprom then Exit;
              LCALL     SaveTxToEEprom
              JC        L_1269
              RET
L_1269:

;               end;
; 
;             For I := 0 to 7 do Key [I] := ReadByteFromEEprom (TempWord.W + Ofs (TxData.tdKey) + I);
              MOV       R6, #$FF
L_126B:
              INC       R6
              MOV       A, R6
              ADD       A, TempWord
              MOV       Ad, A
              CLR       A
              ADDC      A, TempWord+1
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              MOV       R1, A
              MOV       A, R6
              ADD       A, #Key
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R6, #7, L_126B

;             Decrypt;
              LCALL     Decrypt

;             If not DecryptOK then Exit;
              JB        DecryptOK, L_128A
              RET
L_128A:

;             If Key_Cancel = LowLevel then
              JB        P2.2, L_1290

;               begin
;                 RemoveTx;
              LJMP      RemoveTx

;                 Exit;
;               end;
L_1290:
;             If Key_Up = LowLevel then
              JB        P2.1, L_12AF

;               begin
;                 Setup := SetModuleType;
              MOV       Setup, #3

;                 TempModuleType := ModuleType;
              MOV       TempModuleType, ModuleType

;                 SetupTimer := SetupTime;
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)

;                 For I := 1 to 15 do SetRelay (I, 0);
              MOV       R4, #0
              MOV       R5, #0
L_12A3:
              INC       R4
              MOV       R, R4
              MOV       Status, R5
              LCALL     SetRelay
              CJNE      R4, #$0F, L_12A3

;                 Exit;
              RET

;               end;
L_12AF:
;             If Key_Down = LowLevel then
              JB        P2.0, L_12DF

;               begin
;                 Setup := SetBlindsMode;
              MOV       Setup, #7

;                 If mfBlinds12 in ModuleFlags then
              MOV       R0, #ModuleFlags
              MOV       A, @R0
              JNB       ACC.0, L_12C9

;                   Case mfBlinds34 in ModuleFlags of
              MOV       A, @R0

;                     True: BlindsMode := bmCh1234;
              JNB       ACC.1, L_12C4
              MOV       BlindsMode, #3
              SJMP      L_12D5
L_12C4:

;                     else  BlindsMode := bmCh12;
              MOV       BlindsMode, #1
              SJMP      L_12D5
L_12C9:

;                   end else If mfBlinds34 in ModuleFlags then BlindsMode := bmCh34 else BlindsMode := bmNone;
              MOV       A, @R0
              JNB       ACC.1, L_12D2
              MOV       BlindsMode, #2
              SJMP      L_12D5
L_12D2:
              MOV       BlindsMode, #0
L_12D5:

;                 TempBlindsMode := BlindsMode;
              MOV       TempBlindsMode, BlindsMode

;                 SetupTimer := SetupTime;
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)

;                 Exit;
              RET

;               end;
L_12DF:
;             If CheckPgmKey then
              LCALL     CheckPgmKey
              JNC       L_12F8

;               begin
;                 If RPT then Exit;
              JNB       RPT, L_12E8
              RET
L_12E8:

;                 UpdateCounter;
              LCALL     UpdateCounter

;                 Setup := LearnKey;
              MOV       Setup, #1

;                 TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;                 Repeat until not Sending;
L_12F2:
              JB        Sending, L_12F2

;                 SendStatus;
              LJMP      SendStatus

;                 Exit;
;               end;
L_12F8:
; 
;             If CounterCheck and (SerialNumber [3] and $0F <> $0E) then
              JNB       P2.7, L_1376
              MOV       R0, #SerialNumber+3
              MOV       A, @R0
              ANL       A, #$0F
              XRL       A, #$0E
              JZ        L_1376

;               Case TempSet of
;                 False: begin
              JB        TempSet, L_135D

;                          TempCounter.L := ReadByteFromEEprom (TempWord.W + Ofs (TxData.tdCounter.L));
              MOV       A, TempWord
              ADD       A, #LOW  ($000C)
              MOV       Ad, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000C)
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              MOV       TempCounter, A

;                          TempCounter.H := ReadByteFromEEprom (TempWord.W + Ofs (TxData.tdCounter.H));
              MOV       A, TempWord
              ADD       A, #LOW  ($000D)
              MOV       Ad, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000D)
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              MOV       TempCounter+1, A

; 
;                          CounterDifference.W := Counter.W - TempCounter.W;
              MOV       R0, #EncryptedCode
              MOV       A, @R0
              CLR       C
              SUBB      A, TempCounter
              MOV       R2, A
              INC       R0
              MOV       A, @R0
              SUBB      A, TempCounter+1
              MOV       R0, #TE
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, A

; 
;                          If (CounterDifference.H <> 0) or not (CounterDifference.L in [0..16]) or ((CounterDifference.L = 0) and not RPT) then
              JNZ       L_1347
              MOV       A, R2
              ADD       A, #-17
              JC        L_1347
              CJNE      R2, #0, L_135B
              JB        RPT, L_135B
L_1347:

;                            begin
;                              If CounterDifference.W > $8000 then Exit;
              MOV       A, R2
              ADD       A, #LOW  (32767)
              INC       R0
              MOV       A, @R0
              ADDC      A, #HIGH (32767)
              JNC       L_1351
              RET
L_1351:

;                              TempCounter.W := Counter.W;
              MOV       R0, #EncryptedCode
              MOV       TempCounter, @R0
              INC       R0
              MOV       TempCounter+1, @R0

;                              TempSet := True;
              SETB      TempSet

;                              Exit;
              RET

;                            end;
L_135B:
;                        end;
              SJMP      L_1378
L_135D:

;                 True: begin
;                         TempSet := False;
              CLR       TempSet

;                         If Counter.W - TempCounter.W <> 1 then Exit;
              MOV       R0, #EncryptedCode
              MOV       A, @R0
              CLR       C
              SUBB      A, TempCounter
              MOV       R2, A
              INC       R0
              MOV       A, @R0
              SUBB      A, TempCounter+1
              MOV       R3, A
              CJNE      R2, #LOW  (1), L_1371
              MOV       A, R3
              JZ        L_1372
L_1371:
              RET
L_1372:

;                         RPT := False;
              CLR       RPT

;                       end;
              SJMP      L_1378
L_1376:

;               end else TempSet := False;
              CLR       TempSet
L_1378:

; 
;             UpdateCounter;
              LCALL     UpdateCounter

;             ProcessTxKey;
              LJMP      ProcessTxKey

;           end;
L_137E:
;     LearnKey: begin
              CJNE      R2, #1, L_13C2

;                 SetupTimer := SetupTime;
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)

;                 GenerateKeyAndDecrypt;
              LCALL     GenerateKeyAndDecrypt

;                 If not DecryptOK then
              JB        DecryptOK, L_1399

;                   begin
;                     Display := 'O';
              MOV       Display, #'O'

;                     Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LJMP      Delay

;                     Exit;
;                   end;
L_1399:
;                 If CheckPgmKey then
              LCALL     CheckPgmKey
              JNC       L_13B7

;                   If TXInEEprom then
              LCALL     TXInEEprom
              JNC       L_13B7

;                     begin
;                       If RPT then Exit;
              JNB       RPT, L_13A7
              RET
L_13A7:

;                       UpdateCounter;
              LCALL     UpdateCounter

;                       Setup := None;;
              MOV       Setup, #0

;                       TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;                       Repeat until not Sending;
L_13B1:
              JB        Sending, L_13B1

;                       SendStatus;
              LJMP      SendStatus

;                       Exit;
;                     end;
L_13B7:
;                 TempCounter.W := Counter.W;
              MOV       R0, #EncryptedCode
              MOV       TempCounter, @R0
              INC       R0
              MOV       TempCounter+1, @R0

;                 Setup := LearnKey2;
              MOV       Setup, #2

;               end;
              RET
L_13C2:

;     LearnKey2: begin
              MOV       A, R2
              XRL       A, #2
              JZ        L_13CA
              LJMP      L_145A
L_13CA:

;                 SetupTimer := SetupTime;
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)

;                 GenerateKeyAndDecrypt;
              LCALL     GenerateKeyAndDecrypt

;                 If not DecryptOK then
              JB        DecryptOK, L_13E6

;                   begin
;                     Display := 'O';
              MOV       Display, #'O'

;                     Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

;                     Setup := LearnKey;
              MOV       Setup, #1

;                     Exit;
              RET

;                   end;
L_13E6:
;                 If CheckPgmKey then
              LCALL     CheckPgmKey
              JNC       L_1404

;                   If TXInEEprom then
              LCALL     TXInEEprom
              JNC       L_1404

;                     begin
;                       If RPT then Exit;
              JNB       RPT, L_13F4
              RET
L_13F4:

;                       UpdateCounter;
              LCALL     UpdateCounter

;                       Setup := None;
              MOV       Setup, #0

;                       TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;                       Repeat until not Sending;
L_13FE:
              JB        Sending, L_13FE

;                       SendStatus;
              LJMP      SendStatus

;                       Exit;
;                     end;
L_1404:
;                 If Counter.W - TempCounter.W > 2 then
              MOV       R0, #EncryptedCode
              MOV       A, @R0
              CLR       C
              SUBB      A, TempCounter
              MOV       R2, A
              INC       R0
              MOV       A, @R0
              SUBB      A, TempCounter+1
              MOV       R3, A
              MOV       A, R2
              ADD       A, #LOW  (-3)
              MOV       A, R3
              ADDC      A, #HIGH (-3)
              JNC       L_1428

;                   begin
;                     Display := 'C';
              MOV       Display, #'C'

;                     Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

;                     Setup := LearnKey;
              MOV       Setup, #1

;                     Exit;
              RET

;                   end;
L_1428:
;                 If SaveTxToEEprom then
              LCALL     SaveTxToEEprom
              JNC       L_1456

;                   begin
;                     Display := 'P';
              MOV       Display, #'P'

;                     WriteDisplay;
              LCALL     WriteDisplay

;                     Repeat until not Sending;
L_1433:
              JB        Sending, L_1433

;                     Delay (5);
              MOV       Dl, #LOW  (5)
              MOV       Dl+1, #HIGH (5)
              LCALL     Delay

;                     TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;                     SendStatus;
              LCALL     SendStatus

;                     Delay (200);
              MOV       Dl, #LOW  ($00C8)
              MOV       Dl+1, #HIGH ($00C8)
              LCALL     Delay

;                     ProcessTxKey;
              LCALL     ProcessTxKey

;                     Setup := LearnKey;
              MOV       Setup, #1

;                   end else Setup := None;
              RET
L_1456:
              MOV       Setup, #0

;               end;
              RET
L_145A:

;     SetTxKey: begin
              MOV       A, R2
              XRL       A, #6
              JZ        L_1460
              RET
L_1460:

;                 SetupTimer := SetupTime;
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)

;                 Case ModuleType of
              MOV       R2, ModuleType

;                   mtNormal,
              MOV       A, R2
              JZ        L_146E
              CJNE      R2, #3, L_14C2
L_146E:

;                   mtAlarm:  begin
;                               ChDataBlock [Channel] := NibToByte (TxKeyBits, ChDataBlock [Channel]);
              MOV       Hi, TxKeyBits
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       Lo, @R0
              LCALL     NibToByte
              MOV       R1, A
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       @R0, AR1

;                               WriteByteToEEPROM (Ofs (TEEprom.EE_ChannelConfig) + Channel , ChDataBlock [Channel]);
              MOV       A, Channel
              ADD       A, #$10
              MOV       Address, A
              MOV       Address+1, #0
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;                               Setup := SetChannel;
              MOV       Setup, #4

;                               Case ModuleType of
              MOV       R2, ModuleType

;                                 mtNormal : begin
              CJNE      R2, #0, L_14B0

;                                              Channel := (Channel + 1) and $0F;
              MOV       A, Channel
              INC       A
              ANL       A, #$0F
              MOV       Channel, A

;                                              If AuxModule then If Channel = 15 then
              JNB       P2.4, L_14AE
              CJNE      A, #$0F, L_14AE

;                                                Channel := 0;
              MOV       Channel, #0
L_14AE:

;                                            end;
              SJMP      L_14C0
L_14B0:

;                                 mtAlarm: begin
              CJNE      R2, #3, L_14C0

;                                            Channel := (Channel + 1) and $03;
              MOV       A, Channel
              INC       A
              ANL       A, #3
              MOV       Channel, A

;                                            If Channel = 1 then Channel := 2;
              CJNE      A, #1, L_14C0
              MOV       Channel, #2

;                                          end;
L_14C0:
;                               end
;                             end;
              SJMP      L_14E3
L_14C2:

;                   mtCrawford,
              MOV       A, R2
              XRL       A, #1
              JZ        L_14CA
              CJNE      R2, #2, L_14E3
L_14CA:

;                   mtDoor: begin
;                              ChData [1] := NibToByte (TxKeyBits, ChData [1]);
              MOV       Hi, TxKeyBits
              MOV       R0, #ChData
              MOV       Lo, @R0
              LCALL     NibToByte
              MOV       @R0, A

;                              WriteByteToEEPROM (Ofs (TEEprom.EE_ChannelConfig), ChData [1]);
              MOV       Address, #LOW  ($0010)
              MOV       Address+1, #HIGH ($0010)
              MOV       D, A
              LCALL     WriteByteToEEPROM

;                              Setup := None;
              MOV       Setup, #0

;                           end;
L_14E3:
;                 end;
;                 Display := HexChar [TxKeyBits];
              MOV       A, TxKeyBits
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;                 Delay (300);
              MOV       Dl, #LOW  ($012C)
              MOV       Dl+1, #HIGH ($012C)
              LCALL     Delay

;                 Display := ' ';
              MOV       Display, #' '

;                 Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LJMP      Delay

;               end;
;   end;
; end;
; 
; Procedure ProcessCommands;
; Var TempByte, I: Byte;
;     IW: Word;

ProcessCommands:
; begin
;   BlockReceived := False;
              CLR       BlockReceived

;   Delay (2);
              MOV       Dl, #LOW  (2)
              MOV       Dl+1, #HIGH (2)
              LCALL     Delay

;   Case RX_Buffer [bpCommand] of
              MOV       R0, #RX_Buffer+2
              MOV       AR2, @R0

;     Cmd_StatusRequest: begin
              MOV       A, R2
              XRL       A, #$40
              JZ        L_1517
              LJMP      L_15A1
L_1517:

;                          TX_Buffer [bpDestinationAddress] := RX_Buffer [bpSourceAddress];
              MOV       R1, #RX_Buffer+5
              MOV       R0, #TX_Buffer+1
              MOV       A, @R1
              MOV       @R0, A

;                          If RX_Buffer [bpParameter1] = $FF then
              MOV       R0, #RX_Buffer+3
              MOV       A, @R0
              CPL       A
              JNZ       L_159E

;                            begin
;                              TX_Buffer [bpCommand] := Cmd_LNG_Tx;
              MOV       R0, #TX_Buffer+2
              MOV       @R0, #$57

;                              TempWord.W := Ofs (TEEprom.EE_TXKeyData);
              MOV       TempWord, #LOW  ($0020)
              MOV       TempWord+1, A

;                              IW := NumberOfLearnedKeys;
              MOV       R0, #NumberOfLearnedKeys
              MOV       AR7, @R0
              INC       R0
              MOV       R8, @R0

;                              While IW <> 0 do
              SJMP      L_1598

;                                begin
;                                  Repeat until not Sending;
L_1535:
              JB        Sending, L_1535

;                                  TX_Buffer [bpParameter1] := ReadByteFromEEprom (TempWord.W + Ofs (TxData.tdCounter.H));
              MOV       A, TempWord
              ADD       A, #LOW  ($000D)
              MOV       Ad, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000D)
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              MOV       R0, #TX_Buffer+3
              MOV       @R0, A

;                                  TX_Buffer [bpParameter2] := ReadByteFromEEprom (TempWord.W + Ofs (TxData.tdCounter.L));
              MOV       A, TempWord
              ADD       A, #LOW  ($000C)
              MOV       Ad, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000C)
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              INC       R0
              MOV       @R0, A

;                                  For TempByte := 0 to 3 do
              MOV       R6, #$FF
L_155D:
              INC       R6

;                                    TX_Buffer [bpParameter3 + TempByte] := ReadByteFromEEprom (TempWord.W + Ofs (TxData.tdSerialNumber [3]) - TempByte);
              MOV       A, TempWord
              ADD       A, #LOW  ($000B)
              MOV       R2, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000B)
              MOV       R3, A
              MOV       A, R2
              CLR       C
              SUBB      A, R6
              MOV       Ad, A
              MOV       A, R3
              SUBB      A, #0
              MOV       Ad+1, A
              LCALL     ReadByteFromEEPROM
              MOV       R1, A
              MOV       A, R6
              ADD       A, #TX_Buffer+7
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R6, #3, L_155D

;                                  TX_Buffer [bpParameter7] := 0;
              MOV       R0, #TX_Buffer+11
              MOV       @R0, #0

;                                  TX_Buffer [bpParameter8] := 0;
              INC       R0
              MOV       @R0, #0

;                                  SendLNGBlock;
              LCALL     SendLNGBlock

;                                  Inc (TempWord.W, SizeOf (TxData));
              MOV       R0, #TempWord
              MOV       R2, #LOW  ($000E)
              MOV       R3, #HIGH ($000E)
              LCALL     sysIncWord_IDATA_R3R2

;                                  Dec (IW);
              DEC       R7
              CJNE      R7, #-1, L_1598
              DEC       R8

;                                end;
L_1598:
;                              While IW <> 0 do
              MOV       A, R8
              ORL       A, R7
              JNZ       L_1535

;                            end else SendStatus;
              RET
L_159E:
              LJMP      SendStatus

;                        end;
L_15A1:
;     Cmd_ChangeAddress: begin
              CJNE      R2, #$55, L_15BA

;                          If RX_Buffer [bpParameter1] = RX_Buffer [bpParameter2] then
              MOV       R0, #RX_Buffer+3
              MOV       A, @R0
              INC       R0
              XRL       A, @R0
              JNZ       L_15B9

;                            begin
;                              ModuleAddress := RX_Buffer [bpParameter1];
              DEC       R0
              MOV       ModuleAddress, @R0

;                              WriteByteToEEPROM (Ofs (TEEprom.EE_ModuleAddress), ModuleAddress);
              MOV       Address, #LOW  (3)
              MOV       Address+1, A
              MOV       D, ModuleAddress
              LCALL     WriteByteToEEPROM

;                            end;
L_15B9:
;                        end;
              RET
L_15BA:

;     Cmd_GetData: begin
              MOV       A, R2
              XRL       A, #$31
              JZ        L_15C2
              LJMP      L_1648
L_15C2:

;                    TX_Buffer [bpCommand] := RX_Buffer [bpParameter1];
              MOV       R1, #RX_Buffer+3
              MOV       R0, #TX_Buffer+2
              MOV       A, @R1
              MOV       @R0, A

;                    TX_Buffer [bpDestinationAddress] := RX_Buffer [bpSourceAddress];
              MOV       R1, #RX_Buffer+5
              DEC       R0
              MOV       A, @R1
              MOV       @R0, A

;                    Case RX_Buffer [bpParameter1] of
              MOV       R0, #RX_Buffer+3
              MOV       AR2, @R0

;                      Cmd_SoftwareVersion: begin
              CJNE      R2, #$4F, L_15DE

;                                             TX_Buffer [bpParameter1] := VersionHi;
              MOV       R0, #TX_Buffer+3
              MOV       @R0, #1

;                                             TX_Buffer [bpParameter2] := VersionLo;
              INC       R0
              MOV       @R0, #0

;                                             SendBlock;
              LJMP      SendBlock

;                                           end;
L_15DE:
;                      Cmd_RelayTime: begin
              CJNE      R2, #$22, L_160A

;                                       TempByte := RX_Buffer [bpParameter2] and $03 + 1;
              MOV       R0, #RX_Buffer+4
              MOV       A, @R0
              ANL       A, #3
              INC       A
              MOV       R2, A

;                                       TX_Buffer [bpParameter1] := RelayTime [TempByte].H and $3F or RX_Buffer [bpParameter2] shl 6;
              MOV       A, @R0
              SWAP      A
              RLC       A
              RLC       A
              ANL       A, #$C0
              MOV       R1, A
              MOV       A, R2
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              INC       R0
              MOV       A, @R0
              ANL       A, #$3F
              ORL       A, R1
              MOV       R0, #TX_Buffer+3
              MOV       @R0, A

;                                       TX_Buffer [bpParameter2] := RelayTime [TempByte].L;
              MOV       A, R2
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       R1, #TX_Buffer+4
              MOV       A, @R0
              MOV       @R1, A

;                                       SendBlock;
              LJMP      SendBlock

;                                     end;
L_160A:
;                      Cmd_Cfg: begin
              CJNE      R2, #$59, L_1647

;                                 TX_Buffer [bpParameter1] := Byte (ModuleType);
              MOV       R0, #TX_Buffer+3
              MOV       @R0, ModuleType

;                                 TX_Buffer [bpParameter2] := Byte (ModuleFlags);
              MOV       R1, #ModuleFlags
              INC       R0
              MOV       A, @R1
              MOV       @R0, A

;                                 TX_Buffer [bpParameter11] := RX_Buffer [bpParameter2];
              MOV       R1, #RX_Buffer+4
              MOV       R0, #TX_Buffer+15
              MOV       A, @R1
              MOV       @R0, A

;                                 If RX_Buffer [bpParameter2] = 0 then
              JNZ       L_1632

;                                   For I := 0 to 7 do TX_Buffer [bpParameter3 + I] := ChDataBlock [I]
              MOV       R2, #$FF
L_1620:
              INC       R2
              MOV       A, R2
              ADD       A, #ChData
              MOV       R0, A
              MOV       AR1, @R0
              MOV       A, R2
              ADD       A, #TX_Buffer+7
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R2, #7, L_1620
              SJMP      L_1644
L_1632:

;                                     else For I := 0 to 6 do TX_Buffer [bpParameter3 + I] := ChDataBlock [I + 8];
              MOV       R2, #$FF
L_1634:
              INC       R2
              MOV       A, R2
              ADD       A, #ChData+8
              MOV       R0, A
              MOV       AR1, @R0
              MOV       A, R2
              ADD       A, #TX_Buffer+7
              MOV       R0, A
              MOV       @R0, AR1
              CJNE      R2, #6, L_1634
L_1644:

;                                 SendLNGBlock;
              LCALL     SendLNGBlock

;                               end;
L_1647:
;                    end;
;                  end;
              RET
L_1648:

;     Cmd_Relay: begin
              CJNE      R2, #$21, L_1663

;                  If (RX_Buffer [bpParameter2]) and $F0 <> 0 then Exit;
              MOV       R0, #RX_Buffer+4
              MOV       A, @R0
              ANL       A, #$F0
              JZ        L_1653
              RET
L_1653:

;                  If RX_Buffer [bpParameter1] > 2 then Exit;
              DEC       R0
              MOV       A, @R0
              ADD       A, #-3
              JNC       L_165A
              RET
L_165A:

;                  SetRelay (RX_Buffer [bpParameter2], RX_Buffer [bpParameter1]);
              INC       R0
              MOV       R, @R0
              DEC       R0
              MOV       Status, @R0
              LJMP      SetRelay

;                end;
L_1663:
;     Cmd_ActivateOutput: begin
              CJNE      R2, #$54, L_1691

;                           If (RX_Buffer [bpParameter1] - 1) and $FC <> 0 then Exit;
              MOV       R0, #RX_Buffer+3
              MOV       A, @R0
              DEC       A
              ANL       A, #$FC
              JZ        L_166F
              RET
L_166F:

;                           RelayTimer [RX_Buffer [bpParameter1]] := RelayTime [RX_Buffer [bpParameter1]].W;
              MOV       A, @R0
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       AR2, @R0
              INC       R0
              MOV       AR3, @R0
              MOV       R0, #RX_Buffer+3
              MOV       A, @R0
              ADD       A, ACC
              ADD       A, #RelayTimer-2
              MOV       R0, A
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, AR3

;                           SetRelay (RX_Buffer [bpParameter1], 1);
              MOV       R0, #RX_Buffer+3
              MOV       R, @R0
              MOV       Status, #1
              LJMP      SetRelay

;                         end;
L_1691:
;     Cmd_RelayTime: begin
              CJNE      R2, #$22, L_16B8

;                      TempByte := (RX_Buffer [bpParameter1] shr 6) and $03 + 1;
              MOV       R0, #RX_Buffer+3
              MOV       A, @R0
              SWAP      A
              RRC       A
              RRC       A
              ANL       A, #3
              INC       A
              MOV       R2, A

;                      TempWord.H := RX_Buffer [bpParameter1] and $3F;
              MOV       A, @R0
              ANL       A, #$3F
              MOV       TempWord+1, A

;                      TempWord.L := RX_Buffer [bpParameter2];
              INC       R0
              MOV       TempWord, @R0

;                      RelayTime [TempByte].W := TempWord.W;
              MOV       A, R2
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       @R0, TempWord
              INC       R0
              MOV       @R0, TempWord+1

;                      If TempByte = 4 then WriteRelayTimesToEEPROM;
              CJNE      R2, #4, L_16B7
              LCALL     WriteRelayTimesToEEPROM
L_16B7:

;                    end;
              RET
L_16B8:

;     Cmd_LearnLNG_Tx: begin
              CJNE      R2, #$58, L_16DA

;                        If Setup = None then
              MOV       A, Setup
              JNZ       L_16CA

;                          begin
;                            Setup := LearnKey;
              MOV       Setup, #1

;                            SetupTimer := SetupTime;
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)

;                          end else
              SJMP      L_16D1
L_16CA:

;                            begin
;                              Setup := None;
              CLR       A
              MOV       Setup, A

;                              SetupTimer := 0;
              MOV       SetupTimer, A
              MOV       SetupTimer+1, A

;                            end;
L_16D1:
;                        TX_Buffer [bpDestinationAddress] := RX_Buffer [bpSourceAddress];
              MOV       R1, #RX_Buffer+5
              MOV       R0, #TX_Buffer+1
              MOV       A, @R1
              MOV       @R0, A

;                        SendStatus;
              LJMP      SendStatus

;                      end;
L_16DA:
;     Cmd_LNG_Tx: begin
              CJNE      R2, #$57, L_174C

;                   SerialNumber [3] := RX_Buffer [bpParameter3];
              MOV       R1, #RX_Buffer+7
              MOV       R0, #SerialNumber+3
              MOV       A, @R1
              MOV       @R0, A

;                   SerialNumber [2] := RX_Buffer [bpParameter4];
              INC       R1
              DEC       R0
              MOV       A, @R1
              MOV       @R0, A

;                   SerialNumber [1] := RX_Buffer [bpParameter5];
              INC       R1
              DEC       R0
              MOV       A, @R1
              MOV       @R0, A

;                   SerialNumber [0] := RX_Buffer [bpParameter6];
              INC       R1
              DEC       R0
              MOV       A, @R1
              MOV       @R0, A

;                   If RX_Buffer [bpParameter8] and $02 <> 0 then
              MOV       R0, #RX_Buffer+12
              MOV       A, @R0
              JNB       ACC.1, L_16F8

;                     begin
;                       RemoveTx;
              LJMP      RemoveTx

;                       Exit;
;                     end;
L_16F8:
;                   If not TXInEEprom then Exit;
              LCALL     TXInEEprom
              JC        L_16FE
              RET
L_16FE:

;                   If RX_Buffer [bpParameter8] and $04 <> 0 then
              MOV       R0, #RX_Buffer+12
              MOV       A, @R0
              JNB       ACC.2, L_1717

;                     begin
;                       WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdSerialNumber [3]), RX_Buffer [bpParameter3]);
              MOV       A, TempWord
              ADD       A, #LOW  ($000B)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000B)
              MOV       Address+1, A
              MOV       R0, #RX_Buffer+7
              MOV       D, @R0
              LJMP      WriteByteToEEPROM

;                       Exit;
;                     end;
L_1717:
;                   If Counter.L = RX_Buffer [bpParameter2] then
              MOV       R0, #EncryptedCode
              MOV       A, @R0
              MOV       R0, #RX_Buffer+4
              XRL       A, @R0
              JNZ       L_1727

;                     If Counter.H = RX_Buffer [bpParameter1] then Exit;
              MOV       R0, #EncryptedCode+1
              MOV       A, @R0
              MOV       R0, #RX_Buffer+3
              XRL       A, @R0
              JZ        L_179D
L_1727:

;                   WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdCounter.L), RX_Buffer [bpParameter2]);
              MOV       A, TempWord
              ADD       A, #LOW  ($000C)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000C)
              MOV       Address+1, A
              MOV       R0, #RX_Buffer+4
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;                   WriteByteToEEPROM (TempWord.W + Ofs (TxData.tdCounter.H), RX_Buffer [bpParameter1]);
              MOV       A, TempWord
              ADD       A, #LOW  ($000D)
              MOV       Address, A
              MOV       A, TempWord+1
              ADDC      A, #HIGH ($000D)
              MOV       Address+1, A
              DEC       R0
              MOV       D, @R0
              LJMP      WriteByteToEEPROM

;                 end;
L_174C:
;     Cmd_Cfg: begin
              CJNE      R2, #$59, L_179D

;                ModuleType := TModuleType (RX_Buffer [bpParameter1]);
              MOV       R0, #RX_Buffer+3
              MOV       ModuleType, @R0

;                Byte (ModuleFlags) := RX_Buffer [bpParameter2];
              MOV       R1, #RX_Buffer+4
              MOV       R0, #ModuleFlags
              MOV       A, @R1
              MOV       @R0, A

;                If RX_Buffer [bpParameter11] = 0 then
              MOV       R0, #RX_Buffer+15
              CJNE      @R0, #0, L_177C

;                  For I := 0 to 7 do
              MOV       R4, #$FF
              MOV       R5, #0
L_1762:
              INC       R4

;                    begin
;                      ChDataBlock [I] := RX_Buffer [bpParameter3 + I];
              MOV       A, R4
              ADD       A, #RX_Buffer+7
              MOV       R0, A
              MOV       AR1, @R0
              MOV       A, R4
              ADD       A, #ChData
              MOV       R0, A
              MOV       @R0, AR1

;                      SetRelay (I + 1, 0);
              MOV       A, R4
              INC       A
              MOV       R, A
              MOV       Status, R5
              LCALL     SetRelay

;                    end else begin
              CJNE      R4, #7, L_1762
              RET
L_177C:

;                               For I := 0 to 6 do
              MOV       R4, #$FF
              MOV       R5, #0
L_1780:
              INC       R4

;                                 begin
;                                   ChDataBlock [I + 8] := RX_Buffer [bpParameter3 + I];
              MOV       A, R4
              ADD       A, #RX_Buffer+7
              MOV       R0, A
              MOV       AR1, @R0
              MOV       A, R4
              ADD       A, #ChData+8
              MOV       R0, A
              MOV       @R0, AR1

;                                   SetRelay (I + 9, 0);
              MOV       A, R4
              ADD       A, #9
              MOV       R, A
              MOV       Status, R5
              LCALL     SetRelay

;                                 end;
              CJNE      R4, #6, L_1780

;                               WriteModuleConfig;
              LCALL     WriteModuleConfig

;                             end;
;              end;
;   end;
; end;
L_179D:
              RET

; 
; Procedure ProcessSetup;
; Const ModuleTypeChar: Array [mtNormal..mtAlarm] of Char = 'NCDA';

RSEG _CONST

ModuleTypeChar:                 DB        'NCDA'

;       ChannelTypeChar: Array [chFollow..chPulse] of Char = 'FTP';
ChannelTypeChar:                DB        'FTP'


RSEG _CODE

ProcessSetup:
; begin
;   Case Setup of
              MOV       R2, Setup

;     None: begin
              CJNE      R2, #0, L_17B5

;             SetupTimer := 0;
              CLR       A
              MOV       SetupTimer, A
              MOV       SetupTimer+1, A

;             If ClsTimer = 0 then
              MOV       R0, #ClsTimer+1
              MOV       A, @R0
              DEC       R0
              ORL       A, @R0
              JNZ       L_17B4

;               begin
;                 Display := ' ';
              MOV       Display, #' '

;                 LastTxKeyBits := 0;
              MOV       LastTxKeyBits, A

;               end;
L_17B4:
;           end;
              RET
L_17B5:

;     LearnKey: begin
              CJNE      R2, #1, L_17CB

;                 Display := '-';
              MOV       Display, #'-'

;                 Case Kbd of
;                   kCancel: begin
              MOV       A, Kbd
              CJNE      A, #2, L_17CA

;                              Setup := None;
              MOV       Setup, #0

;                              TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;                              SendStatus;
              LCALL     SendStatus

;                            end;
L_17CA:
;                 end;
;               end;
              RET
L_17CB:

;     LearnKey2: begin
              CJNE      R2, #2, L_17E1

;                  Display := '=';
              MOV       Display, #'='

;                  Case Kbd of
;                    kCancel: begin
              MOV       A, Kbd
              CJNE      A, #2, L_17E0

;                               Setup := None;
              MOV       Setup, #0

;                               TX_Buffer [bpDestinationAddress] := $FF;
              MOV       R0, #TX_Buffer+1
              MOV       @R0, #$FF

;                               SendStatus;
              LCALL     SendStatus

;                             end;
L_17E0:
;                  end;
;                end;
              RET
L_17E1:

;     SetModuleType: begin
              MOV       A, R2
              XRL       A, #3
              JZ        L_17E9
              LJMP      L_18C6
L_17E9:

;                      Case Kbd of
              MOV       R2, Kbd

;                        kUp: begin
              CJNE      R2, #3, L_17FB

;                               TempModuleType := Succ (TempModuleType);
              INC       TempModuleType

;                               If TempModuleType = Succ (High (TModuleType)) then TempModuleType := Low (TModuleType);
              MOV       A, TempModuleType
              CJNE      A, #4, L_17F8
              MOV       TempModuleType, #0
L_17F8:

;                             end;
              LJMP      L_18B3
L_17FB:

;                        kDown: begin
              CJNE      R2, #4, L_180B

;                                 TempModuleType := Pred (TempModuleType);
              DEC       TempModuleType

;                                 If TempModuleType = Pred (Low (TModuleType)) then TempModuleType := High (TModuleType);
              MOV       A, TempModuleType
              CPL       A
              JNZ       L_1808
              MOV       TempModuleType, #3
L_1808:

;                               end;
              LJMP      L_18B3
L_180B:

;                        kCancel: Setup := None;
              CJNE      R2, #2, L_1814
              MOV       Setup, #0
              LJMP      L_18B3
L_1814:

;                        kEnter: begin
              MOV       A, R2
              XRL       A, #1
              JZ        L_181C
              LJMP      L_18B3
L_181C:

;                                  If ModuleType <> TempModuleType then
              MOV       A, ModuleType
              XRL       A, TempModuleType
              JNZ       L_1825
              LJMP      L_18AD
L_1825:

;                                    begin
;                                      ModuleType := TempModuleType;
              MOV       ModuleType, TempModuleType

;                                      ModuleFlags := [];
              MOV       R0, #ModuleFlags
              MOV       @R0, #0

;                                      Case ModuleType of
              MOV       R2, TempModuleType

;                                        mtNormal: InitNormalModuleType;
              CJNE      R2, #0, L_1836
              LCALL     InitNormalModuleType
              SJMP      L_18AA
L_1836:

;                                        mtCrawford,
              MOV       A, R2
              XRL       A, #1
              JZ        L_183E
              CJNE      R2, #2, L_187E
L_183E:

;                                        mtDoor:     begin
;                                                      RelayTime [1].W := DefaultRelayShortPulseTime;
              MOV       R0, #RelayTime
              MOV       @R0, #LOW  ($000C)
              INC       R0
              MOV       @R0, #HIGH ($000C)

;                                                      RelayTime [2].W := DefaultRelayShortPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($000C)
              INC       R0
              MOV       @R0, #HIGH ($000C)

;                                                      RelayTime [3].W := DefaultRelayShortPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($000C)
              INC       R0
              MOV       @R0, #HIGH ($000C)

;                                                      RelayTime [4].W := DafaultLightPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($DBBA)
              INC       R0
              MOV       @R0, #HIGH ($DBBA)

;                                                      WriteRelayTimesToEEPROM;
              LCALL     WriteRelayTimesToEEPROM

;                                                      ChData [4] := Byte (chPulse);
              MOV       R0, #ChData+3
              MOV       @R0, #2

;                                                      Case ModuleType of
              MOV       R2, ModuleType

;                                                        mtCrawford: begin
              CJNE      R2, #1, L_186F

;                                                                      ChData [1] := Byte (chPulse);
              MOV       R0, #ChData
              MOV       @R0, #2

;                                                                      ChData [2] := Byte (chPulse);
              INC       R0
              MOV       @R0, #2

;                                                                      ChData [3] := Byte (chPulse);
              INC       R0
              MOV       @R0, #2

;                                                                    end;
              SJMP      L_187C
L_186F:

;                                                        mtDoor: begin
              CJNE      R2, #2, L_187C

;                                                                  ChData [1] := Byte (chToggle);
              MOV       R0, #ChData
              MOV       @R0, #1

;                                                                  ChData [2] := Byte (chToggle);
              INC       R0
              MOV       @R0, #1

;                                                                  ChData [3] := Byte (chToggle);
              INC       R0
              MOV       @R0, #1

;                                                                end;
L_187C:
;                                                      end
;                                                    end;
              SJMP      L_18AA
L_187E:

;                                        mtAlarm: begin
              CJNE      R2, #3, L_18AA

;                                                   RelayTime [1].W := DefaultRelayShortPulseTime;
              MOV       R0, #RelayTime
              MOV       @R0, #LOW  ($000C)
              INC       R0
              MOV       @R0, #HIGH ($000C)

;                                                   RelayTime [2].W := DefaultRelayOffPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($002E)
              INC       R0
              MOV       @R0, #HIGH ($002E)

;                                                   RelayTime [3].W := DafaultRelayLongPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($03A9)
              INC       R0
              MOV       @R0, #HIGH ($03A9)

;                                                   RelayTime [4].W := DafaultRelayLongPulseTime;
              INC       R0
              MOV       @R0, #LOW  ($03A9)
              INC       R0
              MOV       @R0, #HIGH ($03A9)

;                                                   WriteRelayTimesToEEPROM;
              LCALL     WriteRelayTimesToEEPROM

;                                                   ChData [1] := Byte (chToggle);
              MOV       R0, #ChData
              MOV       @R0, #1

;                                                   ChData [2] := Byte (chPulse);
              INC       R0
              MOV       @R0, #2

;                                                   ChData [3] := Byte (chFollow);
              INC       R0
              MOV       @R0, #0

;                                                   ChData [4] := Byte (chFollow);
              INC       R0
              MOV       @R0, #0

;                                                 end;
L_18AA:
;                                      end;
;                                      WriteModuleConfig;
              LCALL     WriteModuleConfig

;                                    end;
L_18AD:
;                                  Setup := SetChannel;
              MOV       Setup, #4

;                                  Channel := 0;
              MOV       Channel, #0

;                                end;
L_18B3:
;                      end;
;                      Display := ModuleTypeChar [TempModuleType];
              MOV       A, TempModuleType
              MOV       DPTR, #ModuleTypeChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;                      If Kbd <> kNone then SetupTimer := SetupTime;
              MOV       A, Kbd
              JZ        L_18C5
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)
L_18C5:

;                    end;
              RET
L_18C6:

;     SetChannel: begin
              MOV       A, R2
              XRL       A, #4
              JZ        L_18CE
              LJMP      L_1995
L_18CE:

;                   Case ModuleType of
              MOV       R2, ModuleType

;                     mtNormal: begin
              CJNE      R2, #0, L_1927

;                                 Case Kbd of
              MOV       R2, Kbd

;                                   kUp: begin
              CJNE      R2, #3, L_18EB

;                                          Channel := (Channel + 1) and Mask;
              MOV       A, Channel
              INC       A
              MOV       R0, #Mask
              ANL       A, @R0
              MOV       Channel, A

;                                          If AuxModule then If Channel = 15 then
              JNB       P2.4, L_18E9
              CJNE      A, #$0F, L_18E9

;                                            Channel := 0;
              MOV       Channel, #0
L_18E9:

;                                        end;
              SJMP      L_191C
L_18EB:

;                                   kDown: begin
              CJNE      R2, #4, L_1901

;                                            Channel := (Channel - 1) and Mask;
              MOV       A, Channel
              DEC       A
              MOV       R0, #Mask
              ANL       A, @R0
              MOV       Channel, A

;                                            If AuxModule then If Channel = 15 then
              JNB       P2.4, L_18FF
              CJNE      A, #$0F, L_18FF

;                                              Channel := 14;
              MOV       Channel, #$0E
L_18FF:

;                                          end;
              SJMP      L_191C
L_1901:

;                                   kCancel: begin
              CJNE      R2, #2, L_190C

;                                              Setup := SetModuleType;
              MOV       Setup, #3

;                                              TempModuleType := ModuleType;
              MOV       TempModuleType, ModuleType

;                                            end;
              SJMP      L_191C
L_190C:

;                                   kEnter: begin
              CJNE      R2, #1, L_191C

;                                             Setup := SetChannelType;
              MOV       Setup, #5

;                                             TempChannelType := TChType (ChDataBlock [Channel] and $0F);
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       A, @R0
              ANL       A, #$0F
              MOV       TempChannelType, A

;                                           end;
L_191C:
;                                 end;
;                                 Display := HexChar [Channel + 1];
              MOV       A, Channel
              INC       A
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;                               end;
              SJMP      L_198A
L_1927:

;                     mtCrawford,
              MOV       A, R2
              XRL       A, #1
              JZ        L_192F
              CJNE      R2, #2, L_1937
L_192F:

;                     mtDoor: begin
;                               Setup := SetTxKey;
              MOV       Setup, #6

;                               Display := '=';
              MOV       Display, #'='

;                             end;
              SJMP      L_198A
L_1937:

;                     mtAlarm: begin
              CJNE      R2, #3, L_198A

;                                Case Kbd of
              MOV       R2, Kbd

;                                  kUp: begin
              CJNE      R2, #3, L_194E

;                                         Channel := (Channel + 1) and $03;
              MOV       A, Channel
              INC       A
              ANL       A, #3
              MOV       Channel, A

;                                         If Channel = 1 then Channel := 2;
              CJNE      A, #1, L_194C
              MOV       Channel, #2
L_194C:

;                                       end;
              SJMP      L_1984
L_194E:

;                                  kDown: begin
              CJNE      R2, #4, L_1960

;                                           Channel := (Channel - 1) and $03;
              MOV       A, Channel
              DEC       A
              ANL       A, #3
              MOV       Channel, A

;                                           If Channel = 1 then Channel := 0;
              CJNE      A, #1, L_195E
              MOV       Channel, #0
L_195E:

;                                         end;
              SJMP      L_1984
L_1960:

;                                  kCancel: begin
              CJNE      R2, #2, L_196B

;                                             Setup := SetModuleType;
              MOV       Setup, #3

;                                             TempModuleType := ModuleType;
              MOV       TempModuleType, ModuleType

;                                           end;
              SJMP      L_1984
L_196B:

;                                  kEnter: begin
              CJNE      R2, #1, L_1984

;                                            If Channel = 0 then
              MOV       A, Channel
              JNZ       L_1979

;                                               begin
;                                                 Setup := SetTxKey;
              MOV       Setup, #6

;                                                 Display := '=';
              MOV       Display, #'='

;                                                 Exit;
              RET

;                                               end else begin
L_1979:
;                                                          Setup := SetChannelType;
              MOV       Setup, #5

;                                                          TempChannelType := TChType (ChDataBlock [Channel] and $0F);
              ADD       A, #ChData
              MOV       R0, A
              MOV       A, @R0
              ANL       A, #$0F
              MOV       TempChannelType, A

;                                                        end
;                                          end;
L_1984:
;                                end;
;                                Display := Char (Channel + $31);
              MOV       A, Channel
              ADD       A, #$31
              MOV       Display, A

;                              end;
L_198A:
;                   end;
;                   If Kbd <> kNone then SetupTimer := SetupTime;
              MOV       A, Kbd
              JZ        L_1994
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)
L_1994:

;                 end;
              RET
L_1995:

;     SetChannelType: begin
              MOV       A, R2
              XRL       A, #5
              JZ        L_199D
              LJMP      L_1A3D
L_199D:

;                       Case ModuleType of
              MOV       R2, ModuleType

;                         mtNormal,
              MOV       A, R2
              JZ        L_19A5
              CJNE      R2, #3, L_19BE
L_19A5:

;                         mtAlarm:  begin
;                                     Case Kbd of
              MOV       R2, Kbd

;                                       kUp: begin
              CJNE      R2, #3, L_19C9

;                                              If TempChannelType = chPulse then TempChannelType := chFollow
              MOV       A, TempChannelType
              CJNE      A, #2, L_19B4
              MOV       TempChannelType, #0
              SJMP      L_19B6
L_19B4:

;                                                else TempChannelType := TChType (Ord (TempChannelType) + 1);
              INC       TempChannelType

;                                            end;
L_19B6:
              MOV       A, TempChannelType
              MOV       DPTR, #ChannelTypeChar
              MOVC      A, @A + DPTR
              MOV       Display, A
L_19BE:
              MOV       A, Kbd
              JZ        L_19C8
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)
L_19C8:
              RET
L_19C9:

;                                       kDown: begin
              CJNE      R2, #4, L_19D9

;                                                If TempChannelType = chFollow then TempChannelType := chPulse
              MOV       A, TempChannelType
              JNZ       L_19D5
              MOV       TempChannelType, #2
              SJMP      L_19D7
L_19D5:

;                                                  else TempChannelType := TChType (Ord (TempChannelType) - 1);
              DEC       TempChannelType
L_19D7:

;                                                end;
              SJMP      L_19B6
L_19D9:

;                                       kCancel: begin
              CJNE      R2, #2, L_19E1

;                                                  Setup := SetChannel;
              MOV       Setup, #4

;                                                end;
              SJMP      L_19B6
L_19E1:

;                                       kEnter: begin
              CJNE      R2, #1, L_19B6

;                                                 ChDataBlock [Channel] := NibToByte (HighNib (ChDataBlock [Channel]), Byte (TempChannelType));
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       Value, @R0
              LCALL     HighNib
              MOV       Hi, A
              MOV       Lo, TempChannelType
              LCALL     NibToByte
              MOV       R1, A
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       @R0, AR1

;                                                 WriteByteToEEPROM (Ofs (TEEprom.EE_ChannelConfig) + Channel , ChDataBlock [Channel]);
              MOV       A, Channel
              ADD       A, #$10
              MOV       Address, A
              MOV       Address+1, #0
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;                                                 Case (Channel and $FC = 0) and (TempChannelType = chPulse) of
              MOV       A, Channel
              ANL       A, #$FC
              JNZ       L_1A36
              MOV       A, TempChannelType
              CJNE      A, #2, L_1A36

;                                                   True: begin
;                                                           Setup := SetTime;
              MOV       Setup, #8

;                                                           TempTime := RelayTime [Channel + 1].W div (10000 div 32);
              MOV       A, Channel
              INC       A
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       AR2, @R0
              INC       R0
              MOV       AR3, @R0
              MOV       R6, #LOW  ($0138)
              MOV       R7, #HIGH ($0138)
              LCALL     sysWordDivision
              MOV       TempTime, R2

;                                                         end;
              RET
L_1A36:

;                                                   else
;                                                     Setup := SetTxKey;
              MOV       Setup, #6

;                                                     Display := '=';
              MOV       Display, #'='

;                                                 end;
;                                                 Exit;
              RET

;                                               end;
L_1A3D:
;                                     end;
;                                     Display := ChannelTypeChar [TempChannelType];
;                                   end;
;                       end;
;                       If Kbd <> kNone then SetupTimer := SetupTime;
;                     end;
;     SetTime:  begin
              MOV       A, R2
              XRL       A, #8
              JZ        L_1A45
              LJMP      L_1AF8
L_1A45:

;                 Case ModuleType of
              MOV       R2, ModuleType

;                   mtNormal,
              MOV       A, R2
              JZ        L_1A52
              MOV       A, R2
              XRL       A, #3
              JZ        L_1A52
              LJMP      L_1AED
L_1A52:

;                   mtAlarm:  begin
;                               Case Kbd of
              MOV       R2, Kbd

;                                 kUp: begin
              CJNE      R2, #3, L_1A6C

;                                        TempTime := (TempTime + 1) and $0F;
              MOV       A, TempTime
              INC       A
              ANL       A, #$0F
              MOV       TempTime, A

;                                      end;
L_1A5E:
              MOV       A, BlinkTimer+1
              JNB       ACC.1, L_1A66
              LJMP      L_1AE5
L_1A66:
              MOV       Display, #' '
              LJMP      L_1AED
L_1A6C:

;                                 kDown: begin
              CJNE      R2, #4, L_1A78

;                                          TempTime := (TempTime - 1) and $0F;
              MOV       A, TempTime
              DEC       A
              ANL       A, #$0F
              MOV       TempTime, A

;                                        end;
              SJMP      L_1A5E
L_1A78:

;                                 kCancel: begin
              CJNE      R2, #2, L_1A80

;                                            Setup := SetChannelType;
              MOV       Setup, #5

;                                          end;
              SJMP      L_1A5E
L_1A80:

;                                 kEnter: begin
              CJNE      R2, #1, L_1A5E

;                                           Case TempTime of
;                                             0:   RelayTime [Channel + 1].W := 5050 div 32;
              MOV       A, TempTime
              JNZ       L_1A96
              MOV       A, Channel
              INC       A
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       @R0, #LOW  ($009D)
              INC       R0
              MOV       @R0, #HIGH ($009D)
              SJMP      L_1AAD
L_1A96:

;                                             else RelayTime [Channel + 1].W := TempTime * (10050 div 32);
              MOV       R2, A
              MOV       R3, #0
              MOV       R6, #LOW  ($013A)
              MOV       R7, #HIGH ($013A)
              LCALL     sysWordMultiplication
              MOV       A, Channel
              INC       A
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       @R0, AR2
              INC       R0
              MOV       @R0, AR3
L_1AAD:

;                                           end;
; 
;                                           WriteByteToEEPROM (Ofs (TEEprom.EE_RelayTime) + Channel * 2 + 0, RelayTime [Channel + 1].L);
              MOV       A, Channel
              ADD       A, ACC
              ADD       A, #4
              MOV       Address, A
              MOV       Address+1, #0
              MOV       A, Channel
              INC       A
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;                                           WriteByteToEEPROM (Ofs (TEEprom.EE_RelayTime) + Channel * 2 + 1, RelayTime [Channel + 1].H);
              MOV       A, Channel
              ADD       A, ACC
              ADD       A, #5
              MOV       Address, A
              MOV       Address+1, #0
              MOV       A, Channel
              INC       A
              ADD       A, ACC
              ADD       A, #RelayTime-2
              MOV       R0, A
              INC       R0
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;                                           Setup := SetTxKey;
              MOV       Setup, #6

;                                           Display := '=';
              MOV       Display, #'='

;                                           Exit;
              RET

;                                         end;
L_1AE5:
;                               end;
;                               If BlinkTimer.H and $2 = 0 then Display := ' ' else Display := HexChar [TempTime];
              MOV       A, TempTime
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;                             end;
L_1AED:
;                 end;
;                 If Kbd <> kNone then SetupTimer := SetupTime;
              MOV       A, Kbd
              JZ        L_1AF7
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)
L_1AF7:

;               end;
              RET
L_1AF8:

;     SetTxKey: begin
              MOV       A, R2
              XRL       A, #6
              JZ        L_1B00
              LJMP      L_1B7F
L_1B00:

;                 Case Kbd of
              MOV       R2, Kbd

;                   kCancel: Case ModuleType of
              CJNE      R2, #2, L_1B21
              MOV       R2, ModuleType

;                              mtNormal: Setup := SetChannelType;
              CJNE      R2, #0, L_1B0E
              MOV       Setup, #5
              RET
L_1B0E:

;                              mtAlarm: Case Channel of
              CJNE      R2, #3, L_1B1D

;                                         0: Setup := SetModuleType;
              MOV       A, Channel
              JNZ       L_1B19
              MOV       Setup, #3
              RET
L_1B19:

;                                         else Setup := SetChannelType;
              MOV       Setup, #5
              RET
L_1B1D:

;                                       end;
;                              else Setup := SetModuleType;
              MOV       Setup, #3
              RET
L_1B21:

;                            end;
;                   kEnter: begin
              CJNE      R2, #1, L_1B7E

;                             Display := '0';
              MOV       Display, #'0'

;                             WriteDisplay;
              LCALL     WriteDisplay

;                             ChDataBlock [Channel] := ChDataBlock [Channel] and $0F;
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       A, @R0
              ANL       A, #$0F
              MOV       @R0, A

;                             WriteByteToEEPROM (Ofs (TEEprom.EE_ChannelConfig) + Channel, ChDataBlock [Channel]);
              MOV       A, Channel
              ADD       A, #$10
              MOV       Address, A
              MOV       Address+1, #0
              MOV       A, Channel
              ADD       A, #ChData
              MOV       R0, A
              MOV       D, @R0
              LCALL     WriteByteToEEPROM

;                             Setup := SetChannel;
              MOV       Setup, #4

;                             Channel := (Channel + 1) and Mask;
              MOV       A, Channel
              INC       A
              MOV       R0, #Mask
              ANL       A, @R0
              MOV       Channel, A

;                             If ModuleType =  mtAlarm then
              MOV       A, ModuleType
              CJNE      A, #3, L_1B5E

;                               If Channel = 1 then Channel := 2;
              MOV       A, Channel
              CJNE      A, #1, L_1B5E
              MOV       Channel, #2
L_1B5E:

;                             If AuxModule then If Channel = 15 then
              JNB       P2.4, L_1B69
              MOV       A, Channel
              CJNE      A, #$0F, L_1B69

;                               Channel := 0;
              MOV       Channel, #0
L_1B69:

;                             Delay (300);
              MOV       Dl, #LOW  ($012C)
              MOV       Dl+1, #HIGH ($012C)
              LCALL     Delay

;                             Display := ' ';
              MOV       Display, #' '

;                             Delay (100);
              MOV       Dl, #LOW  ($0064)
              MOV       Dl+1, #HIGH ($0064)
              LCALL     Delay

;                           end;
L_1B7E:
;                 end;
;               end;
              RET
L_1B7F:

;     SetBlindsMode: begin
              MOV       A, R2
              XRL       A, #7
              JZ        L_1B85
              RET
L_1B85:

;                      Case ModuleType of
;                        mtNormal: begin
              MOV       A, ModuleType
              JZ        L_1B8C
              LJMP      L_1C0E
L_1B8C:

;                                    Case Kbd of
              MOV       R2, Kbd

;                                      kUp: begin
              CJNE      R2, #3, L_1BA5

;                                             TempBlindsMode := Succ (TempBlindsMode);
              INC       TempBlindsMode

;                                             If TempBlindsMode = Succ (High (TBlindsMode)) then TempBlindsMode := Low (TBlindsMode);
              MOV       A, TempBlindsMode
              CJNE      A, #4, L_1B9B
              MOV       TempBlindsMode, #0

;                                           end;
L_1B9B:
              MOV       A, BlinkTimer+1
              JB        ACC.1, L_1BEC
              MOV       Display, #'/'
              SJMP      L_1C0C
L_1BA5:

;                                      kDown: begin
              CJNE      R2, #4, L_1BB4

;                                             TempBlindsMode := Pred (TempBlindsMode);
              DEC       TempBlindsMode

;                                             If TempBlindsMode = Pred (Low (TBlindsMode)) then TempBlindsMode := High (TBlindsMode);
              MOV       A, TempBlindsMode
              CPL       A
              JNZ       L_1BB2
              MOV       TempBlindsMode, #3
L_1BB2:

;                                               end;
              SJMP      L_1B9B
L_1BB4:

;                                      kCancel: begin
              CJNE      R2, #2, L_1BBC

;                                                 Setup := None;
              MOV       Setup, #0

;                                               end;
              SJMP      L_1B9B
L_1BBC:

;                                      kEnter:  begin
              CJNE      R2, #1, L_1B9B

;                                                 ModuleFlags := ModuleFlags - [mfBlinds12, mfBlinds34];
              MOV       R0, #ModuleFlags
              MOV       A, @R0
              ANL       A, #$FC
              MOV       @R0, A

;                                                 Case TempBlindsMode of
              MOV       R2, TempBlindsMode

;                                                   bmCh12:   ModuleFlags := ModuleFlags + [mfBlinds12];
              CJNE      R2, #1, L_1BCF
              ORL       A, #1
              MOV       @R0, A
              SJMP      L_1BDD
L_1BCF:

;                                                   bmCh34:   ModuleFlags := ModuleFlags + [mfBlinds34];
              CJNE      R2, #2, L_1BD7
              ORL       A, #2
              MOV       @R0, A
              SJMP      L_1BDD
L_1BD7:

;                                                   bmCh1234: ModuleFlags := ModuleFlags + [mfBlinds12, mfBlinds34];
              CJNE      R2, #3, L_1BDD
              ORL       A, #3
              MOV       @R0, A
L_1BDD:

;                                                 end;
;                                                 WriteByteToEEPROM (Ofs (TEEprom.EE_ModuleFlags), Byte (ModuleFlags));
              MOV       Address, #LOW  ($000D)
              MOV       Address+1, #HIGH ($000D)
              MOV       D, A
              LCALL     WriteByteToEEPROM

;                                                 Setup := None;
              MOV       Setup, #0

;                                                 Exit;
              RET

;                                               end;
L_1BEC:
;                                    end;
;                                    If BlinkTimer.H and $2 = 0 then Display := '/' else
;                                      Case TempBlindsMode of
              MOV       R2, TempBlindsMode

;                                        bmNone:   Display := '/';
              CJNE      R2, #0, L_1BF6
              MOV       Display, #'/'
              SJMP      L_1C0C
L_1BF6:

;                                        bmCh12:   Display := 'E';
              CJNE      R2, #1, L_1BFE
              MOV       Display, #'E'
              SJMP      L_1C0C
L_1BFE:

;                                        bmCh34:   Display := '3';
              CJNE      R2, #2, L_1C06
              MOV       Display, #'3'
              SJMP      L_1C0C
L_1C06:

;                                        bmCh1234: Display := '8';
              CJNE      R2, #3, L_1C0C
              MOV       Display, #'8'
L_1C0C:

;                                      end;
;                                  end;
              SJMP      L_1C11
L_1C0E:

;                        else Setup := None;           { Blinds are allowed only in normal mode }
              MOV       Setup, #0
L_1C11:

;                      end;
;                      If (Kbd <> kNone) and (Setup <> None) then SetupTimer := SetupTime;
              MOV       A, Kbd
              JZ        L_1C1F
              MOV       A, Setup
              JZ        L_1C1F
              MOV       SetupTimer, #LOW  ($7530)
              MOV       SetupTimer+1, #HIGH ($7530)

;                    end;
;   end;
; end;
L_1C1F:
              RET

; 
; Procedure ReadKeyboard;
; Var TempKey: TKbd;

ReadKeyboard:
; begin
;   KeyBits := P2 and $0F;
              MOV       A, P2
              ANL       A, #$0F
              MOV       KeyBits, A

;   Kbd := kNone;
              MOV       Kbd, #0

;   If KeyBits = LastKeyBits then Exit;
              XRL       A, LastKeyBits
              JZ        L_1C40

;   For TempKey := kNone to kDown do
              MOV       R2, #$FF
L_1C2F:
              INC       R2

;     If KeyBits = KeyTable [TempKey] then
              MOV       A, R2
              MOV       DPTR, #KeyTable
              MOVC      A, @A + DPTR
              CJNE      A, KeyBits, L_1C3D

;       begin
;         Kbd := TempKey;
              MOV       Kbd, R2

;         LastKeyBits := KeyBits;
              MOV       LastKeyBits, KeyBits

;       end;
L_1C3D:
              CJNE      R2, #4, L_1C2F

; end;
L_1C40:
              RET

; 
; Procedure ProcessInputs;
; Var PosEdge1: Boolean;

RSEG _BIT

PosEdge1:                       DBIT     1

;     PosEdge2: Boolean;
PosEdge2:                       DBIT     1

;     PosEdge3: Boolean;
PosEdge3:                       DBIT     1

;     PosEdge4: Boolean;
PosEdge4:                       DBIT     1

; 
;   Procedure CheckDoorInputs;


RSEG _CODE

CheckDoorInputs:
;   begin
;     If IN2 then If DoorState = dsDown then { Door goes down and light sensor interrupted }
              JNB       P1.1, L_1CA5
              MOV       A, DoorState
              CJNE      A, #2, L_1CA5

;       begin
;         Case ModuleType of
              MOV       R2, ModuleType

;           mtCrawford: begin
              CJNE      R2, #1, L_1C79

;                         RelayTimer [2] := RelayTime [1].W; { Stop }
              MOV       R0, #RelayTime
              MOV       RelayTimer+2, @R0
              INC       R0
              MOV       RelayTimer+3, @R0

;                         SetRelay (2, 1);
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                         LightOnAndDelay;
              LCALL     LightOnAndDelay

;                         DelayRelayTime1;
              LCALL     DelayRelayTime1

;                         DelayRelayTime1;
              LCALL     DelayRelayTime1

;                         RelayTimer [1] := RelayTime [1].W; { Up }
              MOV       R0, #RelayTime
              MOV       RelayTimer, @R0
              INC       R0
              MOV       RelayTimer+1, @R0

;                         SetRelay (1, 1);
              MOV       R, #1
              MOV       Status, #1
              LCALL     SetRelay

;                       end;
              SJMP      L_1C9D
L_1C79:

;           mtDoor: begin
              CJNE      R2, #2, L_1C9D

;                     SetRelay (2, 0); { Motor Off }
              MOV       R, #2
              MOV       Status, #0
              LCALL     SetRelay

;                     DelayRelayTime2;
              LCALL     DelayRelayTime2

;                     SetRelay (1, MotorUp); { Direction Up }
              MOV       R, #1
              MOV       Status, #1
              LCALL     SetRelay

;                     DelayRelayTime2;
              LCALL     DelayRelayTime2

;                     SetRelay (2, 1); { Motor On }
              MOV       R, #2
              MOV       Status, #1
              LCALL     SetRelay

;                   end;
L_1C9D:
;         end;
;         DoorState := dsUp;
              MOV       DoorState, #1

;         LastDoorState := dsUp;
              MOV       R0, #LastDoorState
              MOV       @R0, #1

;         Exit;
              RET

;       end;
L_1CA5:
;     If PosEdge4 or PosEdge3 then
              JB        PosEdge4, L_1CAB
              JNB       PosEdge3, L_1CB6
L_1CAB:

;       begin
;         DoorState := dsStop;
              MOV       DoorState, #0

;         If ModuleType = mtDoor then DoorMotorOff;
              MOV       A, ModuleType
              CJNE      A, #2, L_1CB6
              LCALL     DoorMotorOff

;       end;
L_1CB6:
;     If PosEdge1 and (NoKeyTimer = 0 ) then ProcessDoor;
              JNB       PosEdge1, L_1CC2
              MOV       A, NoKeyTimer+1
              ORL       A, NoKeyTimer
              JNZ       L_1CC2
              LCALL     ProcessDoor

;   end;
L_1CC2:
              RET

ProcessInputs:
; 
; begin
;   Input1 := not IN1;
              MOV       C, P1.0
              CPL       C
              MOV       Input1, C

;   Input2 := not IN2;
              MOV       C, P1.1
              CPL       C
              MOV       Input2, C

;   Input3 := not IN3;
              MOV       C, P1.2
              CPL       C
              MOV       Input3, C

;   Input4 := not IN4;
              MOV       C, P1.3
              CPL       C
              MOV       Input4, C

;   PosEdge1 := Input1 and not LastInput1;
              JNB       Input1, L_1CDD
              JNB       LastInput1, L_1CE1
L_1CDD:
              CLR       PosEdge1
              SJMP      L_1CE3
L_1CE1:
              SETB      PosEdge1
L_1CE3:

;   PosEdge2 := Input2 and not LastInput2;
              JNB       Input2, L_1CE9
              JNB       LastInput2, L_1CED
L_1CE9:
              CLR       PosEdge2
              SJMP      L_1CEF
L_1CED:
              SETB      PosEdge2
L_1CEF:

;   PosEdge3 := Input3 and not LastInput3;
              JNB       Input3, L_1CF5
              JNB       LastInput3, L_1CF9
L_1CF5:
              CLR       PosEdge3
              SJMP      L_1CFB
L_1CF9:
              SETB      PosEdge3
L_1CFB:

;   PosEdge4 := Input4 and not LastInput4;
              JNB       Input4, L_1D01
              JNB       LastInput4, L_1D05
L_1D01:
              CLR       PosEdge4
              SJMP      L_1D07
L_1D05:
              SETB      PosEdge4
L_1D07:

;   Case ModuleType of
              MOV       R2, ModuleType

;     mtNormal: begin
              CJNE      R2, #0, L_1D60

;                 If PosEdge1 then
              JNB       PosEdge1, L_1D26

;                   begin
;                     Case mfBlinds12 in ModuleFlags of
              MOV       R0, #ModuleFlags
              MOV       A, @R0

;                       True: ProcessBlinds12State;
              JNB       ACC.0, L_1D1A
              LCALL     ProcessBlinds12State
              SJMP      L_1D26
L_1D1A:

;                       else
;                         SetRelay (1, 0);
              MOV       R, #1
              MOV       Status, #0
              LCALL     SetRelay

;                         LastTxKeyBits := 0;
              MOV       LastTxKeyBits, #0

;                     end;
;                   end;
L_1D26:
;                 If PosEdge2 then
              JNB       PosEdge2, L_1D35

;                   begin
;                     SetRelay (2, 0);
              MOV       R, #2
              MOV       Status, #0
              LCALL     SetRelay

;                     LastTxKeyBits := 0;
              MOV       LastTxKeyBits, #0

;                   end;
L_1D35:
;                 If PosEdge3 then
              JNB       PosEdge3, L_1D4F

;                   begin
;                     Case mfBlinds34 in ModuleFlags of
              MOV       R0, #ModuleFlags
              MOV       A, @R0

;                       True: ProcessBlinds34State;
              JNB       ACC.1, L_1D43
              LCALL     ProcessBlinds34State
              SJMP      L_1D4F
L_1D43:

;                       else
;                         SetRelay (3, 0);
              MOV       R, #3
              MOV       Status, #0
              LCALL     SetRelay

;                         LastTxKeyBits := 0;
              MOV       LastTxKeyBits, #0

;                     end;
;                   end;
L_1D4F:
;                 If PosEdge4 then
              JNB       PosEdge4, L_1D5E

;                   begin
;                     SetRelay (4, 0);
              MOV       R, #4
              MOV       Status, #0
              LCALL     SetRelay

;                     LastTxKeyBits := 0;
              MOV       LastTxKeyBits, #0

;                   end;
L_1D5E:
;               end;
              SJMP      L_1D6B
L_1D60:

;     mtCrawford,
              MOV       A, R2
              XRL       A, #1
              JZ        L_1D68
              CJNE      R2, #2, L_1D6B
L_1D68:

;     mtDoor: CheckDoorInputs;
              LCALL     CheckDoorInputs
L_1D6B:

;   end;
;   If Input1 then NoKeyTimer := NoKeyTime;
              JNB       Input1, L_1D74
              MOV       NoKeyTimer, #LOW  ($0064)
              MOV       NoKeyTimer+1, #HIGH ($0064)
L_1D74:

;   LastInput1 := Input1;
              MOV       C, Input1
              MOV       LastInput1, C

;   LastInput2 := Input2;
              MOV       C, Input2
              MOV       LastInput2, C

;   LastInput3 := Input3;
              MOV       C, Input3
              MOV       LastInput3, C

;   LastInput4 := Input4;
              MOV       C, Input4
              MOV       LastInput4, C

; end;
              RET


CSEG AT $0000

              LJMP     Example3


RSEG _CODE

Example3:
; 
; begin
              MOV       SP, #StackStart-1

;   Init;
              LCALL     Init

;   Repeat
L_1D8B:
;     ReadKeyboard;
              LCALL     ReadKeyboard

;     ProcessSetup;
              LCALL     ProcessSetup

;     If NewBit then StoreBit;
              JNB       NewBit, L_1D97
              LCALL     StoreBit
L_1D97:

;     If KeyPacketReceived then ProcessTxPacket;
              JNB       KeyPacketReceived, L_1D9D
              LCALL     ProcessTxPacket
L_1D9D:

;     If BlockReceived then ProcessCommands;
              JNB       BlockReceived, L_1DA3
              LCALL     ProcessCommands
L_1DA3:

;     ProcessInputs;
              LCALL     ProcessInputs

;     WriteDisplay;
              LCALL     WriteDisplay

;     If AuxModule then SendToAuxModule;
              JNB       P2.4, L_1DAF
              LCALL     SendToAuxModule
L_1DAF:

;   until False;
              SJMP      L_1D8B

; end.

RSEG _CONST


              END

