{
    This file is part of the Turbo51 examples.
    Copyright (C) 2008 - 2011 by Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit I2C;

Interface

Const HighLevel = True;
      LowLevel  = False;

Var Ack: Boolean;
    SDA: Boolean absolute Forward; Volatile;
    SCL: Boolean absolute Forward; Volatile;

Procedure Start_I2C;
Procedure Stop_I2C;
Procedure Send_I2C_Byte (Data2Send: Byte);
Function  Receive_I2C_Byte: Byte;
Procedure Send_I2C_Ack;
Procedure Send_I2C_ClockPulse;

Implementation

Procedure Start_I2C;
begin
  SCL := HighLevel;
  Asm
    NOP
  end;
  SDA := LowLevel;
  Asm
    NOP
  end;
  SCL := LowLevel;
  Asm
    NOP
  end;
end;

Procedure Stop_I2C;
begin
  SDA := LowLevel;
  Asm
    NOP
  end;
  SCL := HighLevel;
  Asm
    NOP
  end;
  SDA := HighLevel;
  Asm
    NOP
  end;
end;

Procedure Send_I2C_Byte (Data2Send: Byte);
Var BitCounter: Byte;
begin
  For BitCounter := 1 to 8 do
    begin
      SDA := Data2Send and $80 <> 0;
      Asm
        NOP
      end;
      SCL := HighLevel;
      Asm
        NOP
      end;
      SCL := LowLevel;
      Asm
        NOP
      end;
      Data2Send := Data2Send shl 1;
    end;
  SDA := HighLevel;
  Asm
    NOP
  end;
  SCL := HighLevel;
  Asm
    NOP
  end;
  Ack := not SDA;
  SCL := LowLevel;
  Asm
    NOP
  end;
end;

Function Receive_I2C_Byte: Byte;
Var Data: Byte;
    BitCounter: Byte;
begin
  Data := 0;
  For BitCounter := 1 to 8 do
    begin
      SCL := HighLevel;
      Asm
        NOP
      end;
      Data := Data shl 1;
      Data := Data or Byte (SDA);
      SCL := LowLevel;
      Asm
        NOP
      end;
    end;
  Receive_I2C_Byte := Data;
end;

Procedure Send_I2C_Ack;
begin
  SDA := LowLevel;
  Asm
    NOP
  end;
  SCL := HighLevel;
  Asm
    NOP
  end;
  SCL := LowLevel;
  Asm
    NOP
  end;
  SDA := HighLevel;
  Asm
    NOP
  end;
end;

Procedure Send_I2C_ClockPulse;
begin
  SCL := HighLevel;
  Asm
    NOP
  end;
  SCL := LowLevel;
  Asm
    NOP
  end;
end;

end.
