; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_DATA         SEGMENT  DATA
_BIT          SEGMENT  BIT

              PUBLIC   Ack
              PUBLIC   Data2Send

              PUBLIC   Start_I2C
              PUBLIC   Stop_I2C
              PUBLIC   Send_I2C_Byte
              PUBLIC   Receive_I2C_Byte
              PUBLIC   Send_I2C_Ack
              PUBLIC   Send_I2C_ClockPulse

; {
;     This file is part of the Turbo51 examples.
;     Copyright (C) 2008 - 2011 by Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit I2C;
; 
; Interface
; 
; Const HighLevel = True;

RSEG _CONST

;       LowLevel  = False;
; 
; Var Ack: Boolean;

RSEG _BIT

Ack:                            DBIT     1

;     SDA: Boolean absolute Forward; Volatile;
              EXTRN    BIT   (SDA)

;     SCL: Boolean absolute Forward; Volatile;
              EXTRN    BIT   (SCL)

; 
; Procedure Start_I2C;
; Procedure Stop_I2C;
; Procedure Send_I2C_Byte (Data2Send: Byte);

RSEG _DATA

Data2Send:                      DS       1

; Function  Receive_I2C_Byte: Byte;
Receive_I2C_Byte_Result:        DS       1

; Procedure Send_I2C_Ack;
; Procedure Send_I2C_ClockPulse;
; 
; Implementation
; 
; Procedure Start_I2C;

USING 0

Start_I2C:
; begin
;   SCL := HighLevel;
              SETB      SCL

;   Asm
;     NOP
              NOP

;   end;
;   SDA := LowLevel;
              CLR       SDA

;   Asm
;     NOP
              NOP

;   end;
;   SCL := LowLevel;
              CLR       SCL

;   Asm
;     NOP
              NOP

;   end;
; end;
              RET

; 
; Procedure Stop_I2C;

Stop_I2C:
; begin
;   SDA := LowLevel;
              CLR       SDA

;   Asm
;     NOP
              NOP

;   end;
;   SCL := HighLevel;
              SETB      SCL

;   Asm
;     NOP
              NOP

;   end;
;   SDA := HighLevel;
              SETB      SDA

;   Asm
;     NOP
              NOP

;   end;
; end;
              RET

; 
; Procedure Send_I2C_Byte (Data2Send: Byte);
; Var BitCounter: Byte;
BitCounter:                     DS       1

Send_I2C_Byte:
; begin
;   For BitCounter := 1 to 8 do
              MOV       R2, #0
              MOV       R3, Data2Send
L_0018:
              INC       R2

;     begin
;       SDA := Data2Send and $80 <> 0;
              MOV       A, R3
              RLC       A
              MOV       SDA, C

;       Asm
;         NOP
              NOP

;       end;
;       SCL := HighLevel;
              SETB      SCL

;       Asm
;         NOP
              NOP

;       end;
;       SCL := LowLevel;
              CLR       SCL

;       Asm
;         NOP
              NOP

;       end;
;       Data2Send := Data2Send shl 1;
              MOV       A, R3
              ADD       A, ACC
              MOV       R3, A

;     end;
              CJNE      R2, #8, L_0018

;   SDA := HighLevel;
              SETB      SDA

;   Asm
;     NOP
              NOP

;   end;
;   SCL := HighLevel;
              SETB      SCL

;   Asm
;     NOP
              NOP

;   end;
;   Ack := not SDA;
              MOV       C, SDA
              CPL       C
              MOV       Ack, C

;   SCL := LowLevel;
              CLR       SCL

;   Asm
;     NOP
              NOP

;   end;
; end;
              RET

; 
; Function Receive_I2C_Byte: Byte;
; Var Data: Byte;
Data:                           DS       1

;     BitCounter: Byte;
BitCounter:                     DS       1

Receive_I2C_Byte:
; begin
;   Data := 0;
              MOV       R3, #0

;   For BitCounter := 1 to 8 do
              MOV       R2, #0
L_003E:
              INC       R2

;     begin
;       SCL := HighLevel;
              SETB      SCL

;       Asm
;         NOP
              NOP

;       end;
;       Data := Data shl 1;
              MOV       A, R3
              ADD       A, ACC
              MOV       R3, A

;       Data := Data or Byte (SDA);
              MOV       C, SDA
              CLR       A
              RLC       A
              ORL       A, R3
              MOV       R3, A

;       SCL := LowLevel;
              CLR       SCL

;       Asm
;         NOP
              NOP

;       end;
;     end;
              CJNE      R2, #8, L_003E

;   Receive_I2C_Byte := Data;
; end;
              MOV       A, R3
              RET

; 
; Procedure Send_I2C_Ack;

Send_I2C_Ack:
; begin
;   SDA := LowLevel;
              CLR       SDA

;   Asm
;     NOP
              NOP

;   end;
;   SCL := HighLevel;
              SETB      SCL

;   Asm
;     NOP
              NOP

;   end;
;   SCL := LowLevel;
              CLR       SCL

;   Asm
;     NOP
              NOP

;   end;
;   SDA := HighLevel;
              SETB      SDA

;   Asm
;     NOP
              NOP

;   end;
; end;
              RET

; 
; Procedure Send_I2C_ClockPulse;

Send_I2C_ClockPulse:
; begin
;   SCL := HighLevel;
              SETB      SCL

;   Asm
;     NOP
              NOP

;   end;
;   SCL := LowLevel;
              CLR       SCL

;   Asm
;     NOP
              NOP

;   end;
; end;
              RET

RSEG _CONST

; 
; end.

              END

