; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0, 1, 2)

_CODE         SEGMENT  CODE
_CONST        SEGMENT  CODE
_DATA         SEGMENT  DATA
_IDATA        SEGMENT  IDATA
_BIT          SEGMENT  BIT

              PUBLIC   SDA
              PUBLIC   SCL

              EXTRN    IDATA (StackStart)

              EXTRN    CODE  (sysBCD)

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 by Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Program Example5;
; 
; {$IDATA}
; 
; Uses I2C, PCF8583;
              EXTRN    DATA  (IIC_Adr)

              EXTRN    CODE  (I2C_AddressPresent)
              EXTRN    CODE  (I2C)

              EXTRN    DATA  (Adr)
              EXTRN    DATA  (DataW)
              EXTRN    DATA  (RTC)

              EXTRN    CODE  (CheckRTC)
              EXTRN    CODE  (WriteByteToRTC)
              EXTRN    CODE  (ReadRTC)
              EXTRN    CODE  (InitRTC)
              EXTRN    CODE  (PCF8583)

; 
; Const VersionHi = 0;

RSEG _CONST

;       VersionLo = 1;
;       Zero = Ord ('0');
;       Version = 'Turbo  Timer REMOTE version ' + Chr (Zero + VersionHi) + '.' + Chr (Zero + VersionLo div 10) + Chr (Zero + VersionLo mod 10) + ' ';
;       VersionString: String [Length (Version)] = Version;
;       HexChar: Array [0..$F] of Char = '0123456789ABCDEF';
HexChar:                        DB        '0123456789ABCDEF'
; 
;       SystemClock                      = 22118400;
;       TimerInterruptsPerSecond         = 1000;
;       BaudRateSerial                   = 19200;
;       RS485_Time                       =    2;    {   2 ms  }
;       LedTime                          =   30;    {  30 ms  }
;       KeyTime                          =  200;
;       CommTime                         =  200;
; 
;       PeriodicTimerValue               = - SystemClock div 12 div TimerInterruptsPerSecond;
;       BaudRateTimerValue               = - SystemClock div 12 div 32 div BaudRateSerial;
; 
;       BlockStart           = $55;
; 
;       bpBlockStart         = 0;
;       bpDestinationAddress = 1;
;       bpCommand            = 2;
;       bpParameter1         = 3;
;       bpParameter2         = 4;
;       bpParameter3         = 5;
;       bpParameter4         = 6;
;       bpParameter5         = 7;
;       bpParameter6         = 8;
;       bpParameter7         = 9;
;       bpParameter8         = 10;
;       bpSourceAddress      = 11;
;       bpChecksum           = 12;
; 
;       BlockSize            = bpChecksum + 1;
; 
;       Cmd_Segments         = $00;
; 
;       LocalAddress         = $10;
;       RemoteAddress        = $11;
; 
;       RtcSeconds = 1;
;       RtcMinutes = 2;
;       RtcHours   = 3;
; 
;       GreetingText = 'FUNA';
; 
;       DecimalPointMask = $02;
; 
;       CharacterSegments: Array [' '..'f'] of Byte = (
CharacterSegments:              
;         {bafgde.c}
;         %00000000, { ' ' }
                                DB        0                           ; $00 = 0
;         %00000000, { '!' }
                                DB        0                           ; $00 = 0
;         %10100000, { '"' }
                                DB        $A0                         ; $A0 = 160
;         %00000000, { '#' }
                                DB        0                           ; $00 = 0
;         %00000000, { '$' }
                                DB        0                           ; $00 = 0
;         %00000000, { '%' }
                                DB        0                           ; $00 = 0
;         %00000000, { '&' }
                                DB        0                           ; $00 = 0
;         %00000000, { ''' }
                                DB        0                           ; $00 = 0
;         %01101100, { '(' }
                                DB        $6C                         ; $6C = 108
;         %11001001, { ')' }
                                DB        $C9                         ; $C9 = 201
;         %00000000, { '*' }
                                DB        0                           ; $00 = 0
;         %00000000, { '+' }
                                DB        0                           ; $00 = 0
;         %00000000, { ',' }
                                DB        0                           ; $00 = 0
;         %00010000, { '-' }
                                DB        $10                         ; $10 = 16
;         %00000000, { '.' }
                                DB        0                           ; $00 = 0
;         %00000000, { '/' }
                                DB        0                           ; $00 = 0
;         %11101101, { '0' }
                                DB        $ED                         ; $ED = 237
;         %10000001, { '1' }
                                DB        $81                         ; $81 = 129
;         %11011100, { '2' }
                                DB        $DC                         ; $DC = 220
;         %11011001, { '3' }
                                DB        $D9                         ; $D9 = 217
;         %10110001, { '4' }
                                DB        $B1                         ; $B1 = 177
;         %01111001, { '5' }
                                DB        $79                         ; $79 = 121
;         %01111101, { '6' }
                                DB        $7D                         ; $7D = 125
;         %11000001, { '7' }
                                DB        $C1                         ; $C1 = 193
;         %11111101, { '8' }
                                DB        $FD                         ; $FD = 253
;         %11111001, { '9' }
                                DB        $F9                         ; $F9 = 249
;         %00000000, { ':' }
                                DB        0                           ; $00 = 0
;         %00000000, { ';' }
                                DB        0                           ; $00 = 0
;         %00000000, { '<' }
                                DB        0                           ; $00 = 0
;         %00011000, { '=' }
                                DB        $18                         ; $18 = 24
;         %00000000, { '>' }
                                DB        0                           ; $00 = 0
;         %00000000, { '?' }
                                DB        0                           ; $00 = 0
;         %00000000, { '@' }
                                DB        0                           ; $00 = 0
;         %11110101, { 'A' }
                                DB        $F5                         ; $F5 = 245
;         %00111101, { 'B' }
                                DB        $3D                         ; $3D = 61
;         %01101100, { 'C' }
                                DB        $6C                         ; $6C = 108
;         %10011101, { 'D' }
                                DB        $9D                         ; $9D = 157
;         %01111100, { 'E' }
                                DB        $7C                         ; $7C = 124
;         %01110100, { 'F' }
                                DB        $74                         ; $74 = 116
;         %00000000, { 'G' }
                                DB        0                           ; $00 = 0
;         %10110101, { 'H' }
                                DB        $B5                         ; $B5 = 181
;         %00100100, { 'I' }
                                DB        $24                         ; $24 = 36
;         %00000000, { 'J' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'K' }
                                DB        0                           ; $00 = 0
;         %00101100, { 'L' }
                                DB        $2C                         ; $2C = 44
;         %00000000, { 'M' }
                                DB        0                           ; $00 = 0
;         %00010101, { 'N' }
                                DB        $15                         ; $15 = 21
;         %00011101, { 'O' }
                                DB        $1D                         ; $1D = 29
;         %11110100, { 'P' }
                                DB        $F4                         ; $F4 = 244
;         %11110100, { 'Q' }
                                DB        $F4                         ; $F4 = 244
;         %00010100, { 'R' }
                                DB        $14                         ; $14 = 20
;         %01111001, { 'S' }
                                DB        $79                         ; $79 = 121
;         %00111100, { 'T' }
                                DB        $3C                         ; $3C = 60
;         %10101101, { 'U' }
                                DB        $AD                         ; $AD = 173
;         %00000000, { 'V' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'W' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'X' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'Y' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'Z' }
                                DB        0                           ; $00 = 0
;         %00000000, { '[' }
                                DB        0                           ; $00 = 0
;         %00000000, { '\' }
                                DB        0                           ; $00 = 0
;         %00000000, { ']' }
                                DB        0                           ; $00 = 0
;         %00000000, { '^' }
                                DB        0                           ; $00 = 0
;         %00000000, { '_' }
                                DB        0                           ; $00 = 0
;         %00000000, { '`' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'a' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'b' }
                                DB        0                           ; $00 = 0
;         %00011100, { 'c' }
                                DB        $1C                         ; $1C = 28
;         %00000000, { 'd' }
                                DB        0                           ; $00 = 0
;         %00000000, { 'e' }
                                DB        0                           ; $00 = 0
;         %00000000);{ 'f' }
                                DB        0                           ; $00 = 0
; 
; Type PDataWordX = ^TDataWord XDATA;
;      TDataWord = Record
;                    Case Byte of
;                     0: (Word: Word);
;                     1: (Byte0, Byte1: Byte);
;                     2: (Bits: Set of 0..15);
;                     3: (Pointer: Pointer);
;                  end;
; 
;      TDataLongInt = Record
;                       Case Byte of
;                        0: (LongInt: LongInt);
;                        1: (Byte0, Byte1, Byte2, Byte3: Byte);
;                        2: (Word0, Word1: Word);
;                        3: (Bits: Set of 0..31);
;                     end;
; 
;      TErrorFlags = (erRTC);
; 
;      TErrorFlagsSet = Set of TErrorFlags;
; 
;      TKey = (keyNone, keyEnter, keyCancel, keyPlus, keyMinus, keySetup);
; 
;      TMode = (mdClock, mdSetupHours, mdSetupMinutes);
; 
; Var DisplayPort:      Byte    Absolute P1;
DisplayPort                     EQU      P1

; 
;     I2C.SDA:          Boolean Absolute P3.2;
SDA                             BIT      P3.2

;     I2C.SCL:          Boolean Absolute P3.5;
SCL                             BIT      P3.5

;     Jumper:           Boolean Absolute P3.3;
Jumper                          BIT      P3.3

;     RS485_TX:         Boolean Absolute P3.4;
RS485_TX                        BIT      P3.4

; 
;     Display1Col:      Boolean Absolute P2.3;
Display1Col                     BIT      P2.3

;     Display2Col:      Boolean Absolute P2.2;
Display2Col                     BIT      P2.2

;     Display3Col:      Boolean Absolute P2.1;
Display3Col                     BIT      P2.1

;     Display4Col:      Boolean Absolute P2.0;
Display4Col                     BIT      P2.0

; 
;     Key_Minus:        Boolean Absolute P2.4;
Key_Minus                       BIT      P2.4

;     Key_Plus:         Boolean Absolute P2.5;
Key_Plus                        BIT      P2.5

;     Key_Cancel:       Boolean Absolute P2.6;
Key_Cancel                      BIT      P2.6

;     Key_Enter:        Boolean Absolute P2.7;
Key_Enter                       BIT      P2.7

; 
;     Relay_Svet:       Boolean Absolute P3.7;
Relay_Svet                      BIT      P3.7

;     Relay_Uprava:     Boolean Absolute P3.6;
Relay_Uprava                    BIT      P3.6

; 
;     ErrorFlags: TErrorFlagsSet;

RSEG _DATA

ErrorFlags:                     DS       1

; 
;     msCounter: Word;
msCounter:                      DS       2

;     DelayTimer: Word;
DelayTimer:                     DS       2

;     Display:  Array [1..4] of Char;
Display:                        DS       4

;     Segments: Array [1..4] of Byte;
Segments:                       DS       4

;     ledDP1:               Boolean;

RSEG _BIT

ledDP1:                         DBIT     1

;     ledDP2:               Boolean;
ledDP2:                         DBIT     1

;     ledDP3:               Boolean;
ledDP3:                         DBIT     1

;     ledDP4:               Boolean;
ledDP4:                         DBIT     1

;     Flash2:               Boolean;
Flash2:                         DBIT     1

;     Flash1:               Boolean;
Flash1:                         DBIT     1

;     Flash05:              Boolean;
Flash05:                        DBIT     1

;     LocalMode:            Boolean;
LocalMode:                      DBIT     1

;     Key: TKey;

RSEG _DATA

Key:                            DS       1

;     KeyTimer: Byte;
KeyTimer:                       DS       1

;     Sending: Boolean;

RSEG _BIT

Sending:                        DBIT     1

;     BlockReceived: Boolean;
BlockReceived:                  DBIT     1

; 
;     TimerSec: Byte;
;     TimerMin: Byte;
;     Timer: Word Absolute TimerSec;
;     ActiveTimerNumber: Byte;
; 
;     RX_Counter: Byte;

RSEG _DATA

RX_Counter:                     DS       1

;     TX_Counter: Byte;
TX_Counter:                     DS       1

;     RX_Checksum: Byte;
RX_Checksum:                    DS       1

;     RX_LedTimer: Byte;
RX_LedTimer:                    DS       1

;     TX_LedTimer: Byte;
TX_LedTimer:                    DS       1

;     RS485_Timer: Byte;
RS485_Timer:                    DS       1

;     CommTimer: Byte;
CommTimer:                      DS       1

;     RX_Buffer,
;     TX_Buffer: Array [bpBlockStart..bpChecksum] of Byte IDATA;

RSEG _IDATA

RX_Buffer:                      DS       13
TX_Buffer:                      DS       13

; 
;     TempByte: Byte;

RSEG _DATA

TempByte:                       DS       1

;     TempWord:     Word;
;     TempDataWord: TDataWord absolute TempWord;
; 
;     KeyBits: Byte;
KeyBits:                        DS       1

;     LastKeyBits: Byte;
LastKeyBits:                    DS       1

;     Mode: TMode;
Mode:                           DS       1

; 
; Procedure Timer_1ms; Interrupt Timer0; Using 1;         { 1 ms interrupt }
; Var DisplaySegments: Byte;


CSEG AT $000B

              SJMP     Timer_1ms

RSEG _CODE

USING 1

Timer_1ms:
; begin
              PUSH      PSW
              MOV       PSW, #8
              PUSH      ACC

;   TL0 :=  Lo (PeriodicTimerValue);
              MOV       TL0, #$CD

;   TH0 :=  Hi (PeriodicTimerValue);
              MOV       TH0, #$F8

; 
;   If DelayTimer   <> 0 then Dec (DelayTimer);
              MOV       A, DelayTimer+1
              ORL       A, DelayTimer
              JZ        L_00A2
              DEC       DelayTimer
              MOV       A, DelayTimer
              CJNE      A, #-1, L_00A2
              DEC       DelayTimer+1
L_00A2:

;   If RS485_Timer  <> 0 then Dec (RS485_Timer) else RS485_TX := False;
              MOV       A, RS485_Timer
              JZ        L_00AA
              DEC       RS485_Timer
              SJMP      L_00AC
L_00AA:
              CLR       P3.4
L_00AC:

;   If RX_LedTimer  <> 0 then Dec (RX_LedTimer);
              MOV       A, RX_LedTimer
              JZ        L_00B2
              DEC       RX_LedTimer
L_00B2:

;   If TX_LedTimer  <> 0 then Dec (TX_LedTimer);
              MOV       A, TX_LedTimer
              JZ        L_00B8
              DEC       TX_LedTimer
L_00B8:

;   If KeyTimer     <> 0 then Dec (KeyTimer);
              MOV       A, KeyTimer
              JZ        L_00BE
              DEC       KeyTimer
L_00BE:

;   If CommTimer    <> 0 then Dec (CommTimer);
              MOV       A, CommTimer
              JZ        L_00C4
              DEC       CommTimer
L_00C4:

; 
;   Case msCounter and $03 of
              MOV       A, msCounter
              ANL       A, #3

;     0: begin
              JNZ       L_00D3

;          Display4Col := False;
              CLR       P2.0

;          DisplayPort := Segments [1];
              MOV       P1, Segments

;          Display1Col := True;
              SETB      P2.3

;        end;
              SJMP      L_00F5
L_00D3:

;     1: begin
              CJNE      A, #1, L_00DF

;          Display1Col := False;
              CLR       P2.3

;          DisplayPort := Segments [2];
              MOV       P1, Segments+1

;          Display2Col := True;
              SETB      P2.2

;        end;
              SJMP      L_00F5
L_00DF:

;     2: begin
              CJNE      A, #2, L_00EB

;          Display2Col := False;
              CLR       P2.2

;          DisplayPort := Segments [3];
              MOV       P1, Segments+2

;          Display3Col := True;
              SETB      P2.1

;        end;
              SJMP      L_00F5
L_00EB:

;     3: begin
              CJNE      A, #3, L_00F5

;          Display3Col := False;
              CLR       P2.1

;          DisplayPort := Segments [4];
              MOV       P1, Segments+3

;          Display4Col := True;
              SETB      P2.0

;        end;
L_00F5:
;   end;
; 
;   If KeyTimer = 0 then
              MOV       A, KeyTimer
              JNZ       L_0148

;     begin
;       Asm
;         CLR      A
              CLR       A

;         MOV      C, Key_Enter
              MOV       C, P2.7

;         CPL      C
              CPL       C

;         RLC      A
              RLC       A

;         MOV      C, Key_Cancel
              MOV       C, P2.6

;         CPL      C
              CPL       C

;         RLC      A
              RLC       A

;         MOV      C, Key_Plus
              MOV       C, P2.5

;         CPL      C
              CPL       C

;         RLC      A
              RLC       A

;         MOV      C, Key_Minus
              MOV       C, P2.4

;         CPL      C
              CPL       C

;         RLC      A
              RLC       A

;         MOV      KeyBits, A
              MOV       KeyBits, A

;       end;
;       If LastKeyBits <> KeyBits then
              MOV       A, LastKeyBits
              XRL       A, KeyBits
              JZ        L_0148

;         begin
;           Case KeyBits of
              MOV       R2, KeyBits

;             $08: Key := keyEnter;
              CJNE      R2, #8, L_011C
              MOV       Key, #1
              SJMP      L_013F
L_011C:

;             $04: Key := keyCancel;
              CJNE      R2, #4, L_0124
              MOV       Key, #2
              SJMP      L_013F
L_0124:

;             $02: Key := keyPlus;
              CJNE      R2, #2, L_012C
              MOV       Key, #3
              SJMP      L_013F
L_012C:

;             $01: Key := keyMinus;
              CJNE      R2, #1, L_0134
              MOV       Key, #4
              SJMP      L_013F
L_0134:

;             $0C: Key := keySetup;
              CJNE      R2, #$0C, L_013C
              MOV       Key, #5
              SJMP      L_013F
L_013C:

;             else Key := keyNone;
              MOV       Key, #0
L_013F:

;           end;
;           LastKeyBits := KeyBits;
              MOV       LastKeyBits, R2

;           If Key <> keyNone then KeyTimer := KeyTime;
              MOV       A, Key
              JZ        L_0148
              MOV       KeyTimer, #$C8

;         end;
;     end;
L_0148:
; 
;   Inc (msCounter);
              INC       msCounter
              MOV       A, msCounter
              JNZ       L_0150
              INC       msCounter+1
L_0150:

;   Flash1 := msCounter > 500;
              ADD       A, #LOW  (-501)
              MOV       A, msCounter+1
              ADDC      A, #HIGH (-501)
              MOV       Flash1, C

;   Flash05 := msCounter and $0100 <> 0;
              MOV       A, msCounter+1
              RRC       A
              MOV       Flash05, C

;   If msCounter >= 1000 then
              MOV       A, msCounter
              ADD       A, #LOW  (-1000)
              MOV       A, msCounter+1
              ADDC      A, #HIGH (-1000)
              JNC       L_016E

;     begin
;       msCounter := 0;
              CLR       A
              MOV       msCounter, A
              MOV       msCounter+1, A

;       Flash2 := not Flash2;
              CPL       Flash2

;     end;
L_016E:
; end;
              POP       ACC
              POP       PSW
              RETI

; 
; Procedure Serial_0; Interrupt Serial; Using 2;          { RS485 }
; Var Ch: Byte;


CSEG AT $0023

USING 2

Serial_0:
; begin
              PUSH      PSW
              MOV       PSW, #$10
              PUSH      ACC

;   If TI then
              JNB       SCON.1, L_0048

;     begin
;       TI := False;
              CLR       SCON.1

;       If TX_Counter < BlockSize then
              MOV       A, TX_Counter
              ADD       A, #-13
              JC        L_0046

;         begin
;           TX_LedTimer := LedTime;
              MOV       TX_LedTimer, #$1E

;           RS485_Timer := RS485_Time;
              MOV       RS485_Timer, #2

;           SBUF := TX_Buffer [TX_Counter];
              MOV       A, TX_Counter
              ADD       A, #TX_Buffer
              MOV       R0, A
              MOV       SBUF, @R0

;           Inc (TX_Counter);
              INC       TX_Counter

;         end else Sending := False;
              SJMP      L_0048
L_0046:
              CLR       Sending

;     end;
L_0048:
;   If RI then
              JNB       SCON.0, L_0081

;     begin
;       RI := False;
              CLR       SCON.0

;       If Sending or BlockReceived then Exit;
              JB        Sending, L_0053
              JNB       BlockReceived, L_0055
L_0053:
              SJMP      L_0081
L_0055:

;       RX_LedTimer := LedTime;
              MOV       RX_LedTimer, #$1E

;       Ch := SBUF;
              MOV       R2, SBUF

;       If (RX_Counter = bpBlockStart) and (Ch <> BlockStart) then Exit;
              MOV       A, RX_Counter
              JNZ       L_0061
              CJNE      R2, #$55, L_0081
L_0061:

;       RX_Buffer [RX_Counter] := Ch;
              ADD       A, #RX_Buffer
              MOV       R0, A
              MOV       @R0, AR2

;       Inc (RX_Counter);
              INC       RX_Counter

;       RX_Checksum := RX_Checksum xor Ch;
              MOV       A, R2
              XRL       RX_Checksum, A

;       If RX_Counter = BlockSize then
              MOV       A, RX_Counter
              CJNE      A, #$0D, L_0081

;         begin
;           If (RX_Buffer [bpDestinationAddress] = RemoteAddress) and (RX_Checksum = 0) then BlockReceived := True;
              MOV       R0, #RX_Buffer+1
              CJNE      @R0, #$11, L_007B
              MOV       A, RX_Checksum
              JNZ       L_007B
              SETB      BlockReceived
L_007B:

;           RX_Counter  := 0;
              MOV       RX_Counter, #0

;           RX_Checksum := 0;
              MOV       RX_Checksum, #0

;         end;
;     end;
; end;
L_0081:
              POP       ACC
              POP       PSW
              RETI

; 
; Procedure Delay (DelayTime: Word);

RSEG _DATA

DelayTime:                      DS       2


RSEG _CODE

USING 0

Delay:
; begin
;   DelayTimer := DelayTime;
              MOV       DelayTimer, DelayTime
              MOV       DelayTimer+1, DelayTime+1
              MOV       R2, DelayTimer+1
              MOV       R3, DelayTimer

;   Repeat
L_0017:
;   until DelayTimer = 0;
              MOV       A, R2
              ORL       A, R3
              JNZ       L_0017

; end;
              RET

; 
; Procedure SendBlock;
; Var TempCheckSum, TempCounter: Byte;
; begin
;   Sending := True;
;   TX_Buffer [bpBlockStart] := BlockStart;
;   TX_Buffer [bpDestinationAddress] := LocalAddress;
;   TX_Buffer [bpSourceAddress]      := RemoteAddress;
;   TempCheckSum := 0;
;   For TempCounter := bpBlockStart to bpSourceAddress do TempCheckSum := TempCheckSum xor TX_Buffer [TempCounter];
;   TX_Buffer [bpChecksum] := TempCheckSum;
;   TX_Counter := 0;
;   RS485_Timer := RS485_Time;
;   RS485_TX := True;
;   TX_LedTimer := LedTime;
;   Repeat
;   until RS485_Timer <= 1;
;   TI := True;
; end;
; 
; Procedure SetSegments;

SetSegments:
; begin
;   Segments [1] := CharacterSegments [Display [1]];
              MOV       A, Display
              MOV       DPTR, #CharacterSegments-32
              MOVC      A, @A + DPTR
              MOV       Segments, A

;   Segments [2] := CharacterSegments [Display [2]];
              MOV       A, Display+1
              MOVC      A, @A + DPTR
              MOV       Segments+1, A

;   Segments [3] := CharacterSegments [Display [3]];
              MOV       A, Display+2
              MOVC      A, @A + DPTR
              MOV       Segments+2, A

;   Segments [4] := CharacterSegments [Display [4]];
              MOV       A, Display+3
              MOVC      A, @A + DPTR
              MOV       Segments+3, A

; 
;   If ledDP1 then Segments [1] := Segments [1] or DecimalPointMask;
              JNB       ledDP1, L_0190
              ORL       Segments, #2
L_0190:

;   If ledDP2 then Segments [2] := Segments [2] or DecimalPointMask;
              JNB       ledDP2, L_0196
              ORL       Segments+1, #2
L_0196:

;   If ledDP3 then Segments [3] := Segments [3] or DecimalPointMask;
              JNB       ledDP3, L_019C
              ORL       Segments+2, #2
L_019C:

;   If ledDP4 then Segments [4] := Segments [4] or DecimalPointMask;
              JNB       ledDP4, L_01A2
              ORL       Segments+3, #2
L_01A2:

; end;
              RET

; 
; Procedure WriteGreetingMessage;

WriteGreetingMessage:
; begin
;   Display := GreetingText;
              MOV       Display, #$46
              MOV       Display+1, #$55
              MOV       Display+2, #$4E
              MOV       Display+3, #$41

;   SetSegments;
              LCALL     SetSegments

;   Delay (1000);
              MOV       DelayTime, #LOW  ($03E8)
              MOV       DelayTime+1, #HIGH ($03E8)
              LCALL     Delay

;   Display := '    ';
              MOV       Display, #$20
              MOV       Display+1, #$20
              MOV       Display+2, #$20
              MOV       Display+3, #$20

;   SetSegments;
              LCALL     SetSegments

;   Delay (500);
              MOV       DelayTime, #LOW  ($01F4)
              MOV       DelayTime+1, #HIGH ($01F4)
              LCALL     Delay

;   Case LocalMode of
;     True: Display [1] := 'C';
              JNB       LocalMode, L_01DB
              MOV       Display, #'C'
              SJMP      L_01DE
L_01DB:

;     else  Display [1] := 'R';
              MOV       Display, #'R'
L_01DE:

;   end;
;   Display [2] := Char (Zero + VersionHi div 10);
              MOV       Display+1, #'0'

;   Display [3] := Char (Zero + VersionLo div 10);
              MOV       Display+2, #'0'

;   Display [4] := Char (Zero + VersionLo mod 10);
              MOV       Display+3, #'1'

;   ledDP2 := True;
              SETB      ledDP2

;   SetSegments;
              LCALL     SetSegments

;   Delay (2000);
              MOV       DelayTime, #LOW  ($07D0)
              MOV       DelayTime+1, #HIGH ($07D0)
              LCALL     Delay

;   ledDP2 := False;
              CLR       ledDP2

;   Display := '    ';
              MOV       Display, #$20
              MOV       Display+1, #$20
              MOV       Display+2, #$20
              MOV       Display+3, #$20

;   SetSegments;
              LCALL     SetSegments

;   Delay (1000);
              MOV       DelayTime, #LOW  ($03E8)
              MOV       DelayTime+1, #HIGH ($03E8)
              LJMP      Delay

; end;
; 
; Procedure Init;

Init:
; begin
;   Display1Col   := True;
              SETB      P2.3

;   Display2Col   := True;
              SETB      P2.2

;   Display3Col   := True;
              SETB      P2.1

;   Display4Col   := True;
              SETB      P2.0

; 
;   Relay_Svet    := True;
              SETB      P3.7

;   Relay_Uprava  := True;
              SETB      P3.6

; 
;   I2C.SDA       := True;
              SETB      P3.2

;   I2C.SCL       := True;
              SETB      P3.5

;   Jumper        := True;
              SETB      P3.3

;   RS485_TX      := False;
              CLR       P3.4

; 
;   DelayTimer    := 0;
              CLR       A
              MOV       DelayTimer, A
              MOV       DelayTimer+1, A

;   RX_Counter    := 0;
              MOV       RX_Counter, A

;   TX_Counter    := 0;
              MOV       TX_Counter, A

;   RX_Checksum   := 0;
              MOV       RX_Checksum, A

;   RX_LedTimer   := 0;
              MOV       RX_LedTimer, A

;   TX_LedTimer   := 0;
              MOV       TX_LedTimer, A

;   RS485_Timer   := 0;
              MOV       RS485_Timer, A

;   Sending       := False;
              CLR       Sending

;   BlockReceived := False;
              CLR       BlockReceived

;   LocalMode     := Jumper;
              SETB      C
              SETB      LocalMode

;   LastKeyBits   := $FF;
              MOV       LastKeyBits, #$FF

;   KeyBits       := 0;
              MOV       KeyBits, A

;   Mode          := mdClock;
              MOV       Mode, A

; 
;   TL0     := Lo (PeriodicTimerValue);
              MOV       TL0, #$CD

;   TH0     := Hi (PeriodicTimerValue);
              MOV       TH0, #$F8

;   TL1     := Lo (BaudRateTimerValue);
              MOV       TL1, #$FD

;   TH1     := Lo (BaudRateTimerValue);
              MOV       TH1, #$FD

; 
;   PCON    := $00;                               { no IDLE, no POWER DOWN }
              MOV       PCON, A

;   SCON    := %01010000;                         { Serial Mode 1, Enable Reception }
              MOV       SCON, #$50

;   TMOD    := %00100001;                         { Timer1: no GATE, Timer,  8 bit timer, autoreload }
              MOV       TMOD, #$21

;                                                 { Timer0: no GATE, Timer, 16 bit timer }
;   TCON    := %01010101;                         { Timer 1 run, Timer 0 run }
              MOV       TCON, #$55

;                                                 { Int1 falling edge, Int0 falling edge }
;   IE      := %10010010;                         { Serial, Timer0 }
              MOV       IE, #$92

; 
;   Segments [1] := $FF;
              MOV       Segments, #$FF

;   Segments [2] := $FF;
              MOV       Segments+1, #$FF

;   Segments [3] := $FF;
              MOV       Segments+2, #$FF

;   Segments [4] := $FF;
              MOV       Segments+3, #$FF

;   Delay (500);
              MOV       DelayTime, #LOW  ($01F4)
              MOV       DelayTime+1, #HIGH ($01F4)
              LCALL     Delay

; 
;   Display := '    ';
              MOV       Display, #$20
              MOV       Display+1, #$20
              MOV       Display+2, #$20
              MOV       Display+3, #$20

;   ledDP1    := False;
              CLR       ledDP1

;   ledDP2    := False;
              CLR       ledDP2

;   ledDP3    := False;
              CLR       ledDP3

;   ledDP4    := False;
              CLR       ledDP4

;   SetSegments;
              LCALL     SetSegments

;   Delay (300);
              MOV       DelayTime, #LOW  ($012C)
              MOV       DelayTime+1, #HIGH ($012C)
              LCALL     Delay

; 
;   ErrorFlags := [];
              MOV       ErrorFlags, #0

;   Case I2C_AddressPresent (I2C_PCF8583) of       { Before using EEPROM Timer0 must be enabled }
              MOV       IIC_Adr, #$A0
              LCALL     I2C_AddressPresent

;     True: begin
              JNC       L_02AA

;             CheckRTC;
              LCALL     CheckRTC

;             WriteByteToRTC (0, 0);
              MOV       Adr, #0
              MOV       DataW, #0
              LCALL     WriteByteToRTC

;           end;
              SJMP      L_02AD
L_02AA:

;     else  Include (ErrorFlags, erRTC);
              ORL       ErrorFlags, #1
L_02AD:

;   end;
;   ReadRTC;
              LCALL     ReadRTC

; 
;   WriteGreetingMessage;
              LJMP      WriteGreetingMessage

; end;
; 
; Procedure ProcessCommands;

ProcessCommands:
; begin
;   BlockReceived := False;
              CLR       BlockReceived

;   Delay (2);
              MOV       DelayTime, #LOW  (2)
              MOV       DelayTime+1, #HIGH (2)
              LCALL     Delay

;   Case RX_Buffer [bpCommand] of
              MOV       R0, #RX_Buffer+2

;     Cmd_Segments: If not LocalMode then
              CJNE      @R0, #0, L_02DF
              JB        LocalMode, L_02DF

;                     begin
;                       CommTimer := CommTime;
              MOV       CommTimer, #$C8

;                       Segments [1] := RX_Buffer [bpParameter1];
              INC       R0
              MOV       Segments, @R0

;                       Segments [2] := RX_Buffer [bpParameter2];
              INC       R0
              MOV       Segments+1, @R0

;                       Segments [3] := RX_Buffer [bpParameter3];
              INC       R0
              MOV       Segments+2, @R0

;                       Segments [4] := RX_Buffer [bpParameter4];
              INC       R0
              MOV       Segments+3, @R0

;                       Relay_Svet   := RX_Buffer [bpParameter5] and $01 <> 0;
              INC       R0
              MOV       A, @R0
              RRC       A
              MOV       P3.7, C

;                       Relay_Uprava := RX_Buffer [bpParameter6] and $01 <> 0;
              INC       R0
              MOV       A, @R0
              RRC       A
              MOV       P3.6, C

;                     end;
L_02DF:
;   end;
; end;
              RET

; 
; Procedure WriteDisplay;

WriteDisplay:
; begin
;   Case LocalMode of
;     True: Case erRTC in ErrorFlags of
              JNB       LocalMode, L_0356
              MOV       A, ErrorFlags

;             True: begin
              JNB       ACC.0, L_0312

;                     Display := 'RTc ';
              MOV       Display, #$52
              MOV       Display+1, #$54
              MOV       Display+2, #$63
              MOV       Display+3, #$20

;                     Case I2C_AddressPresent (I2C_PCF8583) of
              MOV       IIC_Adr, #$A0
              LCALL     I2C_AddressPresent

;                       True: begin
              JNC       L_030E

;                               Exclude (ErrorFlags, erRTC);
              ANL       ErrorFlags, #$FE

;                               InitRTC;
              LCALL     InitRTC

;                               CheckRTC;
              LCALL     CheckRTC

;                               WriteByteToRTC (0, 0);
              MOV       Adr, #0
              MOV       DataW, #0
              LJMP      WriteByteToRTC

;                             end;
L_030E:
;                       else  Include (ErrorFlags, erRTC);
              ORL       ErrorFlags, #1

;                     end;
;                   end;
              RET
L_0312:

;             else
;               Display [1] := HexChar [RTC [RtcHours] shr 4];
              MOV       A, RTC+3
              SWAP      A
              ANL       A, #$0F
              MOV       DPTR, #HexChar
              MOVC      A, @A + DPTR
              MOV       Display, A

;               Display [2] := HexChar [RTC [RtcHours] and $0F];
              MOV       A, RTC+3
              ANL       A, #$0F
              MOVC      A, @A + DPTR
              MOV       Display+1, A

;               Display [3] := HexChar [RTC [RtcMinutes] shr 4];
              MOV       A, RTC+2
              SWAP      A
              ANL       A, #$0F
              MOVC      A, @A + DPTR
              MOV       Display+2, A

;               Display [4] := HexChar [RTC [RtcMinutes] and $0F];
              MOV       A, RTC+2
              ANL       A, #$0F
              MOVC      A, @A + DPTR
              MOV       Display+3, A

;               ledDP2 := RTC [RtcSeconds] and $01 <> 0;
              MOV       A, RTC+1
              RRC       A
              MOV       ledDP2, C

;               If Flash05 then
              JNB       Flash05, L_0351

;                 Case Mode of
              MOV       R2, Mode

;                   mdSetupHours:   begin
              CJNE      R2, #1, L_0348

;                                     Display [1] := ' ';
              MOV       Display, #' '

;                                     Display [2] := ' ';
              MOV       Display+1, #' '

;                                   end;
              SJMP      L_0351
L_0348:

;                   mdSetupMinutes: begin
              CJNE      R2, #2, L_0351

;                                     Display [3] := ' ';
              MOV       Display+2, #' '

;                                     Display [4] := ' ';
              MOV       Display+3, #' '

;                                   end;
L_0351:
;                 end;
;               Relay_Svet   := False;
              CLR       P3.7

;               Relay_Uprava := False;
              CLR       P3.6
              RET
L_0356:

;           end;
;     else If CommTimer = 0 then
              MOV       A, CommTimer
              JNZ       L_0381

;             begin
;               Relay_Svet   := Flash1;
              MOV       C, Flash1
              MOV       P3.7, C

;               Relay_Uprava := not Flash1;
              CPL       C
              MOV       P3.6, C

;               Case Flash1 of
;                 True: Display := '0---';
              JNB       Flash1, L_0372
              MOV       Display, #$30
              MOV       Display+1, #$2D
              MOV       Display+2, #$2D
              MOV       Display+3, #$2D
              SJMP      L_037E
L_0372:

;                 else  Display := '---0';
              MOV       Display, #$2D
              MOV       Display+1, #$2D
              MOV       Display+2, #$2D
              MOV       Display+3, #$30
L_037E:

;               end;
;               SetSegments;
              LCALL     SetSegments

;             end;
L_0381:
;   end;
; end;
              RET

; 
; Procedure ProcessKeys;
; 
;   Procedure ExitSetup;

ExitSetup:
;   begin
;     RTC [RtcSeconds] := 0;
              MOV       RTC+1, #0

;     WriteByteToRTC (RtcSeconds + 1, RTC [RtcSeconds]);
              MOV       Adr, #2
              MOV       DataW, #0
              LCALL     WriteByteToRTC

;     Mode := mdClock;
              MOV       Mode, #0

;   end;
              RET

ProcessKeys:
; 
; begin
;   If LocalMode then
              JB        LocalMode, L_0398
              LJMP      L_048D
L_0398:

;     Case Mode of
              MOV       R2, Mode

;       mdClock:        Case Key of
              CJNE      R2, #0, L_03A8

;                         keyEnter:  Mode := mdSetupHours;
              MOV       A, Key
              CJNE      A, #1, L_03A5
              MOV       Mode, #1
L_03A5:
              LJMP      L_048D
L_03A8:

;                       end;
;       mdSetupHours:   Case Key of
              CJNE      R2, #1, L_041D
              MOV       R2, Key

;                         keyCancel: ExitSetup;
              CJNE      R2, #2, L_03B6
              LCALL     ExitSetup
              LJMP      L_048D
L_03B6:

;                         keyEnter:  Mode := mdSetupMinutes;
              CJNE      R2, #1, L_03BF
              MOV       Mode, #2
              LJMP      L_048D
L_03BF:

;                         keyPlus: begin
              CJNE      R2, #3, L_03EF

;                                    TempByte := 10 * (RTC [RtcHours] shr 4) + RTC [RtcHours] and $0F;
              MOV       A, RTC+3
              ANL       A, #$0F
              MOV       R1, A
              MOV       A, RTC+3
              SWAP      A
              ANL       A, #$0F
              MOV       B, #$0A
              MUL       AB
              ADD       A, R1
              MOV       TempByte, A

;                                    Inc (TempByte);
              INC       TempByte

;                                    If TempByte = 24 then TempByte := 0;
              MOV       A, TempByte
              CJNE      A, #$18, L_03DD
              MOV       TempByte, #0
L_03DD:

;                                    RTC [RtcHours] := BCD (TempByte);
              MOV       A, TempByte
              LCALL     sysBCD
              MOV       RTC+3, A

;                                    WriteByteToRTC (RtcHours + 1, RTC [RtcHours]);
              MOV       Adr, #4
              MOV       DataW, A
              LCALL     WriteByteToRTC

;                                  end;
              LJMP      L_048D
L_03EF:

;                         keyMinus: begin
              CJNE      R2, #4, L_041B

;                                     TempByte := 10 * (RTC [RtcHours] shr 4) + RTC [RtcHours] and $0F;
              MOV       A, RTC+3
              ANL       A, #$0F
              MOV       R1, A
              MOV       A, RTC+3
              SWAP      A
              ANL       A, #$0F
              MOV       B, #$0A
              MUL       AB
              ADD       A, R1
              MOV       TempByte, A

;                                     If TempByte = 0 then TempByte := 23 else Dec (TempByte);
              JNZ       L_040A
              MOV       TempByte, #$17
              SJMP      L_040C
L_040A:
              DEC       TempByte
L_040C:

;                                     RTC [RtcHours] := BCD (TempByte);
              MOV       A, TempByte
              LCALL     sysBCD
              MOV       RTC+3, A

;                                     WriteByteToRTC (RtcHours + 1, RTC [RtcHours]);
              MOV       Adr, #4
              MOV       DataW, A
              LCALL     WriteByteToRTC

;                                   end;
L_041B:
              SJMP      L_048D
L_041D:

;                       end;
;       mdSetupMinutes: Case Key of
              CJNE      R2, #2, L_048D
              MOV       R2, Key

;                         keyCancel: ExitSetup;
              CJNE      R2, #2, L_042A
              LCALL     ExitSetup
              SJMP      L_048D
L_042A:

;                         keyEnter:  Mode := mdSetupHours;
              CJNE      R2, #1, L_0432
              MOV       Mode, #1
              SJMP      L_048D
L_0432:

;                         keyPlus: begin
              CJNE      R2, #3, L_0461

;                                    TempByte := 10 * (RTC [RtcMinutes] shr 4) + RTC [RtcMinutes] and $0F;
              MOV       A, RTC+2
              ANL       A, #$0F
              MOV       R1, A
              MOV       A, RTC+2
              SWAP      A
              ANL       A, #$0F
              MOV       B, #$0A
              MUL       AB
              ADD       A, R1
              MOV       TempByte, A

;                                    Inc (TempByte);
              INC       TempByte

;                                    If TempByte = 60 then TempByte := 0;
              MOV       A, TempByte
              CJNE      A, #$3C, L_0450
              MOV       TempByte, #0
L_0450:

;                                    RTC [RtcMinutes] := BCD (TempByte);
              MOV       A, TempByte
              LCALL     sysBCD
              MOV       RTC+2, A

;                                    WriteByteToRTC (RtcMinutes + 1, RTC [RtcMinutes]);
              MOV       Adr, #3
              MOV       DataW, A
              LCALL     WriteByteToRTC

;                                  end;
              SJMP      L_048D
L_0461:

;                         keyMinus: begin
              CJNE      R2, #4, L_048D

;                                     TempByte := 10 * (RTC [RtcMinutes] shr 4) + RTC [RtcMinutes] and $0F;
              MOV       A, RTC+2
              ANL       A, #$0F
              MOV       R1, A
              MOV       A, RTC+2
              SWAP      A
              ANL       A, #$0F
              MOV       B, #$0A
              MUL       AB
              ADD       A, R1
              MOV       TempByte, A

;                                     If TempByte = 0 then TempByte := 59 else Dec (TempByte);
              JNZ       L_047C
              MOV       TempByte, #$3B
              SJMP      L_047E
L_047C:
              DEC       TempByte
L_047E:

;                                     RTC [RtcMinutes] := BCD (TempByte);
              MOV       A, TempByte
              LCALL     sysBCD
              MOV       RTC+2, A

;                                     WriteByteToRTC (RtcMinutes + 1, RTC [RtcMinutes]);
              MOV       Adr, #3
              MOV       DataW, A
              LCALL     WriteByteToRTC

;                                   end;
L_048D:
;                       end;
;     end;
;   Key := KeyNone;
              MOV       Key, #0

; end;
              RET


CSEG AT $0000

              AJMP     Example5


RSEG _CODE

Example5:
; 
; begin
              MOV       SP, #StackStart-1
              LCALL     I2C
              LCALL     PCF8583

;   Init;
              LCALL     Init

;   Repeat
L_049D:
;     ReadRTC;
              LCALL     ReadRTC

;     ProcessKeys;
              LCALL     ProcessKeys

;     If BlockReceived then ProcessCommands;
              JNB       BlockReceived, L_04A9
              LCALL     ProcessCommands
L_04A9:

;     WriteDisplay;
              LCALL     WriteDisplay

;     If LocalMode then SetSegments;
              JNB       LocalMode, L_04B2
              LCALL     SetSegments
L_04B2:

;   until False;
              SJMP      L_049D

; end.

RSEG _CONST


              END

