{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 by Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Program Example5;

{$IDATA}

Uses I2C, PCF8583;

Const VersionHi = 0;
      VersionLo = 1;
      Zero = Ord ('0');
      Version = 'Turbo  Timer REMOTE version ' + Chr (Zero + VersionHi) + '.' + Chr (Zero + VersionLo div 10) + Chr (Zero + VersionLo mod 10) + ' ';
      VersionString: String [Length (Version)] = Version;
      HexChar: Array [0..$F] of Char = '0123456789ABCDEF';

      SystemClock                      = 22118400;
      TimerInterruptsPerSecond         = 1000;
      BaudRateSerial                   = 19200;
      RS485_Time                       =    2;    {   2 ms  }
      LedTime                          =   30;    {  30 ms  }
      KeyTime                          =  200;
      CommTime                         =  200;

      PeriodicTimerValue               = - SystemClock div 12 div TimerInterruptsPerSecond;
      BaudRateTimerValue               = - SystemClock div 12 div 32 div BaudRateSerial;

      BlockStart           = $55;

      bpBlockStart         = 0;
      bpDestinationAddress = 1;
      bpCommand            = 2;
      bpParameter1         = 3;
      bpParameter2         = 4;
      bpParameter3         = 5;
      bpParameter4         = 6;
      bpParameter5         = 7;
      bpParameter6         = 8;
      bpParameter7         = 9;
      bpParameter8         = 10;
      bpSourceAddress      = 11;
      bpChecksum           = 12;

      BlockSize            = bpChecksum + 1;

      Cmd_Segments         = $00;

      LocalAddress         = $10;
      RemoteAddress        = $11;

      RtcSeconds = 1;
      RtcMinutes = 2;
      RtcHours   = 3;

      GreetingText = 'FUNA';

      DecimalPointMask = $02;

      CharacterSegments: Array [' '..'f'] of Byte = (
        {bafgde.c}
        %00000000, { ' ' }
        %00000000, { '!' }
        %10100000, { '"' }
        %00000000, { '#' }
        %00000000, { '$' }
        %00000000, { '%' }
        %00000000, { '&' }
        %00000000, { ''' }
        %01101100, { '(' }
        %11001001, { ')' }
        %00000000, { '*' }
        %00000000, { '+' }
        %00000000, { ',' }
        %00010000, { '-' }
        %00000000, { '.' }
        %00000000, { '/' }
        %11101101, { '0' }
        %10000001, { '1' }
        %11011100, { '2' }
        %11011001, { '3' }
        %10110001, { '4' }
        %01111001, { '5' }
        %01111101, { '6' }
        %11000001, { '7' }
        %11111101, { '8' }
        %11111001, { '9' }
        %00000000, { ':' }
        %00000000, { ';' }
        %00000000, { '<' }
        %00011000, { '=' }
        %00000000, { '>' }
        %00000000, { '?' }
        %00000000, { '@' }
        %11110101, { 'A' }
        %00111101, { 'B' }
        %01101100, { 'C' }
        %10011101, { 'D' }
        %01111100, { 'E' }
        %01110100, { 'F' }
        %00000000, { 'G' }
        %10110101, { 'H' }
        %00100100, { 'I' }
        %00000000, { 'J' }
        %00000000, { 'K' }
        %00101100, { 'L' }
        %00000000, { 'M' }
        %00010101, { 'N' }
        %00011101, { 'O' }
        %11110100, { 'P' }
        %11110100, { 'Q' }
        %00010100, { 'R' }
        %01111001, { 'S' }
        %00111100, { 'T' }
        %10101101, { 'U' }
        %00000000, { 'V' }
        %00000000, { 'W' }
        %00000000, { 'X' }
        %00000000, { 'Y' }
        %00000000, { 'Z' }
        %00000000, { '[' }
        %00000000, { '\' }
        %00000000, { ']' }
        %00000000, { '^' }
        %00000000, { '_' }
        %00000000, { '`' }
        %00000000, { 'a' }
        %00000000, { 'b' }
        %00011100, { 'c' }
        %00000000, { 'd' }
        %00000000, { 'e' }
        %00000000);{ 'f' }

Type PDataWordX = ^TDataWord XDATA;
     TDataWord = Record
                   Case Byte of
                    0: (Word: Word);
                    1: (Byte0, Byte1: Byte);
                    2: (Bits: Set of 0..15);
                    3: (Pointer: Pointer);
                 end;

     TDataLongInt = Record
                      Case Byte of
                       0: (LongInt: LongInt);
                       1: (Byte0, Byte1, Byte2, Byte3: Byte);
                       2: (Word0, Word1: Word);
                       3: (Bits: Set of 0..31);
                    end;

     TErrorFlags = (erRTC);

     TErrorFlagsSet = Set of TErrorFlags;

     TKey = (keyNone, keyEnter, keyCancel, keyPlus, keyMinus, keySetup);

     TMode = (mdClock, mdSetupHours, mdSetupMinutes);

Var DisplayPort:      Byte    Absolute P1;

    I2C.SDA:          Boolean Absolute P3.2;
    I2C.SCL:          Boolean Absolute P3.5;
    Jumper:           Boolean Absolute P3.3;
    RS485_TX:         Boolean Absolute P3.4;

    Display1Col:      Boolean Absolute P2.3;
    Display2Col:      Boolean Absolute P2.2;
    Display3Col:      Boolean Absolute P2.1;
    Display4Col:      Boolean Absolute P2.0;

    Key_Minus:        Boolean Absolute P2.4;
    Key_Plus:         Boolean Absolute P2.5;
    Key_Cancel:       Boolean Absolute P2.6;
    Key_Enter:        Boolean Absolute P2.7;

    Relay_Svet:       Boolean Absolute P3.7;
    Relay_Uprava:     Boolean Absolute P3.6;

    ErrorFlags: TErrorFlagsSet;

    msCounter: Word;
    DelayTimer: Word;
    Display:  Array [1..4] of Char;
    Segments: Array [1..4] of Byte;
    ledDP1:               Boolean;
    ledDP2:               Boolean;
    ledDP3:               Boolean;
    ledDP4:               Boolean;
    Flash2:               Boolean;
    Flash1:               Boolean;
    Flash05:              Boolean;
    LocalMode:            Boolean;
    Key: TKey;
    KeyTimer: Byte;
    Sending: Boolean;
    BlockReceived: Boolean;

    TimerSec: Byte;
    TimerMin: Byte;
    Timer: Word Absolute TimerSec;
    ActiveTimerNumber: Byte;

    RX_Counter: Byte;
    TX_Counter: Byte;
    RX_Checksum: Byte;
    RX_LedTimer: Byte;
    TX_LedTimer: Byte;
    RS485_Timer: Byte;
    CommTimer: Byte;
    RX_Buffer,
    TX_Buffer: Array [bpBlockStart..bpChecksum] of Byte IDATA;

    TempByte: Byte;
    TempWord:     Word;
    TempDataWord: TDataWord absolute TempWord;

    KeyBits: Byte;
    LastKeyBits: Byte;
    Mode: TMode;

Procedure Timer_1ms; Interrupt Timer0; Using 1;         { 1 ms interrupt }
Var DisplaySegments: Byte;
begin
  TL0 :=  Lo (PeriodicTimerValue);
  TH0 :=  Hi (PeriodicTimerValue);

  If DelayTimer   <> 0 then Dec (DelayTimer);
  If RS485_Timer  <> 0 then Dec (RS485_Timer) else RS485_TX := False;
  If RX_LedTimer  <> 0 then Dec (RX_LedTimer);
  If TX_LedTimer  <> 0 then Dec (TX_LedTimer);
  If KeyTimer     <> 0 then Dec (KeyTimer);
  If CommTimer    <> 0 then Dec (CommTimer);

  Case msCounter and $03 of
    0: begin
         Display4Col := False;
         DisplayPort := Segments [1];
         Display1Col := True;
       end;
    1: begin
         Display1Col := False;
         DisplayPort := Segments [2];
         Display2Col := True;
       end;
    2: begin
         Display2Col := False;
         DisplayPort := Segments [3];
         Display3Col := True;
       end;
    3: begin
         Display3Col := False;
         DisplayPort := Segments [4];
         Display4Col := True;
       end;
  end;

  If KeyTimer = 0 then
    begin
      Asm
        CLR      A
        MOV      C, Key_Enter
        CPL      C
        RLC      A
        MOV      C, Key_Cancel
        CPL      C
        RLC      A
        MOV      C, Key_Plus
        CPL      C
        RLC      A
        MOV      C, Key_Minus
        CPL      C
        RLC      A
        MOV      KeyBits, A
      end;
      If LastKeyBits <> KeyBits then
        begin
          Case KeyBits of
            $08: Key := keyEnter;
            $04: Key := keyCancel;
            $02: Key := keyPlus;
            $01: Key := keyMinus;
            $0C: Key := keySetup;
            else Key := keyNone;
          end;
          LastKeyBits := KeyBits;
          If Key <> keyNone then KeyTimer := KeyTime;
        end;
    end;

  Inc (msCounter);
  Flash1 := msCounter > 500;
  Flash05 := msCounter and $0100 <> 0;
  If msCounter >= 1000 then
    begin
      msCounter := 0;
      Flash2 := not Flash2;
    end;
end;

Procedure Serial_0; Interrupt Serial; Using 2;          { RS485 }
Var Ch: Byte;
begin
  If TI then
    begin
      TI := False;
      If TX_Counter < BlockSize then
        begin
          TX_LedTimer := LedTime;
          RS485_Timer := RS485_Time;
          SBUF := TX_Buffer [TX_Counter];
          Inc (TX_Counter);
        end else Sending := False;
    end;
  If RI then
    begin
      RI := False;
      If Sending or BlockReceived then Exit;
      RX_LedTimer := LedTime;
      Ch := SBUF;
      If (RX_Counter = bpBlockStart) and (Ch <> BlockStart) then Exit;
      RX_Buffer [RX_Counter] := Ch;
      Inc (RX_Counter);
      RX_Checksum := RX_Checksum xor Ch;
      If RX_Counter = BlockSize then
        begin
          If (RX_Buffer [bpDestinationAddress] = RemoteAddress) and (RX_Checksum = 0) then BlockReceived := True;
          RX_Counter  := 0;
          RX_Checksum := 0;
        end;
    end;
end;

Procedure Delay (DelayTime: Word);
begin
  DelayTimer := DelayTime;
  Repeat
  until DelayTimer = 0;
end;

Procedure SendBlock;
Var TempCheckSum, TempCounter: Byte;
begin
  Sending := True;
  TX_Buffer [bpBlockStart] := BlockStart;
  TX_Buffer [bpDestinationAddress] := LocalAddress;
  TX_Buffer [bpSourceAddress]      := RemoteAddress;
  TempCheckSum := 0;
  For TempCounter := bpBlockStart to bpSourceAddress do TempCheckSum := TempCheckSum xor TX_Buffer [TempCounter];
  TX_Buffer [bpChecksum] := TempCheckSum;
  TX_Counter := 0;
  RS485_Timer := RS485_Time;
  RS485_TX := True;
  TX_LedTimer := LedTime;
  Repeat
  until RS485_Timer <= 1;
  TI := True;
end;

Procedure SetSegments;
begin
  Segments [1] := CharacterSegments [Display [1]];
  Segments [2] := CharacterSegments [Display [2]];
  Segments [3] := CharacterSegments [Display [3]];
  Segments [4] := CharacterSegments [Display [4]];

  If ledDP1 then Segments [1] := Segments [1] or DecimalPointMask;
  If ledDP2 then Segments [2] := Segments [2] or DecimalPointMask;
  If ledDP3 then Segments [3] := Segments [3] or DecimalPointMask;
  If ledDP4 then Segments [4] := Segments [4] or DecimalPointMask;
end;

Procedure WriteGreetingMessage;
begin
  Display := GreetingText;
  SetSegments;
  Delay (1000);
  Display := '    ';
  SetSegments;
  Delay (500);
  Case LocalMode of
    True: Display [1] := 'C';
    else  Display [1] := 'R';
  end;
  Display [2] := Char (Zero + VersionHi div 10);
  Display [3] := Char (Zero + VersionLo div 10);
  Display [4] := Char (Zero + VersionLo mod 10);
  ledDP2 := True;
  SetSegments;
  Delay (2000);
  ledDP2 := False;
  Display := '    ';
  SetSegments;
  Delay (1000);
end;

Procedure Init;
begin
  Display1Col   := True;
  Display2Col   := True;
  Display3Col   := True;
  Display4Col   := True;

  Relay_Svet    := True;
  Relay_Uprava  := True;

  I2C.SDA       := True;
  I2C.SCL       := True;
  Jumper        := True;
  RS485_TX      := False;

  DelayTimer    := 0;
  RX_Counter    := 0;
  TX_Counter    := 0;
  RX_Checksum   := 0;
  RX_LedTimer   := 0;
  TX_LedTimer   := 0;
  RS485_Timer   := 0;
  Sending       := False;
  BlockReceived := False;
  LocalMode     := Jumper;
  LastKeyBits   := $FF;
  KeyBits       := 0;
  Mode          := mdClock;

  TL0     := Lo (PeriodicTimerValue);
  TH0     := Hi (PeriodicTimerValue);
  TL1     := Lo (BaudRateTimerValue);
  TH1     := Lo (BaudRateTimerValue);

  PCON    := $00;                               { no IDLE, no POWER DOWN }
  SCON    := %01010000;                         { Serial Mode 1, Enable Reception }
  TMOD    := %00100001;                         { Timer1: no GATE, Timer,  8 bit timer, autoreload }
                                                { Timer0: no GATE, Timer, 16 bit timer }
  TCON    := %01010101;                         { Timer 1 run, Timer 0 run }
                                                { Int1 falling edge, Int0 falling edge }
  IE      := %10010010;                         { Serial, Timer0 }

  Segments [1] := $FF;
  Segments [2] := $FF;
  Segments [3] := $FF;
  Segments [4] := $FF;
  Delay (500);

  Display := '    ';
  ledDP1    := False;
  ledDP2    := False;
  ledDP3    := False;
  ledDP4    := False;
  SetSegments;
  Delay (300);

  ErrorFlags := [];
  Case I2C_AddressPresent (I2C_PCF8583) of       { Before using EEPROM Timer0 must be enabled }
    True: begin
            CheckRTC;
            WriteByteToRTC (0, 0);
          end;
    else  Include (ErrorFlags, erRTC);
  end;
  ReadRTC;

  WriteGreetingMessage;
end;

Procedure ProcessCommands;
begin
  BlockReceived := False;
  Delay (2);
  Case RX_Buffer [bpCommand] of
    Cmd_Segments: If not LocalMode then
                    begin
                      CommTimer := CommTime;
                      Segments [1] := RX_Buffer [bpParameter1];
                      Segments [2] := RX_Buffer [bpParameter2];
                      Segments [3] := RX_Buffer [bpParameter3];
                      Segments [4] := RX_Buffer [bpParameter4];
                      Relay_Svet   := RX_Buffer [bpParameter5] and $01 <> 0;
                      Relay_Uprava := RX_Buffer [bpParameter6] and $01 <> 0;
                    end;
  end;
end;

Procedure WriteDisplay;
begin
  Case LocalMode of
    True: Case erRTC in ErrorFlags of
            True: begin
                    Display := 'RTc ';
                    Case I2C_AddressPresent (I2C_PCF8583) of
                      True: begin
                              Exclude (ErrorFlags, erRTC);
                              InitRTC;
                              CheckRTC;
                              WriteByteToRTC (0, 0);
                            end;
                      else  Include (ErrorFlags, erRTC);
                    end;
                  end;
            else
              Display [1] := HexChar [RTC [RtcHours] shr 4];
              Display [2] := HexChar [RTC [RtcHours] and $0F];
              Display [3] := HexChar [RTC [RtcMinutes] shr 4];
              Display [4] := HexChar [RTC [RtcMinutes] and $0F];
              ledDP2 := RTC [RtcSeconds] and $01 <> 0;
              If Flash05 then
                Case Mode of
                  mdSetupHours:   begin
                                    Display [1] := ' ';
                                    Display [2] := ' ';
                                  end;
                  mdSetupMinutes: begin
                                    Display [3] := ' ';
                                    Display [4] := ' ';
                                  end;
                end;
              Relay_Svet   := False;
              Relay_Uprava := False;
          end;
    else If CommTimer = 0 then
            begin
              Relay_Svet   := Flash1;
              Relay_Uprava := not Flash1;
              Case Flash1 of
                True: Display := '0---';
                else  Display := '---0';
              end;
              SetSegments;
            end;
  end;
end;

Procedure ProcessKeys;

  Procedure ExitSetup;
  begin
    RTC [RtcSeconds] := 0;
    WriteByteToRTC (RtcSeconds + 1, RTC [RtcSeconds]);
    Mode := mdClock;
  end;

begin
  If LocalMode then
    Case Mode of
      mdClock:        Case Key of
                        keyEnter:  Mode := mdSetupHours;
                      end;
      mdSetupHours:   Case Key of
                        keyCancel: ExitSetup;
                        keyEnter:  Mode := mdSetupMinutes;
                        keyPlus: begin
                                   TempByte := 10 * (RTC [RtcHours] shr 4) + RTC [RtcHours] and $0F;
                                   Inc (TempByte);
                                   If TempByte = 24 then TempByte := 0;
                                   RTC [RtcHours] := BCD (TempByte);
                                   WriteByteToRTC (RtcHours + 1, RTC [RtcHours]);
                                 end;
                        keyMinus: begin
                                    TempByte := 10 * (RTC [RtcHours] shr 4) + RTC [RtcHours] and $0F;
                                    If TempByte = 0 then TempByte := 23 else Dec (TempByte);
                                    RTC [RtcHours] := BCD (TempByte);
                                    WriteByteToRTC (RtcHours + 1, RTC [RtcHours]);
                                  end;
                      end;
      mdSetupMinutes: Case Key of
                        keyCancel: ExitSetup;
                        keyEnter:  Mode := mdSetupHours;
                        keyPlus: begin
                                   TempByte := 10 * (RTC [RtcMinutes] shr 4) + RTC [RtcMinutes] and $0F;
                                   Inc (TempByte);
                                   If TempByte = 60 then TempByte := 0;
                                   RTC [RtcMinutes] := BCD (TempByte);
                                   WriteByteToRTC (RtcMinutes + 1, RTC [RtcMinutes]);
                                 end;
                        keyMinus: begin
                                    TempByte := 10 * (RTC [RtcMinutes] shr 4) + RTC [RtcMinutes] and $0F;
                                    If TempByte = 0 then TempByte := 59 else Dec (TempByte);
                                    RTC [RtcMinutes] := BCD (TempByte);
                                    WriteByteToRTC (RtcMinutes + 1, RTC [RtcMinutes]);
                                  end;
                      end;
    end;
  Key := KeyNone;
end;

begin
  Init;
  Repeat
    ReadRTC;
    ProcessKeys;
    If BlockReceived then ProcessCommands;
    WriteDisplay;
    If LocalMode then SetSegments;
  until False;
end.
