{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 by Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit I2C;

Interface

Var Ack: Boolean;
    SDA: Boolean Absolute Forward;
    SCL: Boolean Absolute Forward;

Procedure Start_I2C;
Procedure Stop_I2C;
Procedure Send_I2C_Byte (Data2Send: Byte);
Function  Receive_I2C_Byte: Byte;
Procedure Send_I2C_Ack;
Procedure Send_I2C_ClockPulse;
Function  I2C_AddressPresent (IIC_Adr: Byte): Boolean;

Implementation

Var BitCounter: Byte;

Procedure Start_I2C; Assembler;
Asm
  SETB     SCL
  NOP
  NOP
  CLR      SDA
  NOP
  NOP
  CLR      SCL
end;

Procedure Stop_I2C; Assembler;
Asm
  CLR      SDA
  NOP
  NOP
  SETB     SCL
  NOP
  NOP
  SETB     SDA
end;

Procedure Send_I2C_Byte (Data2Send: Byte);
begin
  For BitCounter := 1 to 8 do
    begin
      SDA := (Data2Send and $80) <> 0;
      Asm
        NOP
        NOP
        SETB     SCL
        NOP
        NOP
        CLR      SCL
      end;
      Data2Send := Data2Send shl 1;
    end;
  Asm
    NOP
    SETB     SDA
    NOP
    NOP
    SETB     SCL
    NOP
    NOP
    MOV      C, SDA
    CPL      C
    MOV      Ack, C
    CLR      SCL
  end;
end;

Function Receive_I2C_Byte: Byte; Assembler;
Asm
  MOV      Receive_I2C_Byte_Result, #0
  MOV      BitCounter, #0
@1:
  INC      BitCounter
  SETB     SCL
  NOP
  NOP
  MOV      A, Receive_I2C_Byte_Result
  MOV      C, SDA
  RLC      A
  MOV      Receive_I2C_Byte_Result, A
  CLR      SCL
  MOV      A, BitCounter
  CJNE     A, #8, @1
  MOV      A, Receive_I2C_Byte_Result
end;

Procedure Send_I2C_Ack; Assembler;
Asm
  CLR      SDA
  NOP
  SETB     SCL
  NOP
  CLR      SCL
  NOP
  SETB     SDA
end;

Procedure Send_I2C_ClockPulse; Assembler;
Asm
  SETB     SCL
  NOP
  CLR      SCL
end;

Procedure Delay; Assembler;
Asm
  MUL  AB
  MUL  AB
  MUL  AB
  MUL  AB
  MUL  AB
  MUL  AB
  MUL  AB
  MUL  AB
  MUL  AB
  MUL  AB
end;

Function  I2C_AddressPresent (IIC_Adr: Byte): Boolean;
begin
  Start_I2C;
  Send_I2C_Byte (IIC_Adr);
  Stop_I2C;
  Delay;
  I2C_AddressPresent := Ack;
end;

begin
end.
