; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_DATA         SEGMENT  DATA
_BIT          SEGMENT  BIT

              PUBLIC   Ack
              PUBLIC   Data2Send
              PUBLIC   IIC_Adr
              PUBLIC   BitCounter

              PUBLIC   Start_I2C
              PUBLIC   Stop_I2C
              PUBLIC   Send_I2C_Byte
              PUBLIC   Receive_I2C_Byte
              PUBLIC   Send_I2C_Ack
              PUBLIC   Send_I2C_ClockPulse
              PUBLIC   Delay
              PUBLIC   I2C_AddressPresent
              PUBLIC   I2C

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 by Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit I2C;
; 
; Interface
; 
; Var Ack: Boolean;

RSEG _BIT

Ack:                            DBIT     1

;     SDA: Boolean Absolute Forward;
              EXTRN    BIT   (SDA)

;     SCL: Boolean Absolute Forward;
              EXTRN    BIT   (SCL)

; 
; Procedure Start_I2C;
; Procedure Stop_I2C;
; Procedure Send_I2C_Byte (Data2Send: Byte);

RSEG _DATA

Data2Send:                      DS       1

; Function  Receive_I2C_Byte: Byte;
Receive_I2C_Byte_Result:        DS       1

; Procedure Send_I2C_Ack;
; Procedure Send_I2C_ClockPulse;
; Function  I2C_AddressPresent (IIC_Adr: Byte): Boolean;

RSEG _BIT

I2C_AddressPresent_Result:      DBIT     1

RSEG _DATA

IIC_Adr:                        DS       1

; 
; Implementation
; 
; Var BitCounter: Byte;
BitCounter:                     DS       1

; 
; Procedure Start_I2C; Assembler;

USING 0

Start_I2C:
; Asm
;   SETB     SCL
              SETB      SCL

;   NOP
              NOP

;   NOP
              NOP

;   CLR      SDA
              CLR       SDA

;   NOP
              NOP

;   NOP
              NOP

;   CLR      SCL
              CLR       SCL

; end;
              RET

; 
; Procedure Stop_I2C; Assembler;

Stop_I2C:
; Asm
;   CLR      SDA
              CLR       SDA

;   NOP
              NOP

;   NOP
              NOP

;   SETB     SCL
              SETB      SCL

;   NOP
              NOP

;   NOP
              NOP

;   SETB     SDA
              SETB      SDA

; end;
              RET

; 
; Procedure Send_I2C_Byte (Data2Send: Byte);

Send_I2C_Byte:
; begin
;   For BitCounter := 1 to 8 do
              MOV       BitCounter, #0
              MOV       R2, Data2Send
L_001B:
              INC       BitCounter

;     begin
;       SDA := (Data2Send and $80) <> 0;
              MOV       A, R2
              RLC       A
              MOV       SDA, C

;       Asm
;         NOP
              NOP

;         NOP
              NOP

;         SETB     SCL
              SETB      SCL

;         NOP
              NOP

;         NOP
              NOP

;         CLR      SCL
              CLR       SCL

;       end;
;       Data2Send := Data2Send shl 1;
              MOV       A, R2
              ADD       A, ACC
              MOV       R2, A

;     end;
              MOV       A, BitCounter
              CJNE      A, #8, L_001B

;   Asm
;     NOP
              NOP

;     SETB     SDA
              SETB      SDA

;     NOP
              NOP

;     NOP
              NOP

;     SETB     SCL
              SETB      SCL

;     NOP
              NOP

;     NOP
              NOP

;     MOV      C, SDA
              MOV       C, SDA

;     CPL      C
              CPL       C

;     MOV      Ack, C
              MOV       Ack, C

;     CLR      SCL
              CLR       SCL

;   end;
; end;
              RET

; 
; Function Receive_I2C_Byte: Byte; Assembler;

Receive_I2C_Byte:
; Asm
;   MOV      Receive_I2C_Byte_Result, #0
              MOV       Receive_I2C_Byte_Result, #0

;   MOV      BitCounter, #0
              MOV       BitCounter, #0

; @1:
L_0049:
;   INC      BitCounter
              INC       BitCounter

;   SETB     SCL
              SETB      SCL

;   NOP
              NOP

;   NOP
              NOP

;   MOV      A, Receive_I2C_Byte_Result
              MOV       A, Receive_I2C_Byte_Result

;   MOV      C, SDA
              MOV       C, SDA

;   RLC      A
              RLC       A

;   MOV      Receive_I2C_Byte_Result, A
              MOV       Receive_I2C_Byte_Result, A

;   CLR      SCL
              CLR       SCL

;   MOV      A, BitCounter
              MOV       A, BitCounter

;   CJNE     A, #8, @1
              CJNE      A, #8, L_0049

;   MOV      A, Receive_I2C_Byte_Result
              MOV       A, Receive_I2C_Byte_Result

; end;
              RET

; 
; Procedure Send_I2C_Ack; Assembler;

Send_I2C_Ack:
; Asm
;   CLR      SDA
              CLR       SDA

;   NOP
              NOP

;   SETB     SCL
              SETB      SCL

;   NOP
              NOP

;   CLR      SCL
              CLR       SCL

;   NOP
              NOP

;   SETB     SDA
              SETB      SDA

; end;
              RET

; 
; Procedure Send_I2C_ClockPulse; Assembler;

Send_I2C_ClockPulse:
; Asm
;   SETB     SCL
              SETB      SCL

;   NOP
              NOP

;   CLR      SCL
              CLR       SCL

; end;
              RET

; 
; Procedure Delay; Assembler;

Delay:
; Asm
;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

;   MUL  AB
              MUL       AB

; end;
              RET

; 
; Function  I2C_AddressPresent (IIC_Adr: Byte): Boolean;

I2C_AddressPresent:
; begin
;   Start_I2C;
              LCALL     Start_I2C

;   Send_I2C_Byte (IIC_Adr);
              MOV       Data2Send, IIC_Adr
              LCALL     Send_I2C_Byte

;   Stop_I2C;
              LCALL     Stop_I2C

;   Delay;
              LCALL     Delay

;   I2C_AddressPresent := Ack;
              MOV       C, Ack

; end;
              RET


I2C:
; 
; begin
; end.
              RET

RSEG _CONST


              END

