; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_DATA         SEGMENT  DATA
_BIT          SEGMENT  BIT

              PUBLIC   RTC
              PUBLIC   Adr
              PUBLIC   DataW
              PUBLIC   Adr1
              PUBLIC   BCD

              PUBLIC   WriteByteToRTC
              PUBLIC   ReadByteFromRTC
              PUBLIC   InitRTC
              PUBLIC   ReadRTC
              PUBLIC   CheckRTC
              PUBLIC   PCF8583

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 by Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit PCF8583;
; 
; Interface
; 
; Const I2C_PCF8583 = $A0;

RSEG _CONST

; 
; Var RTC: Array [0..7] of Byte;

RSEG _DATA

RTC:                            DS       8

; 
; Procedure ReadRTC;
; Procedure WriteByteToRTC (Adr, DataW: Byte);
Adr:                            DS       1
DataW:                          DS       1

; Function  ReadByteFromRTC (Adr1: Byte): Byte;
ReadByteFromRTC_Result:         DS       1
Adr1:                           DS       1

; Procedure InitRTC;
; Procedure CheckRTC;
; 
; Implementation
; 
; Uses I2C;
              EXTRN    DATA  (Data2Send)
              EXTRN    BIT   (Ack)

              EXTRN    CODE  (Start_I2C)
              EXTRN    CODE  (Send_I2C_Byte)
              EXTRN    CODE  (Stop_I2C)
              EXTRN    CODE  (Receive_I2C_Byte)
              EXTRN    CODE  (Send_I2C_ClockPulse)
              EXTRN    CODE  (Send_I2C_Ack)

; 
; Procedure WriteByteToRTC (Adr, DataW: Byte);

USING 0

WriteByteToRTC:
; begin
;   Start_I2C;
              LCALL     Start_I2C

;   Send_I2C_Byte (I2C_PCF8583);
              MOV       Data2Send, #$A0
              LCALL     Send_I2C_Byte

;   Send_I2C_Byte (Adr);
              MOV       Data2Send, Adr
              LCALL     Send_I2C_Byte

;   Send_I2C_Byte (DataW);
              MOV       Data2Send, DataW
              LCALL     Send_I2C_Byte

;   Stop_I2C;
              LJMP      Stop_I2C

; end;
; 
; Function ReadByteFromRTC (Adr1: Byte): Byte;

ReadByteFromRTC:
; begin
;   Start_I2C;
              LCALL     Start_I2C

;   Send_I2C_Byte (I2C_PCF8583);
              MOV       Data2Send, #$A0
              LCALL     Send_I2C_Byte

;   Send_I2C_Byte (Adr1);
              MOV       Data2Send, Adr1
              LCALL     Send_I2C_Byte

;   Start_I2C;
              LCALL     Start_I2C

;   Send_I2C_Byte (I2C_PCF8583 or $01);
              MOV       Data2Send, #$A1
              LCALL     Send_I2C_Byte

;   ReadByteFromRTC := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       ReadByteFromRTC_Result, A

;   Send_I2C_ClockPulse;
              LCALL     Send_I2C_ClockPulse

;   Stop_I2C;
              LCALL     Stop_I2C

; end;
              MOV       A, ReadByteFromRTC_Result
              RET

; 
; Procedure InitRTC;

InitRTC:
; begin
;   WriteByteToRTC (0, $80);      { stop counting  }
              MOV       Adr, #0
              MOV       DataW, #$80
              LCALL     WriteByteToRTC

;   WriteByteToRTC (1, 0);        { 1/100 second   }
              MOV       Adr, #1
              MOV       DataW, #0
              LCALL     WriteByteToRTC

;   WriteByteToRTC (2, 0);        { second         }
              MOV       Adr, #2
              MOV       DataW, #0
              LCALL     WriteByteToRTC

;   WriteByteToRTC (3, 0);        { minute         }
              MOV       Adr, #3
              MOV       DataW, #0
              LCALL     WriteByteToRTC

;   WriteByteToRTC (4, 0);        { hour           }
              MOV       Adr, #4
              MOV       DataW, #0
              LCALL     WriteByteToRTC

;   WriteByteToRTC (5, 1);        { year / day     }
              MOV       Adr, #5
              MOV       DataW, #1
              LCALL     WriteByteToRTC

;   WriteByteToRTC (6, 1);        { month          }
              MOV       Adr, #6
              MOV       DataW, #1
              LCALL     WriteByteToRTC

;   WriteByteToRTC (7, 0);        { timer          }
              MOV       Adr, #7
              MOV       DataW, #0
              LCALL     WriteByteToRTC

;   WriteByteToRTC (8, 39);       { year - 1960    }
              MOV       Adr, #8
              MOV       DataW, #$27
              LCALL     WriteByteToRTC

;   WriteByteToRTC (0, 0);        { start counting }
              MOV       Adr, #0
              MOV       DataW, #0
              LJMP      WriteByteToRTC

; end;
; 
; Procedure ReadRTC;
; Var TempY, Diff: Byte;
TempY:                          DS       1
Diff:                           DS       1

ReadRTC:
; begin
;   Start_I2C;
              LCALL     Start_I2C

;   Send_I2C_Byte (I2C_PCF8583);
              MOV       Data2Send, #$A0
              LCALL     Send_I2C_Byte

;   If not Ack then
              JB        Ack, L_00A7

;     begin
;       Stop_I2C;
              LJMP      Stop_I2C

;       Exit;
;     end;
L_00A7:
;   Send_I2C_Byte ($01);
              MOV       Data2Send, #1
              LCALL     Send_I2C_Byte

;   If not Ack then
              JB        Ack, L_00B3

;     begin
;       Stop_I2C;
              LJMP      Stop_I2C

;       Exit;
;     end;
L_00B3:
;   Start_I2C;
              LCALL     Start_I2C

;   Send_I2C_Byte (I2C_PCF8583 or $01);
              MOV       Data2Send, #$A1
              LCALL     Send_I2C_Byte

;   RTC [0] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC, A

;   Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   RTC [1] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC+1, A

;   Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   RTC [2] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC+2, A

;   Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   RTC [3] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC+3, A

;   Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   RTC [4] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC+4, A

;   Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   RTC [5] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC+5, A

;   Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   RTC [6] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC+6, A

;   Send_I2C_Ack;
              LCALL     Send_I2C_Ack

;   RTC [7] := Receive_I2C_Byte;
              LCALL     Receive_I2C_Byte
              MOV       RTC+7, A

;   Send_I2C_ClockPulse;
              LCALL     Send_I2C_ClockPulse

;   Stop_I2C;
              LCALL     Stop_I2C

;   TempY := (RTC [4] shr 6) and $03;
              MOV       A, RTC+4
              SWAP      A
              RRC       A
              RRC       A
              ANL       A, #3
              MOV       R2, A

;   If (TempY <> RTC [7]) and (RTC [7] < $80) then
              XRL       A, RTC+7
              JZ        L_0129
              MOV       A, RTC+7
              ADD       A, #-128
              JC        L_0129

;     begin
;       Diff := (TempY - RTC [7]) and $03;
              MOV       A, R2
              CLR       C
              SUBB      A, RTC+7
              ANL       A, #3
              MOV       R3, A

;       If Diff < 2 then
              ADD       A, #-2
              JC        L_0129

;         begin
;           RTC [7] := RTC [7] + Diff;
              MOV       A, RTC+7
              ADD       A, R3
              MOV       RTC+7, A

;           WriteByteToRTC (8, RTC [7]);
              MOV       Adr, #8
              MOV       DataW, A
              LCALL     WriteByteToRTC

;         end;
;     end;
L_0129:
;   RTC [3] := RTC [3] and $3F;
              ANL       RTC+3, #$3F

; end;
              RET

; 
; Procedure CheckRTC;
; 
;   Function BCDtoDecimal (BCD: Byte): Byte;
BCDtoDecimal_Result:            DS       1
BCD:                            DS       1

BCDtoDecimal:
;   begin
;     BCDtoDecimal := $FF;
              MOV       R3, #$FF
              MOV       R2, BCD

;     If BCD shr 4 > 9 then Exit;
              MOV       A, R2
              SWAP      A
              ANL       A, #$0F
              ADD       A, #-10
              JC        L_014E

;     If BCD and $0F > 9 then Exit;
              MOV       A, R2
              ANL       A, #$0F
              ADD       A, #-10
              JC        L_014E

;     BCDtoDecimal := 10 * (BCD shr 4) + BCD and $0F;
              MOV       A, R2
              ANL       A, #$0F
              MOV       R1, A
              MOV       A, R2
              SWAP      A
              ANL       A, #$0F
              MOV       B, #$0A
              MUL       AB
              ADD       A, R1
              MOV       R3, A

;   end;
L_014E:
              MOV       A, R3
              RET

; 
;   Function CheckRTCData: Boolean;

RSEG _BIT

CheckRTCData_Result:            DBIT     1

;   Var Temp: Byte;

RSEG _DATA

Temp:                           DS       1

CheckRTCData:
;   begin
;     CheckRTCData := False;
              CLR       CheckRTCData_Result

;     If BCDtoDecimal (RTC [0]) = $FF then Exit;
              MOV       BCD, RTC
              LCALL     BCDtoDecimal
              CPL       A
              JZ        L_01A6

;     If BCDtoDecimal (RTC [1]) > $59 then Exit;
              MOV       BCD, RTC+1
              LCALL     BCDtoDecimal
              ADD       A, #-90
              JC        L_01A6

;     If BCDtoDecimal (RTC [2]) > $59 then Exit;
              MOV       BCD, RTC+2
              LCALL     BCDtoDecimal
              ADD       A, #-90
              JC        L_01A6

;     If BCDtoDecimal (RTC [3]) > $23 then Exit;
              MOV       BCD, RTC+3
              LCALL     BCDtoDecimal
              ADD       A, #-36
              JC        L_01A6

;     If BCDtoDecimal (RTC [4] and $3F) > $31 then Exit;
              MOV       A, RTC+4
              ANL       A, #$3F
              MOV       BCD, A
              LCALL     BCDtoDecimal
              ADD       A, #-50
              JC        L_01A6

;     If RTC [5] and $E0 = $E0 then Exit;
              MOV       A, RTC+5
              ANL       A, #$E0
              XRL       A, #$E0
              JZ        L_01A6

;     If BCDtoDecimal (RTC [5] and $1F) > $12 then Exit;
              MOV       A, RTC+5
              ANL       A, #$1F
              MOV       BCD, A
              LCALL     BCDtoDecimal
              ADD       A, #-19
              JC        L_01A6

;     If BCDtoDecimal (RTC [6]) = $FF then Exit;
              MOV       BCD, RTC+6
              LCALL     BCDtoDecimal
              CPL       A
              JZ        L_01A6

;     CheckRTCData := True;
              SETB      CheckRTCData_Result

;   end;
L_01A6:
              MOV       C, CheckRTCData_Result
              RET

CheckRTC:
; 
; begin
;   ReadRTC;
              LCALL     ReadRTC

;   If not CheckRTCData then InitRTC;
              LCALL     CheckRTCData
              JC        L_01B4
              LCALL     InitRTC
L_01B4:

;   ReadRTC;
              LJMP      ReadRTC

; end;


PCF8583:
; 
; begin
; end.
              RET

RSEG _CONST


              END

