{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 by Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit PCF8583;

Interface

Const I2C_PCF8583 = $A0;

Var RTC: Array [0..7] of Byte;

Procedure ReadRTC;
Procedure WriteByteToRTC (Adr, DataW: Byte);
Function  ReadByteFromRTC (Adr1: Byte): Byte;
Procedure InitRTC;
Procedure CheckRTC;

Implementation

Uses I2C;

Procedure WriteByteToRTC (Adr, DataW: Byte);
begin
  Start_I2C;
  Send_I2C_Byte (I2C_PCF8583);
  Send_I2C_Byte (Adr);
  Send_I2C_Byte (DataW);
  Stop_I2C;
end;

Function ReadByteFromRTC (Adr1: Byte): Byte;
begin
  Start_I2C;
  Send_I2C_Byte (I2C_PCF8583);
  Send_I2C_Byte (Adr1);
  Start_I2C;
  Send_I2C_Byte (I2C_PCF8583 or $01);
  ReadByteFromRTC := Receive_I2C_Byte;
  Send_I2C_ClockPulse;
  Stop_I2C;
end;

Procedure InitRTC;
begin
  WriteByteToRTC (0, $80);      { stop counting  }
  WriteByteToRTC (1, 0);        { 1/100 second   }
  WriteByteToRTC (2, 0);        { second         }
  WriteByteToRTC (3, 0);        { minute         }
  WriteByteToRTC (4, 0);        { hour           }
  WriteByteToRTC (5, 1);        { year / day     }
  WriteByteToRTC (6, 1);        { month          }
  WriteByteToRTC (7, 0);        { timer          }
  WriteByteToRTC (8, 39);       { year - 1960    }
  WriteByteToRTC (0, 0);        { start counting }
end;

Procedure ReadRTC;
Var TempY, Diff: Byte;
begin
  Start_I2C;
  Send_I2C_Byte (I2C_PCF8583);
  If not Ack then
    begin
      Stop_I2C;
      Exit;
    end;
  Send_I2C_Byte ($01);
  If not Ack then
    begin
      Stop_I2C;
      Exit;
    end;
  Start_I2C;
  Send_I2C_Byte (I2C_PCF8583 or $01);
  RTC [0] := Receive_I2C_Byte;
  Send_I2C_Ack;
  RTC [1] := Receive_I2C_Byte;
  Send_I2C_Ack;
  RTC [2] := Receive_I2C_Byte;
  Send_I2C_Ack;
  RTC [3] := Receive_I2C_Byte;
  Send_I2C_Ack;
  RTC [4] := Receive_I2C_Byte;
  Send_I2C_Ack;
  RTC [5] := Receive_I2C_Byte;
  Send_I2C_Ack;
  RTC [6] := Receive_I2C_Byte;
  Send_I2C_Ack;
  RTC [7] := Receive_I2C_Byte;
  Send_I2C_ClockPulse;
  Stop_I2C;
  TempY := (RTC [4] shr 6) and $03;
  If (TempY <> RTC [7]) and (RTC [7] < $80) then
    begin
      Diff := (TempY - RTC [7]) and $03;
      If Diff < 2 then
        begin
          RTC [7] := RTC [7] + Diff;
          WriteByteToRTC (8, RTC [7]);
        end;
    end;
  RTC [3] := RTC [3] and $3F;
end;

Procedure CheckRTC;

  Function BCDtoDecimal (BCD: Byte): Byte;
  begin
    BCDtoDecimal := $FF;
    If BCD shr 4 > 9 then Exit;
    If BCD and $0F > 9 then Exit;
    BCDtoDecimal := 10 * (BCD shr 4) + BCD and $0F;
  end;

  Function CheckRTCData: Boolean;
  Var Temp: Byte;
  begin
    CheckRTCData := False;
    If BCDtoDecimal (RTC [0]) = $FF then Exit;
    If BCDtoDecimal (RTC [1]) > $59 then Exit;
    If BCDtoDecimal (RTC [2]) > $59 then Exit;
    If BCDtoDecimal (RTC [3]) > $23 then Exit;
    If BCDtoDecimal (RTC [4] and $3F) > $31 then Exit;
    If RTC [5] and $E0 = $E0 then Exit;
    If BCDtoDecimal (RTC [5] and $1F) > $12 then Exit;
    If BCDtoDecimal (RTC [6]) = $FF then Exit;
    CheckRTCData := True;
  end;

begin
  ReadRTC;
  If not CheckRTCData then InitRTC;
  ReadRTC;
end;

begin
end.
