; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0, 2)

_CODE         SEGMENT  CODE
_DATA         SEGMENT  DATA
_BIT          SEGMENT  BIT

              EXTRN    IDATA (StackStart)

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Program Example6;
; 
; Const Const1ms = - 11059200 div 12 div 1000;

RSEG _CONST

; 
;       BaudRateTimerValue = Byte (- 11059200 div 12 div 32 div 9600);
; 
;       BlockStart = $A5;
; 
;       TokenSampleTime =  20;
;       NoTokenTime     = 400;
;       TokenLedTime    = 100;
; 
;       DestinationAddress = 1;
;       Command            = 2;
;       Parameter1         = 3;
;       Parameter2         = 4;
;       SourceAddress      = 5;
;       Checksum           = 6;
; 
;       BlockLength        = Checksum + 1;
; 
;       Cmd_Leds           = $01;
;       Cmd_Keys           = $02;
; 
; Var   Key_Up: Boolean absolute P0.0;
Key_Up                          BIT      P0.0

;       Key_Down: Boolean absolute P0.1;
Key_Down                        BIT      P0.1

;       Key_Left: Boolean absolute P0.2;
Key_Left                        BIT      P0.2

;       Key_Right: Boolean absolute P0.3;
Key_Right                       BIT      P0.3

;       Key_Escape: Boolean absolute P0.4;
Key_Escape                      BIT      P0.4

;       Key_Enter: Boolean absolute P0.5;
Key_Enter                       BIT      P0.5

;       Key_VolumeUp: Boolean absolute P0.6;
Key_VolumeUp                    BIT      P0.6

;       Key_VolumeDown: Boolean absolute P0.7;
Key_VolumeDown                  BIT      P0.7

; 
;       Led_Up: Boolean absolute P2.7;
Led_Up                          BIT      P2.7

;       Led_Down: Boolean absolute P2.6;
Led_Down                        BIT      P2.6

;       Led_Left: Boolean absolute P2.5;
Led_Left                        BIT      P2.5

;       Led_Rigt: Boolean absolute P2.4;
Led_Rigt                        BIT      P2.4

;       Led_Enter: Boolean absolute P2.3;
Led_Enter                       BIT      P2.3

;       Led_Escape: Boolean absolute P2.2;
Led_Escape                      BIT      P2.2

;       TokenCounter: Boolean absolute P2.1;
TokenCounter                    BIT      P2.1

;       Led_Token: Boolean absolute P2.0;
Led_Token                       BIT      P2.0

; 
;       Key_Stop: Boolean absolute P1.0;
Key_Stop                        BIT      P1.0

;       Key_Token: Boolean absolute P1.1;
Key_Token                       BIT      P1.1

;       Key_Set: Boolean absolute P1.2;
Key_Set                         BIT      P1.2

;       Out_Radio: Boolean absolute P1.3;
Out_Radio                       BIT      P1.3

; 
; 
;       RX_Buffer: Array [0..Checksum] of Byte;

RSEG _DATA

RX_Buffer:                      DS       7

;       RX_Counter, RX_Checksum: Byte;
RX_Counter:                     DS       1
RX_Checksum:                    DS       1

;       BlockReceived: Boolean;

RSEG _BIT

BlockReceived:                  DBIT     1

;       Leds: Byte;

RSEG _DATA

Leds:                           DS       1

;       TX_Buffer: Array [0..Checksum] of Byte;         { 0 BlockStart }
TX_Buffer:                      DS       7

;                                                       { 1 dest. address = camera }
;                                                      	{ 2 command }
;                                                      	{ 3 Parameter1 }
;                                                      	{ 4 Parameter2 }
;                                                      	{ 5 source address }
;                                                      	{ 6 checksum }
;       TX_Counter: Byte;
TX_Counter:                     DS       1

;       Sending: Boolean;

RSEG _BIT

Sending:                        DBIT     1

;       N: Byte;
; 
;       BlinkTimer: Word;

RSEG _DATA

BlinkTimer:                     DS       2

;       DelayTimer: Word;
DelayTimer:                     DS       2

;       NoTokenTimer: Word;
NoTokenTimer:                   DS       2

;       Token: Byte;
Token:                          DS       1

;       TokenLeds: Byte;
TokenLeds:                      DS       1

;       TokenLedTimer: Word;
TokenLedTimer:                  DS       2

;       TokenRead: Boolean;

RSEG _BIT

TokenRead:                      DBIT     1

;       TokenOk: Boolean;
TokenOk:                        DBIT     1

; 
; Procedure Timer_1_ms; Interrupt Timer0; { 1 ms interrupt }
; Var M: Byte DATA;


CSEG AT $000B

              SJMP     Timer_1_ms

RSEG _CODE

USING 0

Timer_1_ms:
; begin
              PUSH      PSW
              MOV       PSW, #0
              PUSH      ACC

;   TL0 :=  Lo (Const1ms);
              MOV       TL0, #$67

;   TH0 :=  Hi (Const1ms);
              MOV       TH0, #$FC

; 
;   Inc (BlinkTimer);
              INC       BlinkTimer
              MOV       A, BlinkTimer
              JNZ       L_008D
              INC       BlinkTimer+1
L_008D:

; 
;   If DelayTimer <> 0 then Dec (DelayTimer);
              MOV       A, DelayTimer+1
              ORL       A, DelayTimer
              JZ        L_009C
              DEC       DelayTimer
              MOV       A, DelayTimer
              CJNE      A, #-1, L_009C
              DEC       DelayTimer+1
L_009C:

;   If NoTokenTimer <> 0 then Dec (NoTokenTimer);
              MOV       A, NoTokenTimer+1
              ORL       A, NoTokenTimer
              JZ        L_00AB
              DEC       NoTokenTimer
              MOV       A, NoTokenTimer
              CJNE      A, #-1, L_00AB
              DEC       NoTokenTimer+1
L_00AB:

;   If TokenLedTimer <> 0 then Dec (TokenLedTimer);
              MOV       A, TokenLedTimer+1
              ORL       A, TokenLedTimer
              JZ        L_00BA
              DEC       TokenLedTimer
              MOV       A, TokenLedTimer
              CJNE      A, #-1, L_00BA
              DEC       TokenLedTimer+1
L_00BA:

; end;
              POP       ACC
              POP       PSW
              RETI

; 
; Procedure RS232; Interrupt Serial; Using 2;   { RS232 }
; Var Ch: Byte;


CSEG AT $0023

USING 2

RS232:
; begin
              PUSH      PSW
              MOV       PSW, #$10
              PUSH      ACC

;   If TI then
              JNB       SCON.1, L_0042

;     begin
;       TI := False;
              CLR       SCON.1

;       If TX_Counter < BlockLength then
              MOV       A, TX_Counter
              ADD       A, #-7
              JC        L_0040

;         begin
;           SBUF := TX_Buffer [TX_Counter];
              MOV       A, TX_Counter
              ADD       A, #TX_Buffer
              MOV       R0, A
              MOV       SBUF, @R0

;           Inc (TX_Counter);
              INC       TX_Counter

;         end else Sending := False;
              SJMP      L_0042
L_0040:
              CLR       Sending

;     end;
L_0042:
;   If RI then
              JNB       SCON.0, L_0073

;     begin
;       RI := False;
              CLR       SCON.0

; 
;       If Sending or BlockReceived then Exit;
              JB        Sending, L_004D
              JNB       BlockReceived, L_004F
L_004D:
              SJMP      L_0073
L_004F:

;       Ch := SBUF;
              MOV       R2, SBUF

;       If (RX_Counter = 0) and (Ch <> BlockStart) then Exit;
              MOV       A, RX_Counter
              JNZ       L_0058
              CJNE      R2, #$A5, L_0073
L_0058:

;       RX_Buffer [RX_Counter] := Ch;
              ADD       A, #RX_Buffer
              MOV       R0, A
              MOV       @R0, AR2

;       Inc (RX_Counter);
              INC       RX_Counter

;       RX_Checksum := RX_Checksum xor Ch;
              MOV       A, R2
              XRL       RX_Checksum, A

;       If RX_Counter = BlockLength then
              MOV       A, RX_Counter
              CJNE      A, #7, L_0073

;         begin
;           If RX_Checksum = 0 then BlockReceived := True;
              MOV       A, RX_Checksum
              JNZ       L_006D
              SETB      BlockReceived
L_006D:

;           RX_Counter := 0;
              MOV       RX_Counter, #0

;           RX_Checksum := 0;
              MOV       RX_Checksum, #0

;         end;
;     end;
; end;
L_0073:
              POP       ACC
              POP       PSW
              RETI

; 
; Procedure Delay (Dl: Word);
; begin
;   DelayTimer := Dl;
;   Repeat
;   until DelayTimer = 0;
; end;
; 
; Procedure SendBlock;

USING 0

SendBlock:
; begin
;   Repeat until not Sending;
L_00BF:
              JB        Sending, L_00BF

;   TX_Buffer [Checksum] := BlockStart xor TX_Buffer [1] xor TX_Buffer [2] xor
;                             TX_Buffer [3] xor TX_Buffer [4] xor TX_Buffer [5];
              MOV       A, TX_Buffer+1
              XRL       A, #$A5
              XRL       A, TX_Buffer+2
              XRL       A, TX_Buffer+3
              XRL       A, TX_Buffer+4
              XRL       A, TX_Buffer+5
              MOV       TX_Buffer+6, A

;   TX_Counter := 0;
              MOV       TX_Counter, #0

;   Sending := True;
              SETB      Sending

;   TI := True;
              SETB      SCON.1

; end;
              RET

; 
; 
; Procedure Init;

Init:
; begin
;   P0 := $FF;
              MOV       P0, #$FF

;   P1 := $FF;
              MOV       P1, #$FF

;   P2 := $FF;
              MOV       P2, #$FF

; 
;   TX_Buffer [0] := BlockStart;
              MOV       TX_Buffer, #$A5

; 
;   RX_Counter := 0;
              MOV       RX_Counter, #0

;   RX_Checksum := 0;
              MOV       RX_Checksum, #0

;   BlockReceived := False;
              CLR       BlockReceived

;   TX_Counter := 0;
              MOV       TX_Counter, #0

;   Sending := False;
              CLR       Sending

; 
;   DelayTimer := 0;
              CLR       A
              MOV       DelayTimer, A
              MOV       DelayTimer+1, A

;   NoTokenTimer := 0;
              MOV       NoTokenTimer, A
              MOV       NoTokenTimer+1, A

;   TokenLedTimer := 0;
              MOV       TokenLedTimer, A
              MOV       TokenLedTimer+1, A

;   TokenRead := False;
              CLR       TokenRead

;   TokenOk := True;
              SETB      TokenOk

; 
;   TL0 :=  Lo (Const1ms);
              MOV       TL0, #$67

;   TH0 :=  Hi (Const1ms);
              MOV       TH0, #$FC

;   TL1 := BaudRateTimerValue;
              MOV       TL1, #$FD

;   TH1 := BaudRateTimerValue;
              MOV       TH1, #$FD

;   PCON := $00;       { no IDLE, no POWER DOWN }
              MOV       PCON, A

;   SCON := %01010000; { Serial Mode 1, Enable Reception }
              MOV       SCON, #$50

;   TMOD := %00100001; { Timer1: no GATE, Timer,  8 bit timer, autoreload }
              MOV       TMOD, #$21

;                      { Timer0: no GATE, Timer, 16 bit timer }
;   TCON := %01010101; { Timer 1 run, Timer 0 run }
              MOV       TCON, #$55

;                      { Int1 falling edge, Int0 falling edge }
;   IE := %10010010;   { Serial, Timer0}
              MOV       IE, #$92

; end;
              RET

; 
; Procedure ProcessCommands;

ProcessCommands:
; begin
;   If not BlockReceived then Exit;
              JNB       BlockReceived, L_0149

;   BlockReceived := False;
              CLR       BlockReceived

;   Case RX_Buffer [Command] of
;     Cmd_Leds: begin
              MOV       A, RX_Buffer+2
              CJNE      A, #1, L_0149

;                 Leds := RX_Buffer[Parameter1];
              MOV       Leds, RX_Buffer+3

;                 Out_Radio := (RX_Buffer[Parameter2] and $01) <> 0;
              MOV       A, RX_Buffer+4
              RRC       A
              MOV       P1.3, C

;                 TX_Buffer [Parameter1] := P0;
              MOV       TX_Buffer+3, P0

;                 TX_Buffer [Parameter2] := P1 and %11111101 or %00000010;
              MOV       A, P1
              ANL       A, #$FD
              ORL       A, #2
              MOV       TX_Buffer+4, A

;                 If not TokenRead then
              JB        TokenRead, L_0141

;                   TX_Buffer [Parameter2] := TX_Buffer [Parameter2] xor Token;
              XRL       A, Token
              MOV       TX_Buffer+4, A
L_0141:

;                 TokenRead := True;
              SETB      TokenRead

;                 TX_Buffer [Command] := Cmd_Keys;
              MOV       TX_Buffer+2, #2

;                 SendBlock;
              LCALL     SendBlock

;               end;
;   end;
; end;
L_0149:
              RET


CSEG AT $0000

              AJMP     Example6


RSEG _CODE

Example6:
; 
; begin
              MOV       SP, #StackStart-1

;   Init;
              LCALL     Init
              MOV       R2, #3
              MOV       R3, #0
              MOV       R4, #LOW  ($0064)
              MOV       R5, #HIGH ($0064)
              MOV       R6, #LOW  ($0190)
              MOV       R7, #HIGH ($0190)
              MOV       R0, #2

;   Repeat
L_015E:
;     If Key_Token = False then
              JB        P1.1, L_017A

;       begin
;         If (NoTokenTimer = 0) and TokenOk then
              MOV       A, NoTokenTimer+1
              ORL       A, NoTokenTimer
              JNZ       L_0178
              JNB       TokenOk, L_0178

;           begin
;             TokenLedTimer := TokenLedTime;
              MOV       TokenLedTimer, R4
              MOV       TokenLedTimer+1, R5

;             NoTokenTimer := NoTokenTime;
              MOV       NoTokenTimer, R6
              MOV       NoTokenTimer+1, R7

;             TokenRead := False;
              CLR       TokenRead

;             TokenOk := False;
              CLR       TokenOk

;             Token := $02;
              MOV       Token, R0

;           end;
L_0178:
;       end else TokenOk := True;
              SJMP      L_017C
L_017A:
              SETB      TokenOk
L_017C:

;     ProcessCommands;
              LCALL     ProcessCommands

;     TokenLeds := 0;
              MOV       TokenLeds, R3

;     If TokenLedTimer <> 0 then TokenLeds := $3;
              MOV       A, TokenLedTimer+1
              ORL       A, TokenLedTimer
              JZ        L_0189
              MOV       TokenLeds, R2
L_0189:

; 
;     If BlinkTimer and $3FF > $1FF then
              MOV       A, BlinkTimer+1
              ANL       A, #HIGH ($03FF)
              CLR       C
              ADDC      A, #HIGH (-512)
              JNC       L_0195

;       TokenLeds := TokenLeds or $01;
              ORL       TokenLeds, #1
L_0195:

; 
;     P2 := Leds and $FC or TokenLeds;
              MOV       A, Leds
              ANL       A, #$FC
              ORL       A, TokenLeds
              MOV       P2, A

;   until False;
              SJMP      L_015E

; end.

RSEG _CONST


              END

