{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Program Example6;

Const Const1ms = - 11059200 div 12 div 1000;

      BaudRateTimerValue = Byte (- 11059200 div 12 div 32 div 9600);

      BlockStart = $A5;

      TokenSampleTime =  20;
      NoTokenTime     = 400;
      TokenLedTime    = 100;

      DestinationAddress = 1;
      Command            = 2;
      Parameter1         = 3;
      Parameter2         = 4;
      SourceAddress      = 5;
      Checksum           = 6;

      BlockLength        = Checksum + 1;

      Cmd_Leds           = $01;
      Cmd_Keys           = $02;

Var   Key_Up: Boolean absolute P0.0;
      Key_Down: Boolean absolute P0.1;
      Key_Left: Boolean absolute P0.2;
      Key_Right: Boolean absolute P0.3;
      Key_Escape: Boolean absolute P0.4;
      Key_Enter: Boolean absolute P0.5;
      Key_VolumeUp: Boolean absolute P0.6;
      Key_VolumeDown: Boolean absolute P0.7;

      Led_Up: Boolean absolute P2.7;
      Led_Down: Boolean absolute P2.6;
      Led_Left: Boolean absolute P2.5;
      Led_Rigt: Boolean absolute P2.4;
      Led_Enter: Boolean absolute P2.3;
      Led_Escape: Boolean absolute P2.2;
      TokenCounter: Boolean absolute P2.1;
      Led_Token: Boolean absolute P2.0;

      Key_Stop: Boolean absolute P1.0;
      Key_Token: Boolean absolute P1.1;
      Key_Set: Boolean absolute P1.2;
      Out_Radio: Boolean absolute P1.3;


      RX_Buffer: Array [0..Checksum] of Byte;
      RX_Counter, RX_Checksum: Byte;
      BlockReceived: Boolean;
      Leds: Byte;
      TX_Buffer: Array [0..Checksum] of Byte;         { 0 BlockStart }
                                                      { 1 dest. address = camera }
                                                     	{ 2 command }
                                                     	{ 3 Parameter1 }
                                                     	{ 4 Parameter2 }
                                                     	{ 5 source address }
                                                     	{ 6 checksum }
      TX_Counter: Byte;
      Sending: Boolean;
      N: Byte;

      BlinkTimer: Word;
      DelayTimer: Word;
      NoTokenTimer: Word;
      Token: Byte;
      TokenLeds: Byte;
      TokenLedTimer: Word;
      TokenRead: Boolean;
      TokenOk: Boolean;

Procedure Timer_1_ms; Interrupt Timer0; { 1 ms interrupt }
Var M: Byte DATA;
begin
  TL0 :=  Lo (Const1ms);
  TH0 :=  Hi (Const1ms);

  Inc (BlinkTimer);

  If DelayTimer <> 0 then Dec (DelayTimer);
  If NoTokenTimer <> 0 then Dec (NoTokenTimer);
  If TokenLedTimer <> 0 then Dec (TokenLedTimer);
end;

Procedure RS232; Interrupt Serial; Using 2;   { RS232 }
Var Ch: Byte;
begin
  If TI then
    begin
      TI := False;
      If TX_Counter < BlockLength then
        begin
          SBUF := TX_Buffer [TX_Counter];
          Inc (TX_Counter);
        end else Sending := False;
    end;
  If RI then
    begin
      RI := False;

      If Sending or BlockReceived then Exit;
      Ch := SBUF;
      If (RX_Counter = 0) and (Ch <> BlockStart) then Exit;
      RX_Buffer [RX_Counter] := Ch;
      Inc (RX_Counter);
      RX_Checksum := RX_Checksum xor Ch;
      If RX_Counter = BlockLength then
        begin
          If RX_Checksum = 0 then BlockReceived := True;
          RX_Counter := 0;
          RX_Checksum := 0;
        end;
    end;
end;

Procedure Delay (Dl: Word);
begin
  DelayTimer := Dl;
  Repeat
  until DelayTimer = 0;
end;

Procedure SendBlock;
begin
  Repeat until not Sending;
  TX_Buffer [Checksum] := BlockStart xor TX_Buffer [1] xor TX_Buffer [2] xor
                            TX_Buffer [3] xor TX_Buffer [4] xor TX_Buffer [5];
  TX_Counter := 0;
  Sending := True;
  TI := True;
end;


Procedure Init;
begin
  P0 := $FF;
  P1 := $FF;
  P2 := $FF;

  TX_Buffer [0] := BlockStart;

  RX_Counter := 0;
  RX_Checksum := 0;
  BlockReceived := False;
  TX_Counter := 0;
  Sending := False;

  DelayTimer := 0;
  NoTokenTimer := 0;
  TokenLedTimer := 0;
  TokenRead := False;
  TokenOk := True;

  TL0 :=  Lo (Const1ms);
  TH0 :=  Hi (Const1ms);
  TL1 := BaudRateTimerValue;
  TH1 := BaudRateTimerValue;
  PCON := $00;       { no IDLE, no POWER DOWN }
  SCON := %01010000; { Serial Mode 1, Enable Reception }
  TMOD := %00100001; { Timer1: no GATE, Timer,  8 bit timer, autoreload }
                     { Timer0: no GATE, Timer, 16 bit timer }
  TCON := %01010101; { Timer 1 run, Timer 0 run }
                     { Int1 falling edge, Int0 falling edge }
  IE := %10010010;   { Serial, Timer0}
end;

Procedure ProcessCommands;
begin
  If not BlockReceived then Exit;
  BlockReceived := False;
  Case RX_Buffer [Command] of
    Cmd_Leds: begin
                Leds := RX_Buffer[Parameter1];
                Out_Radio := (RX_Buffer[Parameter2] and $01) <> 0;
                TX_Buffer [Parameter1] := P0;
                TX_Buffer [Parameter2] := P1 and %11111101 or %00000010;
                If not TokenRead then
                  TX_Buffer [Parameter2] := TX_Buffer [Parameter2] xor Token;
                TokenRead := True;
                TX_Buffer [Command] := Cmd_Keys;
                SendBlock;
              end;
  end;
end;

begin
  Init;
  Repeat
    If Key_Token = False then
      begin
        If (NoTokenTimer = 0) and TokenOk then
          begin
            TokenLedTimer := TokenLedTime;
            NoTokenTimer := NoTokenTime;
            TokenRead := False;
            TokenOk := False;
            Token := $02;
          end;
      end else TokenOk := True;
    ProcessCommands;
    TokenLeds := 0;
    If TokenLedTimer <> 0 then TokenLeds := $3;

    If BlinkTimer and $3FF > $1FF then
      TokenLeds := TokenLeds or $01;

    P2 := Leds and $FC or TokenLeds;
  until False;
end.
