; Turbo51 version 0.0.0.13, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_DATA         SEGMENT  DATA
_BIT          SEGMENT  BIT

              PUBLIC   P0
              PUBLIC   SP
              PUBLIC   DPL
              PUBLIC   DPH
              PUBLIC   P4
              PUBLIC   P5
              PUBLIC   P6
              PUBLIC   PCON
              PUBLIC   TCON
              PUBLIC   TMOD
              PUBLIC   TL0
              PUBLIC   TL1
              PUBLIC   TH0
              PUBLIC   TH1
              PUBLIC   CKCON
              PUBLIC   PSCTL
              PUBLIC   P1
              PUBLIC   TMR3CN
              PUBLIC   TMR3RLL
              PUBLIC   TMR3RLH
              PUBLIC   TMR3L
              PUBLIC   TMR3H
              PUBLIC   P7
              PUBLIC   SCON0
              PUBLIC   SBUF0
              PUBLIC   SPI0CFG
              PUBLIC   SPI0DAT
              PUBLIC   ADC1
              PUBLIC   SPI0CKR
              PUBLIC   CPT0CN
              PUBLIC   CPT1CN
              PUBLIC   P2
              PUBLIC   EMI0TC
              PUBLIC   EMI0CF
              PUBLIC   P0MDOUT
              PUBLIC   P1MDOUT
              PUBLIC   P2MDOUT
              PUBLIC   P3MDOUT
              PUBLIC   IE
              PUBLIC   SADDR0
              PUBLIC   ADC1CN
              PUBLIC   ADC1CF
              PUBLIC   AMX1SL
              PUBLIC   P3IF
              PUBLIC   SADEN1
              PUBLIC   EMI0CN
              PUBLIC   P3
              PUBLIC   OSCXCN
              PUBLIC   OSCICN
              PUBLIC   P74OUT
              PUBLIC   FLSCL
              PUBLIC   FLACL
              PUBLIC   IP
              PUBLIC   SADEN0
              PUBLIC   AMX0CF
              PUBLIC   AMX0SL
              PUBLIC   ADC0CF
              PUBLIC   P1MDIN
              PUBLIC   ADC0L
              PUBLIC   ADC0H
              PUBLIC   SMB0CN
              PUBLIC   SMB0STA
              PUBLIC   SMB0DAT
              PUBLIC   SMB0ADR
              PUBLIC   ADC0GTL
              PUBLIC   ADC0GTH
              PUBLIC   ADC0LTL
              PUBLIC   ADC0LTH
              PUBLIC   T2CON
              PUBLIC   T4CON
              PUBLIC   RCAP2L
              PUBLIC   RCAP2H
              PUBLIC   TL2
              PUBLIC   TH2
              PUBLIC   SMB0CR
              PUBLIC   PSW
              PUBLIC   REF0CN
              PUBLIC   DAC0L
              PUBLIC   DAC0H
              PUBLIC   DAC0CN
              PUBLIC   DAC1L
              PUBLIC   DAC1H
              PUBLIC   DAC1CN
              PUBLIC   PCA0CN
              PUBLIC   PCA0MD
              PUBLIC   PCA0CPM0
              PUBLIC   PCA0CPM1
              PUBLIC   PCA0CPM2
              PUBLIC   PCA0CPM3
              PUBLIC   PCA0CPM4
              PUBLIC   ACC
              PUBLIC   XBR0
              PUBLIC   XBR1
              PUBLIC   XBR2
              PUBLIC   RCAP4L
              PUBLIC   RCAP4H
              PUBLIC   EIE1
              PUBLIC   EIE2
              PUBLIC   ADC0CN
              PUBLIC   PCA0L
              PUBLIC   PCA0CPL0
              PUBLIC   PCA0CPL1
              PUBLIC   PCA0CPL2
              PUBLIC   PCA0CPL3
              PUBLIC   PCA0CPL4
              PUBLIC   RSTSRC
              PUBLIC   B
              PUBLIC   SCON1
              PUBLIC   SBUF1
              PUBLIC   SADDR1
              PUBLIC   TL4
              PUBLIC   TH4
              PUBLIC   EIP1
              PUBLIC   EIP2
              PUBLIC   SPI0CN
              PUBLIC   PCA0H
              PUBLIC   PCA0CPH0
              PUBLIC   PCA0CPH1
              PUBLIC   PCA0CPH2
              PUBLIC   PCA0CPH3
              PUBLIC   PCA0CPH4
              PUBLIC   WDTCN
              PUBLIC   CY
              PUBLIC   AC
              PUBLIC   F0
              PUBLIC   RS1
              PUBLIC   RS0
              PUBLIC   OV
              PUBLIC   F1
              PUBLIC   P
              PUBLIC   TF1
              PUBLIC   TR1
              PUBLIC   TF0
              PUBLIC   TR0
              PUBLIC   IE1
              PUBLIC   IT1
              PUBLIC   IE0
              PUBLIC   IT0
              PUBLIC   SM0
              PUBLIC   SM1
              PUBLIC   SM2
              PUBLIC   REN
              PUBLIC   TB8
              PUBLIC   RB8
              PUBLIC   TI
              PUBLIC   RI
              PUBLIC   EX0
              PUBLIC   ET0
              PUBLIC   EX1
              PUBLIC   ET1
              PUBLIC   ES
              PUBLIC   ET2
              PUBLIC   EA
              PUBLIC   PX0
              PUBLIC   PT0
              PUBLIC   PX1
              PUBLIC   PT1
              PUBLIC   PS
              PUBLIC   PT2
              PUBLIC   TF2
              PUBLIC   EXF2
              PUBLIC   RCLK
              PUBLIC   TCLK
              PUBLIC   EXEN2
              PUBLIC   TR2
              PUBLIC   C_T2
              PUBLIC   CP_RL2
              PUBLIC   SMBTOE
              PUBLIC   SMBFTE
              PUBLIC   AA
              PUBLIC   SI
              PUBLIC   STO
              PUBLIC   STA
              PUBLIC   ENSMB
              PUBLIC   BUSY
              PUBLIC   CCF0
              PUBLIC   CCF1
              PUBLIC   CCF2
              PUBLIC   CCF3
              PUBLIC   CCF4
              PUBLIC   CR
              PUBLIC   CF
              PUBLIC   AD0LJST
              PUBLIC   AD0WINT
              PUBLIC   AD0STM0
              PUBLIC   AD0STM1
              PUBLIC   AD0BUSY
              PUBLIC   AD0INT
              PUBLIC   AD0TM
              PUBLIC   AD0EN
              PUBLIC   SPIEN
              PUBLIC   MSTEN
              PUBLIC   SLVSEL
              PUBLIC   TXBSY
              PUBLIC   RXOVRN
              PUBLIC   MODF
              PUBLIC   WCOL
              PUBLIC   SPIF
              PUBLIC   IIC_Adr

              PUBLIC   I2C_AddressPresent
              PUBLIC   C51F020

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit C51F020;
; 
; {$XDATA }
; 
; Interface
; 
; Const

RSEG _CONST

; 
;    RI1 = $01;
;    TI1 = $02;
; 
;    TF3 = $80;
; 
;  { T2CON }
;    RCLK0 = $20;
;    TCLK0 = $10;
;    TR2_  = $04;
; 
;  { EIE1 }
;    ESMB0 = $02;
; 
;  { EIE2 }
;    ES1 = $40;
;    ET3 = $01;
; 
;  { EIP2 }
;    PT3 = $01;
; 
;  { DAC0CN }
;    DAC0EN                = $80;
;    UpdateOn_WriteTo_DACH = $00;
;    UpdateOn_Timer3       = $08;
;    UpdateOn_Timer4       = $10;
;    UpdateOn_Timer2       = $18;
; 
;  { DAC1CN }
;    DAC1EN                = $80;
; //   UpdateOn_WriteTo_DACH = $00;
; //   UpdateOn_Timer3       = $08;
; //   UpdateOn_Timer4       = $10;
; //   UpdateOn_Timer2       = $18;
; 
;  { TMR3CN }
;    TR3 = $04;
;    T3M = $02;
; 
;   { SMB0CN }
;    STA_  = $20;
;    STO_  = $10;
; 
;    Timer2  = $002B;
;    SMBus   = $003B;
;    Timer3  = $0073;
;    Serial1 = $00A3;
; 
;   { SCON1 }
;    TB81    = $08;
;    RB81    = $04;
; 
; Var
;    P0:       Byte absolute $80;
P0                              EQU      $80

;    SP:       Byte absolute $81;
SP                              EQU      $81

;    DPL:      Byte absolute $82;
DPL                             EQU      $82

;    DPH:      Byte absolute $83;
DPH                             EQU      $83

;    P4:       Byte absolute $84;
P4                              EQU      $84

;    P5:       Byte absolute $85;
P5                              EQU      $85

;    P6:       Byte absolute $86;
P6                              EQU      $86

;    PCON:     Byte absolute $87;
PCON                            EQU      $87

;    TCON:     Byte absolute $88;
TCON                            EQU      $88

;    TMOD:     Byte absolute $89;
TMOD                            EQU      $89

;    TL0:      Byte absolute $8A;
TL0                             EQU      $8A

;    TL1:      Byte absolute $8B;
TL1                             EQU      $8B

;    TH0:      Byte absolute $8C;
TH0                             EQU      $8C

;    TH1:      Byte absolute $8D;
TH1                             EQU      $8D

;    CKCON:    Byte absolute $8E;
CKCON                           EQU      $8E

;    PSCTL:    Byte absolute $8F;
PSCTL                           EQU      $8F

;    P1:       Byte absolute $90;
P1                              EQU      $90

;    TMR3CN:   Byte absolute $91;
TMR3CN                          EQU      $91

;    TMR3RLL:  Byte absolute $92;
TMR3RLL                         EQU      $92

;    TMR3RLH:  Byte absolute $93;
TMR3RLH                         EQU      $93

;    TMR3L:    Byte absolute $94;
TMR3L                           EQU      $94

;    TMR3H:    Byte absolute $95;
TMR3H                           EQU      $95

;    P7:       Byte absolute $96;
P7                              EQU      $96

;    SCON0:    Byte absolute $98;
SCON0                           EQU      $98

;    SBUF0:    Byte absolute $99;
SBUF0                           EQU      $99

;    SPI0CFG:  Byte absolute $9A;
SPI0CFG                         EQU      $9A

;    SPI0DAT:  Byte absolute $9B;
SPI0DAT                         EQU      $9B

;    ADC1:     Byte absolute $9C;
ADC1                            EQU      $9C

;    SPI0CKR:  Byte absolute $9D;
SPI0CKR                         EQU      $9D

;    CPT0CN:   Byte absolute $9E;
CPT0CN                          EQU      $9E

;    CPT1CN:   Byte absolute $9F;
CPT1CN                          EQU      $9F

;    P2:       Byte absolute $A0;
P2                              EQU      $A0

;    EMI0TC:   Byte absolute $A1;
EMI0TC                          EQU      $A1

;    EMI0CF:   Byte absolute $A3;
EMI0CF                          EQU      $A3

;    P0MDOUT:  Byte absolute $A4;
P0MDOUT                         EQU      $A4

;    P1MDOUT:  Byte absolute $A5;
P1MDOUT                         EQU      $A5

;    P2MDOUT:  Byte absolute $A6;
P2MDOUT                         EQU      $A6

;    P3MDOUT:  Byte absolute $A7;
P3MDOUT                         EQU      $A7

;    IE:       Byte absolute $A8;
IE                              EQU      $A8

;    SADDR0:   Byte absolute $A9;
SADDR0                          EQU      $A9

;    ADC1CN:   Byte absolute $AA;
ADC1CN                          EQU      $AA

;    ADC1CF:   Byte absolute $AB;
ADC1CF                          EQU      $AB

;    AMX1SL:   Byte absolute $AC;
AMX1SL                          EQU      $AC

;    P3IF:     Byte absolute $AD;
P3IF                            EQU      $AD

;    SADEN1:   Byte absolute $AE;
SADEN1                          EQU      $AE

;    EMI0CN:   Byte absolute $AF;
EMI0CN                          EQU      $AF

;    P3:       Byte absolute $B0;
P3                              EQU      $B0

;    OSCXCN:   Byte absolute $B1;
OSCXCN                          EQU      $B1

;    OSCICN:   Byte absolute $B2;
OSCICN                          EQU      $B2

;    P74OUT:   Byte absolute $B5;
P74OUT                          EQU      $B5

;    FLSCL:    Byte absolute $B6;
FLSCL                           EQU      $B6

;    FLACL:    Byte absolute $B7;
FLACL                           EQU      $B7

;    IP:       Byte absolute $B8;
IP                              EQU      $B8

;    SADEN0:   Byte absolute $B9;
SADEN0                          EQU      $B9

;    AMX0CF:   Byte absolute $BA;
AMX0CF                          EQU      $BA

;    AMX0SL:   Byte absolute $BB;
AMX0SL                          EQU      $BB

;    ADC0CF:   Byte absolute $BC;
ADC0CF                          EQU      $BC

;    P1MDIN:   Byte absolute $BD;
P1MDIN                          EQU      $BD

;    ADC0L:    Byte absolute $BE;
ADC0L                           EQU      $BE

;    ADC0H:    Byte absolute $BF;
ADC0H                           EQU      $BF

;    SMB0CN:   Byte absolute $C0;
SMB0CN                          EQU      $C0

;    SMB0STA:  Byte absolute $C1;
SMB0STA                         EQU      $C1

;    SMB0DAT:  Byte absolute $C2;
SMB0DAT                         EQU      $C2

;    SMB0ADR:  Byte absolute $C3;
SMB0ADR                         EQU      $C3

;    ADC0GTL:  Byte absolute $C4;
ADC0GTL                         EQU      $C4

;    ADC0GTH:  Byte absolute $C5;
ADC0GTH                         EQU      $C5

;    ADC0LTL:  Byte absolute $C6;
ADC0LTL                         EQU      $C6

;    ADC0LTH:  Byte absolute $C7;
ADC0LTH                         EQU      $C7

;    T2CON:    Byte absolute $C8;
T2CON                           EQU      $C8

;    T4CON:    Byte absolute $C9;
T4CON                           EQU      $C9

;    RCAP2L:   Byte absolute $CA;
RCAP2L                          EQU      $CA

;    RCAP2H:   Byte absolute $CB;
RCAP2H                          EQU      $CB

;    TL2:      Byte absolute $CC;
TL2                             EQU      $CC

;    TH2:      Byte absolute $CD;
TH2                             EQU      $CD

;    SMB0CR:   Byte absolute $CF;
SMB0CR                          EQU      $CF

;    PSW:      Byte absolute $D0;
PSW                             EQU      $D0

;    REF0CN:   Byte absolute $D1;
REF0CN                          EQU      $D1

;    DAC0L:    Byte absolute $D2;
DAC0L                           EQU      $D2

;    DAC0H:    Byte absolute $D3;
DAC0H                           EQU      $D3

;    DAC0CN:   Byte absolute $D4;
DAC0CN                          EQU      $D4

;    DAC1L:    Byte absolute $D5;
DAC1L                           EQU      $D5

;    DAC1H:    Byte absolute $D6;
DAC1H                           EQU      $D6

;    DAC1CN:   Byte absolute $D7;
DAC1CN                          EQU      $D7

;    PCA0CN:   Byte absolute $D8;
PCA0CN                          EQU      $D8

;    PCA0MD:   Byte absolute $D9;
PCA0MD                          EQU      $D9

;    PCA0CPM0: Byte absolute $DA;
PCA0CPM0                        EQU      $DA

;    PCA0CPM1: Byte absolute $DB;
PCA0CPM1                        EQU      $DB

;    PCA0CPM2: Byte absolute $DC;
PCA0CPM2                        EQU      $DC

;    PCA0CPM3: Byte absolute $DD;
PCA0CPM3                        EQU      $DD

;    PCA0CPM4: Byte absolute $DE;
PCA0CPM4                        EQU      $DE

;    ACC:      Byte absolute $E0;
ACC                             EQU      $E0

;    XBR0:     Byte absolute $E1;
XBR0                            EQU      $E1

;    XBR1:     Byte absolute $E2;
XBR1                            EQU      $E2

;    XBR2:     Byte absolute $E3;
XBR2                            EQU      $E3

;    RCAP4L:   Byte absolute $E4;
RCAP4L                          EQU      $E4

;    RCAP4H:   Byte absolute $E5;
RCAP4H                          EQU      $E5

;    EIE1:     Byte absolute $E6;
EIE1                            EQU      $E6

;    EIE2:     Byte absolute $E7;
EIE2                            EQU      $E7

;    ADC0CN:   Byte absolute $E8;
ADC0CN                          EQU      $E8

;    PCA0L:    Byte absolute $E9;
PCA0L                           EQU      $E9

;    PCA0CPL0: Byte absolute $EA;
PCA0CPL0                        EQU      $EA

;    PCA0CPL1: Byte absolute $EB;
PCA0CPL1                        EQU      $EB

;    PCA0CPL2: Byte absolute $EC;
PCA0CPL2                        EQU      $EC

;    PCA0CPL3: Byte absolute $ED;
PCA0CPL3                        EQU      $ED

;    PCA0CPL4: Byte absolute $EE;
PCA0CPL4                        EQU      $EE

;    RSTSRC:   Byte absolute $EF;
RSTSRC                          EQU      $EF

;    B:        Byte absolute $F0;
B                               EQU      $F0

;    SCON1:    Byte absolute $F1;
SCON1                           EQU      $F1

;    SBUF1:    Byte absolute $F2;
SBUF1                           EQU      $F2

;    SADDR1:   Byte absolute $F3;
SADDR1                          EQU      $F3

;    TL4:      Byte absolute $F4;
TL4                             EQU      $F4

;    TH4:      Byte absolute $F5;
TH4                             EQU      $F5

;    EIP1:     Byte absolute $F6;
EIP1                            EQU      $F6

;    EIP2:     Byte absolute $F7;
EIP2                            EQU      $F7

;    SPI0CN:   Byte absolute $F8;
SPI0CN                          EQU      $F8

;    PCA0H:    Byte absolute $F9;
PCA0H                           EQU      $F9

;    PCA0CPH0: Byte absolute $FA;
PCA0CPH0                        EQU      $FA

;    PCA0CPH1: Byte absolute $FB;
PCA0CPH1                        EQU      $FB

;    PCA0CPH2: Byte absolute $FC;
PCA0CPH2                        EQU      $FC

;    PCA0CPH3: Byte absolute $FD;
PCA0CPH3                        EQU      $FD

;    PCA0CPH4: Byte absolute $FE;
PCA0CPH4                        EQU      $FE

;    WDTCN:    Byte absolute $FF;
WDTCN                           EQU      $FF

; 
; { PSW }
;    CY:       Boolean absolute PSW.7;
CY                              BIT      PSW.7

;    AC:       Boolean absolute PSW.6;
AC                              BIT      PSW.6

;    F0:       Boolean absolute PSW.5;
F0                              BIT      PSW.5

;    RS1:      Boolean absolute PSW.4;
RS1                             BIT      PSW.4

;    RS0:      Boolean absolute PSW.3;
RS0                             BIT      PSW.3

;    OV:       Boolean absolute PSW.2;
OV                              BIT      PSW.2

;    F1:       Boolean absolute PSW.1;
F1                              BIT      PSW.1

;    P:        Boolean absolute PSW.0;
P                               BIT      PSW.0

; 
; { TCON }
;    TF1:      Boolean absolute $8F;
TF1                             BIT      TCON.7

;    TR1:      Boolean absolute $8E;
TR1                             BIT      TCON.6

;    TF0:      Boolean absolute $8D;
TF0                             BIT      TCON.5

;    TR0:      Boolean absolute $8C;
TR0                             BIT      TCON.4

;    IE1:      Boolean absolute $8B;
IE1                             BIT      TCON.3

;    IT1:      Boolean absolute $8A;
IT1                             BIT      TCON.2

;    IE0:      Boolean absolute $89;
IE0                             BIT      TCON.1

;    IT0:      Boolean absolute $88;
IT0                             BIT      TCON.0

; 
; { SCON0 }
;    SM0:      Boolean absolute $9F;
SM0                             BIT      SCON.7

;    SM1:      Boolean absolute $9E;
SM1                             BIT      SCON.6

;    SM2:      Boolean absolute $9D;
SM2                             BIT      SCON.5

;    REN:      Boolean absolute $9C;
REN                             BIT      SCON.4

;    TB8:      Boolean absolute $9B;
TB8                             BIT      SCON.3

;    RB8:      Boolean absolute $9A;
RB8                             BIT      SCON.2

;    TI:       Boolean absolute $99;
TI                              BIT      SCON.1

;    RI:       Boolean absolute $98;
RI                              BIT      SCON.0

; 
; { IE}
;    EX0:      Boolean absolute IE.0;
EX0                             BIT      IE.0

;    ET0:      Boolean absolute IE.1;
ET0                             BIT      IE.1

;    EX1:      Boolean absolute IE.2;
EX1                             BIT      IE.2

;    ET1:      Boolean absolute IE.3;
ET1                             BIT      IE.3

;    ES:       Boolean absolute IE.4;
ES                              BIT      IE.4

;    ET2:      Boolean absolute IE.5;
ET2                             BIT      IE.5

;    EA:       Boolean absolute IE.7;
EA                              BIT      IE.7

; 
; { IP }
;    PX0:      Boolean absolute IP.0;
PX0                             BIT      IP.0

;    PT0:      Boolean absolute IP.1;
PT0                             BIT      IP.1

;    PX1:      Boolean absolute IP.2;
PX1                             BIT      IP.2

;    PT1:      Boolean absolute IP.3;
PT1                             BIT      IP.3

;    PS:       Boolean absolute IP.4;
PS                              BIT      IP.4

;    PT2:      Boolean absolute IP.5;
PT2                             BIT      IP.5

; 
; { T2CON }
;    TF2:      Boolean absolute T2CON.7;
TF2                             BIT      $C8.7

;    EXF2:     Boolean absolute T2CON.6;
EXF2                            BIT      $C8.6

;    RCLK:     Boolean absolute T2CON.5;
RCLK                            BIT      $C8.5

;    TCLK:     Boolean absolute T2CON.4;
TCLK                            BIT      $C8.4

;    EXEN2:    Boolean absolute T2CON.3;
EXEN2                           BIT      $C8.3

;    TR2:      Boolean absolute T2CON.2;
TR2                             BIT      $C8.2

;    C_T2:     Boolean absolute T2CON.1;
C_T2                            BIT      $C8.1

;    CP_RL2:   Boolean absolute T2CON.0;
CP_RL2                          BIT      $C8.0

; 
; { SMB0CN }
;    SMBTOE:   Boolean absolute SMB0CN.0;
SMBTOE                          BIT      $C0.0

;    SMBFTE:   Boolean absolute SMB0CN.1;
SMBFTE                          BIT      $C0.1

;    AA:       Boolean absolute SMB0CN.2;
AA                              BIT      $C0.2

;    SI:       Boolean absolute SMB0CN.3;
SI                              BIT      $C0.3

;    STO:      Boolean absolute SMB0CN.4;
STO                             BIT      $C0.4

;    STA:      Boolean absolute SMB0CN.5;
STA                             BIT      $C0.5

;    ENSMB:    Boolean absolute SMB0CN.6;
ENSMB                           BIT      $C0.6

;    BUSY:     Boolean absolute SMB0CN.7;
BUSY                            BIT      $C0.7

; 
; { PCA0CN }
;    CCF0:     Boolean absolute PCA0CN.0;
CCF0                            BIT      $D8.0

;    CCF1:     Boolean absolute PCA0CN.1;
CCF1                            BIT      $D8.1

;    CCF2:     Boolean absolute PCA0CN.2;
CCF2                            BIT      $D8.2

;    CCF3:     Boolean absolute PCA0CN.3;
CCF3                            BIT      $D8.3

;    CCF4:     Boolean absolute PCA0CN.4;
CCF4                            BIT      $D8.4

;    CR:       Boolean absolute PCA0CN.6;
CR                              BIT      $D8.6

;    CF:       Boolean absolute PCA0CN.7;
CF                              BIT      $D8.7

; 
; { ADC0CN }
;    AD0LJST:  Boolean absolute ADC0CN.0;
AD0LJST                         BIT      $E8.0

;    AD0WINT:  Boolean absolute ADC0CN.1;
AD0WINT                         BIT      $E8.1

;    AD0STM0:  Boolean absolute ADC0CN.2;
AD0STM0                         BIT      $E8.2

;    AD0STM1:  Boolean absolute ADC0CN.3;
AD0STM1                         BIT      $E8.3

;    AD0BUSY:  Boolean absolute ADC0CN.4;
AD0BUSY                         BIT      $E8.4

;    AD0INT:   Boolean absolute ADC0CN.5;
AD0INT                          BIT      $E8.5

;    AD0TM:    Boolean absolute ADC0CN.6;
AD0TM                           BIT      $E8.6

;    AD0EN:    Boolean absolute ADC0CN.7;
AD0EN                           BIT      $E8.7

; 
; { SPI0CN }
;    SPIEN:    Boolean absolute SPI0CN.0;
SPIEN                           BIT      $F8.0

;    MSTEN:    Boolean absolute SPI0CN.1;
MSTEN                           BIT      $F8.1

;    SLVSEL:   Boolean absolute SPI0CN.2;
SLVSEL                          BIT      $F8.2

;    TXBSY:    Boolean absolute SPI0CN.3;
TXBSY                           BIT      $F8.3

;    RXOVRN:   Boolean absolute SPI0CN.4;
RXOVRN                          BIT      $F8.4

;    MODF:     Boolean absolute SPI0CN.5;
MODF                            BIT      $F8.5

;    WCOL:     Boolean absolute SPI0CN.6;
WCOL                            BIT      $F8.6

;    SPIF:     Boolean absolute SPI0CN.7;
SPIF                            BIT      $F8.7

; 
; Function  I2C_AddressPresent (IIC_Adr: Byte XDATA): Boolean;

RSEG _BIT

I2C_AddressPresent_Result:      DBIT     1

RSEG _DATA

IIC_Adr:                        DS       1

; 
; Implementation
; 
; Function  I2C_AddressPresent (IIC_Adr: Byte): Boolean;
; Var TempCounter: Byte;
TempCounter:                    DS       1

USING 0

I2C_AddressPresent:
; begin
;   I2C_AddressPresent := False;
              CLR       I2C_AddressPresent_Result

;   TempCounter := 0;
              MOV       R2, #0

;   Repeat
L_0004:
;     Inc (TempCounter);
              INC       R2

;   until not BUSY or (TempCounter > 250);
              JNB       $C0.7, L_000D
              MOV       A, R2
              ADD       A, #5
              JNC       L_0004
L_000D:

;   If BUSY then Exit;
              JB        $C0.7, L_0033

; 
;   Repeat
              MOV       R2, #$A5
L_0012:

;     WDTCN := $A5;
              MOV       $FF, R2

;   until not BUSY;
              JB        $C0.7, L_0012

; 
;   STA := True;
              SETB      $C0.5

; 
;   Repeat until SI;
L_0019:
              JNB       $C0.3, L_0019

;   STA := False;
              CLR       $C0.5

;   SMB0DAT := IIC_Adr;
              MOV       $C2, IIC_Adr

;   SI := False;
              CLR       $C0.3

; 
;   Repeat until SI;
L_0023:
              JNB       $C0.3, L_0023

;   I2C_AddressPresent := SMB0STA = $18;
              MOV       A, $C1
              XRL       A, #$18
              ADD       A, #$FF
              CPL       C
              MOV       I2C_AddressPresent_Result, C

;   STO := True;
              SETB      $C0.4

;   SI := False;
              CLR       $C0.3

; end;
L_0033:
              MOV       C, I2C_AddressPresent_Result
              RET


C51F020:
; 
; begin
; end.
              RET

RSEG _CONST


              END

