{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit C51F020;

{$XDATA }

Interface

Const

   RI1 = $01;
   TI1 = $02;

   TF3 = $80;

 { T2CON }
   RCLK0 = $20;
   TCLK0 = $10;
   TR2_  = $04;

 { EIE1 }
   ESMB0 = $02;

 { EIE2 }
   ES1 = $40;
   ET3 = $01;

 { EIP2 }
   PT3 = $01;

 { DAC0CN }
   DAC0EN                = $80;
   UpdateOn_WriteTo_DACH = $00;
   UpdateOn_Timer3       = $08;
   UpdateOn_Timer4       = $10;
   UpdateOn_Timer2       = $18;

 { DAC1CN }
   DAC1EN                = $80;
//   UpdateOn_WriteTo_DACH = $00;
//   UpdateOn_Timer3       = $08;
//   UpdateOn_Timer4       = $10;
//   UpdateOn_Timer2       = $18;

 { TMR3CN }
   TR3 = $04;
   T3M = $02;

  { SMB0CN }
   STA_  = $20;
   STO_  = $10;

   Timer2  = $002B;
   SMBus   = $003B;
   Timer3  = $0073;
   Serial1 = $00A3;

  { SCON1 }
   TB81    = $08;
   RB81    = $04;

Var
   P0:       Byte absolute $80;
   SP:       Byte absolute $81;
   DPL:      Byte absolute $82;
   DPH:      Byte absolute $83;
   P4:       Byte absolute $84;
   P5:       Byte absolute $85;
   P6:       Byte absolute $86;
   PCON:     Byte absolute $87;
   TCON:     Byte absolute $88;
   TMOD:     Byte absolute $89;
   TL0:      Byte absolute $8A;
   TL1:      Byte absolute $8B;
   TH0:      Byte absolute $8C;
   TH1:      Byte absolute $8D;
   CKCON:    Byte absolute $8E;
   PSCTL:    Byte absolute $8F;
   P1:       Byte absolute $90;
   TMR3CN:   Byte absolute $91;
   TMR3RLL:  Byte absolute $92;
   TMR3RLH:  Byte absolute $93;
   TMR3L:    Byte absolute $94;
   TMR3H:    Byte absolute $95;
   P7:       Byte absolute $96;
   SCON0:    Byte absolute $98;
   SBUF0:    Byte absolute $99;
   SPI0CFG:  Byte absolute $9A;
   SPI0DAT:  Byte absolute $9B;
   ADC1:     Byte absolute $9C;
   SPI0CKR:  Byte absolute $9D;
   CPT0CN:   Byte absolute $9E;
   CPT1CN:   Byte absolute $9F;
   P2:       Byte absolute $A0;
   EMI0TC:   Byte absolute $A1;
   EMI0CF:   Byte absolute $A3;
   P0MDOUT:  Byte absolute $A4;
   P1MDOUT:  Byte absolute $A5;
   P2MDOUT:  Byte absolute $A6;
   P3MDOUT:  Byte absolute $A7;
   IE:       Byte absolute $A8;
   SADDR0:   Byte absolute $A9;
   ADC1CN:   Byte absolute $AA;
   ADC1CF:   Byte absolute $AB;
   AMX1SL:   Byte absolute $AC;
   P3IF:     Byte absolute $AD;
   SADEN1:   Byte absolute $AE;
   EMI0CN:   Byte absolute $AF;
   P3:       Byte absolute $B0;
   OSCXCN:   Byte absolute $B1;
   OSCICN:   Byte absolute $B2;
   P74OUT:   Byte absolute $B5;
   FLSCL:    Byte absolute $B6;
   FLACL:    Byte absolute $B7;
   IP:       Byte absolute $B8;
   SADEN0:   Byte absolute $B9;
   AMX0CF:   Byte absolute $BA;
   AMX0SL:   Byte absolute $BB;
   ADC0CF:   Byte absolute $BC;
   P1MDIN:   Byte absolute $BD;
   ADC0L:    Byte absolute $BE;
   ADC0H:    Byte absolute $BF;
   SMB0CN:   Byte absolute $C0;
   SMB0STA:  Byte absolute $C1;
   SMB0DAT:  Byte absolute $C2;
   SMB0ADR:  Byte absolute $C3;
   ADC0GTL:  Byte absolute $C4;
   ADC0GTH:  Byte absolute $C5;
   ADC0LTL:  Byte absolute $C6;
   ADC0LTH:  Byte absolute $C7;
   T2CON:    Byte absolute $C8;
   T4CON:    Byte absolute $C9;
   RCAP2L:   Byte absolute $CA;
   RCAP2H:   Byte absolute $CB;
   TL2:      Byte absolute $CC;
   TH2:      Byte absolute $CD;
   SMB0CR:   Byte absolute $CF;
   PSW:      Byte absolute $D0;
   REF0CN:   Byte absolute $D1;
   DAC0L:    Byte absolute $D2;
   DAC0H:    Byte absolute $D3;
   DAC0CN:   Byte absolute $D4;
   DAC1L:    Byte absolute $D5;
   DAC1H:    Byte absolute $D6;
   DAC1CN:   Byte absolute $D7;
   PCA0CN:   Byte absolute $D8;
   PCA0MD:   Byte absolute $D9;
   PCA0CPM0: Byte absolute $DA;
   PCA0CPM1: Byte absolute $DB;
   PCA0CPM2: Byte absolute $DC;
   PCA0CPM3: Byte absolute $DD;
   PCA0CPM4: Byte absolute $DE;
   ACC:      Byte absolute $E0;
   XBR0:     Byte absolute $E1;
   XBR1:     Byte absolute $E2;
   XBR2:     Byte absolute $E3;
   RCAP4L:   Byte absolute $E4;
   RCAP4H:   Byte absolute $E5;
   EIE1:     Byte absolute $E6;
   EIE2:     Byte absolute $E7;
   ADC0CN:   Byte absolute $E8;
   PCA0L:    Byte absolute $E9;
   PCA0CPL0: Byte absolute $EA;
   PCA0CPL1: Byte absolute $EB;
   PCA0CPL2: Byte absolute $EC;
   PCA0CPL3: Byte absolute $ED;
   PCA0CPL4: Byte absolute $EE;
   RSTSRC:   Byte absolute $EF;
   B:        Byte absolute $F0;
   SCON1:    Byte absolute $F1;
   SBUF1:    Byte absolute $F2;
   SADDR1:   Byte absolute $F3;
   TL4:      Byte absolute $F4;
   TH4:      Byte absolute $F5;
   EIP1:     Byte absolute $F6;
   EIP2:     Byte absolute $F7;
   SPI0CN:   Byte absolute $F8;
   PCA0H:    Byte absolute $F9;
   PCA0CPH0: Byte absolute $FA;
   PCA0CPH1: Byte absolute $FB;
   PCA0CPH2: Byte absolute $FC;
   PCA0CPH3: Byte absolute $FD;
   PCA0CPH4: Byte absolute $FE;
   WDTCN:    Byte absolute $FF;

{ PSW }
   CY:       Boolean absolute PSW.7;
   AC:       Boolean absolute PSW.6;
   F0:       Boolean absolute PSW.5;
   RS1:      Boolean absolute PSW.4;
   RS0:      Boolean absolute PSW.3;
   OV:       Boolean absolute PSW.2;
   F1:       Boolean absolute PSW.1;
   P:        Boolean absolute PSW.0;

{ TCON }
   TF1:      Boolean absolute $8F;
   TR1:      Boolean absolute $8E;
   TF0:      Boolean absolute $8D;
   TR0:      Boolean absolute $8C;
   IE1:      Boolean absolute $8B;
   IT1:      Boolean absolute $8A;
   IE0:      Boolean absolute $89;
   IT0:      Boolean absolute $88;

{ SCON0 }
   SM0:      Boolean absolute $9F;
   SM1:      Boolean absolute $9E;
   SM2:      Boolean absolute $9D;
   REN:      Boolean absolute $9C;
   TB8:      Boolean absolute $9B;
   RB8:      Boolean absolute $9A;
   TI:       Boolean absolute $99;
   RI:       Boolean absolute $98;

{ IE}
   EX0:      Boolean absolute IE.0;
   ET0:      Boolean absolute IE.1;
   EX1:      Boolean absolute IE.2;
   ET1:      Boolean absolute IE.3;
   ES:       Boolean absolute IE.4;
   ET2:      Boolean absolute IE.5;
   EA:       Boolean absolute IE.7;

{ IP }
   PX0:      Boolean absolute IP.0;
   PT0:      Boolean absolute IP.1;
   PX1:      Boolean absolute IP.2;
   PT1:      Boolean absolute IP.3;
   PS:       Boolean absolute IP.4;
   PT2:      Boolean absolute IP.5;

{ T2CON }
   TF2:      Boolean absolute T2CON.7;
   EXF2:     Boolean absolute T2CON.6;
   RCLK:     Boolean absolute T2CON.5;
   TCLK:     Boolean absolute T2CON.4;
   EXEN2:    Boolean absolute T2CON.3;
   TR2:      Boolean absolute T2CON.2;
   C_T2:     Boolean absolute T2CON.1;
   CP_RL2:   Boolean absolute T2CON.0;

{ SMB0CN }
   SMBTOE:   Boolean absolute SMB0CN.0;
   SMBFTE:   Boolean absolute SMB0CN.1;
   AA:       Boolean absolute SMB0CN.2;
   SI:       Boolean absolute SMB0CN.3;
   STO:      Boolean absolute SMB0CN.4;
   STA:      Boolean absolute SMB0CN.5;
   ENSMB:    Boolean absolute SMB0CN.6;
   BUSY:     Boolean absolute SMB0CN.7;

{ PCA0CN }
   CCF0:     Boolean absolute PCA0CN.0;
   CCF1:     Boolean absolute PCA0CN.1;
   CCF2:     Boolean absolute PCA0CN.2;
   CCF3:     Boolean absolute PCA0CN.3;
   CCF4:     Boolean absolute PCA0CN.4;
   CR:       Boolean absolute PCA0CN.6;
   CF:       Boolean absolute PCA0CN.7;

{ ADC0CN }
   AD0LJST:  Boolean absolute ADC0CN.0;
   AD0WINT:  Boolean absolute ADC0CN.1;
   AD0STM0:  Boolean absolute ADC0CN.2;
   AD0STM1:  Boolean absolute ADC0CN.3;
   AD0BUSY:  Boolean absolute ADC0CN.4;
   AD0INT:   Boolean absolute ADC0CN.5;
   AD0TM:    Boolean absolute ADC0CN.6;
   AD0EN:    Boolean absolute ADC0CN.7;

{ SPI0CN }
   SPIEN:    Boolean absolute SPI0CN.0;
   MSTEN:    Boolean absolute SPI0CN.1;
   SLVSEL:   Boolean absolute SPI0CN.2;
   TXBSY:    Boolean absolute SPI0CN.3;
   RXOVRN:   Boolean absolute SPI0CN.4;
   MODF:     Boolean absolute SPI0CN.5;
   WCOL:     Boolean absolute SPI0CN.6;
   SPIF:     Boolean absolute SPI0CN.7;

Function  I2C_AddressPresent (IIC_Adr: Byte XDATA): Boolean;

Implementation

Function  I2C_AddressPresent (IIC_Adr: Byte): Boolean;
Var TempCounter: Byte;
begin
  I2C_AddressPresent := False;
  TempCounter := 0;
  Repeat
    Inc (TempCounter);
  until not BUSY or (TempCounter > 250);
  If BUSY then Exit;

  Repeat
    WDTCN := $A5;
  until not BUSY;

  STA := True;

  Repeat until SI;
  STA := False;
  SMB0DAT := IIC_Adr;
  SI := False;

  Repeat until SI;
  I2C_AddressPresent := SMB0STA = $18;
  STO := True;
  SI := False;
end;

begin
end.
