{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Const PacketHeaderSize            = 12;
      DefaultPacketSize           = PacketHeaderSize + 32;
      MagicDemoWord               = $DE3A;
      MagicControlNumber          = $ABAA;
      NoTemperature               = $FF00;

      MaxModuleAddress            = $3F;

      MaxModuleAdressLocalRemote  = 2 * (MaxModuleAddress + 1) - 1;

      SerialNumberLength          = 12;
      CommentLength               = 14;
      ModuleNameLength            = 12;
      LocationNameLength          = 18;
      SourceNameLength            = 15;
      SourceDescriptionLength     = 30;
      InputNameLength             = 18;
      UserTextLength              = 64;
      UserTextLength1             = 32;
      UserTextLength2             = 32;
      BroadcastAddress            = $7F;
      BroadcastAddress_Frame      = $FF;
      PC_AddressSetup             = $7E;
      PC_AddressAlarm             = $7A;
      PC_Address_Frame            = $FE;
      Test_Address                = $7D;
      Dummy_Address               = $7C;
      Transport_Address           = $7B;
      Peer_Address                = $7C;
      Test_Address_Frame          = $FD;
      DummyAddress_Frame          = $FC;
      Debugger_Address_Frame      = $FB;
      InterFrameAddress           = $00;
      COM_ModuleAddress           = $10;
      SingleExternalModuleAddress = $FF;
      VCS64_IO_ModuleAddress      = $0F;
      TurboStartByte              = $AA;
      SetupDataSize               = 9;
      FirstOutModuleAddress       = 2;
      FOM100SetupStartByte        = $FA;
      MAX_Cmd_Registers           = $20;


      BroadcastReplyTimeSlot      =   80;
      LoopTestTime                = 5000;
      CommPacketTime              = 3000;


      Cmd_ModuleData              = $00;
      Cmd_SetupData               = $01;
      Cmd_SourceNameAndFlags      = $02;
      Cmd_SourceDescription       = $03;
      Cmd_RemoteSlots             = $04;
      Cmd_EEPROM                  = $05;
      Cmd_Reset                   = $06;
      Cmd_FrameData               = $07;
      Cmd_Message                 = $08;
      Cmd_VideoInputName          = $09;
      Cmd_Outputs                 = $0A;
      Cmd_InputSyncs              = $0B;
      Cmd_Transport               = $0C;
      Cmd_Protocols               = $0D;
      Cmd_Keyboard                = $0E;
      Cmd_IOData                  = $0F;
      Cmd_EventActions            = $10;
      Cmd_AllOutputs              = $11;
      Cmd_OsdData                 = $12;
      Cmd_AlarmEvent              = $13;
      Cmd_DigitalInputName        = $14;
      Cmd_PhysicalInputs          = $15;
      Cmd_PhysicalOutputs         = $16;
      Cmd_Video_IO                = $17;
      Cmd_IO                      = $18;
      Cmd_ModuleAddress           = $19;
      Cmd_SerialPorts             = $1A;
      Cmd_CameraIO                = $1B;
      Cmd_TestMode                = $1C;
      Cmd_FrameDataExt            = $1D;
      Cmd_ICM_Mode                = $1E;
      Cmd_CameraAddresses         = $1F;
      Cmd_AudioSetup              = $20;
      Cmd_VID5_Setup              = $21;
      Cmd_VideoSetup              = $22;
      Cmd_VID8X8_Setup            = $23;
      Cmd_UART_Setup              = $24;
      Cmd_UART_Transport          = $25;
      Cmd_OVS4_45_Setup           = $26;
      Cmd_UART_Test               = $27;
      Cmd_OVS4_45_IO              = $28;
      Cmd_LinkData                = $29;
      Cmd_UserText                = $2A;
      Cmd_SPDIF                   = $2B;
      Cmd_OVS4_45_RF              = $2C;
      Cmd_SFP                     = $2D;
      Cmd_UI                      = $2E;
      Cmd_Registers               = $2F;
      Cmd_Hours                   = $30;
      Cmd_CommCounters            = $31;
      Cmd_UserTexts               = $32;
      Cmd_ModuleInfo              = $33;
      Cmd_Transceiver             = $34;
      Cmd_IMC_Video               = $35;
      Cmd_IMC_VideoExchange       = $36;
      Cmd_IMC_UART                = $37;


      mdVideoPresent              = $01;
      mdErrorEEPROM               = $02;
      mdErrorTDA8444              = $04;
      mdKeyUp                     = $08;
      mdKeyDown                   = $10;
      mdKeyEnter                  = $20;


      mdErrorTHS7353              = $04;
      mdBypass                    = $08;
      mdVideo1Present             = $10;
      mdVideo2Present             = $20;
      mdVideo3Present             = $40;
      mdVideo4Present             = $80;


      mdErrorFMS6501              = $04;

      mdVideoInPresent            = $01;
      mdErrorTEA6415              = $04;
      mdUDet                      = $08;
      mdIDet                      = $10;
      mdVideoOutPresent           = $40;
      mdLink                      = $80;

      mdErrorTDA8425              = $40;


      mdRS232                     = $01;
      mdKeyTest                   = $40;
      mdErrorRTC_COM              = $80;

     mdErrorPCF8574               = $04;
      mdKey                       = $40;


     mdErrorModules          =     $04;
     mdNoKeyboard            =     $08;
     mdErrorRTC              =     $10;

     mdLedRS485                  = $01;
     mdLedRS232                  = $04;
     mdLedOptics                 = $08;
     mdLedLink                   = $10;
     mdNoSwitch                  = $80;


     mdErrorPCF8574_IO           = $01;
     mdErrorPCF8574_CAMERA       = $08;
     mdMatrix                    = $10;

     mdLedRS485_1                = $10;
     mdLedRS485_2                = $20;
     mdLedRS485_3                = $40;
     mdLedRS485_4                = $80;

     mdErrorTHS7353_1            = $04;
     mdErrorTHS7353_2            = $08;

     mdOtherModuleMaster         = $04;

      hdDescrVisible              = $01;
      hdEqualizerOn               = $02;
      hdEqualizer0                = $04;
      hdEqualizer1                = $08;
      hdNameVisible               = $10;
      hdReportCommAlarm           = $20;
      hdReturnVideoFromBus        = $40;

      hdLocal                     = $01;
      hdMaster                    = $02;

      adMaster                    = $01;
      adRemoteInputs              = $02;

      mdTHS7353                   = $01;

      mdErrorPORT_U1              = $01;
      mdErrorUART_U43             = $04;
      mdErrorUART_U44             = $08;
      mdErrorPORT_U45             = $10;
      mdErrorMatrix_U49           = $20;
      mdRemoteLink                = $40;


      mdErrorSpare                = $10;
      mdErrorSpare2               = $20;


      mdErrorPCA                  = $04;

      mdErrorTHS                  = $08;

      mdErrorINA220               = $04;
      mdErrorTC665_0              = $08;
      mdErrorTC665_1              = $10;
      mdErrorTC665_2              = $20;
      mdErrorTC665_3              = $40;


      adRemoteMaster              = $40;
      adLink                      = $80;

      hdSW1                       = $01;
      hdSW2                       = $02;
      hdSW3                       = $04;
      hdSW4                       = $08;
      hdSW5                       = $10;
      hdSW6                       = $20;
      hdRelay                     = $40;

      ActionEventStr              = '#ACTION';
      enNoMoreEvents              = 0;
      enEventNowInput             = $FF;
      enEventNowAction            = $FE;

      evReset                     = 0;
      evInput1                    = 1;
      evInput2                    = 2;
      evInput3                    = 3;
      evInput4                    = 4;
      evInput5                    = 5;
      evInput6                    = 6;
      evInput7                    = 7;
      evInput8                    = 8;
      evInput9                    = 9;
      evInput10                   = 10;
      {.}
      {.}
      evInput64                   = 64;

      evTimer1                    = 65;
      evTimer2                    = 66;
      evTimer3                    = 67;
      evTimer4                    = 68;
      evTimer5                    = 69;
      evTimer6                    = 70;
      evTimer7                    = 71;
      evTimer8                    = 72;
      evTimer9                    = 73;
      evTimer10                   = 74;
      evTimer11                   = 75;
      evTimer12                   = 76;
      evTimer13                   = 77;
      evTimer14                   = 78;
      evTimer15                   = 79;
      evTimer16                   = 80;

      evMacro1                    = 81;
      evMacro2                    = 82;
      evMacro3                    = 83;
      evMacro4                    = 84;
      evMacro5                    = 85;
      evMacro6                    = 86;
      evMacro7                    = 87;
      evMacro8                    = 88;
      evMacro9                    = 89;
      evMacro10                   = 90;
      evMacro11                   = 91;
      evMacro12                   = 92;
      evMacro13                   = 93;
      evMacro14                   = 94;
      evMacro15                   = 95;
      evMacro16                   = 96;

      evKeyboard_TextOn           = 97;
      evKeyboard_TextOff          = 98;
      evKeyboard_INC              = 99;   { Output n }
      evKeyboard_DEC              = 100;  { Output n }
      evKeyboard_SEQ              = 101;  { Output n }
      evKeyboard_ENTER            = 102;  { Output n }
      evKeyboard_SET_ENTER        = 103;  { Output n }
      evKeyboard_SET_CAM          = 104;  { Output n }
      evKeyboard_END_CAM          = 105;  { Output n }
      evKeyboard_SHIFT_CAM        = 106;  { Output n }
      evKeyboard_SET_SEQ          = 107;  { Output n }
      evKeyboard_END_SEQ          = 108;  { Output n }
      evKeyboard_SET_0            = 109;  { Output n }
      evKeyboard_SET_1            = 110;  { Output n }
      evKeyboard_SET_2            = 111;  { Output n }
      evKeyboard_SET_3            = 112;  { Output n }
      evKeyboard_SET_4            = 113;  { Output n }
      evKeyboard_SET_5            = 114;  { Output n }
      evKeyboard_SET_6            = 115;  { Output n }
      evKeyboard_SET_7            = 116;  { Output n }
      evKeyboard_SET_8            = 117;  { Output n }
      evKeyboard_SET_9            = 118;  { Output n }

      evJoystick_UP               = 119;  { Output n }
      evJoystick_DOWN             = 120;  { Output n }
      evJoystick_LEFT             = 121;  { Output n }
      evJoystick_RIGHT            = 122;  { Output n }
      evJoystick_CW               = 123;  { Output n }
      evJoystick_CCW              = 124;  { Output n }

      LastEvent                   = evJoystick_CCW;

      BytesPerEventAction         = 32;

      tmDAC                       = 0;
      tmAudioVideo                = 1;
      tmOSD                       = 2;

Type  TModuleType = (mtNone,      mtFOM3000_Local, mtFOM3000_Remote, mtPIT_X, mtPIT_T1, mtPIT_X2, mtPIT_VB);

      TCommandFlag = (cfReadFromHW, cfReadFromEEPROM, cfWriteToHW, cfWriteToEEPROM, cfResetHWToEEPROM, cfResetHW, cfSpare, cfSpare2);
      TCommandFlagsSet = Set of TCommandFlag;

      TProtocols = (prTurbo, prPanasonic, prMacro, prPelcoD, prSony, prAddressFiltering, prTransportForwarding, prAny);
      TProtocolsSet = Set of TProtocols;

      TProtocols2 = (pr2Any, pr2Turbo, pr2Panasonic, pr2PelcoD, pr2Sony, pr2PelcoP, pr2Siemens, pr2JVC);
      TProtocols2Set = Set of TProtocols2;

      TBaudRate = (brDefault, br1200, br2400, br4800, br9600, br19200, br38400, brUndefined, brPelcoD, brSony);

      TIOData  = Array [0..9] of Byte;
      TInData  = Array [0..7] of Byte;
      TOutData = Array [0..1] of Byte;

      TEventActions         = Array [0..BytesPerEventAction - 1] of Byte;
      TEventActionsArray    = Array [evReset..LastEvent] of TEventActions;
      TEventActionsArrayRAM = Array [evReset..evMacro8]  of TEventActions;

      TEventAction = packed Record
                       Action: Byte;
                       Parameter1: Byte;
                       Parameter2: Byte;
                       Parameter3: Byte;
                       Parameter4: Byte;
                     end;

      TPhysicalInputs  = Array [1..128] of Byte;
      TPhysicalOutputs = Array [1.. 64] of Byte;
      TSkippedInputs   = Array [0.. 15] of Byte;

      TLed = (ledOff, ledRed, ledGreen, ledYellow);

      TCable = (cableRG11, cableRG59, cableOther);

      TCableLength = (m50, m100, m150, m200, m250, m300, m350, m400, m450, m500);

Const LedBit_Red   = $01;
      LedBit_Green = $02;

      eaNoAction                 = $FF;

      eaConnectVideoInput        = 0;   { Output: 1..64            Input: 1..64                                                       }
      eaCopyVideoInput           = 1;   { SourceOutput: 1..64      DestinationOutput: 1..64    Shift: 0..255         LastInput: 1..64 }
      eaCopyScreen               = 2;   { SourceOutput: 1..64      DestinationOutput: 1..64                                           }
      eaSwapScreens              = 3;   { FirstOutput: 1..64       SecondOutput: 1..64                                                }
      eaSetVideoInputsWindow     = 4;   { StartOutput: 1..64       EndOutput: 1..64            StartIntput: 1..64    LastInput: 1..64 }
      eaShiftVideoInputsWindow   = 5;   { StartOutput: 1..64       EndOutput: 1..64            Shift: 0..255         LastInput: 1..64 }

      eaBeeperON                 = 6;
      eaBeeperOFF                = 7;
      eaBeeperToggle             = 8;

      eaKeyboardAlarmON          = 9;
      eaKeyboardAlarmOFF         = 10;
      eaKeyboardAlarmToggle      = 11;

      eaExecuteMacro             = 12;  { Macro: 1..8 }
      eaExecuteInputMacro        = 13;  { Input: 1..64 }
      eaExecuteTimerMacro        = 14;  { Timer: 1..8 }

      eaTimerON                  = 15;  { Timer: 1..8, Time 1..255 (s10, s, min) }
      eaTimerOFF                 = 16;  { Timer: 1..8 }
      eaTimerToggle              = 17;  { Timer: 1..8, Time 1..255 (s10, s, min) }

      eaDigitalOutputON          = 18;  { Output: 1..16 }
      eaDigitalOutputOFF         = 19;  { Output: 1..16 }
      eaDigitalOutputToggle      = 20;  { Output: 1..16 }

      eaEnableDigitalInput       = 21;  { Input: 1..64 }
      eaDisableDigitalInput      = 22;  { Input: 1..64 }

      eaClearScreen              = 23;  { Output: 1..64 }

      eaWrite_ALARM              = 24;  { Output: 1..64, Y: 1..12, X: 1..30 }
      eaWriteTime                = 25;  { Output: 1..64, Y: 1..12, X: 1..30 }
      eaWriteDate                = 26;  { Output: 1..64, Y: 1..12, X: 1..30 }
      eaWriteInputNumber         = 27;  { Output: 1..64, Y: 1..12, X: 1..30 }
      eaWriteOutputNumber        = 28;  { Output: 1..64, Y: 1..12, X: 1..30 }
      eaWriteVideoInputPosition  = 29;  { Output: 1..64, Y: 1..12, LastInput: 1..64 }
      eaWriteDigitalInputName    = 30;  { Output: 1..64, Y: 1..12, Input: 1..64 }
      eaWriteVideoInputName      = 31;  { Output: 1..64, Y: 1..12, Input: 1..128 }

      eaWriteToLogFile           = 32;  { Event Number }

      eaClearVariables           = 33;  { First Var Number: 1..256, Last Var Number: 1..256 }
      eaSetVariable              = 34;  { Var Number: 1..256, Value: 0..255 }
      eaIncVariable              = 35;  { Var Number: 1..256 }
      eaDecVariable              = 36;  { Var Number: 1..256 }
      eaToggleVariable           = 37;  { Var Number: 1..256 }

      eaExitIfVariableEqual      = 38;  { Var Number: 1..256, Value: 0..255 }
      eaExitIfVariableNotEqual   = 39;  { Var Number: 1..256, Value: 0..255 }
      eaExitIfVariableGreater    = 40;  { Var Number: 1..256, Value: 0..255 }
      eaExitIfVariableLower      = 41;  { Var Number: 1..256, Value: 0..255 }
      eaSkipIfVariableEqual      = 42;  { Var Number: 1..256, Value: 0..255 }
      eaSkipIfVariableNotEqual   = 43;  { Var Number: 1..256, Value: 0..255 }
      eaSkipIfVariableGreater    = 44;  { Var Number: 1..256, Value: 0..255 }
      eaSkipIfVariableLower      = 45;  { Var Number: 1..256, Value: 0..255 }

      NumberOfAvailableActions   = 46;


      cfDataEnd               = cfResetHW;

      cfInitEEPROMModuleData  = cfResetHW;
      cfInitEEPROMSettings    = cfResetHWToEEPROM;

      cfSendCmd_FrameData     = cfSpare;
      cfWriteDemoCounter      = cfSpare2;
      cfUpdateDateTime        = cfResetHWToEEPROM;
      cfNoDelayForBroadcast   = cfResetHW;
      cfEraseAlarmEvents      = cfWriteToHW;

      cfWriteOutputs          = cfSpare;
      cfWriteOutputsToEEPROM  = cfSpare2;

      cfFoundModules          = cfReadFromHW;      { $01 }
      cfModuleGateways        = cfReadFromEEPROM;  { $02 }
      cfRefreshModules        = cfResetHWToEEPROM; { $10 }
      cfDefaultModules        = cfSpare;           { $40 }
      cfOriginalAddresses     = cfSpare2;          { $80 }

      cfFoundLocalModules     = cfFoundModules;       { $01 }
      cfFoundRemoteModules    = cfDefaultModules;     { $40 }
      cfRemoteOriginalAddr    = cfOriginalAddresses;  { $80 }
      cfLocalOriginalAddr     = cfResetHW;            { $20 }

      cfLoopTest              = cfReadFromHW;
      cfCommTest              = cfReadFromEEPROM;
      cfStatus                = cfWriteToHW;

      cfSendIO                = cfSpare;

      cfLink                  = cfSpare;

      cfInitLoop              = cfSpare;

      cfTestRemoteModule      = cfSpare;

      cfReadPresetFromEEPROMAndSetHW  = cfSpare;

      cfHourLimits            = cfSpare;

      cfResetCounters         = cfResetHWToEEPROM;

      cfLoopBack              = cfSpare;

      cfVideoTexts            = cfSpare;
      cfPortTexts             = cfSpare2;

      cfUserTextArray         = cfSpare;

      stReset                 = $00;
      stVideoInput            = $01;
      stLink                  = $02;

      Attenuations: Array [TCable, TCableLength] of Byte = (
       ( 5, 11, 16, 22, 27, 33, 38, 44, 49,  55),
       (11, 22, 33, 44, 55, 66, 77, 88, 99, 110),
       (10, 20, 30, 40, 50, 60, 70, 80, 90, 100));

      SizeOf_TCmd_ModuleData = $2C;

Type  TData32       = Array [0..$1F] of Byte;
      TData128      = Array [0..$7F] of Byte;
      TExtendedData = Array [0..$4F] of Byte;

      TBlockData     = packed Record
                         StartByte:                        Byte;             { $00 }
                         PacketSize:                       Byte;             { $01 }
                         Checksum:                         Byte;             { $02 }
                         DestinationAddress:               Byte;             { $03 }
                         DestinationAddress_Frame:         Byte;             { $04 }
                         SourceAddress:                    Byte;             { $05 }
                         SourceAddress_Frame:              Byte;             { $06 }
                         OriginalAddress:                  Byte;             { $07 }
                         GatewayAddress:                   Byte;             { $08 }
                         Command:                          Byte;             { $09 }
                         CommandFlags:                     TCommandFlagsSet; { $0A }
                         Spare:                            Byte;             { $0B }
                       end;

      TGeneralPacket = packed Record
                         StartByte:                        Byte;             { $00 }
                         PacketSize:                       Byte;             { $01 }
                         Checksum:                         Byte;             { $02 }
                         DestinationAddress:               Byte;             { $03 }
                         DestinationAddress_Frame:         Byte;             { $04 }
                         SourceAddress:                    Byte;             { $05 }
                         SourceAddress_Frame:              Byte;             { $06 }
                         OriginalAddress:                  Byte;             { $07 }
                         GatewayAddress:                   Byte;             { $08 }
                         Command:                          Byte;             { $09 }
                         CommandFlags:                     TCommandFlagsSet; { $0A }
                         Spare:                            Byte;             { $0B }
                         Data:                             TData32;          { $0C }
                       end;

      TGeneralPacket128 = packed Record
                            StartByte:                Byte;             { $00 }
                            PacketSize:               Byte;             { $01 }
                            Checksum:                 Byte;             { $02 }
                            DestinationAddress:       Byte;             { $03 }
                            DestinationAddress_Frame: Byte;             { $04 }
                            SourceAddress:            Byte;             { $05 }
                            SourceAddress_Frame:      Byte;             { $06 }
                            OriginalAddress:          Byte;             { $07 }
                            GatewayAddress:           Byte;             { $08 }
                            Command:                  Byte;             { $09 }
                            CommandFlags:             TCommandFlagsSet; { $0A }
                            Spare:                    Byte;             { $0B }
                            Data:                     TData128;         { $0C }
                          end;

      TExtendedGeneralPacket = packed Record
                                 StartByte:                Byte;             { $00 }
                                 PacketSize:               Byte;             { $01 }
                                 Checksum:                 Byte;             { $02 }
                                 DestinationAddress:       Byte;             { $03 }
                                 DestinationAddress_Frame: Byte;             { $04 }
                                 SourceAddress:            Byte;             { $05 }
                                 SourceAddress_Frame:      Byte;             { $06 }
                                 OriginalAddress:          Byte;             { $07 }
                                 GatewayAddress:           Byte;             { $08 }
                                 Command:                  Byte;             { $09 }
                                 CommandFlags:             TCommandFlagsSet; { $0A }
                                 Spare:                    Byte;             { $0B }
                                 Data:                     TExtendedData;    { $0C }
                               end;

      TSerialNumber       = String [SerialNumberLength];
      TComment            = String [CommentLength];
      TModuleName         = String [ModuleNameLength];
      TLocationName       = String [LocationNameLength];
      TSourceName         = String [SourceNameLength];
      TSourceDescription  = String [SourceDescriptionLength];
      TInputName          = String [InputNameLength];
      TUserText           = String [UserTextLength];
      TUserText1          = String [UserTextLength1];
      TUserText2          = String [UserTextLength2];
      T4                  = String [4];
      T10                 = String [10];

      TADC = Array [0..7] of Word;

      TDAC = Array [0..7] of Byte;

      TDAC12       = Array [1..12] of Byte;
      TVideoBuffer = Array [1..3] of Byte;

      TSetupData = packed Record
                     DAC: TDAC;
                     Switches: Byte;
                   end;

      TSetup = Array [0..8] of TSetupData;

      TEEPROMBlock = Array [0..15] of Byte;

      TRemoteSlots = Array [1..16] of Byte;

      TModules    = Array [0..$1F] of TModuleType;
      TModulesExt = Array [0..MaxModuleAddress] of TModuleType;

      TOutputs = Array [1..8] of Byte;

      TOutputsArray = Array [1..8] of TOutputs;

      TInputSyncs = Array [1..32] of Byte;

      TCameraAddressArray = Array [0..31] of Byte;

      TSequenceDataFlags = (sdFlagsOnly, sdRunning);

      TSetOfSequenceDataFlags = Set of TSequenceDataFlags;

      TSequenceData = packed Record
                        sdSequenceInputs:  Byte;
                        sdSequenceOutputs: Byte;
                        sdSequenceTime:    Byte;
                        sdFlags:           TSetOfSequenceDataFlags;
                      end;

      TOsdFlags = (ofDate, ofTime, ofInputNumber, ofOutputNumber, of_ALARM, ofCameraPosition, ofDigitalInputName, ofVideoInputName);

      TICMMode = (FOM2_Local, FOM2_Remote, COM2, SAD2, COM4);

      TICMPortFlags = (pfEnabled1, pfEnabled2, pfEnabled3, pfEnabled4, pfFullDuplex1, pfFullDuplex2, pfFullDuplex3, pfFullDuplex4);

      TICMPortFlagsSet = Set of TICMPortFlags;

      TICMPortFlags2 = (pfEnabledExtRS485,     pfEnabledExtOptics,   pfSingleEndedLoop,        pfNoDelayAfterExtBroadcast,
                        pfDisabledIntRS485_RX, pfDisabledIntRS485_5);

      TICMPortFlagsSet2 = Set of TICMPortFlags2;

      TOsdFlagsSet = Set of TOsdFlags;

      TYX = packed Record
              Y: Byte;
              X: Byte;
            end;

      TOsdDataOutput = Array [ofDate..ofVideoInputName] of TYX;

      TOsdDataOutputs = Array [1..64] of TOsdDataOutput;

      TOsdDataModule = Array [0..7] of TOsdDataOutput;

      TOsdDataModules = Array [0..7] of TOsdDataModule;

      TDateTime = packed Record
                    dtTimeSec100: Byte;
                    dtTimeSec:    Byte;
                    dtTimeMin:    Byte;
                    dtTimeHour:   Byte;
                    dtDateDay:    Byte;
                    dtDateMonth:  Byte;
                    dtDateYear:   Byte;
                  end;

      TAlarmEvent = packed Record
                      aeInput:       Byte;
                      aeDateTime:    TDateTime;
                      aeInputName:   TInputName;
                    end;


      TCodec = packed Record
                 adLeftLineInputChannelVolumeControl:  Word;
                 adRightLineInputChannelVolumeControl: Word;
                 adLeftChannelHeadphoneVolumeControl:  Word;
                 adRightChannelHeadphoneVolumeControl: Word;
                 adAnalogAudioPathControl:             Word;
                 adDigitalAudioPathControl:            Word;
                 adPowerDownControl:                   Word;
                 adDigitalAudioInterfaceFormat:        Word;
                 adSampleRateControl:                  Word;
                 adDigitalInterfaceActivation:         Word;
               end;

      TTEA6415 = Array [0..5] of Byte;

      TCmd_ModuleData = packed Record
                          mdBlockData:       TBlockData;    { $00  0 }
                          mdModuleType:      TModuleType;   { $0C 12 }
                          mdModuleFlags:     Byte;          { $0D 13 }
                          mdFirmwareVersion: Word;          { $0E 14 }
                          mdSerialNumber:    TSerialNumber; { $10 16 }
                          mdComment:         TComment;      { $1D 29 }

                          mdtemperature:     Word;                 { $2C 44, only where C8051F020 }
                          Case Byte of
                            0: (mdRandomNumber:    Word;           { $2E 46, only for VCS64-CPU }
                                mdDemoCounter:     Word;           { $30 48, only for VCS64-CPU }
                                mdADC:             TADC);          { $32 50, only for COM }
                            1: (mdModuleName:         TModuleName; { $2E 46, only for OVS4-45 }
                                mdLocationName:       TLocationName;
                                mdRemoteTemperature:  Array [1..4] of Word;
                                mdLinkState:          Byte;
                                mdVideoAcState:       Byte;
                                mdVideoStates:        Byte;  { 4B 4A 3B 3A 2B 2A 1B 1A }
                                mdPeerAddress:        Byte;
                                mdAvailableLinks:     Byte); {  xxxx4321 }
                        end;

      TCmd_ModuleDataTime = packed Record
                              mdBlockData:       TBlockData;    { $00  0 }
                              mdDateTime:        TDateTime;     { $0C 12 }
                              mdtRandomNumber:   Word;          { $13 19 }
                              mdtDemoCounter:    Word;          { $13 19 }
                            end;

      TCmd_SetupData = packed Record
                         sdBlockData: TBlockData;  { $00  0 }
                         sdSetup:     Byte;        { $0C 12 }
                         sdSetupData: TSetupData;  { $0D 13 }
                       end;

      TCmd_SourceNameAndFlags = packed Record
                                  hdBlockData:       TBlockData;
                                  hdSourceName:      TSourceName;
                                  hdMiscFlags:       Byte;
                                end;

      TCmd_SourceDescription = packed Record
                                 hdBlockData:         TBlockData;
                                 hdSourceDescription: TSourceDescription;
                               end;

      TCmd_RemoteSlots = packed Record
                           hdBlockData:       TBlockData;
                           hdModeFlags:       Byte;
                           hdRemoteSlots:     TRemoteSlots;
                         end;

      TCmd_Outputs = packed Record
                       hdBlockData:       TBlockData;
                       hdOutputs:         TOutputs;
                       hdOutputSyncs:     Byte;
                     end;

      TCmd_AllOutputs = packed Record
                          hdBlockData:       TBlockData;
                          hdOutputsArray:    TOutputsArray;
                        end;

      TCmd_InputSyncs = packed Record
                          hdBlockData:       TBlockData;
                          hdInputSyncs:      TInputSyncs;
                        end;

      TCmd_EEPROM = packed Record
                      eeBlockData:       TBlockData;    { $00  0 }
                      eeData:            TEEPROMBlock;  { $0C 12 }
                      eeAddress:         Word;          { $1C 22 }
                      eeSize:            Word;          { $1E 24 }
                      eeDataSize:        Word;          { $20 26 }
                    end;

      TCmd_Message = packed Record
                       msBlockData:       TBlockData;  { $00 }
                       msByte0:           Byte;        { $0C }
                       msByte1:           Byte;
                       msWord0:           Word;
                       msWord1:           Word;
                       msLongInt0:        LongInt;
                       msLongInt1:        LongInt;
                     end;

      TCmd_FrameData = packed Record
                         msBlockData:      TBlockData;
                         msModules:        TModules;
                       end;

      TCmd_FrameDataExt = packed Record
                            msBlockData:      TBlockData;
                            msModulesExt:     TModulesExt;
                          end;

      TCmd_SequenceData = packed Record
                            sdBlockData:    TBlockData;
                            sdSequenceData: TSequenceData;
                          end;

      TCmd_Protocols = packed Record
                         prBlockData: TBlockData;
                         prProtocols: TProtocolsSet;
                       end;

      TCmd_IOData = packed Record
                      ioBlockData: TBlockData;
                      ioNCNO:      TIOData;
                      ioEnabled:   TIOData;
                      ioInData:    TInData;
                      ioOutData:   TOutData;
                    end;

      TCmd_EventActions = packed Record
                            eaBlockData: TBlockData;
                            eaEvent: Byte;
                            eaEventActions: TEventActions;
                          end;

      TCmd_OsdData = packed Record
                       odBlockData: TBlockData;
                       odOsdData:   TOsdDataModule;
                     end;

      TCmd_AlarmEvent = packed Record
                          aeBlockData:   TBlockData;   { $00   0 }
                          aeEventNumber: Byte;         { $0C  12 }
                          aeAlarmEvent:  TAlarmEvent;  { $0D  13 }
                        end;                           { $27  39 }

      TCmd_DigitalInputName = packed Record
                                diBlockData: TBlockData;   { $00    0 }
                                diInput:     Byte;         { $0C   12 }
                                diInputName: TInputName;   { $0D   13 }
                              end;

      TCmd_VideoInputName = packed Record
                              viBlockData: TBlockData;   { $00    0 }
                              viInput:     Byte;         { $0C   12 }
                              viInputName: TInputName;   { $0D   13 }
                            end;

      TCmd_PhysicalInputs = packed Record
                              piBlockData:       TBlockData;
                              piPhysicalInputs:  TPhysicalInputs;
                            end;

      TCmd_PhysicalOutputs = packed Record
                               poBlockData:       TBlockData;
                               poPhysicalOutputs: TPhysicalOutputs;
                               poSkippedInputs:   TSkippedInputs;
                             end;

      TCmd_Video_IO = packed Record
                        ioBlockData: TBlockData;
                        ioTEA6415:   TTEA6415;
                      end;

      TCmd_IO = packed Record
                  ioBlockData: TBlockData;
                  ioInputs:  Byte;       { bit 3 = in1,  bit 2 = in2,  bit 1 = in3,  bit 0 = in4 }
                  ioOutputs: Byte;       { bit 3 = out1, bit 2 = out2, bit 1 = out3, bit 0 = out4 }
                end;

      TCmd_ModuleAddress = packed Record
                             caBlockData: TBlockData;
                             caAddress:   Byte;
                           end;

      TCmd_SerialPorts = packed Record
                           spBlockData:             TBlockData;
                           spMode:                  TICMMode;                    { Not used anymore }
                           spPortFlags:             TICMPortFlagsSet;
                           spPortFlags2:            TICMPortFlagsSet2;
                           spOVS4_41_Address:       Byte;                         { Not used anymore, only for ICM }
                         end;

      TCmd_CameraIO = packed Record
                   cioBlockData: TBlockData;
                   cioAC:        Byte;       { bit 3 = Camera 1, bit 2 = Camera 2, bit 1 = Camera 3, bit 0 = Camera 4 }
                   cioReset:     Byte;       { bit 3 = Camera 1, bit 2 = Camera 2, bit 1 = Camera 3, bit 0 = Camera 4 }
                 end;

      TCmd_TestMode = packed Record
                       tmBlockData: TBlockData;
                       tmParameter: Byte;
                       tmValue0:    Byte;
                       tmValue1:    Byte;
                       tmValue2:    Byte;
                       tmValue3:    Byte;
                       tmValue4:    Byte;
                       tmValue5:    Byte;
                       tmValue6:    Byte;
                       tmValue7:    Byte;
                      end;

      TCmd_ICM_Mode = packed Record
                        icmBlockData:         TBlockData;
                        icmMode:              TICMMode;
                        icmOVS4_41_Address:   Byte;
                        icmOVS4_41_CheckTime: Byte;
                        icmValue2:            Byte;
                        icmValue3:            Byte;
                        icmValue4:            Byte;
                        icmValue5:            Byte;
                        icmValue6:            Byte;
                        icmValue7:            Byte;
                      end;

      TCmd_CameraAddresses = packed Record
                               caBlockData: TBlockData;
                               caAddresses: TCameraAddressArray;
                             end;

      TCmd_AudioSetup = packed Record
                          asBlockData: TBlockData;
                          asModeFlags:  Byte;
                          asMiscFlags1: Byte;
                          asSpareWord:  Word;
                          asCodec1:     TCodec;
                          asCodec2:     TCodec;
                        end;

      TCmd_VID5_Setup = packed Record
                          vsBlockData:      TBlockData;
                          vsDAC:            TDAC12;
                          vsVideoBuffer:    TVideoBuffer;
                          vsCableAndLength: Byte;                    { [0..2, 0..9], $F0 = direct data }
                          vsAttenuation:    Byte;
                          vsFlags1:         Byte;
                          vsFlags2:         Byte;
                        end;

      TCmd_VideoSetup = packed Record
                          vsBlockData:      TBlockData;
                          vsDAC:            TDAC12;
                          vsVideoBuffer1:   TVideoBuffer;
                          vsVideoBuffer2:   TVideoBuffer;
                          vsFlags1:         Byte;
                          vsFlags2:         Byte;
                        end;

      TVID8X8Flags = (flAuto, flAuxEnabled, flAlarmsEnabled, flAlarmActive);

      TVID8X8FlagsSet = Set Of TVID8X8Flags;

      TOutputData = Array [1..9] of Byte;
      TClamp      = Array [$1D..$1E] of Byte;

      TCmd_VID8X8_Setup = packed Record
                            vsBlockData:      TBlockData;
                            vsOutputs:        TOutputData;
                            vsClamp:          Array [$1D..$1E] of Byte;
                            vsOutputsAuxData: Array [1..8] of Byte;   { $00 to pass input in vsOutputs, 1..12 to switch to any other logical input when sync lost (AUX1 = 9, AUX2 = 10, AUX3 = 11, AUX4 = 12}
                            vsFlags:          TVID8X8FlagsSet;
                            vsInputs:         Word;
                            vsAlarmsIn:       Word;
                            vsAlarmsOut:      Byte;
                          end;

      TOVS4_45_Flags = (ofDataPortOn, ofDataPort0, ofCamera1, ofCamera2, ofCamera3, ofCamera4);

      TOVS4_45_FlagsSet = Set of TOVS4_45_Flags;

      TOVS4_45_StatusFlags = (sfIO_Module, sfPeerIO_Module, sfAudioModule, sfPeerAudioModule, sfRF_Module);

      TOVS4_45_StatusFlagsSet = Set of TOVS4_45_StatusFlags;

      TDigitalOutputMode = (omOff, omOn,
                            omLocalOverTemperature, omLocalUnderTemperature,
                            omRemoteOverTemperature, omRemoteUnderTemperature,
                            omPeerLink, omNoPeerLink,
                            omLocalIn1, omLocalIn2, omLocalIn3, omLocalIn4,
                            omRemoteIn1, omRemoteIn2, omRemoteIn3, omRemoteIn4,
                            omPeerLocalIn1, omPeerLocalIn2, omPeerLocalIn3, omPeerLocalIn4,
                            omPeerRemoteIn1, omPeerRemoteIn2, omPeerRemoteIn3, omPeerRemoteIn4,
                            omVideo1, omVideo2, omVideo3, omVideo4,
                            omNoVideo1, omNoVideo2, omNoVideo3, omNoVideo4, omAnyNoVideo,
                            omLock1, omLock2, omLock3, omLock4,
                            omNoLock1, omNoLock2, omNoLock3, omNoLock4, omAnyNoLock,
                            omAudioIn1, omAudioIn2, omAudioIn3, omAudioIn4,
                            omLoadVoltageWithinLimits, omLoadVoltageOutOfLimits,
                            omLoadCurrentWithinLimits, omLoadCurrentOutOfLimits,
                            omRFPowerWithinLimits, omRFPowerOutOfLimits);

      TVideoOutputRouting = (vrOff, vrInputA, vrInputB, vrTest, vrInputA_Off, vrInputA_B, vrInputA_Test, vrInputB_Off, vrInputB_A, vrInputB_Test);

      TCmd_OVS4_45_Setup = packed Record
                             osBlockData:                  TBlockData;
                             osFlags:                      TOVS4_45_FlagsSet;
                             osStatusFlags:                TOVS4_45_StatusFlagsSet;
                             osDigitalInputs:              Byte; { Local 4321 - Remote 4321 }
                             osDigitalInputsType:          Byte; { Local 4321 - Remote 4321, 0 = NO, 1 = NC}
                             osPeerDigitalInputs:          Byte; { Local 4321 - Remote 4321 }
                             osDigitalOutputMode:          Array [1..8] of TDigitalOutputMode;  { 1..4 = local, 5..8 = remote }
                             osDigitalOutputs:             Byte; { Local 4321 - Remote 4321 }
                             osLocalTemperatureThreshold:  Word;
                             osRemoteTemperatureThreshold: Word;
                             osVideoOutputFlags:           Array [1..8] of Byte;
                             osVideoOutputRouting:         Array [1..8] of TVideoOutputRouting;
                             osDigitalInputCounter:        Array [1..8] of Byte;
                           end;

      TUARTFlags = (ufRxDisabled, ufLoopBack, ufLoopBackRS485, ufHalfDuplex, ufRS485_RS422);

      TUARTFlagsSet = Set of TUARTFlags;

      TUART = packed Record
                uaBaudRateDivisor:     Word;           { 115200 / Baud rate }
                uaLineControlRegister: Byte;           { Parity, Stop bits, Word length, bits 5..0 }
                uaFlags:               TUARTFlagsSet;
              end;

      TUART_IMC = packed Record
                    iuBaudRate:        Word;             { BaudRate / 100 }
                    iuUartMode:        Byte;             { Parity, Stop bits, Word length }
                    iuUartFlags:       TUARTFlagsSet;    { ufRxDisabled, ufLoopBack, ufLoopBackRS485 }
                    iuUartProtocols:   TProtocols2Set;
                    iuUartDestinationAddress_Frame: Byte;
                    iuUartDestinationAddress:       Byte;
                    iuUartDestinationPort:          Byte;
                  end;

      TCmd_UART_Setup = packed Record
                          osBlockData:      TBlockData;
                          osUART:           Array [1..4] of TUART;
                          osProtocols:      Array [1..4] of TProtocols2Set;
                        end;

      TTransportFlags = (tfPC1, tfPC2, tfPC3, tfPC4, tfDataLink, tfIO_Module, tfAudioModule);

      TTransportFlagsSet = Set Of TTransportFlags;

      TCmd_UART_Transport = packed Record
                              utBlockData:     TBlockData;
                              utFlags:         TTransportFlagsSet;
                              utDigitalInputs: Byte;
                              utAddress:       Byte;
                              utDataSize:      Byte;
                              utSize:          Array [1..4] of Byte;
                              utData:          Array [0..0] of Byte;
                            end;

      TCmd_UART_Test = packed Record
                         utBlockData:          TBlockData;
                         utLoopBackTestResult: Byte;   { RS485 4321, UART 4321 }
                         utAvailableLinks:     Byte;   { RS485 4321, UART 4321 }
                       end;

      TLinkFlags = (lfConnectedLink1, lfConnectedLink2, lfConnectedLink3, lfConnectedLink4, lf);

      TLinkFlagsSet = Set Of TLinkFlags;

      TCmd_LinkData =  packed Record
                         lnBlockData:          TBlockData;
                         lnLinkFlags:          TLinkFlagsSet;
                         lnLinkName:           Array [1..4] of TLocationName;
                       end;

      TCmd_UserText = packed Record
                        utBlockData:          TBlockData;
                        utUserText:           TUserText;
                      end;

      TCmd_ModuleInfo = packed Record
                          utBlockData:         TBlockData;
                          miModuleName:        TModuleName;
                          miSerialNumber:      TSerialNumber;
                          miPartNumber:        TSerialNumber;
                          miRMANumber:         TSerialNumber;
                          miHardwareVersion:   T4;
                          miBoardVersion:      T4;
                          miTestHistory:       T4;
                          miDate:              T10;
                        end;

      TCmd_UserTexts = packed Record
                         utBlockData:         TBlockData;
                         utGroup:             Byte;
                         utSystemName:        TLocationName;
                         utSystemLocation:    TLocationName;
                         utLinkInfo:          TLocationName;
                         utUserText:          TLocationName;
                       end;

      TSPDIF_Flags = (sfLock);

      TSPDIF_FlagsSet = Set of TSPDIF_Flags;

      TCmd_SPDIF = packed Record
                     siBlockData:           TBlockData;
                     siFlags:               TSPDIF_FlagsSet;
                     siDigitalInputsType:   Byte; { xxxx - Remote 4321, 0 = NO, 1 = NC}
                     siDigitalInputs:       Byte; { xxxx - Remote 4321 }
                     siDigitalInputCounter: Array [1..4] of Byte;
                     siDigitalOutputMode:   Array [1..4] of TDigitalOutputMode;
                     siDigitalOutputs:      Byte; { xxxx - Remote 4321 }
                     siInputGain:           Word;
                     siOutputVolume:        Word;
                   end;

      TCmd_OVS4_45_RF = Record
                          rfBlockData:    TBlockData;
                          rfRegisters:    Array [$00..$16] of Word;
                          rfAttenuator:   Byte;
                          rfMeasureAtt:   Byte;
                          rfLevel:        Word;
                          rfADC1:         Word;
                          rfADC2:         Word;
                          rfADC3:         Word;
                          rfRFLowerLimit: Word;
                          rfRFUpperLimit: Word;
                          Spare0:         Word;
                          Spare1:         Word;
                        end;

      TSFP_Data = Array [0..63] of Byte;

      TCmd_SFP = Record
                   sfpBlockData: TBlockData;
                   sfpAddress:   Word;
                   sfpSize:      Byte;
                   sfpData:      TSFP_Data;
                 end;

      TUIFlags = (uifOutputEnabled);
      TUIFlagsSet = Set of TUIFlags;

      TFanFlags = (uifManual, uifManualState, uifManual1, uifManualState1, uifManual2, uifManualState2, uifManual3, uifManualState3);
      TFanFlagsSet = Set of TFanFlags;

      TFanStatus = (uifFanFault, uifFanFault1, uifFanFault2, uifFanFault3, uifFanWarning, uifFanWarning1, uifFanWarning2, uifFanWarning3);
      TFanStatusSet = Set of TFanStatus;

      TLimits = Record
                  limShutdownUpperLimit: Byte;
                  limShutdownLowerLimit: Byte;
                  limWarningUpperLimit:  Byte;
                  limWarningLowerLimit:  Byte;
                end;

      TCmd_UI = Record
                  uiBlockData:    TBlockData;
                  uiFlags:        TUIFlagsSet;
                  uiFanFlags:     TFanFlagsSet;
                  uiRegisters:    Array [$00..$05] of Word;
                  uiADC:          Word;
                  uiFanRpm:       Array [0..3] of Word;
                  uiFanDutyCycle: Array [0..3] of Byte;
                  uiFanStatus:    TFanStatusSet;
                  uiVoltage:      TLimits;
                  uiCurrent:      TLimits;
                  uiTemperature:  TLimits;
                end;

      TRegister = Record
                    Number: Byte;
                    Data:   Byte;
                  end;

      TCmd_Registers = Record
                         regBlockData:         TBlockData;
                         regID:                Byte;
                         regNumberOfRegisters: Byte;
                         regRegister:          Array [$00..MAX_Cmd_Registers - 1] of TRegister;
                       end;

      TCmd_Hours = Record
                     regBlockData:         TBlockData;
                     hComponentHours:      Array [0..7] of LongInt;
                     hEnabledFlags:        Byte;
                     hWriteFlags:          Byte;
                   end;

      TCommCounters_UART = Record
                             ccReceivedBytes:        LongInt;
                             ccReceivedByteErrors:   LongInt;
                             ccReceivedPackets:      LongInt;
                             ccReceivedPacketErrors: LongInt;
                             ccProcessedPackets:     LongInt;
                             ccTransmittedBytes:     LongInt;
                             ccTransmittedPackets:   LongInt;
                           end;

      TCmd_CommCounters = Record
                            ccBlockData:    TBlockData;
                            ccCounter:      Array [0..3] of TCommCounters_UART;
                          end;

      TTransceiverFlags = (trfSFP, trfSingleFiber, trfLaserTypeDFB);
      TTransceiverFlagsSet = Set of TTransceiverFlags;

      TCmd_Transceiver = Record
                           trBlockData:          TBlockData;
                           trTransceiverFlags:   TTransceiverFlagsSet;
                           trTransceiverGroup:   Byte;
                           trInterfaceConnector: Byte;
                           trTypicalBaudrate:    Byte;
                           trLaserWavelength:    Word;
                           trLinkLength_9um:     Byte;  { km }
                           trLinkLength_50um:    Byte;  { 10 m }
                           trLinkLength_62um:    Byte;  { 10 m }
                           trTXOutputPower:      Word;  { 0.1 uW }
                           trRXReceivedPower:    Word;  { 0.1 uW }
                           trWDMFilterIsolation: Byte;  { dB }
                           trCrosstalk:         Byte;  { dB }
                           trUserText:           TLocationName;
                         end;



      TOutputFunction = (osOff, osOn, osInput1, osInput2, osPeerInput1, osPeerInput2, osPeerOutput, osVideo1, osVideo2, osVideo3, osVideo4, osAllVideos, osOpticalLink);
      TIOFlags = (iofInput1Inverted, iofInput2Inverted, iofOutputInverted, iofInput1State, iofInput2State, iofOutputState, iofCommBridge);
      TIOFlagsSet = Set of TIOFlags;

      TCmd_IMC_Video =   Record
                           ivBlockData:          TBlockData;
                           ivADC12:              Word;
                           ivADC34:              Word;
                           ivVideoADC:           Array [1..4] of Byte;
                           ivVideoADC_Peer:      Array [1..4] of Byte;
                           ivFlags:              TIOFlagsSet;
                           ivOutputFunction:     TOutputFunction;
                         end;
Const

UART_CONFIG_WLEN_MASK   = $60;  // Mask for extracting word length
UART_CONFIG_WLEN_8      = $60;  // 8 bit data
UART_CONFIG_WLEN_7      = $40;  // 7 bit data
UART_CONFIG_WLEN_6      = $20;  // 6 bit data
UART_CONFIG_WLEN_5      = $00;  // 5 bit data
UART_CONFIG_STOP_MASK   = $08;  // Mask for extracting stop bits
UART_CONFIG_STOP_ONE    = $00;  // One stop bit
UART_CONFIG_STOP_TWO    = $08;  // Two stop bits
UART_CONFIG_PAR_MASK    = $86;  // Mask for extracting parity
UART_CONFIG_PAR_NONE    = $00;  // No parity
UART_CONFIG_PAR_EVEN    = $06;  // Even parity
UART_CONFIG_PAR_ODD     = $02;  // Odd parity
UART_CONFIG_PAR_ONE     = $86;  // Parity bit is one
UART_CONFIG_PAR_ZERO    = $82;  // Parity bit is zero

Type

      TCmd_IMC_UART =    Record
                           iuBlockData:          TBlockData;
                           iuUART:               Array [0..0] of TUART_IMC;
                         end;

