; Turbo51 version 0.0.0.13, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_DATA         SEGMENT  DATA
_XDATA        SEGMENT  XDATA
_BIT          SEGMENT  BIT

              PUBLIC   EEPROM_Timer
              PUBLIC   NoEEPROM
              PUBLIC   AddressW
              PUBLIC   Value
              PUBLIC   AddressR
              PUBLIC   EepromAddressW
              PUBLIC   SourceAddress
              PUBLIC   CountW
              PUBLIC   EepromAddressXW
              PUBLIC   SourceAddressX
              PUBLIC   CountWX
              PUBLIC   EepromAddressR
              PUBLIC   DestinationAddress
              PUBLIC   CountR
              PUBLIC   EepromAddressXR
              PUBLIC   DestinationAddressX
              PUBLIC   CountRX

              PUBLIC   DelayAfterWrite
              PUBLIC   Check_EEPROM_Status
              PUBLIC   WriteByteToEEPROM
              PUBLIC   ReadByteFromEEPROM
              PUBLIC   WriteBytesToEEPROM
              PUBLIC   WriteXBytesToEEPROM
              PUBLIC   ReadBytesFromEEPROM
              PUBLIC   ReadXBytesFromEEPROM
              PUBLIC   E24C32

              EXTRN    CODE  (sysIncWord_XDATA)

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit E24C32;
; 
; {$IDATA }
; {$XDATA }
; 
; Interface
; 
; Const I2C_24C32 = $A0;

RSEG _CONST

; 
; Var EEPROM_Timer: Byte;

RSEG _DATA

EEPROM_Timer:                   DS       1

;     NoEEPROM: Boolean;

RSEG _BIT

NoEEPROM:                       DBIT     1

; 
; {$MP XDATA}
; 
; Procedure WriteByteToEEPROM    (AddressW: Pointer; Value: Byte);

RSEG _XDATA

AddressW:                       DS       2
Value:                          DS       1

; Function  ReadByteFromEEPROM   (AddressR: Pointer): Byte;

RSEG _DATA

ReadByteFromEEPROM_Result:      DS       1

RSEG _XDATA

AddressR:                       DS       2

; Procedure WriteBytesToEEPROM   (EepromAddressW: Pointer; SourceAddress: ShortPtr; CountW: Byte);
EepromAddressW:                 DS       2
SourceAddress:                  DS       1
CountW:                         DS       1

; Procedure WriteXBytesToEEPROM  (EepromAddressXW, SourceAddressX: Pointer; CountWX: Byte);
EepromAddressXW:                DS       2
SourceAddressX:                 DS       2
CountWX:                        DS       1

; Procedure ReadBytesFromEEPROM  (EepromAddressR: Pointer; DestinationAddress: ShortPtr; CountR: Byte);
EepromAddressR:                 DS       2
DestinationAddress:             DS       1
CountR:                         DS       1

; Procedure ReadXBytesFromEEPROM (EepromAddressXR, DestinationAddressX: Pointer; CountRX: Byte);
EepromAddressXR:                DS       2
DestinationAddressX:            DS       2
CountRX:                        DS       1

; 
; Implementation
; 
; Uses C51F020;
; 
; Const EEPROM_WriteDelay = 6;

RSEG _CONST

; 
; Procedure DelayAfterWrite;

USING 0

DelayAfterWrite:
; begin
;   EEPROM_Timer := EEPROM_WriteDelay;
              MOV       EEPROM_Timer, #6
              MOV       R2, #$A5

;   Repeat
L_0005:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until EEPROM_Timer = 0;
              MOV       A, EEPROM_Timer
              JNZ       L_0005

; end;
              RET

; 
; Procedure Check_EEPROM_Status;

Check_EEPROM_Status:
; begin
              MOV       R2, #$A5

;   Repeat
L_000E:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until not BUSY;
              JB        $C0.7, L_000E

; 
;   EEPROM_Timer := EEPROM_WriteDelay;
              MOV       EEPROM_Timer, #6
              MOV       R2, #$A5
              MOV       R3, #$A0

;   Repeat
L_001A:
;     WDTCN := $A5;
              MOV       $FF, R2

;     STA := True;
              SETB      $C0.5

; 
;     Repeat until SI;
L_001E:
              JNB       $C0.3, L_001E

;     STA := False;
              CLR       $C0.5

;     SMB0DAT := I2C_24C32;
              MOV       $C2, R3

;     SI := False;
              CLR       $C0.3

; 
;     Repeat until SI;
L_0027:
              JNB       $C0.3, L_0027

;     If SMB0STA = $18 then Exit;
              MOV       A, $C1
              XRL       A, #$18
              JZ        L_0036

;     SI := False;
              CLR       $C0.3

;   until EEPROM_Timer = 0;
              MOV       A, EEPROM_Timer
              JNZ       L_001A

; end;
L_0036:
              RET

; 
; Procedure WriteByteToEEPROM   (AddressW: Pointer; Value: Byte);

WriteByteToEEPROM:
; begin
;   If NoEEPROM then Exit;
              JB        NoEEPROM, L_0065

;   Check_EEPROM_Status;
              LCALL     Check_EEPROM_Status

;   SMB0DAT := Hi (AddressW);
              MOV       DPTR, #AddressW+1
              MOVX      A, @DPTR
              MOV       $C2, A

;   SI := False;
              CLR       $C0.3

; 
;   Repeat until SI;
L_0045:
              JNB       $C0.3, L_0045

;   SMB0DAT := Lo (AddressW);
              MOV       DPTR, #AddressW
              MOVX      A, @DPTR
              MOV       $C2, A

;   SI := False;
              CLR       $C0.3

; 
;   Repeat until SI;
L_0050:
              JNB       $C0.3, L_0050

; 
;   SMB0DAT := Value;
              MOV       DPTR, #Value
              MOVX      A, @DPTR
              MOV       $C2, A

;   SI := False;
              CLR       $C0.3

; 
;   Repeat until SI;
L_005B:
              JNB       $C0.3, L_005B

; 
;   STO := True;
              SETB      $C0.4

;   SI := False;
              CLR       $C0.3

;   DelayAfterWrite;
              LCALL     DelayAfterWrite

; end;
L_0065:
              RET

; 
; Function  ReadByteFromEEPROM  (AddressR: Pointer): Byte;

ReadByteFromEEPROM:
; begin
;   Case NoEEPROM of
;     True: ReadByteFromEEPROM := 0;
              JNB       NoEEPROM, L_006D
              MOV       R2, #0
              SJMP      L_00A4
L_006D:

;     else begin
;            Check_EEPROM_Status;
              LCALL     Check_EEPROM_Status

;            SMB0DAT := Hi (AddressR);
              MOV       DPTR, #AddressR+1
              MOVX      A, @DPTR
              MOV       $C2, A

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_0078:
              JNB       $C0.3, L_0078

;            SMB0DAT := Lo (AddressR);
              MOV       DPTR, #AddressR
              MOVX      A, @DPTR
              MOV       $C2, A

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_0083:
              JNB       $C0.3, L_0083

;            STA := True;
              SETB      $C0.5

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_008A:
              JNB       $C0.3, L_008A

;            STA := False;
              CLR       $C0.5

;            SMB0DAT := I2C_24C32 or $01;
              MOV       $C2, #$A1

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_0094:
              JNB       $C0.3, L_0094

;            AA := False;
              CLR       $C0.2

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_009B:
              JNB       $C0.3, L_009B

;            ReadByteFromEEPROM := SMB0DAT;
              MOV       R2, $C2

; 
;            STO := True;
              SETB      $C0.4

;            SI := False;
              CLR       $C0.3

;          end;
L_00A4:
;   end;
; end;
              MOV       A, R2
              RET

; 
; Procedure WriteBytesToEEPROM  (EepromAddressW: Pointer; SourceAddress: ShortPtr; CountW: Byte);

WriteBytesToEEPROM:
; begin
              MOV       R4, #$A5

;   While CountW <> 0 do
              SJMP      L_00DB
L_00AA:

;     begin
;       WDTCN := $A5;
              MOV       $FF, R4

;       WriteByteToEEPROM (EepromAddressW, MemIDATA [Byte (SourceAddress)]);
              MOV       DPTR, #EepromAddressW
              MOVX      A, @DPTR
              MOV       R2, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R3, A
              MOV       DPTR, #AddressW
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #SourceAddress
              MOVX      A, @DPTR
              MOV       R0, A
              MOV       DPTR, #Value
              MOV       A, @R0
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;       Inc (Word (EepromAddressW));
              MOV       DPTR, #EepromAddressW
              LCALL     sysIncWord_XDATA

;       Inc (Byte (SourceAddress));
              MOV       DPTR, #SourceAddress
              MOVX      A, @DPTR
              INC       A
              MOVX      @DPTR, A

;       Dec (CountW);
              MOV       DPTR, #CountW
              MOVX      A, @DPTR
              DEC       A
              MOVX      @DPTR, A

;     end;
L_00DB:
;   While CountW <> 0 do
              MOV       DPTR, #CountW
              MOVX      A, @DPTR
              JNZ       L_00AA

; end;
              RET

; 
; Procedure WriteXBytesToEEPROM  (EepromAddressXW, SourceAddressX: Pointer; CountWX: Byte);

WriteXBytesToEEPROM:
; begin
              MOV       R4, #$A5

;   While CountWX <> 0 do
              SJMP      L_011D
L_00E6:

;     begin
;       WDTCN := $A5;
              MOV       $FF, R4

;       WriteByteToEEPROM (EepromAddressXW, MemXDATA [Word (SourceAddressX)]);
              MOV       DPTR, #EepromAddressXW
              MOVX      A, @DPTR
              MOV       R2, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R3, A
              MOV       DPTR, #AddressW
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #SourceAddressX
              MOVX      A, @DPTR
              MOV       R2, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       DPL, R2
              MOV       DPH, A
              MOVX      A, @DPTR
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;       Inc (Word (EepromAddressXW));
              MOV       DPTR, #EepromAddressXW
              LCALL     sysIncWord_XDATA

;       Inc (Word (SourceAddressX));
              MOV       DPTR, #SourceAddressX
              LCALL     sysIncWord_XDATA

;       Dec (CountWX);
              MOV       DPTR, #CountWX
              MOVX      A, @DPTR
              DEC       A
              MOVX      @DPTR, A

;     end;
L_011D:
;   While CountWX <> 0 do
              MOV       DPTR, #CountWX
              MOVX      A, @DPTR
              JNZ       L_00E6

; end;
              RET

; 
; Procedure ReadBytesFromEEPROM (EepromAddressR: Pointer; DestinationAddress: ShortPtr; CountR: Byte);

RSEG _DATA

Turbo51_Temp_0000:              DS       1

ReadBytesFromEEPROM:
; begin
;   If CountR = 0 then Exit;
              MOV       DPTR, #CountR
              MOVX      A, @DPTR
              JZ        L_01A5

;   Case NoEEPROM of
;     True: For Byte (EepromAddressR) := Byte (DestinationAddress) to Byte (DestinationAddress) + CountR - 1 do
              JNB       NoEEPROM, L_0151
              MOV       DPTR, #DestinationAddress
              MOVX      A, @DPTR
              MOV       R1, A
              MOV       DPTR, #CountR
              MOVX      A, @DPTR
              ADD       A, R1
              DEC       A
              MOV       R2, A
              MOV       A, R1
              MOV       DPTR, #EepromAddressR
              MOVX      @DPTR, A
              SETB      C
              SUBB      A, R2
              JNC       L_0150
              SJMP      L_0146
L_0144:
              INC       A
              MOVX      @DPTR, A
L_0146:

;             MemIDATA [Word (EepromAddressR)] := 0;
              MOV       DPTR, #EepromAddressR
              MOVX      A, @DPTR
              MOV       R0, A
              MOV       @R0, #0
              CJNE      A, AR2, L_0144
L_0150:
              RET
L_0151:

;     else begin
;            Check_EEPROM_Status;
              LCALL     Check_EEPROM_Status

;            SMB0DAT := Hi (EepromAddressR);
              MOV       DPTR, #EepromAddressR+1
              MOVX      A, @DPTR
              MOV       $C2, A

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_015C:
              JNB       $C0.3, L_015C

;            SMB0DAT := Lo (EepromAddressR);
              MOV       DPTR, #EepromAddressR
              MOVX      A, @DPTR
              MOV       $C2, A

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_0167:
              JNB       $C0.3, L_0167

;            STA := True;
              SETB      $C0.5

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_016E:
              JNB       $C0.3, L_016E

;            STA := False;
              CLR       $C0.5

;            SMB0DAT := I2C_24C32 or $01;
              MOV       $C2, #$A1

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_0178:
              JNB       $C0.3, L_0178
              MOV       R2, #$A5

;            While CountR <> 0 do
              SJMP      L_019B
L_017F:

;              begin
;                WDTCN := $A5;
              MOV       $FF, R2

;                AA := CountR <> 1;
              XRL       A, #1
              ADD       A, #$FF
              MOV       $C0.2, C

;                SI := False;
              CLR       $C0.3

; 
;                Repeat until SI;
L_0189:
              JNB       $C0.3, L_0189

;                MemIDATA [Byte (DestinationAddress)] := SMB0DAT;
              MOV       DPTR, #DestinationAddress
              MOVX      A, @DPTR
              MOV       R0, A
              MOV       @R0, $C2

; 
;                Inc (Byte (DestinationAddress));
              INC       A
              MOVX      @DPTR, A

;                Dec (CountR);
              MOV       DPTR, #CountR
              MOVX      A, @DPTR
              DEC       A
              MOVX      @DPTR, A

;              end;
L_019B:
;            While CountR <> 0 do
              MOV       DPTR, #CountR
              MOVX      A, @DPTR
              JNZ       L_017F

; 
;            STO := True;
              SETB      $C0.4

;            SI := False;
              CLR       $C0.3

;          end;
;   end;
; end;
L_01A5:
              RET

; 
; Procedure ReadXBytesFromEEPROM (EepromAddressXR, DestinationAddressX: Pointer; CountRX: Byte);
Turbo51_Temp_0001:              DS       2

ReadXBytesFromEEPROM:
; begin
;   If CountRX = 0 then Exit;
              MOV       DPTR, #CountRX
              MOVX      A, @DPTR
              JNZ       L_01AD
              RET
L_01AD:

;   Case NoEEPROM of
;     True: For Word (EepromAddressXR) := Word (DestinationAddressX) to Word (DestinationAddressX) + CountRX - 1 do
              JNB       NoEEPROM, L_0203
              MOV       DPTR, #DestinationAddressX
              MOVX      A, @DPTR
              MOV       R4, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R5, A
              MOV       DPTR, #CountRX
              MOVX      A, @DPTR
              ADD       A, R4
              MOV       R2, A
              CLR       A
              ADDC      A, R5
              MOV       R3, A
              MOV       A, R2
              ADD       A, #LOW  (-1)
              MOV       R5, A
              MOV       A, R3
              ADDC      A, #HIGH (-1)
              MOV       R4, A
              MOV       DPTR, #DestinationAddressX
              MOVX      A, @DPTR
              MOV       R2, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R3, A
              MOV       DPTR, #EepromAddressXR
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       A, R2
              SETB      C
              SUBB      A, R5
              INC       DPTR
              MOVX      A, @DPTR
              SUBB      A, R4
              JNC       L_0202
              SJMP      L_01E9
L_01E3:
              MOV       DPTR, #EepromAddressXR
              LCALL     sysIncWord_XDATA
L_01E9:

;             MemXDATA [Word (EepromAddressXR)] := 0;
              MOV       DPTR, #EepromAddressXR
              MOVX      A, @DPTR
              MOV       R2, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       DPL, R2
              MOV       DPH, A
              CLR       A
              MOVX      @DPTR, A
              MOV       DPTR, #EepromAddressXR
              MOVX      A, @DPTR
              CJNE      A, AR5, L_01E3
              INC       DPTR
              MOVX      A, @DPTR
              CJNE      A, AR4, L_01E3
L_0202:
              RET
L_0203:

;     else begin
;            Check_EEPROM_Status;
              LCALL     Check_EEPROM_Status

;            SMB0DAT := Hi (EepromAddressXR);
              MOV       DPTR, #EepromAddressXR+1
              MOVX      A, @DPTR
              MOV       $C2, A

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_020E:
              JNB       $C0.3, L_020E

;            SMB0DAT := Lo (EepromAddressXR);
              MOV       DPTR, #EepromAddressXR
              MOVX      A, @DPTR
              MOV       $C2, A

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_0219:
              JNB       $C0.3, L_0219

;            STA := True;
              SETB      $C0.5

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_0220:
              JNB       $C0.3, L_0220

;            STA := False;
              CLR       $C0.5

;            SMB0DAT := I2C_24C32 or $01;
              MOV       $C2, #$A1

;            SI := False;
              CLR       $C0.3

; 
;            Repeat until SI;
L_022A:
              JNB       $C0.3, L_022A
              MOV       R3, #$A5

;            While CountRX <> 0 do
              SJMP      L_0258
L_0231:

;              begin
;                WDTCN := $A5;
              MOV       $FF, R3

;                AA := CountRX <> 1;
              XRL       A, #1
              ADD       A, #$FF
              MOV       $C0.2, C

;                SI := False;
              CLR       $C0.3

; 
;                Repeat until SI;
L_023B:
              JNB       $C0.3, L_023B

;                MemXDATA [Word (DestinationAddressX)] := SMB0DAT;
              MOV       DPTR, #DestinationAddressX
              MOVX      A, @DPTR
              MOV       R2, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       DPL, R2
              MOV       DPH, A
              MOV       A, $C2
              MOVX      @DPTR, A

; 
;                Inc (Word (DestinationAddressX));
              MOV       DPTR, #DestinationAddressX
              LCALL     sysIncWord_XDATA

;                Dec (CountRX);
              MOV       DPTR, #CountRX
              MOVX      A, @DPTR
              DEC       A
              MOVX      @DPTR, A

;              end;
L_0258:
;            While CountRX <> 0 do
              MOV       DPTR, #CountRX
              MOVX      A, @DPTR
              JNZ       L_0231

; 
;            STO := True;
              SETB      $C0.4

;            SI := False;
              CLR       $C0.3

;          end;
;   end;
; end;
              RET


E24C32:
; 
; begin
;   NoEEPROM := True;
              SETB      NoEEPROM

; end.
              RET

RSEG _CONST


              END

