{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit E24C32;

{$IDATA }
{$XDATA }

Interface

Const I2C_24C32 = $A0;

Var EEPROM_Timer: Byte;
    NoEEPROM: Boolean;

{$MP XDATA}

Procedure WriteByteToEEPROM    (AddressW: Pointer; Value: Byte);
Function  ReadByteFromEEPROM   (AddressR: Pointer): Byte;
Procedure WriteBytesToEEPROM   (EepromAddressW: Pointer; SourceAddress: ShortPtr; CountW: Byte);
Procedure WriteXBytesToEEPROM  (EepromAddressXW, SourceAddressX: Pointer; CountWX: Byte);
Procedure ReadBytesFromEEPROM  (EepromAddressR: Pointer; DestinationAddress: ShortPtr; CountR: Byte);
Procedure ReadXBytesFromEEPROM (EepromAddressXR, DestinationAddressX: Pointer; CountRX: Byte);

Implementation

Uses C51F020;

Const EEPROM_WriteDelay = 6;

Procedure DelayAfterWrite;
begin
  EEPROM_Timer := EEPROM_WriteDelay;
  Repeat
    WDTCN := $A5;
  until EEPROM_Timer = 0;
end;

Procedure Check_EEPROM_Status;
begin
  Repeat
    WDTCN := $A5;
  until not BUSY;

  EEPROM_Timer := EEPROM_WriteDelay;
  Repeat
    WDTCN := $A5;
    STA := True;

    Repeat until SI;
    STA := False;
    SMB0DAT := I2C_24C32;
    SI := False;

    Repeat until SI;
    If SMB0STA = $18 then Exit;
    SI := False;
  until EEPROM_Timer = 0;
end;

Procedure WriteByteToEEPROM   (AddressW: Pointer; Value: Byte);
begin
  If NoEEPROM then Exit;
  Check_EEPROM_Status;
  SMB0DAT := Hi (AddressW);
  SI := False;

  Repeat until SI;
  SMB0DAT := Lo (AddressW);
  SI := False;

  Repeat until SI;

  SMB0DAT := Value;
  SI := False;

  Repeat until SI;

  STO := True;
  SI := False;
  DelayAfterWrite;
end;

Function  ReadByteFromEEPROM  (AddressR: Pointer): Byte;
begin
  Case NoEEPROM of
    True: ReadByteFromEEPROM := 0;
    else begin
           Check_EEPROM_Status;
           SMB0DAT := Hi (AddressR);
           SI := False;

           Repeat until SI;
           SMB0DAT := Lo (AddressR);
           SI := False;

           Repeat until SI;
           STA := True;
           SI := False;

           Repeat until SI;
           STA := False;
           SMB0DAT := I2C_24C32 or $01;
           SI := False;

           Repeat until SI;
           AA := False;
           SI := False;

           Repeat until SI;
           ReadByteFromEEPROM := SMB0DAT;

           STO := True;
           SI := False;
         end;
  end;
end;

Procedure WriteBytesToEEPROM  (EepromAddressW: Pointer; SourceAddress: ShortPtr; CountW: Byte);
begin
  While CountW <> 0 do
    begin
      WDTCN := $A5;
      WriteByteToEEPROM (EepromAddressW, MemIDATA [Byte (SourceAddress)]);
      Inc (Word (EepromAddressW));
      Inc (Byte (SourceAddress));
      Dec (CountW);
    end;
end;

Procedure WriteXBytesToEEPROM  (EepromAddressXW, SourceAddressX: Pointer; CountWX: Byte);
begin
  While CountWX <> 0 do
    begin
      WDTCN := $A5;
      WriteByteToEEPROM (EepromAddressXW, MemXDATA [Word (SourceAddressX)]);
      Inc (Word (EepromAddressXW));
      Inc (Word (SourceAddressX));
      Dec (CountWX);
    end;
end;

Procedure ReadBytesFromEEPROM (EepromAddressR: Pointer; DestinationAddress: ShortPtr; CountR: Byte);
begin
  If CountR = 0 then Exit;
  Case NoEEPROM of
    True: For Byte (EepromAddressR) := Byte (DestinationAddress) to Byte (DestinationAddress) + CountR - 1 do
            MemIDATA [Word (EepromAddressR)] := 0;
    else begin
           Check_EEPROM_Status;
           SMB0DAT := Hi (EepromAddressR);
           SI := False;

           Repeat until SI;
           SMB0DAT := Lo (EepromAddressR);
           SI := False;

           Repeat until SI;
           STA := True;
           SI := False;

           Repeat until SI;
           STA := False;
           SMB0DAT := I2C_24C32 or $01;
           SI := False;

           Repeat until SI;
           While CountR <> 0 do
             begin
               WDTCN := $A5;
               AA := CountR <> 1;
               SI := False;

               Repeat until SI;
               MemIDATA [Byte (DestinationAddress)] := SMB0DAT;

               Inc (Byte (DestinationAddress));
               Dec (CountR);
             end;

           STO := True;
           SI := False;
         end;
  end;
end;

Procedure ReadXBytesFromEEPROM (EepromAddressXR, DestinationAddressX: Pointer; CountRX: Byte);
begin
  If CountRX = 0 then Exit;
  Case NoEEPROM of
    True: For Word (EepromAddressXR) := Word (DestinationAddressX) to Word (DestinationAddressX) + CountRX - 1 do
            MemXDATA [Word (EepromAddressXR)] := 0;
    else begin
           Check_EEPROM_Status;
           SMB0DAT := Hi (EepromAddressXR);
           SI := False;

           Repeat until SI;
           SMB0DAT := Lo (EepromAddressXR);
           SI := False;

           Repeat until SI;
           STA := True;
           SI := False;

           Repeat until SI;
           STA := False;
           SMB0DAT := I2C_24C32 or $01;
           SI := False;

           Repeat until SI;
           While CountRX <> 0 do
             begin
               WDTCN := $A5;
               AA := CountRX <> 1;
               SI := False;

               Repeat until SI;
               MemXDATA [Word (DestinationAddressX)] := SMB0DAT;

               Inc (Word (DestinationAddressX));
               Dec (CountRX);
             end;

           STO := True;
           SI := False;
         end;
  end;
end;

begin
  NoEEPROM := True;
end.
