; Turbo51 version 0.1.3.10, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0, 1, 2, 3)

_CODE         SEGMENT  CODE
_CONST        SEGMENT  CODE
_DATA         SEGMENT  DATA
_IDATA        SEGMENT  IDATA
_XDATA        SEGMENT  XDATA
_BIT          SEGMENT  BIT

              PUBLIC   OSD_SCK
              PUBLIC   OSD_SIN
              PUBLIC   OSD_CSB

              EXTRN    DATA  (R8)
              EXTRN    IDATA (StackStart)

              EXTRN    CODE  (sysCopyStringFrom_CODE_To_XDATA)
              EXTRN    CODE  (sysADD_DPTR_A)
              EXTRN    CODE  (sysCopyFrom_XDATA_To_XDATA)
              EXTRN    CODE  (sysWordMultiplication)
              EXTRN    CODE  (sysWordDivision)
              EXTRN    CODE  (sysCopyFrom_XDATA_To_IDATA)
              EXTRN    CODE  (sysCopyFrom_IDATA_To_XDATA)

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; {$DEFINE DPS900 }
; 
; {$M 0, $10000, $0000, $1000, 0}
; 
; Program Example7;
; 
; Uses  C51F020,
              EXTRN    DATA  (IIC_Adr)

              EXTRN    CODE  (I2C_AddressPresent)
              EXTRN    CODE  (C51F020)

;       TEA6415,
              EXTRN    XDATA (VOut)
              EXTRN    XDATA (VIn)
              EXTRN    XDATA (VideoXPoint)

              EXTRN    CODE  (SetVideoXPoint)
              EXTRN    CODE  (SetVideoXPoints)

;       E24C32,
              EXTRN    DATA  (EEPROM_Timer)
              EXTRN    XDATA (AddressW)
              EXTRN    XDATA (Value)
              EXTRN    XDATA (EepromAddressW)
              EXTRN    XDATA (SourceAddress)
              EXTRN    XDATA (CountW)
              EXTRN    XDATA (AddressR)
              EXTRN    XDATA (EepromAddressR)
              EXTRN    XDATA (DestinationAddress)
              EXTRN    XDATA (CountR)
              EXTRN    XDATA (EepromAddressXR)
              EXTRN    XDATA (DestinationAddressX)
              EXTRN    XDATA (CountRX)
              EXTRN    XDATA (EepromAddressXW)
              EXTRN    XDATA (SourceAddressX)
              EXTRN    XDATA (CountWX)
              EXTRN    BIT   (NoEEPROM)

              EXTRN    CODE  (WriteByteToEEPROM)
              EXTRN    CODE  (WriteBytesToEEPROM)
              EXTRN    CODE  (ReadByteFromEEPROM)
              EXTRN    CODE  (ReadBytesFromEEPROM)
              EXTRN    CODE  (ReadXBytesFromEEPROM)
              EXTRN    CODE  (WriteXBytesToEEPROM)
              EXTRN    CODE  (E24C32)

;       KS5520;
              EXTRN    DATA  (BackgroundColor)
              EXTRN    XDATA (OsdString)
              EXTRN    XDATA (RowY)
              EXTRN    XDATA (Attribute)
              EXTRN    BIT   (OverlayOn)

              EXTRN    CODE  (SetBackground)
              EXTRN    CODE  (WriteAtRow)
              EXTRN    CODE  (InitOsd)
              EXTRN    CODE  (Overlay)

; 
; {$I CommonData.inc }
; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Const PacketHeaderSize            = 12;

RSEG _CONST

;       DefaultPacketSize           = PacketHeaderSize + 32;
;       MagicDemoWord               = $DE3A;
;       MagicControlNumber          = $ABAA;
;       NoTemperature               = $FF00;
; 
;       MaxModuleAddress            = $3F;
; 
;       MaxModuleAdressLocalRemote  = 2 * (MaxModuleAddress + 1) - 1;
; 
;       SerialNumberLength          = 12;
;       CommentLength               = 14;
;       ModuleNameLength            = 12;
;       LocationNameLength          = 18;
;       SourceNameLength            = 15;
;       SourceDescriptionLength     = 30;
;       InputNameLength             = 18;
;       UserTextLength              = 64;
;       UserTextLength1             = 32;
;       UserTextLength2             = 32;
;       BroadcastAddress            = $7F;
;       BroadcastAddress_Frame      = $FF;
;       PC_AddressSetup             = $7E;
;       PC_AddressAlarm             = $7A;
;       PC_Address_Frame            = $FE;
;       Test_Address                = $7D;
;       Dummy_Address               = $7C;
;       Transport_Address           = $7B;
;       Peer_Address                = $7C;
;       Test_Address_Frame          = $FD;
;       DummyAddress_Frame          = $FC;
;       Debugger_Address_Frame      = $FB;
;       InterFrameAddress           = $00;
;       COM_ModuleAddress           = $10;
;       SingleExternalModuleAddress = $FF;
;       VCS64_IO_ModuleAddress      = $0F;
;       TurboStartByte              = $AA;
;       SetupDataSize               = 9;
;       FirstOutModuleAddress       = 2;
;       FOM100SetupStartByte        = $FA;
;       MAX_Cmd_Registers           = $20;
; 
; 
;       BroadcastReplyTimeSlot      =   80;
;       LoopTestTime                = 5000;
;       CommPacketTime              = 3000;
; 
; 
;       Cmd_ModuleData              = $00;
;       Cmd_SetupData               = $01;
;       Cmd_SourceNameAndFlags      = $02;
;       Cmd_SourceDescription       = $03;
;       Cmd_RemoteSlots             = $04;
;       Cmd_EEPROM                  = $05;
;       Cmd_Reset                   = $06;
;       Cmd_FrameData               = $07;
;       Cmd_Message                 = $08;
;       Cmd_VideoInputName          = $09;
;       Cmd_Outputs                 = $0A;
;       Cmd_InputSyncs              = $0B;
;       Cmd_Transport               = $0C;
;       Cmd_Protocols               = $0D;
;       Cmd_Keyboard                = $0E;
;       Cmd_IOData                  = $0F;
;       Cmd_EventActions            = $10;
;       Cmd_AllOutputs              = $11;
;       Cmd_OsdData                 = $12;
;       Cmd_AlarmEvent              = $13;
;       Cmd_DigitalInputName        = $14;
;       Cmd_PhysicalInputs          = $15;
;       Cmd_PhysicalOutputs         = $16;
;       Cmd_Video_IO                = $17;
;       Cmd_IO                      = $18;
;       Cmd_ModuleAddress           = $19;
;       Cmd_SerialPorts             = $1A;
;       Cmd_CameraIO                = $1B;
;       Cmd_TestMode                = $1C;
;       Cmd_FrameDataExt            = $1D;
;       Cmd_ICM_Mode                = $1E;
;       Cmd_CameraAddresses         = $1F;
;       Cmd_AudioSetup              = $20;
;       Cmd_VID5_Setup              = $21;
;       Cmd_VideoSetup              = $22;
;       Cmd_VID8X8_Setup            = $23;
;       Cmd_UART_Setup              = $24;
;       Cmd_UART_Transport          = $25;
;       Cmd_OVS4_45_Setup           = $26;
;       Cmd_UART_Test               = $27;
;       Cmd_OVS4_45_IO              = $28;
;       Cmd_LinkData                = $29;
;       Cmd_UserText                = $2A;
;       Cmd_SPDIF                   = $2B;
;       Cmd_OVS4_45_RF              = $2C;
;       Cmd_SFP                     = $2D;
;       Cmd_UI                      = $2E;
;       Cmd_Registers               = $2F;
;       Cmd_Hours                   = $30;
;       Cmd_CommCounters            = $31;
;       Cmd_UserTexts               = $32;
;       Cmd_ModuleInfo              = $33;
;       Cmd_Transceiver             = $34;
;       Cmd_IMC_Video               = $35;
;       Cmd_IMC_VideoExchange       = $36;
;       Cmd_IMC_UART                = $37;
; 
; 
;       mdVideoPresent              = $01;
;       mdErrorEEPROM               = $02;
;       mdErrorTDA8444              = $04;
;       mdKeyUp                     = $08;
;       mdKeyDown                   = $10;
;       mdKeyEnter                  = $20;
; 
; 
;       mdErrorTHS7353              = $04;
;       mdBypass                    = $08;
;       mdVideo1Present             = $10;
;       mdVideo2Present             = $20;
;       mdVideo3Present             = $40;
;       mdVideo4Present             = $80;
; 
; 
;       mdErrorFMS6501              = $04;
; 
;       mdVideoInPresent            = $01;
;       mdErrorTEA6415              = $04;
;       mdUDet                      = $08;
;       mdIDet                      = $10;
;       mdVideoOutPresent           = $40;
;       mdLink                      = $80;
; 
;       mdErrorTDA8425              = $40;
; 
; 
;       mdRS232                     = $01;
;       mdKeyTest                   = $40;
;       mdErrorRTC_COM              = $80;
; 
;      mdErrorPCF8574               = $04;
;       mdKey                       = $40;
; 
; 
;      mdErrorModules          =     $04;
;      mdNoKeyboard            =     $08;
;      mdErrorRTC              =     $10;
; 
;      mdLedRS485                  = $01;
;      mdLedRS232                  = $04;
;      mdLedOptics                 = $08;
;      mdLedLink                   = $10;
;      mdNoSwitch                  = $80;
; 
; 
;      mdErrorPCF8574_IO           = $01;
;      mdErrorPCF8574_CAMERA       = $08;
;      mdMatrix                    = $10;
; 
;      mdLedRS485_1                = $10;
;      mdLedRS485_2                = $20;
;      mdLedRS485_3                = $40;
;      mdLedRS485_4                = $80;
; 
;      mdErrorTHS7353_1            = $04;
;      mdErrorTHS7353_2            = $08;
; 
;      mdOtherModuleMaster         = $04;
; 
;       hdDescrVisible              = $01;
;       hdEqualizerOn               = $02;
;       hdEqualizer0                = $04;
;       hdEqualizer1                = $08;
;       hdNameVisible               = $10;
;       hdReportCommAlarm           = $20;
;       hdReturnVideoFromBus        = $40;
; 
;       hdLocal                     = $01;
;       hdMaster                    = $02;
; 
;       adMaster                    = $01;
;       adRemoteInputs              = $02;
; 
;       mdTHS7353                   = $01;
; 
;       mdErrorPORT_U1              = $01;
;       mdErrorUART_U43             = $04;
;       mdErrorUART_U44             = $08;
;       mdErrorPORT_U45             = $10;
;       mdErrorMatrix_U49           = $20;
;       mdRemoteLink                = $40;
; 
; 
;       mdErrorSpare                = $10;
;       mdErrorSpare2               = $20;
; 
; 
;       mdErrorPCA                  = $04;
; 
;       mdErrorTHS                  = $08;
; 
;       mdErrorINA220               = $04;
;       mdErrorTC665_0              = $08;
;       mdErrorTC665_1              = $10;
;       mdErrorTC665_2              = $20;
;       mdErrorTC665_3              = $40;
; 
; 
;       adRemoteMaster              = $40;
;       adLink                      = $80;
; 
;       hdSW1                       = $01;
;       hdSW2                       = $02;
;       hdSW3                       = $04;
;       hdSW4                       = $08;
;       hdSW5                       = $10;
;       hdSW6                       = $20;
;       hdRelay                     = $40;
; 
;       ActionEventStr              = '#ACTION';
;       enNoMoreEvents              = 0;
;       enEventNowInput             = $FF;
;       enEventNowAction            = $FE;
; 
;       evReset                     = 0;
;       evInput1                    = 1;
;       evInput2                    = 2;
;       evInput3                    = 3;
;       evInput4                    = 4;
;       evInput5                    = 5;
;       evInput6                    = 6;
;       evInput7                    = 7;
;       evInput8                    = 8;
;       evInput9                    = 9;
;       evInput10                   = 10;
;       {.}
;       {.}
;       evInput64                   = 64;
; 
;       evTimer1                    = 65;
;       evTimer2                    = 66;
;       evTimer3                    = 67;
;       evTimer4                    = 68;
;       evTimer5                    = 69;
;       evTimer6                    = 70;
;       evTimer7                    = 71;
;       evTimer8                    = 72;
;       evTimer9                    = 73;
;       evTimer10                   = 74;
;       evTimer11                   = 75;
;       evTimer12                   = 76;
;       evTimer13                   = 77;
;       evTimer14                   = 78;
;       evTimer15                   = 79;
;       evTimer16                   = 80;
; 
;       evMacro1                    = 81;
;       evMacro2                    = 82;
;       evMacro3                    = 83;
;       evMacro4                    = 84;
;       evMacro5                    = 85;
;       evMacro6                    = 86;
;       evMacro7                    = 87;
;       evMacro8                    = 88;
;       evMacro9                    = 89;
;       evMacro10                   = 90;
;       evMacro11                   = 91;
;       evMacro12                   = 92;
;       evMacro13                   = 93;
;       evMacro14                   = 94;
;       evMacro15                   = 95;
;       evMacro16                   = 96;
; 
;       evKeyboard_TextOn           = 97;
;       evKeyboard_TextOff          = 98;
;       evKeyboard_INC              = 99;   { Output n }
;       evKeyboard_DEC              = 100;  { Output n }
;       evKeyboard_SEQ              = 101;  { Output n }
;       evKeyboard_ENTER            = 102;  { Output n }
;       evKeyboard_SET_ENTER        = 103;  { Output n }
;       evKeyboard_SET_CAM          = 104;  { Output n }
;       evKeyboard_END_CAM          = 105;  { Output n }
;       evKeyboard_SHIFT_CAM        = 106;  { Output n }
;       evKeyboard_SET_SEQ          = 107;  { Output n }
;       evKeyboard_END_SEQ          = 108;  { Output n }
;       evKeyboard_SET_0            = 109;  { Output n }
;       evKeyboard_SET_1            = 110;  { Output n }
;       evKeyboard_SET_2            = 111;  { Output n }
;       evKeyboard_SET_3            = 112;  { Output n }
;       evKeyboard_SET_4            = 113;  { Output n }
;       evKeyboard_SET_5            = 114;  { Output n }
;       evKeyboard_SET_6            = 115;  { Output n }
;       evKeyboard_SET_7            = 116;  { Output n }
;       evKeyboard_SET_8            = 117;  { Output n }
;       evKeyboard_SET_9            = 118;  { Output n }
; 
;       evJoystick_UP               = 119;  { Output n }
;       evJoystick_DOWN             = 120;  { Output n }
;       evJoystick_LEFT             = 121;  { Output n }
;       evJoystick_RIGHT            = 122;  { Output n }
;       evJoystick_CW               = 123;  { Output n }
;       evJoystick_CCW              = 124;  { Output n }
; 
;       LastEvent                   = evJoystick_CCW;
; 
;       BytesPerEventAction         = 32;
; 
;       tmDAC                       = 0;
;       tmAudioVideo                = 1;
;       tmOSD                       = 2;
; 
; Type  TModuleType = (mtNone,      mtFOM3000_Local, mtFOM3000_Remote, mtPIT_X, mtPIT_T1, mtPIT_X2, mtPIT_VB);
; 
;       TCommandFlag = (cfReadFromHW, cfReadFromEEPROM, cfWriteToHW, cfWriteToEEPROM, cfResetHWToEEPROM, cfResetHW, cfSpare, cfSpare2);
;       TCommandFlagsSet = Set of TCommandFlag;
; 
;       TProtocols = (prTurbo, prPanasonic, prMacro, prPelcoD, prSony, prAddressFiltering, prTransportForwarding, prAny);
;       TProtocolsSet = Set of TProtocols;
; 
;       TProtocols2 = (pr2Any, pr2Turbo, pr2Panasonic, pr2PelcoD, pr2Sony, pr2PelcoP, pr2Siemens, pr2JVC);
;       TProtocols2Set = Set of TProtocols2;
; 
;       TBaudRate = (brDefault, br1200, br2400, br4800, br9600, br19200, br38400, brUndefined, brPelcoD, brSony);
; 
;       TIOData  = Array [0..9] of Byte;
;       TInData  = Array [0..7] of Byte;
;       TOutData = Array [0..1] of Byte;
; 
;       TEventActions         = Array [0..BytesPerEventAction - 1] of Byte;
;       TEventActionsArray    = Array [evReset..LastEvent] of TEventActions;
;       TEventActionsArrayRAM = Array [evReset..evMacro8]  of TEventActions;
; 
;       TEventAction = packed Record
;                        Action: Byte;
;                        Parameter1: Byte;
;                        Parameter2: Byte;
;                        Parameter3: Byte;
;                        Parameter4: Byte;
;                      end;
; 
;       TPhysicalInputs  = Array [1..128] of Byte;
;       TPhysicalOutputs = Array [1.. 64] of Byte;
;       TSkippedInputs   = Array [0.. 15] of Byte;
; 
;       TLed = (ledOff, ledRed, ledGreen, ledYellow);
; 
;       TCable = (cableRG11, cableRG59, cableOther);
; 
;       TCableLength = (m50, m100, m150, m200, m250, m300, m350, m400, m450, m500);
; 
; Const LedBit_Red   = $01;
;       LedBit_Green = $02;
; 
;       eaNoAction                 = $FF;
; 
;       eaConnectVideoInput        = 0;   { Output: 1..64            Input: 1..64                                                       }
;       eaCopyVideoInput           = 1;   { SourceOutput: 1..64      DestinationOutput: 1..64    Shift: 0..255         LastInput: 1..64 }
;       eaCopyScreen               = 2;   { SourceOutput: 1..64      DestinationOutput: 1..64                                           }
;       eaSwapScreens              = 3;   { FirstOutput: 1..64       SecondOutput: 1..64                                                }
;       eaSetVideoInputsWindow     = 4;   { StartOutput: 1..64       EndOutput: 1..64            StartIntput: 1..64    LastInput: 1..64 }
;       eaShiftVideoInputsWindow   = 5;   { StartOutput: 1..64       EndOutput: 1..64            Shift: 0..255         LastInput: 1..64 }
; 
;       eaBeeperON                 = 6;
;       eaBeeperOFF                = 7;
;       eaBeeperToggle             = 8;
; 
;       eaKeyboardAlarmON          = 9;
;       eaKeyboardAlarmOFF         = 10;
;       eaKeyboardAlarmToggle      = 11;
; 
;       eaExecuteMacro             = 12;  { Macro: 1..8 }
;       eaExecuteInputMacro        = 13;  { Input: 1..64 }
;       eaExecuteTimerMacro        = 14;  { Timer: 1..8 }
; 
;       eaTimerON                  = 15;  { Timer: 1..8, Time 1..255 (s10, s, min) }
;       eaTimerOFF                 = 16;  { Timer: 1..8 }
;       eaTimerToggle              = 17;  { Timer: 1..8, Time 1..255 (s10, s, min) }
; 
;       eaDigitalOutputON          = 18;  { Output: 1..16 }
;       eaDigitalOutputOFF         = 19;  { Output: 1..16 }
;       eaDigitalOutputToggle      = 20;  { Output: 1..16 }
; 
;       eaEnableDigitalInput       = 21;  { Input: 1..64 }
;       eaDisableDigitalInput      = 22;  { Input: 1..64 }
; 
;       eaClearScreen              = 23;  { Output: 1..64 }
; 
;       eaWrite_ALARM              = 24;  { Output: 1..64, Y: 1..12, X: 1..30 }
;       eaWriteTime                = 25;  { Output: 1..64, Y: 1..12, X: 1..30 }
;       eaWriteDate                = 26;  { Output: 1..64, Y: 1..12, X: 1..30 }
;       eaWriteInputNumber         = 27;  { Output: 1..64, Y: 1..12, X: 1..30 }
;       eaWriteOutputNumber        = 28;  { Output: 1..64, Y: 1..12, X: 1..30 }
;       eaWriteVideoInputPosition  = 29;  { Output: 1..64, Y: 1..12, LastInput: 1..64 }
;       eaWriteDigitalInputName    = 30;  { Output: 1..64, Y: 1..12, Input: 1..64 }
;       eaWriteVideoInputName      = 31;  { Output: 1..64, Y: 1..12, Input: 1..128 }
; 
;       eaWriteToLogFile           = 32;  { Event Number }
; 
;       eaClearVariables           = 33;  { First Var Number: 1..256, Last Var Number: 1..256 }
;       eaSetVariable              = 34;  { Var Number: 1..256, Value: 0..255 }
;       eaIncVariable              = 35;  { Var Number: 1..256 }
;       eaDecVariable              = 36;  { Var Number: 1..256 }
;       eaToggleVariable           = 37;  { Var Number: 1..256 }
; 
;       eaExitIfVariableEqual      = 38;  { Var Number: 1..256, Value: 0..255 }
;       eaExitIfVariableNotEqual   = 39;  { Var Number: 1..256, Value: 0..255 }
;       eaExitIfVariableGreater    = 40;  { Var Number: 1..256, Value: 0..255 }
;       eaExitIfVariableLower      = 41;  { Var Number: 1..256, Value: 0..255 }
;       eaSkipIfVariableEqual      = 42;  { Var Number: 1..256, Value: 0..255 }
;       eaSkipIfVariableNotEqual   = 43;  { Var Number: 1..256, Value: 0..255 }
;       eaSkipIfVariableGreater    = 44;  { Var Number: 1..256, Value: 0..255 }
;       eaSkipIfVariableLower      = 45;  { Var Number: 1..256, Value: 0..255 }
; 
;       NumberOfAvailableActions   = 46;
; 
; 
;       cfDataEnd               = cfResetHW;
; 
;       cfInitEEPROMModuleData  = cfResetHW;
;       cfInitEEPROMSettings    = cfResetHWToEEPROM;
; 
;       cfSendCmd_FrameData     = cfSpare;
;       cfWriteDemoCounter      = cfSpare2;
;       cfUpdateDateTime        = cfResetHWToEEPROM;
;       cfNoDelayForBroadcast   = cfResetHW;
;       cfEraseAlarmEvents      = cfWriteToHW;
; 
;       cfWriteOutputs          = cfSpare;
;       cfWriteOutputsToEEPROM  = cfSpare2;
; 
;       cfFoundModules          = cfReadFromHW;      { $01 }
;       cfModuleGateways        = cfReadFromEEPROM;  { $02 }
;       cfRefreshModules        = cfResetHWToEEPROM; { $10 }
;       cfDefaultModules        = cfSpare;           { $40 }
;       cfOriginalAddresses     = cfSpare2;          { $80 }
; 
;       cfFoundLocalModules     = cfFoundModules;       { $01 }
;       cfFoundRemoteModules    = cfDefaultModules;     { $40 }
;       cfRemoteOriginalAddr    = cfOriginalAddresses;  { $80 }
;       cfLocalOriginalAddr     = cfResetHW;            { $20 }
; 
;       cfLoopTest              = cfReadFromHW;
;       cfCommTest              = cfReadFromEEPROM;
;       cfStatus                = cfWriteToHW;
; 
;       cfSendIO                = cfSpare;
; 
;       cfLink                  = cfSpare;
; 
;       cfInitLoop              = cfSpare;
; 
;       cfTestRemoteModule      = cfSpare;
; 
;       cfReadPresetFromEEPROMAndSetHW  = cfSpare;
; 
;       cfHourLimits            = cfSpare;
; 
;       cfResetCounters         = cfResetHWToEEPROM;
; 
;       cfLoopBack              = cfSpare;
; 
;       cfVideoTexts            = cfSpare;
;       cfPortTexts             = cfSpare2;
; 
;       cfUserTextArray         = cfSpare;
; 
;       stReset                 = $00;
;       stVideoInput            = $01;
;       stLink                  = $02;
; 
;       Attenuations: Array [TCable, TCableLength] of Byte = (
;        ( 5, 11, 16, 22, 27, 33, 38, 44, 49,  55),
;        (11, 22, 33, 44, 55, 66, 77, 88, 99, 110),
;        (10, 20, 30, 40, 50, 60, 70, 80, 90, 100));
; 
;       SizeOf_TCmd_ModuleData = $2C;
; 
; Type  TData32       = Array [0..$1F] of Byte;
;       TData128      = Array [0..$7F] of Byte;
;       TExtendedData = Array [0..$4F] of Byte;
; 
;       TBlockData     = packed Record
;                          StartByte:                        Byte;             { $00 }
;                          PacketSize:                       Byte;             { $01 }
;                          Checksum:                         Byte;             { $02 }
;                          DestinationAddress:               Byte;             { $03 }
;                          DestinationAddress_Frame:         Byte;             { $04 }
;                          SourceAddress:                    Byte;             { $05 }
;                          SourceAddress_Frame:              Byte;             { $06 }
;                          OriginalAddress:                  Byte;             { $07 }
;                          GatewayAddress:                   Byte;             { $08 }
;                          Command:                          Byte;             { $09 }
;                          CommandFlags:                     TCommandFlagsSet; { $0A }
;                          Spare:                            Byte;             { $0B }
;                        end;
; 
;       TGeneralPacket = packed Record
;                          StartByte:                        Byte;             { $00 }
;                          PacketSize:                       Byte;             { $01 }
;                          Checksum:                         Byte;             { $02 }
;                          DestinationAddress:               Byte;             { $03 }
;                          DestinationAddress_Frame:         Byte;             { $04 }
;                          SourceAddress:                    Byte;             { $05 }
;                          SourceAddress_Frame:              Byte;             { $06 }
;                          OriginalAddress:                  Byte;             { $07 }
;                          GatewayAddress:                   Byte;             { $08 }
;                          Command:                          Byte;             { $09 }
;                          CommandFlags:                     TCommandFlagsSet; { $0A }
;                          Spare:                            Byte;             { $0B }
;                          Data:                             TData32;          { $0C }
;                        end;
; 
;       TGeneralPacket128 = packed Record
;                             StartByte:                Byte;             { $00 }
;                             PacketSize:               Byte;             { $01 }
;                             Checksum:                 Byte;             { $02 }
;                             DestinationAddress:       Byte;             { $03 }
;                             DestinationAddress_Frame: Byte;             { $04 }
;                             SourceAddress:            Byte;             { $05 }
;                             SourceAddress_Frame:      Byte;             { $06 }
;                             OriginalAddress:          Byte;             { $07 }
;                             GatewayAddress:           Byte;             { $08 }
;                             Command:                  Byte;             { $09 }
;                             CommandFlags:             TCommandFlagsSet; { $0A }
;                             Spare:                    Byte;             { $0B }
;                             Data:                     TData128;         { $0C }
;                           end;
; 
;       TExtendedGeneralPacket = packed Record
;                                  StartByte:                Byte;             { $00 }
;                                  PacketSize:               Byte;             { $01 }
;                                  Checksum:                 Byte;             { $02 }
;                                  DestinationAddress:       Byte;             { $03 }
;                                  DestinationAddress_Frame: Byte;             { $04 }
;                                  SourceAddress:            Byte;             { $05 }
;                                  SourceAddress_Frame:      Byte;             { $06 }
;                                  OriginalAddress:          Byte;             { $07 }
;                                  GatewayAddress:           Byte;             { $08 }
;                                  Command:                  Byte;             { $09 }
;                                  CommandFlags:             TCommandFlagsSet; { $0A }
;                                  Spare:                    Byte;             { $0B }
;                                  Data:                     TExtendedData;    { $0C }
;                                end;
; 
;       TSerialNumber       = String [SerialNumberLength];
;       TComment            = String [CommentLength];
;       TModuleName         = String [ModuleNameLength];
;       TLocationName       = String [LocationNameLength];
;       TSourceName         = String [SourceNameLength];
;       TSourceDescription  = String [SourceDescriptionLength];
;       TInputName          = String [InputNameLength];
;       TUserText           = String [UserTextLength];
;       TUserText1          = String [UserTextLength1];
;       TUserText2          = String [UserTextLength2];
;       T4                  = String [4];
;       T10                 = String [10];
; 
;       TADC = Array [0..7] of Word;
; 
;       TDAC = Array [0..7] of Byte;
; 
;       TDAC12       = Array [1..12] of Byte;
;       TVideoBuffer = Array [1..3] of Byte;
; 
;       TSetupData = packed Record
;                      DAC: TDAC;
;                      Switches: Byte;
;                    end;
; 
;       TSetup = Array [0..8] of TSetupData;
; 
;       TEEPROMBlock = Array [0..15] of Byte;
; 
;       TRemoteSlots = Array [1..16] of Byte;
; 
;       TModules    = Array [0..$1F] of TModuleType;
;       TModulesExt = Array [0..MaxModuleAddress] of TModuleType;
; 
;       TOutputs = Array [1..8] of Byte;
; 
;       TOutputsArray = Array [1..8] of TOutputs;
; 
;       TInputSyncs = Array [1..32] of Byte;
; 
;       TCameraAddressArray = Array [0..31] of Byte;
; 
;       TSequenceDataFlags = (sdFlagsOnly, sdRunning);
; 
;       TSetOfSequenceDataFlags = Set of TSequenceDataFlags;
; 
;       TSequenceData = packed Record
;                         sdSequenceInputs:  Byte;
;                         sdSequenceOutputs: Byte;
;                         sdSequenceTime:    Byte;
;                         sdFlags:           TSetOfSequenceDataFlags;
;                       end;
; 
;       TOsdFlags = (ofDate, ofTime, ofInputNumber, ofOutputNumber, of_ALARM, ofCameraPosition, ofDigitalInputName, ofVideoInputName);
; 
;       TICMMode = (FOM2_Local, FOM2_Remote, COM2, SAD2, COM4);
; 
;       TICMPortFlags = (pfEnabled1, pfEnabled2, pfEnabled3, pfEnabled4, pfFullDuplex1, pfFullDuplex2, pfFullDuplex3, pfFullDuplex4);
; 
;       TICMPortFlagsSet = Set of TICMPortFlags;
; 
;       TICMPortFlags2 = (pfEnabledExtRS485,     pfEnabledExtOptics,   pfSingleEndedLoop,        pfNoDelayAfterExtBroadcast,
;                         pfDisabledIntRS485_RX, pfDisabledIntRS485_5);
; 
;       TICMPortFlagsSet2 = Set of TICMPortFlags2;
; 
;       TOsdFlagsSet = Set of TOsdFlags;
; 
;       TYX = packed Record
;               Y: Byte;
;               X: Byte;
;             end;
; 
;       TOsdDataOutput = Array [ofDate..ofVideoInputName] of TYX;
; 
;       TOsdDataOutputs = Array [1..64] of TOsdDataOutput;
; 
;       TOsdDataModule = Array [0..7] of TOsdDataOutput;
; 
;       TOsdDataModules = Array [0..7] of TOsdDataModule;
; 
;       TDateTime = packed Record
;                     dtTimeSec100: Byte;
;                     dtTimeSec:    Byte;
;                     dtTimeMin:    Byte;
;                     dtTimeHour:   Byte;
;                     dtDateDay:    Byte;
;                     dtDateMonth:  Byte;
;                     dtDateYear:   Byte;
;                   end;
; 
;       TAlarmEvent = packed Record
;                       aeInput:       Byte;
;                       aeDateTime:    TDateTime;
;                       aeInputName:   TInputName;
;                     end;
; 
; 
;       TCodec = packed Record
;                  adLeftLineInputChannelVolumeControl:  Word;
;                  adRightLineInputChannelVolumeControl: Word;
;                  adLeftChannelHeadphoneVolumeControl:  Word;
;                  adRightChannelHeadphoneVolumeControl: Word;
;                  adAnalogAudioPathControl:             Word;
;                  adDigitalAudioPathControl:            Word;
;                  adPowerDownControl:                   Word;
;                  adDigitalAudioInterfaceFormat:        Word;
;                  adSampleRateControl:                  Word;
;                  adDigitalInterfaceActivation:         Word;
;                end;
; 
;       TTEA6415 = Array [0..5] of Byte;
; 
;       TCmd_ModuleData = packed Record
;                           mdBlockData:       TBlockData;    { $00  0 }
;                           mdModuleType:      TModuleType;   { $0C 12 }
;                           mdModuleFlags:     Byte;          { $0D 13 }
;                           mdFirmwareVersion: Word;          { $0E 14 }
;                           mdSerialNumber:    TSerialNumber; { $10 16 }
;                           mdComment:         TComment;      { $1D 29 }
; 
;                           mdtemperature:     Word;                 { $2C 44, only where C8051F020 }
;                           Case Byte of
;                             0: (mdRandomNumber:    Word;           { $2E 46, only for VCS64-CPU }
;                                 mdDemoCounter:     Word;           { $30 48, only for VCS64-CPU }
;                                 mdADC:             TADC);          { $32 50, only for COM }
;                             1: (mdModuleName:         TModuleName; { $2E 46, only for OVS4-45 }
;                                 mdLocationName:       TLocationName;
;                                 mdRemoteTemperature:  Array [1..4] of Word;
;                                 mdLinkState:          Byte;
;                                 mdVideoAcState:       Byte;
;                                 mdVideoStates:        Byte;  { 4B 4A 3B 3A 2B 2A 1B 1A }
;                                 mdPeerAddress:        Byte;
;                                 mdAvailableLinks:     Byte); {  xxxx4321 }
;                         end;
; 
;       TCmd_ModuleDataTime = packed Record
;                               mdBlockData:       TBlockData;    { $00  0 }
;                               mdDateTime:        TDateTime;     { $0C 12 }
;                               mdtRandomNumber:   Word;          { $13 19 }
;                               mdtDemoCounter:    Word;          { $13 19 }
;                             end;
; 
;       TCmd_SetupData = packed Record
;                          sdBlockData: TBlockData;  { $00  0 }
;                          sdSetup:     Byte;        { $0C 12 }
;                          sdSetupData: TSetupData;  { $0D 13 }
;                        end;
; 
;       TCmd_SourceNameAndFlags = packed Record
;                                   hdBlockData:       TBlockData;
;                                   hdSourceName:      TSourceName;
;                                   hdMiscFlags:       Byte;
;                                 end;
; 
;       TCmd_SourceDescription = packed Record
;                                  hdBlockData:         TBlockData;
;                                  hdSourceDescription: TSourceDescription;
;                                end;
; 
;       TCmd_RemoteSlots = packed Record
;                            hdBlockData:       TBlockData;
;                            hdModeFlags:       Byte;
;                            hdRemoteSlots:     TRemoteSlots;
;                          end;
; 
;       TCmd_Outputs = packed Record
;                        hdBlockData:       TBlockData;
;                        hdOutputs:         TOutputs;
;                        hdOutputSyncs:     Byte;
;                      end;
; 
;       TCmd_AllOutputs = packed Record
;                           hdBlockData:       TBlockData;
;                           hdOutputsArray:    TOutputsArray;
;                         end;
; 
;       TCmd_InputSyncs = packed Record
;                           hdBlockData:       TBlockData;
;                           hdInputSyncs:      TInputSyncs;
;                         end;
; 
;       TCmd_EEPROM = packed Record
;                       eeBlockData:       TBlockData;    { $00  0 }
;                       eeData:            TEEPROMBlock;  { $0C 12 }
;                       eeAddress:         Word;          { $1C 22 }
;                       eeSize:            Word;          { $1E 24 }
;                       eeDataSize:        Word;          { $20 26 }
;                     end;
; 
;       TCmd_Message = packed Record
;                        msBlockData:       TBlockData;  { $00 }
;                        msByte0:           Byte;        { $0C }
;                        msByte1:           Byte;
;                        msWord0:           Word;
;                        msWord1:           Word;
;                        msLongInt0:        LongInt;
;                        msLongInt1:        LongInt;
;                      end;
; 
;       TCmd_FrameData = packed Record
;                          msBlockData:      TBlockData;
;                          msModules:        TModules;
;                        end;
; 
;       TCmd_FrameDataExt = packed Record
;                             msBlockData:      TBlockData;
;                             msModulesExt:     TModulesExt;
;                           end;
; 
;       TCmd_SequenceData = packed Record
;                             sdBlockData:    TBlockData;
;                             sdSequenceData: TSequenceData;
;                           end;
; 
;       TCmd_Protocols = packed Record
;                          prBlockData: TBlockData;
;                          prProtocols: TProtocolsSet;
;                        end;
; 
;       TCmd_IOData = packed Record
;                       ioBlockData: TBlockData;
;                       ioNCNO:      TIOData;
;                       ioEnabled:   TIOData;
;                       ioInData:    TInData;
;                       ioOutData:   TOutData;
;                     end;
; 
;       TCmd_EventActions = packed Record
;                             eaBlockData: TBlockData;
;                             eaEvent: Byte;
;                             eaEventActions: TEventActions;
;                           end;
; 
;       TCmd_OsdData = packed Record
;                        odBlockData: TBlockData;
;                        odOsdData:   TOsdDataModule;
;                      end;
; 
;       TCmd_AlarmEvent = packed Record
;                           aeBlockData:   TBlockData;   { $00   0 }
;                           aeEventNumber: Byte;         { $0C  12 }
;                           aeAlarmEvent:  TAlarmEvent;  { $0D  13 }
;                         end;                           { $27  39 }
; 
;       TCmd_DigitalInputName = packed Record
;                                 diBlockData: TBlockData;   { $00    0 }
;                                 diInput:     Byte;         { $0C   12 }
;                                 diInputName: TInputName;   { $0D   13 }
;                               end;
; 
;       TCmd_VideoInputName = packed Record
;                               viBlockData: TBlockData;   { $00    0 }
;                               viInput:     Byte;         { $0C   12 }
;                               viInputName: TInputName;   { $0D   13 }
;                             end;
; 
;       TCmd_PhysicalInputs = packed Record
;                               piBlockData:       TBlockData;
;                               piPhysicalInputs:  TPhysicalInputs;
;                             end;
; 
;       TCmd_PhysicalOutputs = packed Record
;                                poBlockData:       TBlockData;
;                                poPhysicalOutputs: TPhysicalOutputs;
;                                poSkippedInputs:   TSkippedInputs;
;                              end;
; 
;       TCmd_Video_IO = packed Record
;                         ioBlockData: TBlockData;
;                         ioTEA6415:   TTEA6415;
;                       end;
; 
;       TCmd_IO = packed Record
;                   ioBlockData: TBlockData;
;                   ioInputs:  Byte;       { bit 3 = in1,  bit 2 = in2,  bit 1 = in3,  bit 0 = in4 }
;                   ioOutputs: Byte;       { bit 3 = out1, bit 2 = out2, bit 1 = out3, bit 0 = out4 }
;                 end;
; 
;       TCmd_ModuleAddress = packed Record
;                              caBlockData: TBlockData;
;                              caAddress:   Byte;
;                            end;
; 
;       TCmd_SerialPorts = packed Record
;                            spBlockData:             TBlockData;
;                            spMode:                  TICMMode;                    { Not used anymore }
;                            spPortFlags:             TICMPortFlagsSet;
;                            spPortFlags2:            TICMPortFlagsSet2;
;                            spOVS4_41_Address:       Byte;                         { Not used anymore, only for ICM }
;                          end;
; 
;       TCmd_CameraIO = packed Record
;                    cioBlockData: TBlockData;
;                    cioAC:        Byte;       { bit 3 = Camera 1, bit 2 = Camera 2, bit 1 = Camera 3, bit 0 = Camera 4 }
;                    cioReset:     Byte;       { bit 3 = Camera 1, bit 2 = Camera 2, bit 1 = Camera 3, bit 0 = Camera 4 }
;                  end;
; 
;       TCmd_TestMode = packed Record
;                        tmBlockData: TBlockData;
;                        tmParameter: Byte;
;                        tmValue0:    Byte;
;                        tmValue1:    Byte;
;                        tmValue2:    Byte;
;                        tmValue3:    Byte;
;                        tmValue4:    Byte;
;                        tmValue5:    Byte;
;                        tmValue6:    Byte;
;                        tmValue7:    Byte;
;                       end;
; 
;       TCmd_ICM_Mode = packed Record
;                         icmBlockData:         TBlockData;
;                         icmMode:              TICMMode;
;                         icmOVS4_41_Address:   Byte;
;                         icmOVS4_41_CheckTime: Byte;
;                         icmValue2:            Byte;
;                         icmValue3:            Byte;
;                         icmValue4:            Byte;
;                         icmValue5:            Byte;
;                         icmValue6:            Byte;
;                         icmValue7:            Byte;
;                       end;
; 
;       TCmd_CameraAddresses = packed Record
;                                caBlockData: TBlockData;
;                                caAddresses: TCameraAddressArray;
;                              end;
; 
;       TCmd_AudioSetup = packed Record
;                           asBlockData: TBlockData;
;                           asModeFlags:  Byte;
;                           asMiscFlags1: Byte;
;                           asSpareWord:  Word;
;                           asCodec1:     TCodec;
;                           asCodec2:     TCodec;
;                         end;
; 
;       TCmd_VID5_Setup = packed Record
;                           vsBlockData:      TBlockData;
;                           vsDAC:            TDAC12;
;                           vsVideoBuffer:    TVideoBuffer;
;                           vsCableAndLength: Byte;                    { [0..2, 0..9], $F0 = direct data }
;                           vsAttenuation:    Byte;
;                           vsFlags1:         Byte;
;                           vsFlags2:         Byte;
;                         end;
; 
;       TCmd_VideoSetup = packed Record
;                           vsBlockData:      TBlockData;
;                           vsDAC:            TDAC12;
;                           vsVideoBuffer1:   TVideoBuffer;
;                           vsVideoBuffer2:   TVideoBuffer;
;                           vsFlags1:         Byte;
;                           vsFlags2:         Byte;
;                         end;
; 
;       TVID8X8Flags = (flAuto, flAuxEnabled, flAlarmsEnabled, flAlarmActive);
; 
;       TVID8X8FlagsSet = Set Of TVID8X8Flags;
; 
;       TOutputData = Array [1..9] of Byte;
;       TClamp      = Array [$1D..$1E] of Byte;
; 
;       TCmd_VID8X8_Setup = packed Record
;                             vsBlockData:      TBlockData;
;                             vsOutputs:        TOutputData;
;                             vsClamp:          Array [$1D..$1E] of Byte;
;                             vsOutputsAuxData: Array [1..8] of Byte;   { $00 to pass input in vsOutputs, 1..12 to switch to any other logical input when sync lost (AUX1 = 9, AUX2 = 10, AUX3 = 11, AUX4 = 12}
;                             vsFlags:          TVID8X8FlagsSet;
;                             vsInputs:         Word;
;                             vsAlarmsIn:       Word;
;                             vsAlarmsOut:      Byte;
;                           end;
; 
;       TOVS4_45_Flags = (ofDataPortOn, ofDataPort0, ofCamera1, ofCamera2, ofCamera3, ofCamera4);
; 
;       TOVS4_45_FlagsSet = Set of TOVS4_45_Flags;
; 
;       TOVS4_45_StatusFlags = (sfIO_Module, sfPeerIO_Module, sfAudioModule, sfPeerAudioModule, sfRF_Module);
; 
;       TOVS4_45_StatusFlagsSet = Set of TOVS4_45_StatusFlags;
; 
;       TDigitalOutputMode = (omOff, omOn,
;                             omLocalOverTemperature, omLocalUnderTemperature,
;                             omRemoteOverTemperature, omRemoteUnderTemperature,
;                             omPeerLink, omNoPeerLink,
;                             omLocalIn1, omLocalIn2, omLocalIn3, omLocalIn4,
;                             omRemoteIn1, omRemoteIn2, omRemoteIn3, omRemoteIn4,
;                             omPeerLocalIn1, omPeerLocalIn2, omPeerLocalIn3, omPeerLocalIn4,
;                             omPeerRemoteIn1, omPeerRemoteIn2, omPeerRemoteIn3, omPeerRemoteIn4,
;                             omVideo1, omVideo2, omVideo3, omVideo4,
;                             omNoVideo1, omNoVideo2, omNoVideo3, omNoVideo4, omAnyNoVideo,
;                             omLock1, omLock2, omLock3, omLock4,
;                             omNoLock1, omNoLock2, omNoLock3, omNoLock4, omAnyNoLock,
;                             omAudioIn1, omAudioIn2, omAudioIn3, omAudioIn4,
;                             omLoadVoltageWithinLimits, omLoadVoltageOutOfLimits,
;                             omLoadCurrentWithinLimits, omLoadCurrentOutOfLimits,
;                             omRFPowerWithinLimits, omRFPowerOutOfLimits);
; 
;       TVideoOutputRouting = (vrOff, vrInputA, vrInputB, vrTest, vrInputA_Off, vrInputA_B, vrInputA_Test, vrInputB_Off, vrInputB_A, vrInputB_Test);
; 
;       TCmd_OVS4_45_Setup = packed Record
;                              osBlockData:                  TBlockData;
;                              osFlags:                      TOVS4_45_FlagsSet;
;                              osStatusFlags:                TOVS4_45_StatusFlagsSet;
;                              osDigitalInputs:              Byte; { Local 4321 - Remote 4321 }
;                              osDigitalInputsType:          Byte; { Local 4321 - Remote 4321, 0 = NO, 1 = NC}
;                              osPeerDigitalInputs:          Byte; { Local 4321 - Remote 4321 }
;                              osDigitalOutputMode:          Array [1..8] of TDigitalOutputMode;  { 1..4 = local, 5..8 = remote }
;                              osDigitalOutputs:             Byte; { Local 4321 - Remote 4321 }
;                              osLocalTemperatureThreshold:  Word;
;                              osRemoteTemperatureThreshold: Word;
;                              osVideoOutputFlags:           Array [1..8] of Byte;
;                              osVideoOutputRouting:         Array [1..8] of TVideoOutputRouting;
;                              osDigitalInputCounter:        Array [1..8] of Byte;
;                            end;
; 
;       TUARTFlags = (ufRxDisabled, ufLoopBack, ufLoopBackRS485, ufHalfDuplex, ufRS485_RS422);
; 
;       TUARTFlagsSet = Set of TUARTFlags;
; 
;       TUART = packed Record
;                 uaBaudRateDivisor:     Word;           { 115200 / Baud rate }
;                 uaLineControlRegister: Byte;           { Parity, Stop bits, Word length, bits 5..0 }
;                 uaFlags:               TUARTFlagsSet;
;               end;
; 
;       TUART_IMC = packed Record
;                     iuBaudRate:        Word;             { BaudRate / 100 }
;                     iuUartMode:        Byte;             { Parity, Stop bits, Word length }
;                     iuUartFlags:       TUARTFlagsSet;    { ufRxDisabled, ufLoopBack, ufLoopBackRS485 }
;                     iuUartProtocols:   TProtocols2Set;
;                     iuUartDestinationAddress_Frame: Byte;
;                     iuUartDestinationAddress:       Byte;
;                     iuUartDestinationPort:          Byte;
;                   end;
; 
;       TCmd_UART_Setup = packed Record
;                           osBlockData:      TBlockData;
;                           osUART:           Array [1..4] of TUART;
;                           osProtocols:      Array [1..4] of TProtocols2Set;
;                         end;
; 
;       TTransportFlags = (tfPC1, tfPC2, tfPC3, tfPC4, tfDataLink, tfIO_Module, tfAudioModule);
; 
;       TTransportFlagsSet = Set Of TTransportFlags;
; 
;       TCmd_UART_Transport = packed Record
;                               utBlockData:     TBlockData;
;                               utFlags:         TTransportFlagsSet;
;                               utDigitalInputs: Byte;
;                               utAddress:       Byte;
;                               utDataSize:      Byte;
;                               utSize:          Array [1..4] of Byte;
;                               utData:          Array [0..0] of Byte;
;                             end;
; 
;       TCmd_UART_Test = packed Record
;                          utBlockData:          TBlockData;
;                          utLoopBackTestResult: Byte;   { RS485 4321, UART 4321 }
;                          utAvailableLinks:     Byte;   { RS485 4321, UART 4321 }
;                        end;
; 
;       TLinkFlags = (lfConnectedLink1, lfConnectedLink2, lfConnectedLink3, lfConnectedLink4, lf);
; 
;       TLinkFlagsSet = Set Of TLinkFlags;
; 
;       TCmd_LinkData =  packed Record
;                          lnBlockData:          TBlockData;
;                          lnLinkFlags:          TLinkFlagsSet;
;                          lnLinkName:           Array [1..4] of TLocationName;
;                        end;
; 
;       TCmd_UserText = packed Record
;                         utBlockData:          TBlockData;
;                         utUserText:           TUserText;
;                       end;
; 
;       TCmd_ModuleInfo = packed Record
;                           utBlockData:         TBlockData;
;                           miModuleName:        TModuleName;
;                           miSerialNumber:      TSerialNumber;
;                           miPartNumber:        TSerialNumber;
;                           miRMANumber:         TSerialNumber;
;                           miHardwareVersion:   T4;
;                           miBoardVersion:      T4;
;                           miTestHistory:       T4;
;                           miDate:              T10;
;                         end;
; 
;       TCmd_UserTexts = packed Record
;                          utBlockData:         TBlockData;
;                          utGroup:             Byte;
;                          utSystemName:        TLocationName;
;                          utSystemLocation:    TLocationName;
;                          utLinkInfo:          TLocationName;
;                          utUserText:          TLocationName;
;                        end;
; 
;       TSPDIF_Flags = (sfLock);
; 
;       TSPDIF_FlagsSet = Set of TSPDIF_Flags;
; 
;       TCmd_SPDIF = packed Record
;                      siBlockData:           TBlockData;
;                      siFlags:               TSPDIF_FlagsSet;
;                      siDigitalInputsType:   Byte; { xxxx - Remote 4321, 0 = NO, 1 = NC}
;                      siDigitalInputs:       Byte; { xxxx - Remote 4321 }
;                      siDigitalInputCounter: Array [1..4] of Byte;
;                      siDigitalOutputMode:   Array [1..4] of TDigitalOutputMode;
;                      siDigitalOutputs:      Byte; { xxxx - Remote 4321 }
;                      siInputGain:           Word;
;                      siOutputVolume:        Word;
;                    end;
; 
;       TCmd_OVS4_45_RF = Record
;                           rfBlockData:    TBlockData;
;                           rfRegisters:    Array [$00..$16] of Word;
;                           rfAttenuator:   Byte;
;                           rfMeasureAtt:   Byte;
;                           rfLevel:        Word;
;                           rfADC1:         Word;
;                           rfADC2:         Word;
;                           rfADC3:         Word;
;                           rfRFLowerLimit: Word;
;                           rfRFUpperLimit: Word;
;                           Spare0:         Word;
;                           Spare1:         Word;
;                         end;
; 
;       TSFP_Data = Array [0..63] of Byte;
; 
;       TCmd_SFP = Record
;                    sfpBlockData: TBlockData;
;                    sfpAddress:   Word;
;                    sfpSize:      Byte;
;                    sfpData:      TSFP_Data;
;                  end;
; 
;       TUIFlags = (uifOutputEnabled);
;       TUIFlagsSet = Set of TUIFlags;
; 
;       TFanFlags = (uifManual, uifManualState, uifManual1, uifManualState1, uifManual2, uifManualState2, uifManual3, uifManualState3);
;       TFanFlagsSet = Set of TFanFlags;
; 
;       TFanStatus = (uifFanFault, uifFanFault1, uifFanFault2, uifFanFault3, uifFanWarning, uifFanWarning1, uifFanWarning2, uifFanWarning3);
;       TFanStatusSet = Set of TFanStatus;
; 
;       TLimits = Record
;                   limShutdownUpperLimit: Byte;
;                   limShutdownLowerLimit: Byte;
;                   limWarningUpperLimit:  Byte;
;                   limWarningLowerLimit:  Byte;
;                 end;
; 
;       TCmd_UI = Record
;                   uiBlockData:    TBlockData;
;                   uiFlags:        TUIFlagsSet;
;                   uiFanFlags:     TFanFlagsSet;
;                   uiRegisters:    Array [$00..$05] of Word;
;                   uiADC:          Word;
;                   uiFanRpm:       Array [0..3] of Word;
;                   uiFanDutyCycle: Array [0..3] of Byte;
;                   uiFanStatus:    TFanStatusSet;
;                   uiVoltage:      TLimits;
;                   uiCurrent:      TLimits;
;                   uiTemperature:  TLimits;
;                 end;
; 
;       TRegister = Record
;                     Number: Byte;
;                     Data:   Byte;
;                   end;
; 
;       TCmd_Registers = Record
;                          regBlockData:         TBlockData;
;                          regID:                Byte;
;                          regNumberOfRegisters: Byte;
;                          regRegister:          Array [$00..MAX_Cmd_Registers - 1] of TRegister;
;                        end;
; 
;       TCmd_Hours = Record
;                      regBlockData:         TBlockData;
;                      hComponentHours:      Array [0..7] of LongInt;
;                      hEnabledFlags:        Byte;
;                      hWriteFlags:          Byte;
;                    end;
; 
;       TCommCounters_UART = Record
;                              ccReceivedBytes:        LongInt;
;                              ccReceivedByteErrors:   LongInt;
;                              ccReceivedPackets:      LongInt;
;                              ccReceivedPacketErrors: LongInt;
;                              ccProcessedPackets:     LongInt;
;                              ccTransmittedBytes:     LongInt;
;                              ccTransmittedPackets:   LongInt;
;                            end;
; 
;       TCmd_CommCounters = Record
;                             ccBlockData:    TBlockData;
;                             ccCounter:      Array [0..3] of TCommCounters_UART;
;                           end;
; 
;       TTransceiverFlags = (trfSFP, trfSingleFiber, trfLaserTypeDFB);
;       TTransceiverFlagsSet = Set of TTransceiverFlags;
; 
;       TCmd_Transceiver = Record
;                            trBlockData:          TBlockData;
;                            trTransceiverFlags:   TTransceiverFlagsSet;
;                            trTransceiverGroup:   Byte;
;                            trInterfaceConnector: Byte;
;                            trTypicalBaudrate:    Byte;
;                            trLaserWavelength:    Word;
;                            trLinkLength_9um:     Byte;  { km }
;                            trLinkLength_50um:    Byte;  { 10 m }
;                            trLinkLength_62um:    Byte;  { 10 m }
;                            trTXOutputPower:      Word;  { 0.1 uW }
;                            trRXReceivedPower:    Word;  { 0.1 uW }
;                            trWDMFilterIsolation: Byte;  { dB }
;                            trCrosstalk:         Byte;  { dB }
;                            trUserText:           TLocationName;
;                          end;
; 
; 
; 
;       TOutputFunction = (osOff, osOn, osInput1, osInput2, osPeerInput1, osPeerInput2, osPeerOutput, osVideo1, osVideo2, osVideo3, osVideo4, osAllVideos, osOpticalLink);
;       TIOFlags = (iofInput1Inverted, iofInput2Inverted, iofOutputInverted, iofInput1State, iofInput2State, iofOutputState, iofCommBridge);
;       TIOFlagsSet = Set of TIOFlags;
; 
;       TCmd_IMC_Video =   Record
;                            ivBlockData:          TBlockData;
;                            ivADC12:              Word;
;                            ivADC34:              Word;
;                            ivVideoADC:           Array [1..4] of Byte;
;                            ivVideoADC_Peer:      Array [1..4] of Byte;
;                            ivFlags:              TIOFlagsSet;
;                            ivOutputFunction:     TOutputFunction;
;                          end;
; Const
; 
; UART_CONFIG_WLEN_MASK   = $60;  // Mask for extracting word length
; UART_CONFIG_WLEN_8      = $60;  // 8 bit data
; UART_CONFIG_WLEN_7      = $40;  // 7 bit data
; UART_CONFIG_WLEN_6      = $20;  // 6 bit data
; UART_CONFIG_WLEN_5      = $00;  // 5 bit data
; UART_CONFIG_STOP_MASK   = $08;  // Mask for extracting stop bits
; UART_CONFIG_STOP_ONE    = $00;  // One stop bit
; UART_CONFIG_STOP_TWO    = $08;  // Two stop bits
; UART_CONFIG_PAR_MASK    = $86;  // Mask for extracting parity
; UART_CONFIG_PAR_NONE    = $00;  // No parity
; UART_CONFIG_PAR_EVEN    = $06;  // Even parity
; UART_CONFIG_PAR_ODD     = $02;  // Odd parity
; UART_CONFIG_PAR_ONE     = $86;  // Parity bit is one
; UART_CONFIG_PAR_ZERO    = $82;  // Parity bit is zero
; 
; Type
; 
;       TCmd_IMC_UART =    Record
;                            iuBlockData:          TBlockData;
;                            iuUART:               Array [0..0] of TUART_IMC;
;                          end;
; 
; 
; Const VersionHi = 0;
;       VersionLo = 10;
; 
;       SamplesPerPeriod_1kHz   =  8;
;       SamplesPerPeriod_100Hz  = 80;
; 
;       Sinus_100Hz: Array [0..SamplesPerPeriod_100Hz - 1] of Byte = ({$I Sin100Hz.inc });
Sinus_100Hz:                    
; $7F,
                                DB        $7F                         ; $7F = 127
; $89,
                                DB        $89                         ; $89 = 137
; $93,
                                DB        $93                         ; $93 = 147
; $9D,
                                DB        $9D                         ; $9D = 157
; $A6,
                                DB        $A6                         ; $A6 = 166
; $B0,
                                DB        $B0                         ; $B0 = 176
; $B9,
                                DB        $B9                         ; $B9 = 185
; $C1,
                                DB        $C1                         ; $C1 = 193
; $CA,
                                DB        $CA                         ; $CA = 202
; $D1,
                                DB        $D1                         ; $D1 = 209
; $D9,
                                DB        $D9                         ; $D9 = 217
; $E0,
                                DB        $E0                         ; $E0 = 224
; $E6,
                                DB        $E6                         ; $E6 = 230
; $EB,
                                DB        $EB                         ; $EB = 235
; $F0,
                                DB        $F0                         ; $F0 = 240
; $F4,
                                DB        $F4                         ; $F4 = 244
; $F8,
                                DB        $F8                         ; $F8 = 248
; $FA,
                                DB        $FA                         ; $FA = 250
; $FC,
                                DB        $FC                         ; $FC = 252
; $FE,
                                DB        $FE                         ; $FE = 254
; $FE,
                                DB        $FE                         ; $FE = 254
; $FE,
                                DB        $FE                         ; $FE = 254
; $FC,
                                DB        $FC                         ; $FC = 252
; $FA,
                                DB        $FA                         ; $FA = 250
; $F8,
                                DB        $F8                         ; $F8 = 248
; $F4,
                                DB        $F4                         ; $F4 = 244
; $F0,
                                DB        $F0                         ; $F0 = 240
; $EB,
                                DB        $EB                         ; $EB = 235
; $E6,
                                DB        $E6                         ; $E6 = 230
; $E0,
                                DB        $E0                         ; $E0 = 224
; $D9,
                                DB        $D9                         ; $D9 = 217
; $D1,
                                DB        $D1                         ; $D1 = 209
; $CA,
                                DB        $CA                         ; $CA = 202
; $C1,
                                DB        $C1                         ; $C1 = 193
; $B9,
                                DB        $B9                         ; $B9 = 185
; $B0,
                                DB        $B0                         ; $B0 = 176
; $A6,
                                DB        $A6                         ; $A6 = 166
; $9D,
                                DB        $9D                         ; $9D = 157
; $93,
                                DB        $93                         ; $93 = 147
; $89,
                                DB        $89                         ; $89 = 137
; $7F,
                                DB        $7F                         ; $7F = 127
; $75,
                                DB        $75                         ; $75 = 117
; $6B,
                                DB        $6B                         ; $6B = 107
; $61,
                                DB        $61                         ; $61 = 97
; $58,
                                DB        $58                         ; $58 = 88
; $4E,
                                DB        $4E                         ; $4E = 78
; $45,
                                DB        $45                         ; $45 = 69
; $3D,
                                DB        $3D                         ; $3D = 61
; $34,
                                DB        $34                         ; $34 = 52
; $2D,
                                DB        $2D                         ; $2D = 45
; $25,
                                DB        $25                         ; $25 = 37
; $1E,
                                DB        $1E                         ; $1E = 30
; $18,
                                DB        $18                         ; $18 = 24
; $13,
                                DB        $13                         ; $13 = 19
; $0E,
                                DB        $0E                         ; $0E = 14
; $0A,
                                DB        $0A                         ; $0A = 10
; $06,
                                DB        6                           ; $06 = 6
; $04,
                                DB        4                           ; $04 = 4
; $02,
                                DB        2                           ; $02 = 2
; $00,
                                DB        0                           ; $00 = 0
; $00,
                                DB        0                           ; $00 = 0
; $00,
                                DB        0                           ; $00 = 0
; $02,
                                DB        2                           ; $02 = 2
; $04,
                                DB        4                           ; $04 = 4
; $06,
                                DB        6                           ; $06 = 6
; $0A,
                                DB        $0A                         ; $0A = 10
; $0E,
                                DB        $0E                         ; $0E = 14
; $13,
                                DB        $13                         ; $13 = 19
; $18,
                                DB        $18                         ; $18 = 24
; $1E,
                                DB        $1E                         ; $1E = 30
; $25,
                                DB        $25                         ; $25 = 37
; $2D,
                                DB        $2D                         ; $2D = 45
; $34,
                                DB        $34                         ; $34 = 52
; $3D,
                                DB        $3D                         ; $3D = 61
; $45,
                                DB        $45                         ; $45 = 69
; $4E,
                                DB        $4E                         ; $4E = 78
; $58,
                                DB        $58                         ; $58 = 88
; $61,
                                DB        $61                         ; $61 = 97
; $6B,
                                DB        $6B                         ; $6B = 107
; $75
                                DB        $75                         ; $75 = 117
;       Sinus_1kHz:  Array [0..SamplesPerPeriod_1kHz - 1] of Byte = ({$I Sin_1kHz.inc });
Sinus_1kHz:                     
; $7F,
                                DB        $7F                         ; $7F = 127
; $D9,
                                DB        $D9                         ; $D9 = 217
; $FE,
                                DB        $FE                         ; $FE = 254
; $D9,
                                DB        $D9                         ; $D9 = 217
; $7F,
                                DB        $7F                         ; $7F = 127
; $25,
                                DB        $25                         ; $25 = 37
; $00,
                                DB        0                           ; $00 = 0
; $25
                                DB        $25                         ; $25 = 37
; 
;       SignatureLength = 7;
; 
;       KeepAliveByte   = $00;
;       LocalRemoteFlag = $80;
; 
;       STX             = $02;
;       ETX             = $03;
;       ACK             = $06;
; 
;       SignatureOffset = $0010;
; 
;       EEPROM_Size    = $1000;
;       MaxPacketSize  = PacketHeaderSize + 90;
; 
;       EmptyLine30 = '                              ';
;       EmptyLine15 = '               ';
; 
; {$IFDEF DPS900 }
;   {$DEFINE BaudRateExt_19200  }
; {$ELSE}
;   {$DEFINE BaudRateExt_172800  }
; {$ENDIF}
; 
; 
;       Const1ms                 = Word (- 22118400 div 12 div 1000);
;       BaudRateTimerValue       = Byte (- 22118400 div 12 div 32 div 19200);
;       ConversionClock          = Byte ((22118 div 2500) shl 3); { for 2.5 MHz }
;       DAC_SampleRateTimerValue = Word (- (22118400 div 8000));
; 
; 
;   {$IFDEF BaudRateExt_19200 }
;       BaudRateTimerValue1 = Word (- 22118400 div 32 div 19200);
;   {$ENDIF}
;   {$IFDEF BaudRateExt_38400 }
;       BaudRateTimerValue1 = Word (- 22118400 div 32 div 38400);
;   {$ENDIF}
;   {$IFDEF BaudRateExt_76800 }
;       BaudRateTimerValue1 = Word (- 22118400 div 32 div 76800);
;   {$ENDIF}
;   {$IFDEF BaudRateExt_115200 }
;       BaudRateTimerValue1 = Word (- 22118400 div 32 div 115200);
;   {$ENDIF}
;   {$IFDEF BaudRateExt_172800 }
;       BaudRateTimerValue1 = Word (- 22118400 div 32 div 172800);
;   {$ENDIF}
; 
;       DefaultModeFlags = 0;
; 
;       AdditionalReplyTimeForRemoteLinkModule =     7;       { Time needed to transmit broadcast to other remote modules }
;       ExtCommunicationTime                   =   250;       { Max time before ext comm confirmation }
;       RS485_Time                             =     1;
;       RS485_Time_External                    = RS485_Time + 20; { Max time before switch from ext comm to int comm }
;       LedTime                                =    30;
;       LedTimeExt                             =    10;
;       TxBlockDelay                           =    13;
;       CommRxEndWaitTime                      =    20;
; 
;       FilterConstant = 100;
; 
;       Led_OFF   = True;
;       Led_ON    = False;
;       sInternal = True;
;       sExternal = False;
; 
;                               { pin5, pin8, pin3, pin20, pin6, pin10, pin1, pin11 }
;       PinToInput: Array [TInputPin] of Byte = (3, 5, 2, 8, 4, 6, 1, 7);
PinToInput:                     DB        3                           ; $03 = 3
                                DB        5                           ; $05 = 5
                                DB        2                           ; $02 = 2
                                DB        8                           ; $08 = 8
                                DB        4                           ; $04 = 4
                                DB        6                           ; $06 = 6
                                DB        1                           ; $01 = 1
                                DB        7                           ; $07 = 7
; 
;       vIn_NC             = pin1;
;       vIn_COM_Out        = pin3;    { A22 }
;       vIn_NC2            = pin5;    { NC, reserve }
;       vIn_IO             = pin6;
;       vIn_OSD_Out        = pin8;
;       vIn_Optic_RX       = pin10;
;       vIn_VideoIn        = pin11;
;       vIn_Spare          = pin20;   { Spare, AUX video }
; 
;       vOut_VideoOut_BUS  = pin13;
;       vOut_OSD_In        = pin14;
;       vOut_VideoOut      = pin17;   { REMOTE: ext. sync out, LOCAL: video out  }
;       vOut_IO            = pin16;
;       vOut_ExtSyncOut    = pin15;
;       vOut_Optic_TX      = pin18;
; 
; 
; Type TSignature = Array [0..SignatureLength - 1] of Char;
; 
;      TPacketType = (ptTurbo, ptPanasonic);
; 
;      TErrorCode = (ecNone, ecTEA6415, ecTDA8425, ecEEPROM);
; 
;      TBufferArray = Array [0..MaxPacketSize - 1] of Byte;
; 
;      PExtendedGeneralPacket = ^TExtendedGeneralPacket XDATA;
; 
;      TEEPROM_Data = Record
;                       eeSignature:          TSignature;
;                       eeSerialNumber:       TSerialNumber;
;                       eeComment:            TComment;
;                       eeSourceName:         TSourceName;
;                       eeMiscFlags:          Byte;
;                       eeSourceDescription:  TSourceDescription;
;                       eeModeFlags:          Byte;
;                       eeRemoteSlots:        TRemoteSlots;
;                       eeProtocols:          TProtocolsSet;
;                       eeEND:                Byte;
;                     end;
; 
; Var   Int_RS485_TX:            Boolean absolute P3.6;
Int_RS485_TX                    BIT      P3.6

;       Ext_RS485_TX:            Boolean absolute P0.7;
Ext_RS485_TX                    BIT      P0.7

;       Ext_RS485_TX_Int:        Boolean absolute P0.6;
Ext_RS485_TX_Int                BIT      P0.6

;       A0:                      Boolean absolute P3.2;
A0                              BIT      P3.2

;       A1:                      Boolean absolute P3.3;
A1                              BIT      P3.3

;       A2:                      Boolean absolute P3.4;
A2                              BIT      P3.4

;       RemoteLink:              Boolean absolute P3.7;
RemoteLink                      BIT      P3.7

; 
;       Led_PowerSupply_U:       Boolean absolute P3.1;
Led_PowerSupply_U               BIT      P3.1

;       Led_PowerSupply_I:       Boolean absolute P3.0;
Led_PowerSupply_I               BIT      P3.0

; 
;       KS5520.OSD_SCK:          Boolean absolute P2.7;
OSD_SCK                         BIT      P2.7

;       KS5520.OSD_SIN:          Boolean absolute P2.5;
OSD_SIN                         BIT      P2.5

;       KS5520.OSD_CSB:          Boolean absolute P2.6;
OSD_CSB                         BIT      P2.6

;       OSD_SYD:                 Boolean absolute P2.4;
OSD_SYD                         BIT      P2.4

;       I_DET:                   Boolean absolute P1.7;
I_DET                           BIT      P1.7

;       U_DET:                   Boolean absolute P1.6;
U_DET                           BIT      P1.6

; 
; 
;       LOCK:                    Boolean absolute P3.5;
LOCK                            BIT      P3.5

; 
;       KeysAndSlotPort:         Byte absolute P4;
KeysAndSlotPort                 EQU      P4

;       LedsAndLatchPort:        Byte absolute P5;
LedsAndLatchPort                EQU      P5

; 
;       EEPROM_Data:             TEEPROM_Data XDATA absolute 0;
EEPROM_Data                     EQU      0

; 
;       Leds:                    Byte DATA;      { $24: $20..$27 }

RSEG _DATA

Leds:                           DS       1

;       KeysAndSlot:             Byte DATA;
KeysAndSlot:                    DS       1

;       IOData:                  Byte DATA;
; 
;       Led_Error:               Boolean absolute $24.0;
Led_Error                       BIT      $24.0

;       Led_VideoLink:           Boolean absolute $24.1;
Led_VideoLink                   BIT      $24.1

;       Led_TX_Int:              Boolean absolute $22;
Led_TX_Int                      BIT      $24.2

;       Led_RX_Int:              Boolean absolute $23;
Led_RX_Int                      BIT      $24.3

;       Led_TX_Ext:              Boolean absolute $24;
Led_TX_Ext                      BIT      $24.4

;       Led_RX_Ext:              Boolean absolute $25;
Led_RX_Ext                      BIT      $24.5

; 
;       Key_Enter:               Boolean absolute $28;
Key_Enter                       BIT      $25.0

;       Key_Down:                Boolean absolute $29;
Key_Down                        BIT      $25.1

;       Key_Up:                  Boolean absolute $2A;
Key_Up                          BIT      $25.2

;       SlotBit0:                Boolean absolute $2C;
SlotBit0                        BIT      $25.4

;       SlotBit1:                Boolean absolute $2D;
SlotBit1                        BIT      $25.5

;       SlotBit2:                Boolean absolute $2E;
SlotBit2                        BIT      $25.6

;       SlotBit3:                Boolean absolute $2F;
SlotBit3                        BIT      $25.7

; 
;       DO4:                     Boolean absolute $30;
DO4                             BIT      $26.0

;       DO3:                     Boolean absolute $31;
DO3                             BIT      $26.1

;       DO2:                     Boolean absolute $32;
DO2                             BIT      $26.2

;       DO1:                     Boolean absolute $33;
DO1                             BIT      $26.3

;       Tipka1:                  Boolean absolute $34;
Tipka1                          BIT      $26.4

;       Tipka2:                  Boolean absolute $35;
Tipka2                          BIT      $26.5

;       Tipka3:                  Boolean absolute $36;
Tipka3                          BIT      $26.6

;       Tipka4:                  Boolean absolute $37;
Tipka4                          BIT      $26.7

; 
;       TempByte:                Byte;
TempByte:                       DS       1

;       Counter:                 Byte;
;       Slot:                    Byte;
Slot:                           DS       1

;       ErrorLedTimer:           Byte;
ErrorLedTimer:                  DS       1

;       RX_Int_LedTimer:         Byte;
RX_Int_LedTimer:                DS       1

;       RX_Ext_LedTimer:         Byte;
RX_Ext_LedTimer:                DS       1

;       TX_Int_LedTimer:         Byte;
TX_Int_LedTimer:                DS       1

;       TX_Ext_LedTimer:         Byte;
TX_Ext_LedTimer:                DS       1

;       BlinkTimer:              Word;
BlinkTimer:                     DS       2

;       ExtCommunicationTimer:   Byte;
ExtCommunicationTimer:          DS       1

;       ExtCommKeepAliveCounter: Byte;
;       SlowBlinkTimer:          Byte;
SlowBlinkTimer:                 DS       1

;       RS485_Timer:             Byte;
RS485_Timer:                    DS       1

;       RS485_Timer_External:    Byte;
RS485_Timer_External:           DS       1

;       TX_Counter_Int:          Byte;
TX_Counter_Int:                 DS       1

;       TX_Counter_Ext:          Byte;
TX_Counter_Ext:                 DS       1

;       RX_Counter_Int:          Byte;
RX_Counter_Int:                 DS       1

;       RX_Counter_Ext:          Byte;
RX_Counter_Ext:                 DS       1

;       RX_Checksum_Int:         Byte;
RX_Checksum_Int:                DS       1

;       RX_Checksum_Ext:         Byte;
RX_Checksum_Ext:                DS       1

;       TestMode:                Boolean;

RSEG _BIT

TestMode:                       DBIT     1

;       KeyPressed:              Boolean;
KeyPressed:                     DBIT     1

;       TempBoolean:             Boolean;
TempBoolean:                    DBIT     1

;       Last_I_DET:              Boolean;
Last_I_DET:                     DBIT     1

;       Last_U_DET:              Boolean;
Last_U_DET:                     DBIT     1

;       I_DET_Active:            Boolean;
I_DET_Active:                   DBIT     1

;       U_DET_Active:            Boolean;
U_DET_Active:                   DBIT     1

;       RemoteLinkCounter:       Byte;

RSEG _DATA

RemoteLinkCounter:              DS       1

;       RemoteLinkActive:        Boolean;

RSEG _BIT

RemoteLinkActive:               DBIT     1

;       I_DET_Counter:           Byte;

RSEG _DATA

I_DET_Counter:                  DS       1

;       U_DET_Counter:           Byte;
U_DET_Counter:                  DS       1

;       IntCommActive:           Boolean;

RSEG _BIT

IntCommActive:                  DBIT     1

;       ExtCommActive:           Boolean;
ExtCommActive:                  DBIT     1

;       VideoInputPin:           TInputPin DATA;

RSEG _DATA

VideoInputPin:                  DS       1

;       OSDVideoInputPin:        TInputPin DATA;
OSDVideoInputPin:               DS       1

;       Row:                     Byte;
Row:                            DS       1

;       EqState:                 Byte;   { Must be DATA !!! }
EqState:                        DS       1

;       MiscFlags:               Byte;
MiscFlags:                      DS       1

;       ModeFlags:               Byte;
ModeFlags:                      DS       1

;       RemoteSlots:             TRemoteSlots IDATA;

RSEG _IDATA

RemoteSlots:                    DS       16

;       Int_PacketCounter:       Byte;

RSEG _DATA

Int_PacketCounter:              DS       1

;       Int_PacketOK_Counter:    Byte;
Int_PacketOK_Counter:           DS       1

;       Ext_PacketCounter:       Byte;
Ext_PacketCounter:              DS       1

;       Ext_PacketOK_Counter:    Byte;
Ext_PacketOK_Counter:           DS       1

;       IntCommPacketTimer:      Word;
IntCommPacketTimer:             DS       2

;       ExtCommPacketTimer:      Word;
ExtCommPacketTimer:             DS       2

;       BroadcastReplyTime_Int:  Word;
BroadcastReplyTime_Int:         DS       2

;       BroadcastReplyTimer_Int: Word;
BroadcastReplyTimer_Int:        DS       2

;       BroadcastReplyTime_Ext:  Word;
BroadcastReplyTime_Ext:         DS       2

;       BroadcastReplyTimer_Ext: Word;
BroadcastReplyTimer_Ext:        DS       2

;       DelayTimer:              Word;
DelayTimer:                     DS       2

;       LoopTestTimer:           Word;
LoopTestTimer:                  DS       2

;       Temperature_L:           Byte;
Temperature_L:                  DS       1

;       Temperature_H:           Byte;
;       Temperature:             Word absolute Temperature_L;
Temperature                     EQU      Temperature_L

;       Protocols:               TProtocolsSet IDATA;

RSEG _IDATA

Protocols:                      DS       1

;       msCounter:               Word;

RSEG _DATA

msCounter:                      DS       2

; 
;       ErrorCode:               TErrorCode;
ErrorCode:                      DS       1

;       PacketType:              TPacketType;
PacketType:                     DS       1

; 
;       PTX_Buffer:                        ^TExtendedGeneralPacket   XDATA;
PTX_Buffer:                     DS       2

;       PTX_Buffer_Cmd_ModuleData:         ^TCmd_ModuleData          XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_ModuleData       EQU      PTX_Buffer

;       PTX_Buffer_Cmd_SourceNameAndFlags: ^TCmd_SourceNameAndFlags  XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_SourceNameAndFlags EQU      PTX_Buffer

;       PTX_Buffer_Cmd_SourceDescription:  ^TCmd_SourceDescription   XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_SourceDescription EQU      PTX_Buffer

;       PTX_Buffer_Cmd_RemoteSlots:        ^TCmd_RemoteSlots         XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_RemoteSlots      EQU      PTX_Buffer

;       PTX_Buffer_Cmd_EEPROM:             ^TCmd_EEPROM              XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_EEPROM           EQU      PTX_Buffer

;       PTX_Buffer_Cmd_FrameData:          ^TCmd_FrameData           XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_FrameData        EQU      PTX_Buffer

;       PTX_Buffer_Cmd_Message:            ^TCmd_Message             XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_Message          EQU      PTX_Buffer

;       PTX_Buffer_Cmd_Protocols:          ^TCmd_Protocols           XDATA absolute PTX_Buffer;
PTX_Buffer_Cmd_Protocols        EQU      PTX_Buffer

; 
;       PRX_Buffer:                        ^TExtendedGeneralPacket   XDATA;
PRX_Buffer:                     DS       2

;       PRX_Buffer_Cmd_ModuleData:         ^TCmd_ModuleData          XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_ModuleData       EQU      PRX_Buffer

;       PRX_Buffer_Cmd_SourceNameAndFlags: ^TCmd_SourceNameAndFlags  XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_SourceNameAndFlags EQU      PRX_Buffer

;       PRX_Buffer_Cmd_SourceDescription:  ^TCmd_SourceDescription   XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_SourceDescription EQU      PRX_Buffer

;       PRX_Buffer_Cmd_RemoteSlots:        ^TCmd_RemoteSlots         XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_RemoteSlots      EQU      PRX_Buffer

;       PRX_Buffer_Cmd_EEPROM:             ^TCmd_EEPROM              XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_EEPROM           EQU      PRX_Buffer

;       PRX_Buffer_Cmd_FrameData:          ^TCmd_FrameData           XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_FrameData        EQU      PRX_Buffer

;       PRX_Buffer_Cmd_Message:            ^TCmd_Message             XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_Message          EQU      PRX_Buffer

;       PRX_Buffer_Cmd_Protocols:          ^TCmd_Protocols           XDATA absolute PRX_Buffer;
PRX_Buffer_Cmd_Protocols        EQU      PRX_Buffer

; 
;       TX_Buffer_Int:                  TExtendedGeneralPacket XDATA;

RSEG _XDATA

TX_Buffer_Int:                  DS       92

;       TX_BufferArray_Int:             TBufferArray absolute TX_Buffer_Int;
TX_BufferArray_Int              EQU      TX_Buffer_Int

;       RX_Buffer_Int:                  TExtendedGeneralPacket XDATA;
RX_Buffer_Int:                  DS       92

;       RX_BufferArray_Int:             TBufferArray absolute RX_Buffer_Int;
RX_BufferArray_Int              EQU      RX_Buffer_Int

; 
;       TX_Buffer_Ext:                  TExtendedGeneralPacket XDATA;
TX_Buffer_Ext:                  DS       92

;       TX_BufferArray_Ext:             TBufferArray absolute TX_Buffer_Ext;
TX_BufferArray_Ext              EQU      TX_Buffer_Ext

;       RX_Buffer_Ext:                  TExtendedGeneralPacket XDATA;
RX_Buffer_Ext:                  DS       92

;       RX_BufferArray_Ext:             TBufferArray absolute RX_Buffer_Ext;
RX_BufferArray_Ext              EQU      RX_Buffer_Ext

; 
;       TX_Buffer_Delayed_Int:          Array [1..8] of TExtendedGeneralPacket XDATA;
TX_Buffer_Delayed_Int:          DS       736

;       TX_Buffer_Delayed_Ext:          Array [1..8] of TExtendedGeneralPacket XDATA;
TX_Buffer_Delayed_Ext:          DS       736

; 
;       DelayedTXCounter_Int:           Byte IDATA;

RSEG _IDATA

DelayedTXCounter_Int:           DS       1

;       DelayedTXCounter_Ext:           Byte IDATA;
DelayedTXCounter_Ext:           DS       1

; 
;       DAC_SampleCounter:              Byte;
; 
;       Blink:                          Boolean;

RSEG _BIT

Blink:                          DBIT     1

;       Sending_Int:                    Boolean;
Sending_Int:                    DBIT     1

;       Sending_Ext:                    Boolean;
Sending_Ext:                    DBIT     1

;       CommandReceived_Int:            Boolean;
CommandReceived_Int:            DBIT     1

;       CommandReceived_Ext:            Boolean;
CommandReceived_Ext:            DBIT     1

;       Local:                          Boolean;
Local:                          DBIT     1

;       Master:                         Boolean;
Master:                         DBIT     1

;       KeyPulse:                       Boolean;
KeyPulse:                       DBIT     1

;       ActiveBuffer_Ext:               Boolean;
ActiveBuffer_Ext:               DBIT     1

;       CommTestSent:                   Boolean;
CommTestSent:                   DBIT     1

;       SendKeepAliveByte:              Boolean;
SendKeepAliveByte:              DBIT     1

;       ReadyForExternalCommunication:  Boolean;
ReadyForExternalCommunication:  DBIT     1

;       DelayPacketToExt:               Boolean;
DelayPacketToExt:               DBIT     1

;       OtherModuleLocal:               Boolean;
OtherModuleLocal:               DBIT     1

; 
;       Current_ADC:                    Byte;

RSEG _DATA

Current_ADC:                    DS       1

;       Current_DAC:                    Byte;
Current_DAC:                    DS       1

; 
; 
; Procedure _1ms; Interrupt Timer0; Using 1; { 1 ms interrupt }
; Var LastTemperature: Word;


CSEG AT $000B

              AJMP     _1ms

RSEG _CODE

USING 1

_1ms:
; begin
              PUSH      PSW
              MOV       PSW, #8
              PUSH      ACC

;   TL0 :=  Lo (Const1ms);
              MOV       TL0, #$CD

;   TH0 :=  Hi (Const1ms);
              MOV       TH0, #$F8

; 
;   LedsAndLatchPort := Leds;
              MOV       $85, Leds

;   KeysAndSlot      := KeysAndSlotPort;
              MOV       KeysAndSlot, $84

; 
;   Inc (BlinkTimer);
              INC       BlinkTimer
              MOV       A, BlinkTimer
              JNZ       L_011E
              INC       BlinkTimer+1
L_011E:

;   KeyPulse := Lo (BlinkTimer) and $7F = 0;
              ANL       A, #$7F
              ADD       A, #$FF
              CPL       C
              MOV       KeyPulse, C

;   Blink := Lo (BlinkTimer) and $80 <> 0;
              MOV       A, BlinkTimer
              RLC       A
              MOV       Blink, C

; 
;   If ExtCommunicationTimer <> 0 then Dec (ExtCommunicationTimer)
              MOV       A, ExtCommunicationTimer
              JZ        L_0132
              DEC       ExtCommunicationTimer
              SJMP      L_013A
L_0132:

;     else begin
;            Ext_PacketCounter := 0;
              MOV       Ext_PacketCounter, #0

;            Ext_PacketOK_Counter := 0;
              MOV       Ext_PacketOK_Counter, #0

;            OtherModuleLocal := False;
              CLR       OtherModuleLocal

;          end;
L_013A:
; 
;   If msCounter <> 0 then Dec (msCounter) else
              MOV       A, msCounter+1
              ORL       A, msCounter
              JZ        L_014B
              DEC       msCounter
              MOV       A, msCounter
              CJNE      A, #-1, L_0149
              DEC       msCounter+1
L_0149:
              SJMP      L_0151
L_014B:

;     begin
;       msCounter := 1000;
              MOV       msCounter, #LOW  ($03E8)
              MOV       msCounter+1, #HIGH ($03E8)

;       (*If not AD0BUSY then
;         begin
;           LastTemperature := Temperature;
;           Temperature_L := ADC0L;
;           Temperature_H := ADC0H;
;           If LastTemperature <> 0 then Temperature := (Temperature + LastTemperature) div 2;    { Average }
;           AD0BUSY := True;                         { Start ADC conversion }
;         end;*)
;     end;
L_0151:
; 
;   Last_I_DET := I_DET;
              MOV       C, P1.7
              MOV       Last_I_DET, C

;   Last_U_DET := U_DET;
              MOV       C, P1.6
              MOV       Last_U_DET, C

;   If Lo (BlinkTimer) = 0 then                           { 12 per Lo (BlinkTimer) = 0 }
              MOV       A, BlinkTimer
              JNZ       L_015F

;     begin
;       Dec (SlowBlinkTimer);
              DEC       SlowBlinkTimer

;     end;
L_015F:
; 
;   If IntCommPacketTimer <> 0 then Dec (IntCommPacketTimer) else
              MOV       A, IntCommPacketTimer+1
              ORL       A, IntCommPacketTimer
              JZ        L_0170
              DEC       IntCommPacketTimer
              MOV       A, IntCommPacketTimer
              CJNE      A, #-1, L_016E
              DEC       IntCommPacketTimer+1
L_016E:
              SJMP      L_0182
L_0170:

;     begin
;       IntCommPacketTimer   := CommPacketTime;
              MOV       IntCommPacketTimer, #LOW  ($0BB8)
              MOV       IntCommPacketTimer+1, #HIGH ($0BB8)

;       Int_PacketCounter    := Int_PacketCounter div 2;
              MOV       A, Int_PacketCounter
              CLR       C
              RRC       A
              MOV       Int_PacketCounter, A

;       Int_PacketOK_Counter := Int_PacketOK_Counter div 2;
              MOV       A, Int_PacketOK_Counter
              CLR       C
              RRC       A
              MOV       Int_PacketOK_Counter, A

;     end;
L_0182:
;   If ExtCommPacketTimer <> 0 then Dec (ExtCommPacketTimer) else
              MOV       A, ExtCommPacketTimer+1
              ORL       A, ExtCommPacketTimer
              JZ        L_0193
              DEC       ExtCommPacketTimer
              MOV       A, ExtCommPacketTimer
              CJNE      A, #-1, L_0191
              DEC       ExtCommPacketTimer+1
L_0191:
              SJMP      L_01A5
L_0193:

;     begin
;       ExtCommPacketTimer   := ExtCommunicationTime;
              MOV       ExtCommPacketTimer, #LOW  ($00FA)
              MOV       ExtCommPacketTimer+1, #HIGH ($00FA)

;       Ext_PacketCounter    := Ext_PacketCounter div 2;
              MOV       A, Ext_PacketCounter
              CLR       C
              RRC       A
              MOV       Ext_PacketCounter, A

;       Ext_PacketOK_Counter := Ext_PacketOK_Counter div 2;
              MOV       A, Ext_PacketOK_Counter
              CLR       C
              RRC       A
              MOV       Ext_PacketOK_Counter, A

;     end;
L_01A5:
;   IntCommActive := Int_PacketOK_Counter > 2;
              MOV       A, Int_PacketOK_Counter
              ADD       A, #-3
              MOV       IntCommActive, C

;   ExtCommActive := Ext_PacketOK_Counter > 2;
              MOV       A, Ext_PacketOK_Counter
              ADD       A, #-3
              MOV       ExtCommActive, C

; 
;   If EEPROM_Timer <> 0 then Dec (EEPROM_Timer);
              MOV       A, EEPROM_Timer
              JZ        L_01B7
              DEC       EEPROM_Timer
L_01B7:

;   If DelayTimer <> 0 then Dec (DelayTimer);
              MOV       A, DelayTimer+1
              ORL       A, DelayTimer
              JZ        L_01C6
              DEC       DelayTimer
              MOV       A, DelayTimer
              CJNE      A, #-1, L_01C6
              DEC       DelayTimer+1
L_01C6:

;   If RS485_Timer <> 0 then Dec (RS485_Timer) else
              MOV       A, RS485_Timer
              JZ        L_01CE
              DEC       RS485_Timer
              SJMP      L_01D4
L_01CE:

;     begin
;       Int_RS485_TX := False;
              CLR       P3.6

;       Ext_RS485_TX := False;
              CLR       P0.7

;       Ext_RS485_TX_Int := False;
              CLR       P0.6

;     end;
L_01D4:
;   If BroadcastReplyTimer_Int <> 0 then Dec (BroadcastReplyTimer_Int);
              MOV       A, BroadcastReplyTimer_Int+1
              ORL       A, BroadcastReplyTimer_Int
              JZ        L_01E3
              DEC       BroadcastReplyTimer_Int
              MOV       A, BroadcastReplyTimer_Int
              CJNE      A, #-1, L_01E3
              DEC       BroadcastReplyTimer_Int+1
L_01E3:

;   If BroadcastReplyTimer_Ext <> 0 then Dec (BroadcastReplyTimer_Ext);
              MOV       A, BroadcastReplyTimer_Ext+1
              ORL       A, BroadcastReplyTimer_Ext
              JZ        L_01F2
              DEC       BroadcastReplyTimer_Ext
              MOV       A, BroadcastReplyTimer_Ext
              CJNE      A, #-1, L_01F2
              DEC       BroadcastReplyTimer_Ext+1
L_01F2:

;   If LoopTestTimer <> 0 then Dec (LoopTestTimer);
              MOV       A, LoopTestTimer+1
              ORL       A, LoopTestTimer
              JZ        L_0201
              DEC       LoopTestTimer
              MOV       A, LoopTestTimer
              CJNE      A, #-1, L_0201
              DEC       LoopTestTimer+1
L_0201:

; 
;   If RX_Ext_LedTimer <> 0 then Dec (RX_Ext_LedTimer);
              MOV       A, RX_Ext_LedTimer
              JZ        L_0207
              DEC       RX_Ext_LedTimer
L_0207:

; 
; {$IFDEF DPS900 }
;   Led_RX_Ext := not OSD_SYD;
              MOV       C, P2.4
              CPL       C
              MOV       $24.5, C

; {$ELSE}
;   Led_RX_Ext := RX_Ext_LedTimer = 0;
; {$ENDIF}
; 
;   If RX_Int_LedTimer <> 0 then Dec (RX_Int_LedTimer);
              MOV       A, RX_Int_LedTimer
              JZ        L_0212
              DEC       RX_Int_LedTimer
L_0212:

;   Led_RX_Int := RX_Int_LedTimer = 0;
              MOV       A, RX_Int_LedTimer
              ADD       A, #$FF
              CPL       C
              MOV       $24.3, C

; 
;   If TX_Ext_LedTimer <> 0 then Dec (TX_Ext_LedTimer);
              MOV       A, TX_Ext_LedTimer
              JZ        L_021F
              DEC       TX_Ext_LedTimer
L_021F:

;   Led_TX_Ext := TX_Ext_LedTimer = 0;
              MOV       A, TX_Ext_LedTimer
              ADD       A, #$FF
              CPL       C
              MOV       $24.4, C

; 
;   If TX_Int_LedTimer <> 0 then Dec (TX_Int_LedTimer);
              MOV       A, TX_Int_LedTimer
              JZ        L_022C
              DEC       TX_Int_LedTimer
L_022C:

;   Led_TX_Int := TX_Int_LedTimer = 0;
              MOV       A, TX_Int_LedTimer
              ADD       A, #$FF
              CPL       C
              MOV       $24.2, C

; 
;   If ErrorLedTimer <> 0 then Dec (ErrorLedTimer);
              MOV       A, ErrorLedTimer
              JZ        L_0239
              DEC       ErrorLedTimer
L_0239:

; end;
              POP       ACC
              POP       PSW
              RETI

; 
; Procedure Internal_RS485; Interrupt Serial; Using 2;   { Internal RS485 }
; Var Ch_Int: Byte DATA;


CSEG AT $0023

              AJMP     Internal_RS485

RSEG _CODE

USING 2

Internal_RS485:
; begin
              PUSH      PSW
              MOV       PSW, #$10
              PUSH      ACC
              PUSH      DPL
              PUSH      DPH

;   If TI then
              JNB       SCON.1, L_027A

;     begin
;       TI := False;
              CLR       SCON.1

;       If TX_Counter_Int < TX_Buffer_Int.PacketSize then
              MOV       DPTR, #TX_Buffer_Int+1
              MOVX      A, @DPTR
              SETB      C
              SUBB      A, TX_Counter_Int
              JC        L_0272

;         begin
;           TX_Int_LedTimer := LedTime;
              MOV       TX_Int_LedTimer, #$1E

;           RS485_Timer          := RS485_Time;
              MOV       RS485_Timer, #1

;           RS485_Timer_External := RS485_Time_External;
              MOV       RS485_Timer_External, #$15

;           SBUF := TX_BufferArray_Int [TX_Counter_Int];
              MOV       A, TX_Counter_Int
              ADD       A, #LOW  (TX_Buffer_Int)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (TX_Buffer_Int)
              MOV       DPH, A
              MOVX      A, @DPTR
              MOV       SBUF, A

;           Inc (TX_Counter_Int);
              INC       TX_Counter_Int

;         end else begin
              SJMP      L_027A
L_0272:

;                    Ext_RS485_TX := False;
              CLR       P0.7

;                    Int_RS485_TX := False;
              CLR       P3.6

;                    Ext_RS485_TX_Int := False;
              CLR       P0.6

;                    Sending_Int  := False;
              CLR       Sending_Int

;                  end;
;     end;
L_027A:
;   If RI then
              JB        SCON.0, L_0280
              LJMP      L_03AA
L_0280:

;     begin
;       RI := False;
              CLR       SCON.0

;       RX_Int_LedTimer := LedTime;
              MOV       RX_Int_LedTimer, #$1E

;       If Sending_Int or CommandReceived_Int then Exit;
              JB        Sending_Int, L_028B
              JNB       CommandReceived_Int, L_028E
L_028B:
              LJMP      L_03AA
L_028E:

;       Ch_Int := SBUF;
              MOV       R3, SBUF

; 
;       Case RX_Counter_Int of
;         0: Case Ch_Int of
              MOV       A, RX_Counter_Int
              JNZ       L_02B4

;              TurboStartByte: PacketType := ptTurbo;
              CJNE      R3, #$AA, L_029B
              MOV       PacketType, A
              SJMP      L_02E1
L_029B:

;              ACK,
              MOV       A, R3
              XRL       A, #6
              JZ        L_02A3
              CJNE      R3, #2, L_02AE
L_02A3:

;              STX: Case Local of
;                     False: PacketType := ptPanasonic;                           { Accept Panasonic protocol only on remote module }
              JB        Local, L_02AB
              MOV       PacketType, #1
              SJMP      L_02E1
L_02AB:

;                     else Exit;
              LJMP      L_03AA
L_02AE:

;                   end;
;              else begin
;                     ErrorLedTimer := 2;                                         { Trash }
              MOV       ErrorLedTimer, #2

;                     Exit;
              LJMP      L_03AA

;                   end;
L_02B4:
;            end;
;         else
;           Case PacketType of
;             ptPanasonic: Case Ch_Int of
              MOV       A, PacketType
              CJNE      A, #1, L_02E1

;                            TurboStartByte: begin
              CJNE      R3, #$AA, L_02CA

;                                               ErrorLedTimer := LedTime;
              MOV       ErrorLedTimer, #$1E

;                                               PacketType := ptTurbo;
              MOV       PacketType, #0

;                                               RX_Counter_Int := 0;
              MOV       RX_Counter_Int, #0

;                                               RX_Checksum_Int := 0;
              MOV       RX_Checksum_Int, #0

;                                             end;
              SJMP      L_02E1
L_02CA:

;                            else If (Ch_Int >= $80) or (RX_Counter_Int > 80) then
              MOV       A, R3
              ADD       A, #-128
              JC        L_02D5
              MOV       A, RX_Counter_Int
              ADD       A, #-81
              JNC       L_02E1
L_02D5:

;                                   begin
;                                     RX_Counter_Int := 0;
              MOV       RX_Counter_Int, #0

;                                     RX_Checksum_Int := 0;
              MOV       RX_Checksum_Int, #0

;                                     ErrorLedTimer := LedTime;
              MOV       ErrorLedTimer, #$1E

;                                     Exit;
              LJMP      L_03AA

;                                   end;
L_02E1:
;                          end;
;           end;
;       end;
; 
;       Case PacketType of
              MOV       R2, PacketType

;         ptTurbo: begin
              MOV       A, R2
              JZ        L_02E9
              LJMP      L_0375
L_02E9:

;                     If (RX_Counter_Int < PacketHeaderSize) or (RX_Buffer_Int.PacketSize <= MaxPacketSize) then
              MOV       A, RX_Counter_Int
              ADD       A, #-12
              JNC       L_02F7
              MOV       DPTR, #RX_Buffer_Int+1
              MOVX      A, @DPTR
              ADD       A, #-103
              JC        L_0304
L_02F7:

;                       RX_BufferArray_Int [RX_Counter_Int] := Ch_Int;
              MOV       A, RX_Counter_Int
              ADD       A, #LOW  (RX_Buffer_Int)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (RX_Buffer_Int)
              MOV       DPH, A
              MOV       A, R3
              MOVX      @DPTR, A
L_0304:

;                     RX_Checksum_Int := RX_Checksum_Int xor Ch_Int;
              MOV       A, R3
              XRL       RX_Checksum_Int, A

;                     Inc (RX_Counter_Int);
              INC       RX_Counter_Int

;                     If (RX_Counter_Int >= PacketHeaderSize) and (RX_Counter_Int = RX_Buffer_Int.PacketSize) then
              MOV       A, RX_Counter_Int
              ADD       A, #-12
              JNC       L_0373
              MOV       DPTR, #RX_Buffer_Int+1
              MOVX      A, @DPTR
              CJNE      A, RX_Counter_Int, L_0373

;                       begin
;                         Inc (Int_PacketCounter);
              INC       Int_PacketCounter

;                         If RX_Checksum_Int = 0 then
              MOV       A, RX_Checksum_Int
              JNZ       L_036A

;                           begin
;                             Inc (Int_PacketOK_Counter);
              INC       Int_PacketOK_Counter

;                             If RX_Buffer_Int.PacketSize <= MaxPacketSize then
              MOVX      A, @DPTR
              ADD       A, #-103
              JC        L_0368

;                               begin
;                                 If RX_Buffer_Int.DestinationAddress = BroadcastAddress then CommandReceived_Int := True else
              MOV       DPTR, #RX_Buffer_Int+3
              MOVX      A, @DPTR
              CJNE      A, #$7F, L_032E
              SETB      CommandReceived_Int
              SJMP      L_0368
L_032E:

;                                   Case Local of
;                                     True: Case RX_Buffer_Int.DestinationAddress of
              JNB       Local, L_0362
              MOV       R2, A

;                                             $80..$8F: If Master and (RemoteSlots [RX_Buffer_Int.DestinationAddress and $0F + 1] <> $FF) then
              ADD       A, #-128
              JNC       L_0353
              ADD       A, #-16
              JC        L_0353
              JNB       Master, L_0351
              MOV       A, R2
              ANL       A, #$0F
              INC       A
              ADD       A, #RemoteSlots-1
              MOV       R0, A
              MOV       A, @R0
              CPL       A
              JZ        L_0351

;                                                         begin                                                                             { Over optics to remote }
;                                                           RX_Buffer_Int.DestinationAddress := RemoteSlots [RX_Buffer_Int.DestinationAddress and $0F + 1] or $80;  { Translate }
              MOV       A, @R0
              ORL       A, #$80
              MOV       DPTR, #RX_Buffer_Int+3
              MOVX      @DPTR, A

;                                                           CommandReceived_Int := True;
              SETB      CommandReceived_Int

;                                                         end;
L_0351:
              SJMP      L_0368
L_0353:

;                                             Transport_Address: CommandReceived_Int := True;             { Over this local module to remote module and to eq. }
              CJNE      R2, #$7B, L_035A
              SETB      CommandReceived_Int
              SJMP      L_0368
L_035A:

;                                             else  If RX_Buffer_Int.DestinationAddress = Slot then CommandReceived_Int := True;     { Over RS485 to this local module }
              MOV       A, R2
              CJNE      A, Slot, L_0360
              SETB      CommandReceived_Int
L_0360:
              SJMP      L_0368
L_0362:

;                                           end;
;                                     else  If RX_Buffer_Int.DestinationAddress < $80 then CommandReceived_Int := True; { Over RS485 to this remote module or to local module}
              ADD       A, #-128
              JC        L_0368
              SETB      CommandReceived_Int

;                                   end;
;                               end;
L_0368:
;                           end else ErrorLedTimer := LedTime;
              SJMP      L_036D
L_036A:
              MOV       ErrorLedTimer, #$1E
L_036D:

;                         RX_Counter_Int := 0;
              MOV       RX_Counter_Int, #0

;                         RX_Checksum_Int := 0;
              MOV       RX_Checksum_Int, #0

;                       end;
L_0373:
;                   end;
              SJMP      L_03AA
L_0375:

;         ptPanasonic: begin
              CJNE      R2, #1, L_03AA

;                        If RX_Counter_Int <= MaxPacketSize - PacketHeaderSize then
              MOV       A, RX_Counter_Int
              ADD       A, #-91
              JC        L_03AB

;                          RX_BufferArray_Int [RX_Counter_Int + PacketHeaderSize] := Ch_Int else
              MOV       A, RX_Counter_Int
              ADD       A, #LOW  (RX_Buffer_Int+12)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (RX_Buffer_Int)
              MOV       DPH, A
              MOV       A, R3
              MOVX      @DPTR, A
              INC       RX_Counter_Int
              XRL       A, #3
              JZ        L_0394
              CJNE      R3, #6, L_03AA
L_0394:
              MOV       R0, #Protocols
              MOV       A, @R0
              JNB       ACC.1, L_039C
              SETB      CommandReceived_Int
L_039C:
              MOV       A, RX_Counter_Int
              ADD       A, #$0C
              MOV       DPTR, #RX_Buffer_Int+1
              MOVX      @DPTR, A
              MOV       RX_Counter_Int, #0
              MOV       RX_Checksum_Int, #0
L_03AA:
              RETI
L_03AB:

;                            begin
;                              RX_Counter_Int := 0;
              MOV       RX_Counter_Int, #0

;                              RX_Checksum_Int := 0;
              MOV       RX_Checksum_Int, #0

;                              Exit;
              SJMP      L_03AA

;                            end;
;                        Inc (RX_Counter_Int);
;                        If (Ch_Int = ETX) or (Ch_Int = ACK) then
;                          begin
;                            If prPanasonic in Protocols then CommandReceived_Int := True;
;                            RX_Buffer_Int.PacketSize := PacketHeaderSize + RX_Counter_Int;
;                            RX_Counter_Int  := 0;
;                            RX_Checksum_Int := 0;
;                          end;
;                      end;
;       end;
; 
;     end;
; end;
              POP       DPH
              POP       DPL
              POP       ACC
              POP       PSW

; 
; {$IFDEF DPS900 }
; Procedure External_RS485; Interrupt Serial1; Using 3;  { External, direct to camera }
; Var Ch_Ext: Byte DATA;
;     Saved_Ext_PacketCounter: Byte absolute Ch_Ext;


CSEG AT $00A3

USING 3

External_RS485:
; begin
              PUSH      PSW
              MOV       PSW, #$18
              PUSH      ACC
              PUSH      DPL
              PUSH      DPH

;   If SCON1 and TI1 <> 0 then
              MOV       A, $F1
              JNB       ACC.1, L_00F2

;     begin
;       SCON1 := SCON1 and not TI1;
              ANL       $F1, #$FD

; 
;       If Sending_Ext and (TX_Counter_Ext < TX_Buffer_Ext.PacketSize) then
              JNB       Sending_Ext, L_00EE
              MOV       DPTR, #TX_Buffer_Ext+1
              MOVX      A, @DPTR
              SETB      C
              SUBB      A, TX_Counter_Ext
              JC        L_00EE

;         begin
;           Case TX_Buffer_Ext.Command of
              MOV       DPTR, #TX_Buffer_Ext+9
              MOVX      A, @DPTR

;             Cmd_Transport: begin
              CJNE      A, #$0C, L_00E8

;                              If TX_Counter_Ext = 0 then TX_Counter_Ext := PacketHeaderSize;     { Start with actual packet data }
              MOV       A, TX_Counter_Ext
              JNZ       L_00D0
              MOV       TX_Counter_Ext, #$0C
L_00D0:

;                              RS485_Timer     := RS485_Time;
              MOV       RS485_Timer, #1

;                              TX_Ext_LedTimer := LedTimeExt;
              MOV       TX_Ext_LedTimer, #$0A

;                              SBUF1 := TX_BufferArray_Ext [TX_Counter_Ext];
              MOV       A, TX_Counter_Ext
              ADD       A, #LOW  (TX_Buffer_Ext)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (TX_Buffer_Ext)
              MOV       DPH, A
              MOVX      A, @DPTR
              MOV       $F2, A

;                              Inc (TX_Counter_Ext);
              INC       TX_Counter_Ext

;                            end;
              SJMP      L_00EC
L_00E8:

;             else
;                    Sending_Ext := False;
              CLR       Sending_Ext

;                    ReadyForExternalCommunication := True;        { Ready for packet }
              SETB      ReadyForExternalCommunication
L_00EC:

;           end;
;         end else begin
              SJMP      L_00F2
L_00EE:

;                    Sending_Ext := False;
              CLR       Sending_Ext

;                    ReadyForExternalCommunication := True;        { Ready for packet }
              SETB      ReadyForExternalCommunication

;                  end;
;     end;
L_00F2:
;   If SCON1 and RI1 <> 0 then SCON1 := SCON1 and not RI1;
              MOV       A, $F1
              JNB       ACC.0, L_00FA
              ANL       $F1, #$FE
L_00FA:

; end;
              POP       DPH
              POP       DPL
              POP       ACC
              POP       PSW
              RETI

; {$ELSE}
; Procedure External_RS485; Interrupt Serial1; Using 3;  { External }
; Var Ch_Ext: Byte DATA;
;     Saved_Ext_PacketCounter: Byte absolute Ch_Ext;
; begin
;   If SCON1 and TI1 <> 0 then
;     begin
;       SCON1 := SCON1 and not TI1;
; 
;       Case SCON1 and TB81 <> 0 of
;         True: If Sending_Ext and (TX_Counter_Ext < TX_Buffer_Ext.PacketSize) then
;                 begin
;                   TX_Ext_LedTimer := LedTimeExt;
;                   SBUF1 := TX_BufferArray_Ext [TX_Counter_Ext];
;                   Inc (TX_Counter_Ext);
;                 end else begin
;                            Sending_Ext := False;
;                            If SendKeepAliveByte then begin
;                                                        Case ExtCommKeepAliveCounter of
;                                                          0:   Case Local of
;                                                                 True: SBUF1 := LocalRemoteFlag or $01;
;                                                                 else  SBUF1 := LocalRemoteFlag or $00;
;                                                               end;
;                                                          else SBUF1 := KeepAliveByte                        { To keep communication over optics alive }
;                                                        end;
;                                                        Inc (ExtCommKeepAliveCounter);
;                                                      end else ReadyForExternalCommunication := True;        { Ready for packet }
;                          end;
;         else  SBUF1 := Current_ADC;
;       end;
;       SCON1 := SCON1 xor TB81;           { Toggle ninth bit }
;     end;
;   If SCON1 and RI1 <> 0 then
;     Case SCON1 and RB81 <> 0 of
;       True: begin
;               SCON1 := SCON1 and not RI1;
;               If CommandReceived_Ext then Exit;
;               Ch_Ext := SBUF1;
; 
;               If RX_Counter_Ext = 0 then
;                 Case Ch_Ext of
;                   KeepAliveByte: Exit;
;                   LocalRemoteFlag or $01: begin
;                                             ExtCommunicationTimer := ExtCommunicationTime;
;                                             OtherModuleLocal := True;
;                                             If Ext_PacketCounter <> $FF then
;                                               begin
;                                                 Inc (Ext_PacketCounter);
;                                                 Inc (Ext_PacketOK_Counter);
;                                               end;
;                                             Exit;
;                                           end;
;                   LocalRemoteFlag or $00: begin
;                                             ExtCommunicationTimer := ExtCommunicationTime;
;                                             OtherModuleLocal := False;
;                                             If Ext_PacketCounter <> $FF then
;                                               begin
;                                                 Inc (Ext_PacketCounter);
;                                                 Inc (Ext_PacketOK_Counter);
;                                               end;
;                                             Exit;
;                                           end;
;                   TurboStartByte:
;                   else           begin
;                                    If Ext_PacketCounter <> $FF then Inc (Ext_PacketCounter);
;                                    RX_Ext_LedTimer := 2;
;                                    ErrorLedTimer := 2;                   { Trash Byte }
;                                    Exit;
;                                  end;
;                 end;
; 
;               ExtCommunicationTimer := ExtCommunicationTime;
;               RX_Ext_LedTimer := LedTimeExt;
;               If (RX_Counter_Ext < PacketHeaderSize) or (RX_Buffer_Ext.PacketSize <= MaxPacketSize) then
;                 RX_BufferArray_Ext [RX_Counter_Ext] := Ch_Ext;
;               RX_Checksum_Ext := RX_Checksum_Ext xor Ch_Ext;
;               Inc (RX_Counter_Ext);
;               If (RX_Counter_Ext >= PacketHeaderSize) and (RX_Counter_Ext = RX_Buffer_Ext.PacketSize) then
;                 begin
;                   Saved_Ext_PacketCounter := Ext_PacketCounter;
;                   If Saved_Ext_PacketCounter < 240 then Inc (Ext_PacketCounter, 12);
;                   If RX_Checksum_Ext = 0 then
;                     begin
;                       If Saved_Ext_PacketCounter < 240 then Inc (Ext_PacketOK_Counter, 12);
;                       If RX_Buffer_Ext.PacketSize <= MaxPacketSize then CommandReceived_Ext := True;
;                     end else ErrorLedTimer := LedTimeExt;
;                   RX_Counter_Ext := 0;
;                   RX_Checksum_Ext := 0;
;                 end;
; 
;             end;
;       else  begin
;               SCON1 := SCON1 and (RI1 xor $FF);
;               Current_DAC := SBUF1;
;             end;
;     end;
; end;
; {$ENDIF}
; 
; 
; Procedure DAC_Interrupt; Interrupt Timer3; Using 3;{ DAC sample interrupt }
; Var SamplePointer: Byte DATA;

RSEG _DATA

SamplePointer:                  DS       1


CSEG AT $0073

              AJMP     DAC_Interrupt

RSEG _CODE

DAC_Interrupt:
; begin                                              { Should not use R0..R7 !!! }
              PUSH      PSW
              MOV       PSW, #$18
              PUSH      ACC
              PUSH      B
              PUSH      DPL
              PUSH      DPH

;   Current_ADC := ADC0H;
              MOV       Current_ADC, $BF

;   TMR3CN := TMR3CN and not TF3;
              ANL       $91, #$7F

;   Asm
;     MOV      DAC1L, #0
              MOV       $D5, #0

;     JB       TestMode, @SetTestDac
              JB        TestMode, L_03D9

; 
;     MOV      DAC1H, Current_DAC                    { Normal }
              MOV       $D6, Current_DAC

;     SJMP     @EndDacInterrupt
              SJMP      L_0411

; 
; @SetTestDac:
L_03D9:
;     MOV      A, EqState
              MOV       A, EqState

;     JNZ      @Check_EqState_1
              JNZ       L_03E2

;     MOV      DAC1H, Current_ADC                    { Test 0: Local ADC }
              MOV       $D6, Current_ADC

;     SJMP     @EndDacInterrupt
              SJMP      L_0411

; 
; @Check_EqState_1:
L_03E2:
;     DEC      A
              DEC       A

;     JNZ      @Check_EqState_2
              JNZ       L_03EA

;     MOV      DAC1H, #0                             { Test 1: 0 Hz }
              MOV       $D6, #0

;     SJMP     @EndDacInterrupt
              SJMP      L_0411

; 
; @Check_EqState_2:
L_03EA:
;     DEC      A
              DEC       A

;     JNZ      @EqState_3
              JNZ       L_0400

;     MOV      A, SamplePointer
              MOV       A, SamplePointer

;     INC      A
              INC       A

;     MOV      B, #SamplesPerPeriod_100Hz
              MOV       B, #$50

;     DIV      AB
              DIV       AB

;     MOV      A, B
              MOV       A, B

;     MOV      SamplePointer, A
              MOV       SamplePointer, A

;     MOV      DPTR, #Sinus_100Hz
              MOV       DPTR, #Sinus_100Hz

;     MOVC     A, @A+DPTR                            { Test 2: 100 Hz }
              MOVC      A, @A + DPTR

;     MOV      DAC1H, A
              MOV       $D6, A

;     SJMP     @EndDacInterrupt
              SJMP      L_0411

; 
; @EqState_3:
L_0400:
;     MOV      A, SamplePointer
              MOV       A, SamplePointer

;     INC      A
              INC       A

;     MOV      B, #SamplesPerPeriod_1kHz
              MOV       B, #8

;     DIV      AB
              DIV       AB

;     MOV      A, B
              MOV       A, B

;     MOV      SamplePointer, A
              MOV       SamplePointer, A

;     MOV      DPTR, #Sinus_1kHz
              MOV       DPTR, #Sinus_1kHz

;     MOVC     A, @A+DPTR
              MOVC      A, @A + DPTR

;     MOV      DAC1H, A                              { Test 3: 1 kHz }
              MOV       $D6, A

; 
; @EndDacInterrupt:
;   end;
L_0411:
; end;
              POP       DPH
              POP       DPL
              POP       B
              POP       ACC
              POP       PSW
              RETI

; 
; Function HexNibble (HexByte: Byte): Char;
; begin
;   HexByte := HexByte and $0F;
;   Case HexByte of
;     0..9: HexNibble := Chr (HexByte + $30);
;     else  HexNibble := Chr (HexByte + $37);
;   end;
; end;
; 
; Procedure Delay (DelayTime: Word);

RSEG _DATA

DelayTime:                      DS       2


RSEG _CODE

USING 0

Delay:
; begin
;   DelayTimer := DelayTime;
              MOV       DelayTimer, DelayTime
              MOV       DelayTimer+1, DelayTime+1
              MOV       R2, #$A5

;   Repeat
L_0015:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until DelayTimer = 0;
              MOV       A, DelayTimer+1
              ORL       A, DelayTimer
              JNZ       L_0015

; end;
              RET

; 
; Procedure SetOpticTxXpoint;
; begin
;   Case MiscFlags and hdReturnVideoFromBus <> 0 of
;     True: VideoXPoint [vOut_Optic_TX] := vIn_COM_Out;        { External sync }
;     else  VideoXPoint [vOut_Optic_TX] := vIn_VideoIn;
;   end;
; end;
; 
; Procedure SetHardware;

SetHardware:
; begin
;   Local  := ModeFlags and hdLocal <> 0;
              MOV       A, ModeFlags
              RRC       A
              MOV       Local, C

;   Case Local of
;     True: BackgroundColor := bcGreen;
              JNB       Local, L_0429
              MOV       BackgroundColor, #6
              SJMP      L_042C
L_0429:

;     else  BackgroundColor := bcRed;
              MOV       BackgroundColor, #0
L_042C:

;   end;
;   SetBackground;
              LCALL     SetBackground

;   Master := ModeFlags and hdMaster <> 0;
              MOV       A, ModeFlags
              MOV       C, ACC.1
              MOV       Master, C

;   Case (MiscFlags and hdEqualizerOn) <> 0 of
              MOV       A, MiscFlags

;     True: VideoInputPin := vIn_Spare;     { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }
              JNB       ACC.1, L_043F
              MOV       VideoInputPin, #3
              SJMP      L_0442
L_043F:

;     else  VideoInputPin := vIn_VideoIn;
              MOV       VideoInputPin, #7
L_0442:

;   end;
;   Case Local of
;     True: Case MiscFlags and hdReturnVideoFromBus <> 0 of
              JNB       Local, L_0466
              MOV       A, MiscFlags

;             True: SetVideoXPoint (vOut_Optic_TX, vIn_COM_Out);        { External sync }
              JNB       ACC.6, L_0458
              CLR       A
              MOV       DPTR, #VOut
              MOVX      @DPTR, A
              MOV       DPTR, #VIn
              MOV       A, #2
              MOVX      @DPTR, A
              LJMP      SetVideoXPoint
L_0458:

;             else  SetVideoXPoint (vOut_Optic_TX, vIn_VideoIn);
              CLR       A
              MOV       DPTR, #VOut
              MOVX      @DPTR, A
              MOV       DPTR, #VIn
              MOV       A, #7
              MOVX      @DPTR, A
              LJMP      SetVideoXPoint
L_0466:

;           end;
;     else  SetVideoXPoint (vOut_OSD_In, VideoInputPin);
              MOV       DPTR, #VOut
              MOV       A, #1
              MOVX      @DPTR, A
              MOV       DPTR, #VIn
              MOV       A, VideoInputPin
              MOVX      @DPTR, A
              LJMP      SetVideoXPoint

;   end;
; end;
; 
; Procedure SetLedsDuring_EEPROM_Init;

SetLedsDuring_EEPROM_Init:
; begin
;   If TempByte and $20 <> 0 then RX_Ext_LedTimer := LedTime;
              MOV       A, TempByte
              JNB       ACC.5, L_002D
              MOV       RX_Ext_LedTimer, #$1E
L_002D:

;   If TempByte and $10 <> 0 then TX_Ext_LedTimer := LedTime;
              MOV       A, TempByte
              JNB       ACC.4, L_0035
              MOV       TX_Ext_LedTimer, #$1E
L_0035:

;   Led_VideoLink   := TempByte and $08 <> 0;
              MOV       A, TempByte
              MOV       C, ACC.3
              MOV       $24.1, C

;   Led_Error       := TempByte and $04 <> 0;
              MOV       A, TempByte
              MOV       C, ACC.2
              MOV       $24.0, C

;   If TempByte and $02 <> 0 then RX_Int_LedTimer := LedTime;
              MOV       A, TempByte
              JNB       ACC.1, L_0049
              MOV       RX_Int_LedTimer, #$1E
L_0049:

;   If TempByte and $01 <> 0 then TX_Int_LedTimer := LedTime;
              MOV       A, TempByte
              JNB       ACC.0, L_0051
              MOV       TX_Int_LedTimer, #$1E

;   Repeat
L_0051:
              MOV       R2, #$A5
L_0053:

;     WDTCN := $A5;
              MOV       $FF, R2

;   until (TX_Int_LedTimer or RX_Int_LedTimer) = 0;
              MOV       A, TX_Int_LedTimer
              ORL       A, RX_Int_LedTimer
              JNZ       L_0053

; end;
              RET

; 
; Procedure Init_EEPROM_Settings;

Init_EEPROM_Settings:
; begin
;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;   WriteByteToEEPROM (@EEPROM_Data.eeSourceName [0], 0);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0023)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0023)
              MOVX      @DPTR, A
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;   WriteByteToEEPROM (@EEPROM_Data.eeSourceDescription [0], 0);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0034)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0034)
              MOVX      @DPTR, A
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;   Case Local of
;     True: MiscFlags := hdNameVisible or hdDescrVisible;
              JNB       Local, L_04A8
              MOV       MiscFlags, #$11
              SJMP      L_04AB
L_04A8:

;     else  MiscFlags :=                  hdDescrVisible;
              MOV       MiscFlags, #1
L_04AB:

;   end;
;   WriteByteToEEPROM (@EEPROM_Data.eeMiscFlags, MiscFlags);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0033)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0033)
              MOVX      @DPTR, A
              MOV       DPTR, #Value
              MOV       A, MiscFlags
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

; 
;   For TempByte := 1 to 16 do RemoteSlots [TempByte] := $FF;
              MOV       TempByte, #0
L_04C4:
              INC       TempByte
              MOV       A, TempByte
              ADD       A, #RemoteSlots-1
              MOV       R0, A
              MOV       @R0, #$FF
              MOV       A, TempByte
              CJNE      A, #$10, L_04C4

; 
;   WriteBytesToEEPROM (@EEPROM_Data.eeRemoteSlots, @RemoteSlots, 16);
              MOV       DPTR, #EepromAddressW
              MOV       A, #LOW  ($0054)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0054)
              MOVX      @DPTR, A
              MOV       DPTR, #SourceAddress
              MOV       A, #RemoteSlots
              MOVX      @DPTR, A
              MOV       DPTR, #CountW
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     WriteBytesToEEPROM

;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;   ModeFlags := DefaultModeFlags;
              CLR       A
              MOV       ModeFlags, A

;   Local  := ModeFlags and hdLocal <> 0;
              RRC       A
              MOV       Local, C

;   Master := ModeFlags and hdMaster <> 0;
              MOV       A, #$FF
              MOV       Master, C

;   WriteByteToEEPROM (@EEPROM_Data.eeModeFlags, ModeFlags);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0053)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0053)
              MOVX      @DPTR, A
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;   Protocols := [prTurbo, prPanasonic];
              MOV       R0, #Protocols
              MOV       @R0, #3

;   WriteByteToEEPROM (@EEPROM_Data.eeProtocols, Byte (Protocols));
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0064)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0064)
              MOVX      @DPTR, A
              MOV       DPTR, #Value
              MOV       A, @R0
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;   SetLedsDuring_EEPROM_Init;
              LJMP      SetLedsDuring_EEPROM_Init

; end;
; 
; Procedure Init_EEPROM_ModuleData;

RSEG _CONST

C_246C:                         DB        23, 'EEPROM data initialized'


RSEG _CODE

Init_EEPROM_ModuleData:
; begin
;   For TempByte := 0 to SignatureLength - 1 do
              MOV       TempByte, #$FF
              MOV       R4, #0
L_052A:
              INC       TempByte

;     begin
;       SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;       WriteByteToEEPROM (@EEPROM_Data.eeSignature [TempByte], MemCODE [SignatureOffset + TempByte]);
              MOV       DPTR, #AddressW
              MOV       A, TempByte
              MOVX      @DPTR, A
              INC       DPTR
              CLR       A
              MOVX      @DPTR, A
              MOV       A, TempByte
              ADD       A, #$10
              MOV       DPL, A
              MOV       DPH, R4
              CLR       A
              MOVC      A, @A + DPTR
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;     end;
              MOV       A, TempByte
              CJNE      A, #6, L_052A

;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;   WriteByteToEEPROM (@EEPROM_Data.eeSerialNumber [0], 0);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  (7)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH (7)
              MOVX      @DPTR, A
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;   SetLedsDuring_EEPROM_Init;
              LCALL     SetLedsDuring_EEPROM_Init

;   WriteByteToEEPROM (@EEPROM_Data.eeComment [0], 0);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0014)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0014)
              MOVX      @DPTR, A
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;   Init_EEPROM_Settings;
              LCALL     Init_EEPROM_Settings

;   OsdString := 'EEPROM data initialized';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_246C
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   Inc (Row);
              INC       Row

; end;
              RET

; 
; Function Check_EEPROM_Signature: Boolean;

RSEG _BIT

Check_EEPROM_Signature_Result:  DBIT     1


RSEG _CODE

Check_EEPROM_Signature:
; begin
;   Check_EEPROM_Signature := False;
              CLR       Check_EEPROM_Signature_Result

;   For TempByte := 0 to SignatureLength - 1 do
              MOV       TempByte, #$FF
              MOV       R4, #0
L_007C:
              INC       TempByte

;     If ReadByteFromEEPROM (@EEPROM_Data.eeSignature [TempByte]) <> MemCODE [SignatureOffset + TempByte] then Exit;
              MOV       A, TempByte
              ADD       A, #$10
              MOV       DPL, A
              MOV       DPH, R4
              CLR       A
              MOVC      A, @A + DPTR
              MOV       R1, A
              MOV       DPTR, #AddressR
              MOV       A, TempByte
              MOVX      @DPTR, A
              INC       DPTR
              CLR       A
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              CJNE      A, AR1, L_009F
              MOV       A, TempByte
              CJNE      A, #6, L_007C

;   Check_EEPROM_Signature := True;
              SETB      Check_EEPROM_Signature_Result

; end;
L_009F:
              MOV       C, Check_EEPROM_Signature_Result
              RET

; 
; Procedure Read_EEPROM;

RSEG _CONST

C_2484:                         DB        18, 'Reading EEPROM ...'
C_2497:                         DB        19, 'EEPROM data invalid'


RSEG _CODE

Read_EEPROM:
; begin
;   If not Check_EEPROM_Signature then Init_EEPROM_ModuleData;
              LCALL     Check_EEPROM_Signature
              JC        L_0599
              LCALL     Init_EEPROM_ModuleData
L_0599:

;   If (Key_Up = False) and (Key_Down = False) and (Key_Enter = False) then Init_EEPROM_Settings;
              JB        $25.2, L_05A5
              JB        $25.1, L_05A5
              JB        $25.0, L_05A5
              LCALL     Init_EEPROM_Settings
L_05A5:

;   If Check_EEPROM_Signature then
              LCALL     Check_EEPROM_Signature
              JNC       L_060A

;     begin
;       OsdString := 'Reading EEPROM ...';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2484
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;       WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;       Inc (Row);
              INC       Row

;       MiscFlags := ReadByteFromEEPROM (@EEPROM_Data.eeMiscFlags);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0033)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0033)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       MiscFlags, A

;       ModeFlags := ReadByteFromEEPROM (@EEPROM_Data.eeModeFlags);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0053)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0053)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       ModeFlags, A

;       ReadBytesFromEEPROM (@EEPROM_Data.eeRemoteSlots, @RemoteSlots, 16);
              MOV       DPTR, #EepromAddressR
              MOV       A, #LOW  ($0054)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0054)
              MOVX      @DPTR, A
              MOV       DPTR, #DestinationAddress
              MOV       A, #RemoteSlots
              MOVX      @DPTR, A
              MOV       DPTR, #CountR
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     ReadBytesFromEEPROM

;       Protocols := TProtocolsSet (ReadByteFromEEPROM (@EEPROM_Data.eeProtocols));
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0064)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0064)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       R0, #Protocols
              MOV       @R0, A

;     end else begin
              SJMP      L_0638
L_060A:

;                ErrorCode := ecEEPROM;
              MOV       ErrorCode, #3

;                OsdString := 'EEPROM data invalid';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2497
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;                Attribute := $1D00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1D00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1D00)
              MOVX      @DPTR, A

;                WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;                Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;                Inc (Row);
              INC       Row

;              end;
L_0638:
;   SetHardware;
              LJMP      SetHardware

; end;
; 
; Procedure SetTX_BufferAddresses;

SetTX_BufferAddresses:
; begin
;   PTX_Buffer^.PacketSize               := DefaultPacketSize;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              MOV       A, #$2C
              MOVX      @DPTR, A

;   PTX_Buffer^.SourceAddress_Frame      := PRX_Buffer^.DestinationAddress_Frame;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              INC       DPTR
              INC       DPTR
              INC       DPTR
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R1, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #6
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A

;   PTX_Buffer^.SourceAddress            := Slot;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #5
              LCALL     sysADD_DPTR_A
              MOV       A, Slot
              MOVX      @DPTR, A

;   PTX_Buffer^.DestinationAddress       := PRX_Buffer^.SourceAddress;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #5
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              INC       DPTR
              INC       DPTR
              MOVX      @DPTR, A

;   PTX_Buffer^.DestinationAddress_Frame := PRX_Buffer^.SourceAddress_Frame;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #6
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              INC       DPTR
              INC       DPTR
              INC       DPTR
              MOVX      @DPTR, A

;   PTX_Buffer^.OriginalAddress          := Slot;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #7
              LCALL     sysADD_DPTR_A
              MOV       A, Slot
              MOVX      @DPTR, A

;   PTX_Buffer^.GatewayAddress           := $FF;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #8
              LCALL     sysADD_DPTR_A
              MOV       A, #$FF
              MOVX      @DPTR, A

;   PTX_Buffer^.CommandFlags             := [];
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              CLR       A
              MOVX      @DPTR, A

;   PTX_Buffer^.Spare                    := 0;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #11
              LCALL     sysADD_DPTR_A
              CLR       A
              MOVX      @DPTR, A

; end;
              RET

; 
; Procedure SendPacket;
; Var TempChecksum: Byte DATA;

SendPacket:
; begin
;   Case ActiveBuffer_Ext of
;     True: begin
              JNB       ActiveBuffer_Ext, L_074D

;             If DelayPacketToExt then
              JNB       DelayPacketToExt, L_06F6

;               begin
;                 Inc (DelayedTXCounter_Ext);
              MOV       R0, #DelayedTXCounter_Ext
              INC       @R0

;                 Move (TX_Buffer_Ext, TX_Buffer_Delayed_Ext [DelayedTXCounter_Ext], TX_Buffer_Ext{TX_Buffer_Delayed_Ext [DelayedTXCounter_Ext]}.PacketSize);
              MOV       DPTR, #TX_Buffer_Ext+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       A, @R0
              MOV       B, #92
              MUL       AB
              ADD       A, #LOW  (TX_Buffer_Delayed_Ext-92)
              MOV       R2, A
              MOV       A, B
              ADDC      A, #HIGH (TX_Buffer_Delayed_Ext-92)
              MOV       R3, A
              MOV       DPTR, #TX_Buffer_Ext
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                 DelayPacketToExt := False;
              CLR       DelayPacketToExt

;                 Exit;
              RET

;               end;
L_06F6:
;             SendKeepAliveByte := False;                { Stop sending KeepAliveByte }
              CLR       SendKeepAliveByte

;             WDTCN := $A5;
              MOV       $FF, #$A5

;             DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)
              MOV       R2, #HIGH ($0014)

;             Repeat
L_0703:
;             until not Sending_Ext and ((RX_Counter_Ext = 0) or (DelayTimer = 0));
              JB        Sending_Ext, L_0703
              MOV       A, RX_Counter_Ext
              JZ        L_070F
              MOV       A, R2
              ORL       A, #LOW  ($0014)
              JNZ       L_0703
L_070F:

;             TX_Buffer_Ext.Checksum := 0;
              CLR       A
              MOV       DPTR, #TX_Buffer_Ext+2
              MOVX      @DPTR, A

;             TempChecksum := 0;
              MOV       R2, A

;             For TX_Counter_Ext := 0 to TX_Buffer_Ext.PacketSize - 1 do TempChecksum := TempChecksum xor TX_BufferArray_Ext [TX_Counter_Ext];
              MOV       DPTR, #TX_Buffer_Ext+1
              MOVX      A, @DPTR
              DEC       A
              MOV       R3, A
              MOV       TX_Counter_Ext, #$FF
L_071E:
              INC       TX_Counter_Ext
              MOV       A, TX_Counter_Ext
              ADD       A, #LOW  (TX_Buffer_Ext)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (TX_Buffer_Ext)
              MOV       DPH, A
              MOVX      A, @DPTR
              XRL       A, R2
              MOV       R2, A
              MOV       A, R3
              CJNE      A, TX_Counter_Ext, L_071E

;             TX_Buffer_Ext.Checksum := TempChecksum;
              MOV       DPTR, #TX_Buffer_Ext+2
              MOV       A, R2
              MOVX      @DPTR, A

;             TX_Counter_Ext := 0;
              MOV       TX_Counter_Ext, #0

;             WDTCN := $A5;
              MOV       $FF, #$A5

;             Repeat
L_073D:
;             until ReadyForExternalCommunication;
              JNB       ReadyForExternalCommunication, L_073D

;             TX_Ext_LedTimer := LedTime;
              MOV       TX_Ext_LedTimer, #$1E

;             Sending_Ext := True;
              SETB      Sending_Ext

;             SendKeepAliveByte := True;                 { After packet }
              SETB      SendKeepAliveByte

;             ReadyForExternalCommunication := False;    { Not ready until it will stop sending KeepAliveByte }
              CLR       ReadyForExternalCommunication

;             SCON1 := SCON1 or TI1;
              ORL       $F1, #2

;           end;
              RET
L_074D:

;     else  begin
;             If BroadcastReplyTimer_Int <> 0 then
              MOV       A, BroadcastReplyTimer_Int+1
              ORL       A, BroadcastReplyTimer_Int
              JZ        L_0770

;               begin
;                 Inc (DelayedTXCounter_Int);
              MOV       R0, #DelayedTXCounter_Int
              INC       @R0

;                 Move (TX_Buffer_Int, TX_Buffer_Delayed_Int [DelayedTXCounter_Int], TX_Buffer_Int{TX_Buffer_Delayed_Int [DelayedTXCounter_Int]}.PacketSize);
              MOV       DPTR, #TX_Buffer_Int+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       A, @R0
              MOV       B, #92
              MUL       AB
              ADD       A, #LOW  (TX_Buffer_Delayed_Int-92)
              MOV       R2, A
              MOV       A, B
              ADDC      A, #HIGH (TX_Buffer_Delayed_Int-92)
              MOV       R3, A
              MOV       DPTR, #TX_Buffer_Int
              LJMP      sysCopyFrom_XDATA_To_XDATA

;                 Exit;
;               end;
L_0770:
;             WDTCN := $A5;
              MOV       $FF, #$A5

;             DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)
              MOV       R2, #HIGH ($0014)

;             Repeat
L_077B:
;             until not Sending_Int and ((RX_Counter_Int = 0) or (DelayTimer = 0));
              JB        Sending_Int, L_077B
              MOV       A, RX_Counter_Int
              JZ        L_0787
              MOV       A, R2
              ORL       A, #LOW  ($0014)
              JNZ       L_077B
L_0787:

;             Sending_Int := True;
              SETB      Sending_Int

;             TX_Buffer_Int.Checksum := 0;
              CLR       A
              MOV       DPTR, #TX_Buffer_Int+2
              MOVX      @DPTR, A

;             TempChecksum := 0;
              MOV       R2, A

;             For TX_Counter_Int := 0 to TX_Buffer_Int.PacketSize - 1 do TempChecksum := TempChecksum xor TX_BufferArray_Int [TX_Counter_Int];
              MOV       DPTR, #TX_Buffer_Int+1
              MOVX      A, @DPTR
              DEC       A
              MOV       R3, A
              MOV       TX_Counter_Int, #$FF
L_0798:
              INC       TX_Counter_Int
              MOV       A, TX_Counter_Int
              ADD       A, #LOW  (TX_Buffer_Int)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (TX_Buffer_Int)
              MOV       DPH, A
              MOVX      A, @DPTR
              XRL       A, R2
              MOV       R2, A
              MOV       A, R3
              CJNE      A, TX_Counter_Int, L_0798

;             TX_Buffer_Int.Checksum := TempChecksum;
              MOV       DPTR, #TX_Buffer_Int+2
              MOV       A, R2
              MOVX      @DPTR, A

;             TX_Counter_Int := 0;
              MOV       TX_Counter_Int, #0

;             RS485_Timer          := RS485_Time;
              MOV       RS485_Timer, #1

;             RS485_Timer_External := RS485_Time_External;
              MOV       RS485_Timer_External, #$15

;             Int_RS485_TX := True;
              SETB      P3.6

;             TX_Int_LedTimer := LedTime;
              MOV       TX_Int_LedTimer, #$1E

;             WDTCN := $A5;
              MOV       $FF, #$A5
              MOV       R2, #1

;             Repeat
L_07C4:
;             until RS485_Timer <= 1;
              MOV       A, R2
              ADD       A, #-2
              JC        L_07C4

;             TI := True;
              SETB      SCON.1

;           end;
;   end;
; end;
              RET

; 
; Procedure SendPacketWithDelay (BlockDelay: Byte);

RSEG _DATA

BlockDelay:                     DS       1


RSEG _CODE

SendPacketWithDelay:
; begin
;   Delay (BlockDelay);
              MOV       DelayTime, BlockDelay
              MOV       DelayTime+1, #0
              LCALL     Delay

;   SendPacket;
              LJMP      SendPacket

; end;
; 
; Procedure SetOsdStringToModuleName;

RSEG _CONST

C_24AB:                         DB        30, 'Module PPS5000 LOCAL   slot 00'


RSEG _CODE

SetOsdStringToModuleName:
; begin          {123456789012345678901234567890}
;   OsdString := 'Module PPS5000 LOCAL   slot 00';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_24AB
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   If Local then
              JNB       Local, L_07EE

;     Case Master of
;       True: OsdString [22] := 'M';
              JNB       Master, L_07E6
              MOV       DPTR, #OsdString+22
              MOV       A, #'M'
              MOVX      @DPTR, A
              SJMP      L_0808
L_07E6:

;       else  OsdString [22] := 'S';
              MOV       DPTR, #OsdString+22
              MOV       A, #'S'
              MOVX      @DPTR, A
              SJMP      L_0808
L_07EE:

;     end else begin
;                OsdString [16] := 'R';
              MOV       DPTR, #OsdString+16
              MOV       A, #'R'
              MOVX      @DPTR, A

;                OsdString [17] := 'E';
              INC       DPTR
              MOV       A, #'E'
              MOVX      @DPTR, A

;                OsdString [18] := 'M';
              INC       DPTR
              MOV       A, #'M'
              MOVX      @DPTR, A

;                OsdString [19] := 'O';
              INC       DPTR
              MOV       A, #'O'
              MOVX      @DPTR, A

;                OsdString [20] := 'T';
              INC       DPTR
              MOV       A, #'T'
              MOVX      @DPTR, A

;                OsdString [21] := 'E';
              INC       DPTR
              MOV       A, #'E'
              MOVX      @DPTR, A

;              end;
L_0808:
;   OsdString [29] := Chr ((Slot + 1) div 10 + $30);
              MOV       A, Slot
              INC       A
              MOV       B, #$0A
              DIV       AB
              ADD       A, #$30
              MOV       DPTR, #OsdString+29
              MOVX      @DPTR, A

;   OsdString [30] := Chr ((Slot + 1) mod 10 + $30);
              MOV       A, Slot
              INC       A
              MOV       B, #$0A
              DIV       AB
              MOV       A, B
              ADD       A, #$30
              INC       DPTR
              MOVX      @DPTR, A

; end;
              RET

; 
; Procedure WriteSourceName;

RSEG _CONST

C_24CA:                         DB        15, '               '
C_24DA:                         DB        15, ' MODULE   TEST '


RSEG _CODE

WriteSourceName:
; begin
;   Case TestMode of
;     False: begin
              JB        TestMode, L_0886

;              OsdString := EmptyLine15;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_24CA
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;              If MiscFlags and hdNameVisible <> 0 then
              MOV       A, MiscFlags
              JNB       ACC.4, L_0884

;                begin
;                  TempByte := ReadByteFromEEPROM  (@EEPROM_Data.eeSourceName);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0023)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0023)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       TempByte, A

;                  If TempByte <> 0 then ReadXBytesFromEEPROM  (Pointer (Word (@EEPROM_Data.eeSourceName) + 1),
              JZ        L_0884
              MOV       A, #LOW  ($0023)
              ADD       A, #LOW  (1)
              MOV       R2, A
              MOV       A, #HIGH ($0023)
              ADDC      A, #HIGH (1)
              MOV       R3, A
              MOV       DPTR, #EepromAddressXR
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                                                               Pointer (Word (@OsdString) + 1 + (15 - TempByte) div 2),
              MOV       A, #$0F
              CLR       C
              SUBB      A, TempByte
              CLR       C
              RRC       A
              MOV       R4, A
              MOV       A, #LOW  (OsdString)
              ADD       A, #LOW  (1)
              MOV       R2, A
              MOV       A, #HIGH (OsdString)
              ADDC      A, #HIGH (1)
              MOV       R3, A
              MOV       A, R2
              ADD       A, R4
              MOV       R2, A
              MOV       A, R3
              ADDC      A, #0
              MOV       R3, A
              MOV       DPTR, #DestinationAddressX
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                                                               TempByte);
              MOV       DPTR, #CountRX
              MOV       A, TempByte
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                end;
L_0884:
;            end;
              SJMP      L_0892
L_0886:

;                   { 123456789012345678901234567890 }
;     else OsdString := ' MODULE   TEST ';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_24DA
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA
L_0892:

;   end;
;   WriteAtRow (0);
              CLR       A
              MOV       DPTR, #RowY
              MOVX      @DPTR, A
              LJMP      WriteAtRow

; end;
; 
; Procedure WriteScreen;
; Var CommChar: Char;

RSEG _CONST

C_24EA:                         DB        30, 'ALARMS:                       '
C_2509:                         DB        30, '                              '
C_2528:                         DB        9, 'LOOP TEST'
C_2532:                         DB        30, 'OPTIC  COMM:  """"""""""""""""'
C_2551:                         DB        30, 'OPTIC  COMM:                  '
C_2570:                         DB        30, 'RS485  COMM:  """"""""""""""""'
C_258F:                         DB        30, 'RS485  COMM:                  '
C_25AE:                         DB        30, '                  DAC:        '
C_25CD:                         DB        30, 'OSD In:    Outputs: In    EQ 0'


RSEG _CODE

WriteScreen:
; begin
;   WriteSourceName;
              LCALL     WriteSourceName

;   OsdString := 'ALARMS:                       ';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_24EA
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   TempBoolean := False;
              CLR       TempBoolean

; 
;   { 123456789012345678901234567890 }
;   {'ALARMS: EE UI LINK SYNC  COMM '}
; 
;   If NoEEPROM then
              JNB       NoEEPROM, L_08B8

;     begin
;       TempBoolean := True;
              SETB      TempBoolean

;       OsdString [9]  := 'E';
              MOV       DPTR, #OsdString+9
              MOV       A, #'E'
              MOVX      @DPTR, A

;       OsdString [10] := 'E';
              INC       DPTR
              MOVX      @DPTR, A

;     end;
L_08B8:
;   If not OSD_SYD then
              JB        P2.4, L_08D5

;     begin
;       If not U_DET_Active or not I_DET_Active then TempBoolean := True;
              JNB       U_DET_Active, L_08C1
              JB        I_DET_Active, L_08C3
L_08C1:
              SETB      TempBoolean
L_08C3:

;       If not U_DET_Active then OsdString [12] := 'U';
              JB        U_DET_Active, L_08CC
              MOV       DPTR, #OsdString+12
              MOV       A, #'U'
              MOVX      @DPTR, A
L_08CC:

;       If not I_DET_Active then OsdString [13] := 'I';
              JB        I_DET_Active, L_08D5
              MOV       DPTR, #OsdString+13
              MOV       A, #'I'
              MOVX      @DPTR, A

;     end;
L_08D5:
; 
;   Case Local of
;     True: If not OSD_SYD and not RemoteLinkActive then   { REMOTE module missing (only if no video) }
              JNB       Local, L_08F4
              JB        P2.4, L_08F2
              JB        RemoteLinkActive, L_08F2

;             begin
;               TempBoolean := True;
              SETB      TempBoolean

;               OsdString [15] := 'L';
              MOV       DPTR, #OsdString+15
              MOV       A, #'L'
              MOVX      @DPTR, A

;               OsdString [16] := 'I';
              INC       DPTR
              MOV       A, #'I'
              MOVX      @DPTR, A

;               OsdString [17] := 'N';
              INC       DPTR
              MOV       A, #'N'
              MOVX      @DPTR, A

;               OsdString [18] := 'K';
              INC       DPTR
              MOV       A, #'K'
              MOVX      @DPTR, A

;             end;
L_08F2:
              SJMP      L_090C
L_08F4:

;     else  If ExtCommunicationTimer = 0 then                   { LOCAL module }
              MOV       A, ExtCommunicationTimer
              JNZ       L_090C

;             begin
;               TempBoolean := True;
              SETB      TempBoolean

;               OsdString [15] := 'L';
              MOV       DPTR, #OsdString+15
              MOV       A, #'L'
              MOVX      @DPTR, A

;               OsdString [16] := 'I';
              INC       DPTR
              MOV       A, #'I'
              MOVX      @DPTR, A

;               OsdString [17] := 'N';
              INC       DPTR
              MOV       A, #'N'
              MOVX      @DPTR, A

;               OsdString [18] := 'K';
              INC       DPTR
              MOV       A, #'K'
              MOVX      @DPTR, A

;             end;
L_090C:
;   end;
; 
;   { 123456789012345678901234567890 }
;   {'ALARMS: EE UI LINK SYNC  COMM '}
; 
;   If not OSD_SYD then
              JB        P2.4, L_0923

;     begin
;       TempBoolean := True;
              SETB      TempBoolean

;       OsdString [20] := 'S';
              MOV       DPTR, #OsdString+20
              MOV       A, #'S'
              MOVX      @DPTR, A

;       OsdString [21] := 'Y';
              INC       DPTR
              MOV       A, #'Y'
              MOVX      @DPTR, A

;       OsdString [22] := 'N';
              INC       DPTR
              MOV       A, #'N'
              MOVX      @DPTR, A

;       OsdString [23] := 'C';
              INC       DPTR
              MOV       A, #'C'
              MOVX      @DPTR, A

;     end;
L_0923:
;   If (MiscFlags and hdReportCommAlarm <> 0) and not IntCommActive then
              MOV       A, MiscFlags
              JNB       ACC.5, L_093D
              JB        IntCommActive, L_093D

;     begin
;       TempBoolean := True;
              SETB      TempBoolean

;       OsdString [26] := 'C';
              MOV       DPTR, #OsdString+26
              MOV       A, #'C'
              MOVX      @DPTR, A

;       OsdString [27] := 'O';
              INC       DPTR
              MOV       A, #'O'
              MOVX      @DPTR, A

;       OsdString [28] := 'M';
              INC       DPTR
              MOV       A, #'M'
              MOVX      @DPTR, A

;       OsdString [29] := 'M';
              INC       DPTR
              MOVX      @DPTR, A

;     end;
L_093D:
;   If TempBoolean then
              JB        TempBoolean, L_0943
              LJMP      L_09D6
L_0943:

;     Case Local of
;       True: begin
              JNB       Local, L_098F

;               Attribute := $1D00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1D00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1D00)
              MOVX      @DPTR, A

;               WriteAtRow (6);
              MOV       DPTR, #RowY
              MOV       A, #6
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;               Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;               SetOsdStringToModuleName;
              LCALL     SetOsdStringToModuleName

;               WriteAtRow (5);
              MOV       DPTR, #RowY
              MOV       A, #5
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;               OsdString := EmptyLine30;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2509
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;               WriteAtRow (2);
              MOV       DPTR, #RowY
              MOV       A, #2
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;               WriteAtRow (3);
              MOV       DPTR, #RowY
              MOV       A, #3
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;             end;
              SJMP      L_09D6
L_098F:

;       else  begin
;               Attribute := $1D00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1D00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1D00)
              MOVX      @DPTR, A

;               WriteAtRow (3);
              MOV       DPTR, #RowY
              MOV       A, #3
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;               Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;               SetOsdStringToModuleName;
              LCALL     SetOsdStringToModuleName

;               WriteAtRow (2);
              MOV       DPTR, #RowY
              MOV       A, #2
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;               OsdString := EmptyLine30;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2509
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;               WriteAtRow (5);
              MOV       DPTR, #RowY
              MOV       A, #5
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;               WriteAtRow (6);
              MOV       DPTR, #RowY
              MOV       A, #6
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;             end;
L_09D6:
;     end;
;   OsdString := EmptyLine30;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2509
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   If not TempBoolean then
              JB        TempBoolean, L_0A09

;     begin
;       WriteAtRow (2);
              MOV       DPTR, #RowY
              MOV       A, #2
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;       WriteAtRow (3);
              MOV       DPTR, #RowY
              MOV       A, #3
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;       WriteAtRow (5);
              MOV       DPTR, #RowY
              MOV       A, #5
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;       WriteAtRow (6);
              MOV       DPTR, #RowY
              MOV       A, #6
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;     end;
L_0A09:
;   Case not Local and (LoopTestTimer <> 0) of
              JB        Local, L_0A49
              MOV       A, LoopTestTimer+1
              ORL       A, LoopTestTimer
              JZ        L_0A49

;     True: begin
;             OsdString := 'LOOP TEST';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2528
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;             Attribute := $1D00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1D00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1D00)
              MOVX      @DPTR, A

;             WriteAtRow (1);
              MOV       DPTR, #RowY
              MOV       A, #1
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;             Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;             OsdString := EmptyLine30;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2509
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;           end;
              SJMP      L_0A52
L_0A49:

;     else  WriteAtRow (1);
              MOV       DPTR, #RowY
              MOV       A, #1
              MOVX      @DPTR, A
              LCALL     WriteAtRow
L_0A52:

;   end;
;   WriteAtRow (4);
              MOV       DPTR, #RowY
              MOV       A, #4
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   WriteAtRow (7);
              MOV       DPTR, #RowY
              MOV       A, #7
              MOVX      @DPTR, A
              LCALL     WriteAtRow

; 
;   Case Local xor OtherModuleLocal of
              MOV       C, OtherModuleLocal
              CLR       A
              RLC       A
              MOV       R1, A
              MOV       C, Local
              CLR       A
              RLC       A
              XRL       A, R1

;     True: CommChar := '#';        { Different modules (local/remote) on each side }
              JZ        L_0A74
              MOV       R0, #'#'
              SJMP      L_0A76
L_0A74:

;     else  CommChar := '';        { Same modules (local/remote) on each side }
              MOV       R0, #''
L_0A76:

;   end;
; 
;   Case TestMode of
;     False: If (Key_Up = False) or (LoopTestTimer <> 0) then
              JNB       TestMode, L_0A7C
              LJMP      L_0B42
L_0A7C:
              JNB       $25.2, L_0A88
              MOV       A, LoopTestTimer+1
              ORL       A, LoopTestTimer
              JNZ       L_0A88
              LJMP      L_0B36
L_0A88:

;              begin
;                If ExtCommActive then
              JNB       ExtCommActive, L_0ACC

;                  begin         { 123456789012345678901234567890 }
;                    OsdString := 'OPTIC  COMM:  """"""""""""""""';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2532
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;                    For TempByte := 15 to Byte ((Word (Ext_PacketOK_Counter) * 16) div Ext_PacketCounter) + 14 do
              MOV       R8, Ext_PacketCounter
              MOV       R2, Ext_PacketOK_Counter
              MOV       R3, #0
              MOV       R6, #LOW  ($0010)
              MOV       R7, #HIGH ($0010)
              LCALL     sysWordMultiplication
              MOV       R6, R8
              MOV       R7, #0
              LCALL     sysWordDivision
              MOV       A, R2
              ADD       A, #$0E
              MOV       R2, A
              MOV       TempByte, #$0E
              ADD       A, #-15
              JNC       L_0ACA
L_0AB7:
              INC       TempByte

;                      OsdString [TempByte] := CommChar;
              MOV       A, TempByte
              ADD       A, #LOW  (OsdString)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (OsdString)
              MOV       DPH, A
              MOV       A, R0
              MOVX      @DPTR, A
              MOV       A, R2
              CJNE      A, TempByte, L_0AB7
L_0ACA:

;                  end else OsdString := 'OPTIC  COMM:                  ';
              SJMP      L_0AD8
L_0ACC:
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2551
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA
L_0AD8:

;                WriteAtRow (9);
              MOV       DPTR, #RowY
              MOV       A, #9
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;                If IntCommActive then
              JNB       IntCommActive, L_0B27

;                  begin         { 123456789012345678901234567890 }
;                    OsdString := 'RS485  COMM:  """"""""""""""""';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2570
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;                    For TempByte := 15 to Byte ((Word (Int_PacketOK_Counter) * 16) div Int_PacketCounter) + 14 do
              MOV       R8, Int_PacketCounter
              MOV       R2, Int_PacketOK_Counter
              MOV       R3, #0
              MOV       R6, #LOW  ($0010)
              MOV       R7, #HIGH ($0010)
              LCALL     sysWordMultiplication
              MOV       R6, R8
              MOV       R7, #0
              LCALL     sysWordDivision
              MOV       A, R2
              ADD       A, #$0E
              MOV       R2, A
              MOV       TempByte, #$0E
              ADD       A, #-15
              JNC       L_0B25
              MOV       R3, #'#'
L_0B12:
              INC       TempByte

;                      OsdString [TempByte] := '#';
              MOV       A, TempByte
              ADD       A, #LOW  (OsdString)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (OsdString)
              MOV       DPH, A
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       A, R2
              CJNE      A, TempByte, L_0B12
L_0B25:

;                  end else OsdString := 'RS485  COMM:                  ';
              SJMP      L_0B33
L_0B27:
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_258F
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA
L_0B33:

;              end else WriteAtRow (9);                                   { 123456789012345678901234567890 }
              LJMP      L_0BDD
L_0B36:
              MOV       DPTR, #RowY
              MOV       A, #9
              MOVX      @DPTR, A
              LCALL     WriteAtRow
              LJMP      L_0BDD
L_0B42:

;     else begin         { 123456789012345678901234567890 }               { OSD In:    Outputs: In    EQ 0 }
;            OsdString := '                  DAC:        ';               { Inputs: 0000      DAC: 1000 Hz }
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_25AE
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;            Case EqState of
              MOV       R2, EqState

;              0: begin
              CJNE      R2, #0, L_0B62

;                   OsdString [28] := 'A';
              MOV       DPTR, #OsdString+28
              MOV       A, #'A'
              MOVX      @DPTR, A

;                   OsdString [29] := 'D';
              INC       DPTR
              MOV       A, #'D'
              MOVX      @DPTR, A

;                   OsdString [30] := 'C';
              INC       DPTR
              DEC       A
              MOVX      @DPTR, A

;                 end;
              SJMP      L_0BA8
L_0B62:

;              1: begin
              CJNE      R2, #1, L_0B77

;                   OsdString [27] := '0';
              MOV       DPTR, #OsdString+27
              MOV       A, #'0'
              MOVX      @DPTR, A

;                   OsdString [29] := 'H';
              MOV       DPTR, #OsdString+29
              MOV       A, #'H'
              MOVX      @DPTR, A

;                   OsdString [30] := 'z';
              INC       DPTR
              MOV       A, #'z'
              MOVX      @DPTR, A

;                 end;
              SJMP      L_0BA8
L_0B77:

;              2: begin
              CJNE      R2, #2, L_0B91

;                   OsdString [25] := '1';
              MOV       DPTR, #OsdString+25
              MOV       A, #'1'
              MOVX      @DPTR, A

;                   OsdString [26] := '0';
              INC       DPTR
              DEC       A
              MOVX      @DPTR, A

;                   OsdString [27] := '0';
              INC       DPTR
              MOVX      @DPTR, A

;                   OsdString [29] := 'H';
              MOV       DPTR, #OsdString+29
              MOV       A, #'H'
              MOVX      @DPTR, A

;                   OsdString [30] := 'z';
              INC       DPTR
              MOV       A, #'z'
              MOVX      @DPTR, A

;                 end;
              SJMP      L_0BA8
L_0B91:

;              else begin
;                     OsdString [24] := '1';
              MOV       DPTR, #OsdString+24
              MOV       A, #'1'
              MOVX      @DPTR, A

;                     OsdString [25] := '0';
              INC       DPTR
              DEC       A
              MOVX      @DPTR, A

;                     OsdString [26] := '0';
              INC       DPTR
              MOVX      @DPTR, A

;                     OsdString [27] := '0';
              INC       DPTR
              MOVX      @DPTR, A

;                     OsdString [29] := 'H';
              MOV       DPTR, #OsdString+29
              MOV       A, #'H'
              MOVX      @DPTR, A

;                     OsdString [30] := 'z';
              INC       DPTR
              MOV       A, #'z'
              MOVX      @DPTR, A

;                   end;
L_0BA8:
;            end;
;            WriteAtRow (9);
              MOV       DPTR, #RowY
              MOV       A, #9
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;                        { 123456789012345678901234567890 }
;            OsdString := 'OSD In:    Outputs: In    EQ 0';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_25CD
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;            OsdString [9]  := Chr (PinToInput [OSDVideoInputPin] + $30);
              MOV       A, OSDVideoInputPin
              MOV       DPTR, #PinToInput
              MOVC      A, @A + DPTR
              ADD       A, #$30
              MOV       DPTR, #OsdString+9
              MOVX      @DPTR, A

;            OsdString [23] := Chr (PinToInput [VideoInputPin] + $30);
              MOV       A, VideoInputPin
              MOV       DPTR, #PinToInput
              MOVC      A, @A + DPTR
              ADD       A, #$30
              MOV       DPTR, #OsdString+23
              MOVX      @DPTR, A

;            OsdString [30] := Chr (EqState + $30);
              MOV       A, EqState
              ADD       A, #$30
              MOV       DPTR, #OsdString+30
              MOVX      @DPTR, A

;          end;
L_0BDD:
;   end;
;   WriteAtRow (8);
              MOV       DPTR, #RowY
              MOV       A, #8
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   OsdString := EmptyLine30;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2509
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   If MiscFlags and hdDescrVisible <> 0 then
              MOV       A, MiscFlags
              JNB       ACC.0, L_0C33

;     begin
;       TempByte := ReadByteFromEEPROM  (@EEPROM_Data.eeSourceDescription);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0034)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0034)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       TempByte, A

;       ReadXBytesFromEEPROM  (Pointer (Word (@EEPROM_Data.eeSourceDescription) + 1),
              MOV       A, #LOW  ($0034)
              ADD       A, #LOW  (1)
              MOV       R2, A
              MOV       A, #HIGH ($0034)
              ADDC      A, #HIGH (1)
              MOV       R3, A
              MOV       DPTR, #EepromAddressXR
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                              Pointer (Word (@OsdString) + 1),
              MOV       A, #LOW  (OsdString)
              ADD       A, #LOW  (1)
              MOV       R2, A
              MOV       A, #HIGH (OsdString)
              ADDC      A, #HIGH (1)
              MOV       R3, A
              MOV       DPTR, #DestinationAddressX
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                              TempByte);
              MOV       DPTR, #CountRX
              MOV       A, TempByte
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;     end;
L_0C33:
;   Case Local of
;     True: WriteAtRow (11);
              JNB       Local, L_0C41
              MOV       DPTR, #RowY
              MOV       A, #$0B
              MOVX      @DPTR, A
              LCALL     WriteAtRow
              SJMP      L_0C4A
L_0C41:

;     else  WriteAtRow (10);
              MOV       DPTR, #RowY
              MOV       A, #$0A
              MOVX      @DPTR, A
              LCALL     WriteAtRow
L_0C4A:

;   end;
;   OsdString := EmptyLine30;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2509
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   Case Local of
;     True: WriteAtRow (10);
              JNB       Local, L_0C62
              MOV       DPTR, #RowY
              MOV       A, #$0A
              MOVX      @DPTR, A
              LJMP      WriteAtRow
L_0C62:

;     else  WriteAtRow (11);
              MOV       DPTR, #RowY
              MOV       A, #$0B
              MOVX      @DPTR, A
              LJMP      WriteAtRow

;   end;
; end;
; 
; Procedure ProcessTestKey;

ProcessTestKey:
; begin                                  { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }
;   If KeyPressed then
              JNB       KeyPressed, L_0C7C

;     begin
;       If Key_Up and Key_Down and Key_Enter then KeyPressed := False else Exit;
              JNB       $25.2, L_0C7B
              JNB       $25.1, L_0C7B
              JNB       $25.0, L_0C7B
              CLR       KeyPressed
              SJMP      L_0C7C
L_0C7B:
              RET

;     end;
L_0C7C:
;   If not Key_Up then
              JB        $25.2, L_0C8E

;     begin
;         OSDVideoInputPin := TInputPin ((Ord (OSDVideoInputPin) + 1) and $07);
              MOV       A, OSDVideoInputPin
              INC       A
              ANL       A, #7
              MOV       OSDVideoInputPin, A

;       If OSDVideoInputPin = vIn_OSD_Out then
              CJNE      A, #1, L_0C8E

;         OSDVideoInputPin := TInputPin ((Ord (OSDVideoInputPin) + 1) and $07);
              INC       A
              ANL       A, #7
              MOV       OSDVideoInputPin, A

;     end;
L_0C8E:
;   If not Key_Down then
              JB        $25.1, L_0C98

;     begin
;       VideoInputPin := TInputPin ((Ord (VideoInputPin) + 1) and $07);
              MOV       A, VideoInputPin
              INC       A
              ANL       A, #7
              MOV       VideoInputPin, A

;     end;
L_0C98:
;   If not Key_Enter then
              JB        $25.0, L_0CA2

;     EqState := (EqState + 1) and $03;
              MOV       A, EqState
              INC       A
              ANL       A, #3
              MOV       EqState, A
L_0CA2:

;   KeyPressed := not (Key_Up and Key_Down and Key_Enter);
              JNB       $25.2, L_0CAE
              JNB       $25.1, L_0CAE
              JNB       $25.0, L_0CAE
              CLR       KeyPressed
              RET
L_0CAE:
              SETB      KeyPressed

; end;
              RET

; 
; Procedure SetTestXPoints;

SetTestXPoints:
; begin
;   If (OSDVideoInputPin = vIn_IO) or (VideoInputPin = vIn_IO) then
              MOV       A, OSDVideoInputPin
              XRL       A, #4
              JZ        L_0CBC
              MOV       A, VideoInputPin
              CJNE      A, #4, L_0CC4
L_0CBC:

;     VideoXPoint [vOut_IO]  := vIn_NC else
              MOV       DPTR, #VideoXPoint+2
              MOV       A, #6
              MOVX      @DPTR, A
              SJMP      L_0CC8
L_0CC4:

;       VideoXPoint [vOut_IO] := VideoInputPin;
              MOV       DPTR, #VideoXPoint+2
              MOVX      @DPTR, A
L_0CC8:

;   VideoXPoint [vOut_OSD_In]        := OSDVideoInputPin;
              MOV       DPTR, #VideoXPoint+1
              MOV       A, OSDVideoInputPin
              MOVX      @DPTR, A

;   VideoXPoint [vOut_ExtSyncOut]    := VideoInputPin;
              MOV       DPTR, #VideoXPoint+5
              MOV       A, VideoInputPin
              MOVX      @DPTR, A

;   VideoXPoint [vOut_VideoOut_BUS]  := VideoInputPin;
              MOV       DPTR, #VideoXPoint+4
              MOVX      @DPTR, A

;   VideoXPoint [vOut_VideoOut]      := VideoInputPin;
              MOV       DPTR, #VideoXPoint+3
              MOVX      @DPTR, A

;   VideoXPoint [vOut_Optic_TX]      := VideoInputPin;
              MOV       DPTR, #VideoXPoint
              MOVX      @DPTR, A

;   SetVideoXPoints;
              LJMP      SetVideoXPoints

; end;
; 
; Procedure Init;

RSEG _CONST

C_25EC:                         DB        15, ' MODULE  RESET '
C_25FC:                         DB        15, ' MODULE   TEST '
C_260C:                         DB        21, 'Firmware version 0.00'
C_2622:                         DB        15, 'Error: I2C BUSY'
C_2632:                         DB        30, '                              '
C_2651:                         DB        17, '24C32       found'
C_2663:                         DB        17, '24C32   not found'
C_2675:                         DB        17, 'TEA6415     found'
C_2687:                         DB        17, 'TEA6415 not found'
C_2699:                         DB        22, 'Initializing module...'


RSEG _CODE

Init:
; begin
;   OSCXCN := $67;
              MOV       $B1, #$67

;   Asm
; @1:
L_0CE6:
;    DJNZ  ACC, @1
              DJNZ      ACC, L_0CE6

; @2:
L_0CE9:
;    DJNZ  ACC, @2
              DJNZ      ACC, L_0CE9

;   end;
              MOV       R2, $B1

;   Repeat until OSCXCN and $80 <> 0; { Wait until external oscillator is stable }
L_0CEE:
              MOV       A, R2
              JNB       ACC.7, L_0CEE

;   OSCICN := OSCICN or $08;          { Switch to external oscillator }
              ORL       $B2, #8

; 
;   { P0 }
; 
;   XBR0 := $05;                      { UART0EN, SMB0EN }
              MOV       $E1, #5

;   XBR2 := $04;                      { UART1EN }
              MOV       $E3, #4

;   P0MDOUT := %11010001;             { TX0, TX1 Push-Pull, P0.6, P0.7 }
              MOV       $A4, #$D1

; 
;   { P1 }
; 
;   P1MDIN  := $00;                   { P1 analog inputs }
              MOV       $BD, #0

;   P1MDOUT := $00;                   { P1 as open drain }
              MOV       $A5, #0

;   P1 := $FF;                        { High impenance state }
              MOV       P1, #$FF

;   XBR2    := $44;                   { Enable xbar }
              MOV       $E3, #$44

; 
;   { P2 }
; 
;   { P3 }
; 
;   P3MDOUT := %01011111;             { A2, A1, A0 }
              MOV       $A7, #$5F

; 
;   { P4 = KeysAndSlotPort, P5 = LedsAndLatchPort, P6 = LatchDataPort, P7 = IOPort }
; 
;   P74OUT := %01111100;              { P7H = In, P7L = Out, P6 = Out, P5 = Out, P4 = In }
              MOV       $B5, #$7C

;   P7 := $F0;                        { IOPort: P7.7 to P7.4 set to high impedance state }
              MOV       $96, #$F0

;   P4 := $FF;                        { KeysAndSlotPort: all pins are inputs }
              MOV       $84, #$FF

; 
;   LedsAndLatchPort := $FF;
              MOV       $85, #$FF

; 
;   AMX0SL := $07;                    { select TEMP sensor as ADC0 input }
              MOV       $BB, #7

;   ADC0CF := ConversionClock;        { Set clock and PGA Gain = 1 }
              MOV       $BC, #$40

;   ADC0CN := %01000101;              { Disable ADC, track mode, Conversion initiated by Timer3 overflow, left-justified data }
              MOV       $E8, #$45

; 
;   Int_RS485_TX      := False;
              CLR       P3.6

;   Ext_RS485_TX      := False;
              CLR       P0.7

;   Ext_RS485_TX_Int  := False;
              CLR       P0.6

; 
;   P2  := $FF;
              MOV       P2, #$FF

; 
;   I_DET := True;
              SETB      P1.7

;   U_DET := True;
              SETB      P1.6

; 
;   OSD_SCK := False;
              CLR       P2.7

;   OSD_CSB := False;
              CLR       P2.6

; 
;   OSD_SYD := True;
              SETB      P2.4

; 
;   Key_Up    := True;
              SETB      $25.2

;   Key_Down  := True;
              SETB      $25.1

;   Key_Enter := True;
              SETB      $25.0

; 
;   Led_PowerSupply_U := True;
              SETB      P3.1

;   Led_PowerSupply_I := True;
              SETB      P3.0

;   RemoteLink        := True;
              SETB      P3.7

; 
;   RS485_Timer             := 0;
              MOV       RS485_Timer, #0

;   RS485_Timer_External    := 0;
              MOV       RS485_Timer_External, #0

;   Int_PacketCounter       := 0;
              MOV       Int_PacketCounter, #0

;   Int_PacketOK_Counter    := 0;
              MOV       Int_PacketOK_Counter, #0

;   Ext_PacketCounter       := 0;
              MOV       Ext_PacketCounter, #0

;   Ext_PacketOK_Counter    := 0;
              MOV       Ext_PacketOK_Counter, #0

;   IntCommPacketTimer      := CommPacketTime;
              MOV       IntCommPacketTimer, #LOW  ($0BB8)
              MOV       IntCommPacketTimer+1, #HIGH ($0BB8)

;   ExtCommPacketTimer      := ExtCommunicationTime;
              MOV       ExtCommPacketTimer, #LOW  ($00FA)
              MOV       ExtCommPacketTimer+1, #HIGH ($00FA)

;   TX_Counter_Int          := 0;
              MOV       TX_Counter_Int, #0

;   TX_Counter_Ext          := 0;
              MOV       TX_Counter_Ext, #0

;   RX_Counter_Int          := 0;
              MOV       RX_Counter_Int, #0

;   RX_Counter_Ext          := 0;
              MOV       RX_Counter_Ext, #0

;   RX_Checksum_Int         := 0;
              MOV       RX_Checksum_Int, #0

;   RX_Checksum_Ext         := 0;
              MOV       RX_Checksum_Ext, #0

;   ErrorLedTimer           := 0;
              MOV       ErrorLedTimer, #0

;   TX_Buffer_Int.StartByte := TurboStartByte;
              MOV       DPTR, #TX_Buffer_Int
              MOV       A, #$AA
              MOVX      @DPTR, A

;   TX_Buffer_Ext.StartByte := TurboStartByte;
              MOV       DPTR, #TX_Buffer_Ext
              MOVX      @DPTR, A

;   EqState                 := 0;
              MOV       EqState, #0

;   msCounter               := 1000;
              MOV       msCounter, #LOW  ($03E8)
              MOV       msCounter+1, #HIGH ($03E8)

;   DelayedTXCounter_Int    := 0;
              MOV       R0, #DelayedTXCounter_Int
              MOV       @R0, #0

;   DelayedTXCounter_Ext    := 0;
              MOV       R0, #DelayedTXCounter_Ext
              MOV       @R0, #0

;   BroadcastReplyTimer_Int := 0;
              CLR       A
              MOV       BroadcastReplyTimer_Int, A
              MOV       BroadcastReplyTimer_Int+1, A

;   BroadcastReplyTimer_Ext := 0;
              MOV       BroadcastReplyTimer_Ext, A
              MOV       BroadcastReplyTimer_Ext+1, A

;   LoopTestTimer           := 0;
              MOV       LoopTestTimer, A
              MOV       LoopTestTimer+1, A

;   Temperature             := 0;
              MOV       Temperature_L, A
              MOV       Temperature_L+1, A

;   ExtCommunicationTimer   := 0;
              MOV       ExtCommunicationTimer, A

;   I_DET_Counter           := 0;
              MOV       I_DET_Counter, A

;   U_DET_Counter           := 0;
              MOV       U_DET_Counter, A

;   RemoteLinkCounter       := 0;
              MOV       RemoteLinkCounter, A

; 
;   Sending_Int                   := False;
              CLR       Sending_Int

;   Sending_Ext                   := False;
              CLR       Sending_Ext

;   SendKeepAliveByte             := False;
              CLR       SendKeepAliveByte

;   ReadyForExternalCommunication := True;
              SETB      ReadyForExternalCommunication

;   CommandReceived_Int           := False;
              CLR       CommandReceived_Int

;   CommandReceived_Ext           := False;
              CLR       CommandReceived_Ext

;   KeyPulse                      := False;
              CLR       KeyPulse

;   DelayPacketToExt              := False;
              CLR       DelayPacketToExt

;   OtherModuleLocal              := False;
              CLR       OtherModuleLocal

; 
;   TL0     := Lo (Const1ms);
              MOV       TL0, #$CD

;   TH0     := Hi (Const1ms);
              MOV       TH0, #$F8

;   TL1     := BaudRateTimerValue;
              MOV       TL1, #$FD

;   TH1     := BaudRateTimerValue;
              MOV       TH1, #$FD

;   TMR3RLL := Lo (DAC_SampleRateTimerValue);
              MOV       $92, #$34

;   TMR3RLH := Hi (DAC_SampleRateTimerValue);
              MOV       $93, #$F5

;   RCAP4L  := Lo (BaudRateTimerValue1);
              MOV       $E4, #$DC

;   RCAP4H  := Hi (BaudRateTimerValue1);
              MOV       $E5, #$FF

; 
;   REF0CN  := %00000111; { Temperature sensor on, Internal bias generator on, reference buffer on }
              MOV       $D1, #7

; 
;   PCON    := $00;       { no IDLE, no POWER DOWN }
              MOV       PCON, A

; {$IFDEF DPS900 }
;   SCON1   := %01010000; { Serial Mode 1, Enable Reception }
              MOV       $F1, #$50

; {$ELSE}
;   SCON1   := %11010000; { Serial Mode 3, Enable Reception }
; {$ENDIF}
;   SCON0   := %01010000; { Serial Mode 1, Enable Reception }
              MOV       SCON, #$50

;   TMOD    := %00100001; { Timer1: no GATE, Timer,  8 bit timer, autoreload }
              MOV       TMOD, #$21

;                         { Timer0: no GATE, Timer, 16 bit timer }
;   TCON    := %01010101; { Timer 1 run, Timer 0 run }
              MOV       TCON, #$55

;                         { Int1 falling edge, Int0 falling edge }
;   TMR3CN  := TR3 or T3M;{ Timer3 for DAC sample rate, Run, SysClk }
              MOV       $91, #6

;   T4CON   := %00110100; { Timer 4 for RX1 and TX1 clock, Timer 4 run, Timer }
              MOV       $C9, #$34

;   IE      := %10000010; { Timer0 }
              MOV       IE, #$82

;   EIE2    := ET3;       { Timer3 }
              MOV       $E7, #1

;   EIP2    := PT3;       { Interrupt priority Timer3 }
              MOV       $F7, #1

;   DAC0CN  := DAC0EN or UpdateOn_Timer3 or %100;         { Enable DAC0, update on Timer3 overflow, DAC bits 11..4 in DAC0H }
              MOV       $D4, #$8C

;   DAC1CN  := DAC1EN or UpdateOn_Timer3 or %100;         { Enable DAC1, update on Timer3 overflow, DAC bits 11..4 in DAC0H }
              MOV       $D7, #$8C

;   SMB0CR  := 147;       { I2C (SMBus0) clock 100 kHz }
              MOV       $CF, #$93

;   ENSMB   := True;      { I2C (SMBus0) enabled }
              SETB      $C0.6

;   AD0EN   := True;      { Enable ADC }
              SETB      $E8.7

; 
;   BackgroundColor := bcBlue;
              MOV       BackgroundColor, #3

;   Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;   InitOsd;
              LCALL     InitOsd

; 
;   RX_Int_LedTimer := 255;
              MOV       RX_Int_LedTimer, #$FF

;   RX_Ext_LedTimer := 255;
              MOV       RX_Ext_LedTimer, #$FF

;   TX_Int_LedTimer := 255;
              MOV       TX_Int_LedTimer, #$FF

;   TX_Ext_LedTimer := 255;
              MOV       TX_Ext_LedTimer, #$FF

;   Led_VideoLink   := Led_ON;
              CLR       $24.1

;   Led_Error       := Led_ON;
              CLR       $24.0
              MOV       R2, #$A5

;   Repeat
L_0E1F:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until RX_Int_LedTimer = 10;
              MOV       A, RX_Int_LedTimer
              CJNE      A, #$0A, L_0E1F

;   RX_Int_LedTimer := 255;
              MOV       RX_Int_LedTimer, #$FF

;   RX_Ext_LedTimer := 255;
              MOV       RX_Ext_LedTimer, #$FF

;   TX_Int_LedTimer := 255;
              MOV       TX_Int_LedTimer, #$FF

;   TX_Ext_LedTimer := 255;
              MOV       TX_Ext_LedTimer, #$FF
              MOV       R2, #$A5

;   Repeat
L_0E34:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until RX_Int_LedTimer = 0;
              MOV       A, RX_Int_LedTimer
              JNZ       L_0E34

;   Led_VideoLink := Led_OFF;
              SETB      $24.1

;   Led_Error     := Led_OFF;
              SETB      $24.0

; 
;   Slot := KeysAndSlotPort shr 4;
              MOV       A, $84
              SWAP      A
              ANL       A, #$0F
              MOV       Slot, A

;   BroadcastReplyTime_Int := Word (Slot + 1) * BroadcastReplyTimeSlot;
              INC       A
              MOV       R2, A
              MOV       R3, #0
              MOV       R6, #LOW  ($0050)
              MOV       R7, #HIGH ($0050)
              LCALL     sysWordMultiplication
              MOV       BroadcastReplyTime_Int, R2
              MOV       BroadcastReplyTime_Int+1, R3

;   BroadcastReplyTime_Ext := 18 * BroadcastReplyTimeSlot;   { Time for remote FOM3000 to wait before it forwards broadcast and answers }
              MOV       BroadcastReplyTime_Ext, #LOW  ($05A0)
              MOV       BroadcastReplyTime_Ext+1, #HIGH ($05A0)

; 
;   TestMode := not Key_Down;
              MOV       C, $25.1
              CPL       C
              MOV       TestMode, C

;   KeyPressed := False;
              CLR       KeyPressed

; 
;   Case TestMode of
;     False: OsdString := ' MODULE  RESET ';
              JB        TestMode, L_0E72
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_25EC
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA
              SJMP      L_0E7E
L_0E72:

;     else   OsdString := ' MODULE   TEST ';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_25FC
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA
L_0E7E:

;   end;
;   WriteAtRow (0);
              CLR       A
              MOV       DPTR, #RowY
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   SetOsdStringToModuleName;
              LCALL     SetOsdStringToModuleName

;   OsdString [16] := ' ';
              MOV       DPTR, #OsdString+16
              MOV       A, #' '
              MOVX      @DPTR, A

;   OsdString [17] := ' ';
              INC       DPTR
              MOVX      @DPTR, A

;   OsdString [18] := ' ';
              INC       DPTR
              MOVX      @DPTR, A

;   OsdString [19] := ' ';
              INC       DPTR
              MOVX      @DPTR, A

;   OsdString [20] := ' ';
              INC       DPTR
              MOVX      @DPTR, A

;   OsdString [21] := ' ';
              INC       DPTR
              MOVX      @DPTR, A

;   WriteAtRow (2);
              MOV       DPTR, #RowY
              MOV       A, #2
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   Row := 3;   { 123456789012345678901234567890 }
              MOV       Row, #3

;   OsdString := 'Firmware version 0.00';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_260C
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   OsdString [18] := Chr (VersionHi + $30);
              MOV       DPTR, #OsdString+18
              MOV       A, #'0'
              MOVX      @DPTR, A

;   OsdString [20] := Chr (VersionLo div 10 + $30);
              MOV       DPTR, #OsdString+20
              INC       A
              MOVX      @DPTR, A

;   OsdString [21] := Chr (VersionLo mod 10 + $30);
              INC       DPTR
              DEC       A
              MOVX      @DPTR, A

;   WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   Inc (Row);
              INC       Row

;   Inc (Row);
              INC       Row

; 
;   If BUSY then
              JNB       $C0.7, L_0F32

;     begin
;       OsdString := 'Error: I2C BUSY';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2622
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;       Attribute := $1D00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1D00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1D00)
              MOVX      @DPTR, A

;       WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow
              MOV       R3, #LOW  ($0064)
              MOV       R4, #HIGH ($0064)
              MOV       R5, #$A5

;       While BUSY do
              SJMP      L_0F0E
L_0EF6:

;         begin
;           ENSMB := False;
              CLR       $C0.6

;           Delay (100);
              MOV       DelayTime, R3
              MOV       DelayTime+1, R4
              LCALL     Delay

;           Led_Error := Blink;
              MOV       C, Blink
              MOV       $24.0, C

;           WDTCN := $A5;
              MOV       $FF, R5

;           ENSMB := True;
              SETB      $C0.6

;           Delay (100);
              MOV       DelayTime, R3
              MOV       DelayTime+1, R4
              LCALL     Delay

;         end;
L_0F0E:
;       While BUSY do
              JB        $C0.7, L_0EF6

;       Led_Error := Led_OFF;
              SETB      $24.0

;       OsdString := EmptyLine30;
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2632
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;       Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;       WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;     end;
L_0F32:
; 
;   ErrorCode := ecNone;
              MOV       ErrorCode, #0

;   Case I2C_AddressPresent (I2C_24C32) of
              MOV       IIC_Adr, #$A0
              LCALL     I2C_AddressPresent

;     True: begin
              JNC       L_0F4D

;                         { 123456789012345678901234567890 }
;             OsdString := '24C32       found';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2651
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

; 
;             NoEEPROM := False;
              CLR       NoEEPROM

;           end;
              SJMP      L_0F68
L_0F4D:

;     else  begin
;             ErrorCode := ecEEPROM;
              MOV       ErrorCode, #3

;                         { 123456789012345678901234567890 }
;             OsdString := '24C32   not found';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2663
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;             Attribute := $1D00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1D00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1D00)
              MOVX      @DPTR, A

;             NoEEPROM := True;
              SETB      NoEEPROM

;           end;
L_0F68:
;   end;
;   WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;   Inc (Row);
              INC       Row

;   Case I2C_AddressPresent (I2C_TEA6415) of
              MOV       IIC_Adr, #6
              LCALL     I2C_AddressPresent

;     True: begin
              JNC       L_0F93

;                         { 123456789012345678901234567890 }
;             OsdString := 'TEA6415     found';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2675
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;           end;
              SJMP      L_0FAC
L_0F93:

;     else  begin
;             ErrorCode := ecTEA6415;
              MOV       ErrorCode, #1

;                         { 123456789012345678901234567890 }
;             OsdString := 'TEA6415 not found';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2687
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;             Attribute := $1D00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1D00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1D00)
              MOVX      @DPTR, A

;           end;
L_0FAC:
;   end;
;   WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

;   Inc (Row);
              INC       Row

; 
;   If not NoEEPROM then Read_EEPROM;
              JB        NoEEPROM, L_0FC7
              LCALL     Read_EEPROM
L_0FC7:

;   If TestMode then VideoInputPin := vIn_OSD_Out;
              JNB       TestMode, L_0FCD
              MOV       VideoInputPin, #1
L_0FCD:

;   OSDVideoInputPin := vIn_VideoIn;
              MOV       OSDVideoInputPin, #7

; 
;   { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }
; 
;   Case TestMode of
;     False: Case Local of
              JB        TestMode, L_101B

;              True: begin
              JNB       Local, L_0FF8

;                      VideoXPoint [vOut_IO]           := vIn_NC;
              MOV       DPTR, #VideoXPoint+2
              MOV       A, #6
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_OSD_In]       := vIn_VideoIn;
              MOV       DPTR, #VideoXPoint+1
              INC       A
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_VideoOut_BUS] := vIn_NC;
              MOV       DPTR, #VideoXPoint+4
              DEC       A
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_VideoOut]     := vIn_Optic_RX;
              MOV       DPTR, #VideoXPoint+3
              DEC       A
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_ExtSyncOut]   := vIn_NC;                { Local out not defined }
              MOV       DPTR, #VideoXPoint+5
              INC       A
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_Optic_TX]     := vIn_OSD_Out;
              MOV       DPTR, #VideoXPoint
              MOV       A, #1
              MOVX      @DPTR, A

;                    end;
              SJMP      L_101E
L_0FF8:

;              else  begin
;                      VideoXPoint [vOut_IO]           := vIn_Optic_RX;          { External sync for remote frame }
              MOV       DPTR, #VideoXPoint+2
              MOV       A, #5
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_OSD_In]       := vIn_VideoIn;           { 26.11.2005 }
              MOV       DPTR, #VideoXPoint+1
              MOV       A, #7
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_VideoOut_BUS] := vIn_NC;
              MOV       DPTR, #VideoXPoint+4
              DEC       A
              MOVX      @DPTR, A

;                      VideoXPoint [vOut_VideoOut]     := vIn_Optic_RX;
              MOV       DPTR, #VideoXPoint+3
              DEC       A
              MOVX      @DPTR, A

;                      VideoXPoint [vOut_ExtSyncOut]   := vIn_NC;                { Error in hardware ??? }
              MOV       DPTR, #VideoXPoint+5
              INC       A
              MOVX      @DPTR, A

; 
;                      VideoXPoint [vOut_Optic_TX]     := vIn_OSD_Out;
              MOV       DPTR, #VideoXPoint
              MOV       A, #1
              MOVX      @DPTR, A

;                    end;
              SJMP      L_101E
L_101B:

;            end;
;     else SetTestXPoints;
              LCALL     SetTestXPoints
L_101E:

;   end;
;   SetVideoXPoints;
              LCALL     SetVideoXPoints

; 
;   SetOsdStringToModuleName;
              LCALL     SetOsdStringToModuleName

;   WriteAtRow (2);
              MOV       DPTR, #RowY
              MOV       A, #2
              MOVX      @DPTR, A
              LCALL     WriteAtRow

; 
;   OsdString := 'Initializing module...';
              MOV       R2, #LOW  (OsdString)
              MOV       R3, #HIGH (OsdString)
              MOV       DPTR, #C_2699
              MOV       R4, #30
              LCALL     sysCopyStringFrom_CODE_To_XDATA

;   WriteAtRow (Row);
              MOV       DPTR, #RowY
              MOV       A, Row
              MOVX      @DPTR, A
              LCALL     WriteAtRow

;   Inc (Row);
              INC       Row

;   Delay (2000);
              MOV       DelayTime, #LOW  ($07D0)
              MOV       DelayTime+1, #HIGH ($07D0)
              LCALL     Delay

; 
;   Led_Error      := Slot and $01 = 0;
              MOV       A, Slot
              RRC       A
              CPL       C
              MOV       $24.0, C

;   Led_VideoLink  := Slot and $02 = 0;
              MOV       A, Slot
              MOV       C, ACC.1
              CPL       C
              MOV       $24.1, C

;   BlinkTimer := 0;
              CLR       A
              MOV       BlinkTimer, A
              MOV       BlinkTimer+1, A
              MOV       R2, #$FF
              MOV       R3, #$A5

;   Repeat
L_1063:
;     RX_Ext_LedTimer := 255;                               { Always on during slot address }
              MOV       RX_Ext_LedTimer, R2

;     If Slot and $04 <> 0 then TX_Int_LedTimer := 255;
              MOV       A, Slot
              JNB       ACC.2, L_106C
              MOV       TX_Int_LedTimer, R2
L_106C:

;     If Slot and $08 <> 0 then RX_Int_LedTimer := 255;
              MOV       A, Slot
              JNB       ACC.3, L_1073
              MOV       RX_Int_LedTimer, R2
L_1073:

;     WDTCN := $A5;
              MOV       $FF, R3

;   until BlinkTimer = $0800;
              MOV       A, BlinkTimer
              JNZ       L_1063
              MOV       A, BlinkTimer+1
              CJNE      A, #HIGH ($0800), L_1063
              MOV       R2, #$A5

; 
;   Repeat
L_1080:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until (RX_Int_LedTimer or TX_Int_LedTimer) = 0;
              MOV       A, RX_Int_LedTimer
              ORL       A, TX_Int_LedTimer
              JNZ       L_1080

;   Led_VideoLink := Led_OFF;
              SETB      $24.1

;   Led_Error     := Led_OFF;
              SETB      $24.0

;   ES := True;                { Enable UART  interrupt }
              SETB      IE.4

;   EIE2 := EIE2 or ES1;       { Enable UART1 interrupt }
              ORL       $E7, #$40

; 
;   TX_Buffer_Ext.PacketSize               := DefaultPacketSize;
              MOV       DPTR, #TX_Buffer_Ext+1
              MOV       A, #$2C
              MOVX      @DPTR, A

;   TX_Buffer_Ext.SourceAddress            := Slot;                     { Send test packet }
              MOV       DPTR, #TX_Buffer_Ext+5
              MOV       A, Slot
              MOVX      @DPTR, A

;   TX_Buffer_Ext.SourceAddress_Frame      := InterFrameAddress;
              CLR       A
              INC       DPTR
              MOVX      @DPTR, A

;   Case Local of
;     True: TX_Buffer_Ext.DestinationAddress       := 1;
              JNB       Local, L_10AA
              MOV       DPTR, #TX_Buffer_Ext+3
              INC       A
              MOVX      @DPTR, A
              SJMP      L_10B0
L_10AA:

;     else  TX_Buffer_Ext.DestinationAddress       := COM_ModuleAddress;
              MOV       DPTR, #TX_Buffer_Ext+3
              MOV       A, #$10
              MOVX      @DPTR, A
L_10B0:

;   end;
;   TX_Buffer_Ext.DestinationAddress_Frame := InterFrameAddress;
              CLR       A
              MOV       DPTR, #TX_Buffer_Ext+4
              MOVX      @DPTR, A

;   TX_Buffer_Ext.OriginalAddress          := Slot;
              MOV       DPTR, #TX_Buffer_Ext+7
              MOV       A, Slot
              MOVX      @DPTR, A

;   TX_Buffer_Ext.GatewayAddress           := $FF;
              INC       DPTR
              MOV       A, #$FF
              MOVX      @DPTR, A

;   TX_Buffer_Ext.Spare                    := 0;
              CLR       A
              MOV       DPTR, #TX_Buffer_Ext+11
              MOVX      @DPTR, A

;   TX_Buffer_Ext.Command                  := Cmd_Message;
              MOV       DPTR, #TX_Buffer_Ext+9
              MOV       A, #8
              MOVX      @DPTR, A

;   TX_Buffer_Ext.CommandFlags             := [cfCommTest];
              INC       DPTR
              MOV       A, #2
              MOVX      @DPTR, A

;   PTX_Buffer := @TX_Buffer_Ext;
              MOV       PTX_Buffer, #LOW  (TX_Buffer_Ext)
              MOV       PTX_Buffer+1, #HIGH (TX_Buffer_Ext)

;   PTX_Buffer_Cmd_Message^.msByte0        := 1;             { Reply }
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, #1
              MOVX      @DPTR, A

;   ActiveBuffer_Ext := True;
              SETB      ActiveBuffer_Ext

;   SendPacket;
              LCALL     SendPacket
              MOV       R2, #$A5

; 
;   Repeat
L_10E9:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until Key_Up and Key_Down and Key_Enter;
              JNB       $25.2, L_10E9
              JNB       $25.1, L_10E9
              JNB       $25.0, L_10E9

; end;
              RET

; 
; Procedure ProcessCommands (Source: Boolean);

RSEG _BIT

Source:                         DBIT     1


RSEG _CODE

ProcessCommands:
; begin
;   Case Source of
;     sInternal: begin
              JNB       Source, L_1108

;                  PTX_Buffer := @TX_Buffer_Int;
              MOV       PTX_Buffer, #LOW  (TX_Buffer_Int)
              MOV       PTX_Buffer+1, #HIGH (TX_Buffer_Int)

;                  PRX_Buffer := @RX_Buffer_Int;
              MOV       PRX_Buffer, #LOW  (RX_Buffer_Int)
              MOV       PRX_Buffer+1, #HIGH (RX_Buffer_Int)

;                  ActiveBuffer_Ext    := False;
              CLR       ActiveBuffer_Ext

;                end;
              SJMP      L_1116
L_1108:

;     else       begin
;                  PTX_Buffer := @TX_Buffer_Ext;
              MOV       PTX_Buffer, #LOW  (TX_Buffer_Ext)
              MOV       PTX_Buffer+1, #HIGH (TX_Buffer_Ext)

;                  PRX_Buffer := @RX_Buffer_Ext;
              MOV       PRX_Buffer, #LOW  (RX_Buffer_Ext)
              MOV       PRX_Buffer+1, #HIGH (RX_Buffer_Ext)

;                  ActiveBuffer_Ext    := True;
              SETB      ActiveBuffer_Ext

;                end;
L_1116:
;   end;
;   Case PRX_Buffer^.Command of
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       R2, A

;     Cmd_ModuleData: begin
              JZ        L_1128
              LJMP      L_1298
L_1128:

;                       If PRX_Buffer^.CommandFlags * [cfWriteToEEPROM, cfWriteToHW] <> [] then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              ANL       A, #$0C
              JZ        L_118A

;                         begin
;                           WriteXBytesToEEPROM (@EEPROM_Data.eeSerialNumber, @PRX_Buffer_Cmd_ModuleData^.mdSerialNumber, SerialNumberLength + 1);
              MOV       DPTR, #EepromAddressXW
              MOV       A, #LOW  (7)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH (7)
              MOVX      @DPTR, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #16
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #SourceAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountWX
              MOV       A, #$0D
              MOVX      @DPTR, A
              LCALL     WriteXBytesToEEPROM

;                           WriteXBytesToEEPROM (@EEPROM_Data.eeComment,      @PRX_Buffer_Cmd_ModuleData^.mdComment, CommentLength + 1);
              MOV       DPTR, #EepromAddressXW
              MOV       A, #LOW  ($0014)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0014)
              MOVX      @DPTR, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #29
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #SourceAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountWX
              MOV       A, #$0F
              MOVX      @DPTR, A
              LCALL     WriteXBytesToEEPROM

;                         end;
L_118A:
; 
;                       If PRX_Buffer^.CommandFlags * [cfReadFromEEPROM, cfReadFromHW] <> [] then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              ANL       A, #3
              JNZ       L_119B
              RET
L_119B:

;                         begin
;                           SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                           PTX_Buffer^.PacketSize := DefaultPacketSize + 2;              { Temperature }
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              MOV       A, #$2E
              MOVX      @DPTR, A

;                           PTX_Buffer^.Command                                 := Cmd_ModuleData;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              CLR       A
              MOVX      @DPTR, A

;                           Case Local of
;                             True: PTX_Buffer_Cmd_ModuleData^.mdModuleType     := mtFOM3000_Local;
              JNB       Local, L_11C8
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, #1
              MOVX      @DPTR, A
              SJMP      L_11D6
L_11C8:

;                             else  PTX_Buffer_Cmd_ModuleData^.mdModuleType     := mtFOM3000_Remote;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, #2
              MOVX      @DPTR, A
L_11D6:

;                           end;
;                           If OSD_SYD = False then TempByte := $00 else TempByte := mdVideoPresent;
              JB        P2.4, L_11DE
              MOV       TempByte, #0
              SJMP      L_11E1
L_11DE:
              MOV       TempByte, #1
L_11E1:

;                           If not I2C_AddressPresent (I2C_24C32) then         TempByte := TempByte or mdErrorEEPROM;
              MOV       IIC_Adr, #$A0
              LCALL     I2C_AddressPresent
              JC        L_11EC
              ORL       TempByte, #2
L_11EC:

;                           If not I2C_AddressPresent (I2C_TEA6415) then TempByte := TempByte or mdErrorTEA6415;
              MOV       IIC_Adr, #6
              LCALL     I2C_AddressPresent
              JC        L_11F7
              ORL       TempByte, #4
L_11F7:

;                           If U_DET_Active then TempByte := TempByte or mdUDet;
              JNB       U_DET_Active, L_11FD
              ORL       TempByte, #8
L_11FD:

;                           If I_DET_Active then TempByte := TempByte or mdIDet;
              JNB       I_DET_Active, L_1203
              ORL       TempByte, #$10
L_1203:

;                           If RemoteLinkActive then TempByte := TempByte or mdLink;
              JNB       RemoteLinkActive, L_1209
              ORL       TempByte, #$80
L_1209:

;                           If Key_Enter = False then TempByte := TempByte or mdKeyEnter;
              JB        $25.0, L_120F
              ORL       TempByte, #$20
L_120F:

;                           PTX_Buffer_Cmd_ModuleData^.mdModuleFlags        := TempByte;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #13
              LCALL     sysADD_DPTR_A
              MOV       A, TempByte
              MOVX      @DPTR, A

;                           PTX_Buffer_Cmd_ModuleData^.mdFirmwareVersion    := VersionHi * 256 + VersionLo;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #14
              LCALL     sysADD_DPTR_A
              MOV       A, #LOW  ($000A)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($000A)
              MOVX      @DPTR, A

;                           ReadXBytesFromEEPROM (@EEPROM_Data.eeSerialNumber,
              MOV       DPTR, #EepromAddressXR
              MOV       A, #LOW  (7)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH (7)
              MOVX      @DPTR, A

;                                                 @PTX_Buffer_Cmd_ModuleData^.mdSerialNumber, SerialNumberLength + 1);
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #16
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #DestinationAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountRX
              MOV       A, #$0D
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                           ReadXBytesFromEEPROM (@EEPROM_Data.eeComment,
              MOV       DPTR, #EepromAddressXR
              MOV       A, #LOW  ($0014)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0014)
              MOVX      @DPTR, A

;                                                 @PTX_Buffer_Cmd_ModuleData^.mdComment, CommentLength + 1);
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #29
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #DestinationAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountRX
              MOV       A, #$0F
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                           PTX_Buffer_Cmd_ModuleData^.mdTemperature := NoTemperature{Temperature};
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #44
              LCALL     sysADD_DPTR_A
              MOV       A, #LOW  ($FF00)
              MOVX      @DPTR, A
              INC       DPTR
              DEC       A
              MOVX      @DPTR, A

; 
;                           SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LJMP      SendPacketWithDelay

;                         end;
;                     end;
L_1298:
;     Cmd_SourceNameAndFlags: begin
              MOV       A, R2
              XRL       A, #2
              JZ        L_12A0
              LJMP      L_13FE
L_12A0:

;                               If cfResetHWToEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.4, L_12C1

;                                 begin
;                                   MiscFlags := ReadByteFromEEPROM (@EEPROM_Data.eeMiscFlags);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0033)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0033)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       MiscFlags, A

;                                   SetHardware;
              LCALL     SetHardware

;                                 end;
L_12C1:
; 
;                               If cfWriteToHW in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.2, L_12E1

;                                 begin
;                                   MiscFlags := PRX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       MiscFlags, A

;                                   SetHardware;
              LCALL     SetHardware

;                                 end;
L_12E1:
; 
;                               If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.3, L_1336

;                                 begin
;                                   WriteXBytesToEEPROM (@EEPROM_Data.eeSourceName,
              MOV       DPTR, #EepromAddressXW
              MOV       A, #LOW  ($0023)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0023)
              MOVX      @DPTR, A

;                                                        @PRX_Buffer_Cmd_SourceNameAndFlags^.hdSourceName, SourceNameLength + 1);
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #SourceAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountWX
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     WriteXBytesToEEPROM

;                                   WriteByteToEEPROM (@EEPROM_Data.eeMiscFlags, PRX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0033)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0033)
              MOVX      @DPTR, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;                                 end;
L_1336:
; 
;                               If cfReadFromHW in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.0, L_1393

;                                 begin
;                                   SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                                   PTX_Buffer^.Command  := Cmd_SourceNameAndFlags;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #2
              MOVX      @DPTR, A

;                                   ReadXBytesFromEEPROM  (@EEPROM_Data.eeSourceName,
              MOV       DPTR, #EepromAddressXR
              MOV       A, #LOW  ($0023)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0023)
              MOVX      @DPTR, A

;                                                          @PTX_Buffer_Cmd_SourceNameAndFlags^.hdSourceName,
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #DestinationAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                                                          SourceNameLength + 1);
              MOV       DPTR, #CountRX
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                                   PTX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags := MiscFlags;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOV       A, MiscFlags
              MOVX      @DPTR, A

;                                   SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                                 end;
L_1393:
; 
;                               If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.1, L_13FD

;                                 begin
;                                   SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                                   PTX_Buffer^.Command                      := Cmd_SourceNameAndFlags;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #2
              MOVX      @DPTR, A

;                                   PTX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags := ReadByteFromEEPROM  (@EEPROM_Data.eeMiscFlags);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0033)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0033)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       R1, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A

;                                   ReadXBytesFromEEPROM  (@EEPROM_Data.eeSourceName,
              MOV       DPTR, #EepromAddressXR
              MOV       A, #LOW  ($0023)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0023)
              MOVX      @DPTR, A

;                                                          @PTX_Buffer_Cmd_SourceNameAndFlags^.hdSourceName,
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #DestinationAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                                                          SourceNameLength + 1);
              MOV       DPTR, #CountRX
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                                   SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                                 end;
L_13FD:
;                             end;
              RET
L_13FE:

;     Cmd_SourceDescription: begin
              MOV       A, R2
              XRL       A, #3
              JZ        L_1406
              LJMP      L_148F
L_1406:

;                              If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.3, L_143E

;                                begin
;                                  WriteXBytesToEEPROM (@EEPROM_Data.eeSourceDescription,
              MOV       DPTR, #EepromAddressXW
              MOV       A, #LOW  ($0034)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0034)
              MOVX      @DPTR, A

;                                                       @PRX_Buffer_Cmd_SourceDescription^.hdSourceDescription, SourceDescriptionLength + 1);
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #SourceAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountWX
              MOV       A, #$1F
              MOVX      @DPTR, A
              LCALL     WriteXBytesToEEPROM

;                                end;
L_143E:
; 
;                              If PRX_Buffer^.CommandFlags * [cfReadFromHW, cfReadFromEEPROM] <> [] then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              ANL       A, #3
              JZ        L_148E

;                                begin
;                                  SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                                  PTX_Buffer^.Command                      := Cmd_SourceDescription;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #3
              MOVX      @DPTR, A

;                                  ReadXBytesFromEEPROM  (@EEPROM_Data.eeSourceDescription,
              MOV       DPTR, #EepromAddressXR
              MOV       A, #LOW  ($0034)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0034)
              MOVX      @DPTR, A

;                                                         @PTX_Buffer_Cmd_SourceDescription^.hdSourceDescription,
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #DestinationAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                                                         SourceDescriptionLength + 1);
              MOV       DPTR, #CountRX
              MOV       A, #$1F
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                                  SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                                end;
L_148E:
;                            end;
              RET
L_148F:

;     Cmd_RemoteSlots: begin
              MOV       A, R2
              XRL       A, #4
              JZ        L_1497
              LJMP      L_1665
L_1497:

;                        If cfResetHWToEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.4, L_14D1

;                          begin
;                            ReadBytesFromEEPROM (@EEPROM_Data.eeRemoteSlots, @RemoteSlots, 16);
              MOV       DPTR, #EepromAddressR
              MOV       A, #LOW  ($0054)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0054)
              MOVX      @DPTR, A
              MOV       DPTR, #DestinationAddress
              MOV       A, #RemoteSlots
              MOVX      @DPTR, A
              MOV       DPTR, #CountR
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     ReadBytesFromEEPROM

;                            ModeFlags := ReadByteFromEEPROM (@EEPROM_Data.eeModeFlags);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0053)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0053)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       ModeFlags, A

;                            SetHardware;
              LCALL     SetHardware

;                          end;
L_14D1:
; 
;                        If cfWriteToHW in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.2, L_1527

;                          begin
;                            RemoteSlots := PRX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #13
              LCALL     sysADD_DPTR_A
              MOV       R0, #RemoteSlots
              MOV       R4, #16
              LCALL     sysCopyFrom_XDATA_To_IDATA

; 
;                            If (ModeFlags and hdLocal = 0) and OtherModuleLocal then      { Don't cange remote modul to local if other module is local }
              MOV       A, ModeFlags
              JB        ACC.0, L_1516
              JNB       OtherModuleLocal, L_1516

;                              PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags := PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags and not hdLocal;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              ANL       A, #$FE
              MOV       R1, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A
L_1516:

; 
;                            ModeFlags   := PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       ModeFlags, A

;                            SetHardware;
              LCALL     SetHardware

;                          end;
L_1527:
; 
;                        If cfReadFromHW in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.0, L_1577

;                          begin
;                            SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                            PTX_Buffer^.Command                         := Cmd_RemoteSlots;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #4
              MOVX      @DPTR, A

;                            PTX_Buffer^.PacketSize                      := PacketHeaderSize + 17;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              MOV       A, #$1D
              MOVX      @DPTR, A

;                            PTX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots := RemoteSlots;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #13
              LCALL     sysADD_DPTR_A
              MOV       R0, #RemoteSlots
              MOV       R4, #16
              LCALL     sysCopyFrom_IDATA_To_XDATA

;                            PTX_Buffer_Cmd_RemoteSlots^.hdModeFlags   := ModeFlags;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, ModeFlags
              MOVX      @DPTR, A

;                            SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                          end;
L_1577:
; 
;                        If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.3, L_15F0

;                          begin
;                            WriteXBytesToEEPROM (@EEPROM_Data.eeRemoteSlots, @PRX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots, 16);
              MOV       DPTR, #EepromAddressXW
              MOV       A, #LOW  ($0054)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0054)
              MOVX      @DPTR, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #13
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #SourceAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountWX
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     WriteXBytesToEEPROM

; 
;                            If (ModeFlags and hdLocal = 0) and OtherModuleLocal then      { Don't cange remote modul to local if other module is local }
              MOV       A, ModeFlags
              JB        ACC.0, L_15D3
              JNB       OtherModuleLocal, L_15D3

;                              PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags := PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags and not hdLocal;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              ANL       A, #$FE
              MOV       R1, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A
L_15D3:

; 
;                            WriteByteToEEPROM (@EEPROM_Data.eeModeFlags, PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags);
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0053)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0053)
              MOVX      @DPTR, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;                          end;
L_15F0:
; 
;                        If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.1, L_1664

;                          begin
;                            SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                            PTX_Buffer^.Command                       := Cmd_RemoteSlots;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #4
              MOVX      @DPTR, A

;                            PTX_Buffer^.PacketSize                    := PacketHeaderSize + 17;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              MOV       A, #$1D
              MOVX      @DPTR, A

;                            ReadXBytesFromEEPROM (@EEPROM_Data.eeRemoteSlots, @PTX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots, 16);
              MOV       DPTR, #EepromAddressXR
              MOV       A, #LOW  ($0054)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0054)
              MOVX      @DPTR, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #13
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #DestinationAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountRX
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                            PTX_Buffer_Cmd_RemoteSlots^.hdModeFlags := ReadByteFromEEPROM (@EEPROM_Data.eeModeFlags);
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0053)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0053)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       R1, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A

;                            SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                          end;
L_1664:
;                      end;
              RET
L_1665:

;     Cmd_Protocols: begin
              MOV       A, R2
              XRL       A, #$0D
              JZ        L_166D
              LJMP      L_1741
L_166D:

;                      If cfReadFromHW in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.0, L_16AB

;                        begin
;                          SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                          PTX_Buffer^.PacketSize                   := PacketHeaderSize + 1;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              MOV       A, #$0D
              MOVX      @DPTR, A

;                          PTX_Buffer^.Command                      := Cmd_Protocols;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #$0D
              MOVX      @DPTR, A

;                          PTX_Buffer_Cmd_Protocols^.prProtocols    := Protocols;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              DEC       A
              LCALL     sysADD_DPTR_A
              MOV       R0, #Protocols
              MOV       A, @R0
              MOVX      @DPTR, A

;                          SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                        end;
L_16AB:
; 
;                      If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.1, L_16F6

;                        begin
;                          SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                          PTX_Buffer^.PacketSize                   := PacketHeaderSize + 1;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              MOV       A, #$0D
              MOVX      @DPTR, A

;                          PTX_Buffer^.Command                      := Cmd_Protocols;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #$0D
              MOVX      @DPTR, A

;                          PTX_Buffer_Cmd_Protocols^.prProtocols    := TProtocolsSet (ReadByteFromEEPROM (@EEPROM_Data.eeProtocols));
              MOV       DPTR, #AddressR
              MOV       A, #LOW  ($0064)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0064)
              MOVX      @DPTR, A
              LCALL     ReadByteFromEEPROM
              MOV       R1, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A

;                          SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                        end;
L_16F6:
; 
;                      If cfWriteToHW in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.2, L_1714

;                        begin
;                          Protocols := PRX_Buffer_Cmd_Protocols^.prProtocols;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       R0, #Protocols
              MOVX      A, @DPTR
              MOV       @R0, A

;                        end;
L_1714:
; 
;                      If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.3, L_1740

;                        begin
;                          WriteByteToEEPROM (@EEPROM_Data.eeProtocols, Byte (PRX_Buffer_Cmd_Protocols^.prProtocols));
              MOV       DPTR, #AddressW
              MOV       A, #LOW  ($0064)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0064)
              MOVX      @DPTR, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       DPTR, #Value
              MOVX      @DPTR, A
              LCALL     WriteByteToEEPROM

;                        end;
L_1740:
;                    end;
              RET
L_1741:

;     Cmd_EEPROM: begin
              MOV       A, R2
              XRL       A, #5
              JZ        L_1749
              LJMP      L_1883
L_1749:

;                   If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.3, L_178D

;                     WriteXBytesToEEPROM  (@PRX_Buffer_Cmd_EEPROM^.eeAddress, @PRX_Buffer_Cmd_EEPROM^.eeData, 16);
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #EepromAddressXW
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #SourceAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountWX
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     WriteXBytesToEEPROM
L_178D:

; 
;                   If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JB        ACC.1, L_179D
              RET
L_179D:

;                     begin
;                       SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                       PTX_Buffer^.PacketSize               := PacketHeaderSize + 22;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              INC       DPTR
              MOV       A, #$22
              MOVX      @DPTR, A

;                       ReadXBytesFromEEPROM  (@PRX_Buffer_Cmd_EEPROM^.eeAddress, @PTX_Buffer_Cmd_EEPROM^.eeData, 16);
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #EepromAddressXR
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              MOV       R3, DPH
              MOV       DPTR, #DestinationAddressX
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              MOV       DPTR, #CountRX
              MOV       A, #$10
              MOVX      @DPTR, A
              LCALL     ReadXBytesFromEEPROM

;                       PTX_Buffer^.Command                  := Cmd_EEPROM;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #5
              MOVX      @DPTR, A

;                       PTX_Buffer^.CommandFlags             := PRX_Buffer^.CommandFlags;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       R1, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A

;                       If Word (@PRX_Buffer_Cmd_EEPROM^.eeAddress) >= Word (@EEPROM_Data.eeEND) then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOV       A, DPL
              CLR       C
              SUBB      A, #LOW  ($0065)
              MOV       A, DPH
              SUBB      A, #HIGH ($0065)
              JC        L_1839

;                         PTX_Buffer^.CommandFlags := PTX_Buffer^.CommandFlags + [cfDataEnd];
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              ORL       A, #$20
              MOV       R1, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOV       A, R1
              MOVX      @DPTR, A
L_1839:

;                       PTX_Buffer_Cmd_EEPROM^.eeAddress     := PRX_Buffer_Cmd_EEPROM^.eeAddress;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              MOV       R2, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R3, A
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #28
              LCALL     sysADD_DPTR_A
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A

;                       PTX_Buffer_Cmd_EEPROM^.eeSize        := EEPROM_Size;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #30
              LCALL     sysADD_DPTR_A
              MOV       A, #LOW  ($1000)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1000)
              MOVX      @DPTR, A

;                       PTX_Buffer_Cmd_EEPROM^.eeDataSize    := Word (@EEPROM_Data.eeEND);
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #32
              LCALL     sysADD_DPTR_A
              MOV       A, #LOW  ($0065)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0065)
              MOVX      @DPTR, A

;                       SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LJMP      SendPacketWithDelay

;                     end;
;                 end;
L_1883:
;     Cmd_Message: begin
              MOV       A, R2
              XRL       A, #8
              JZ        L_188B
              LJMP      L_1908
L_188B:

;                    If (cfLoopTest in PRX_Buffer^.CommandFlags) and Local {and (PRX_Buffer^.SourceAddress = $80 + Slot)} then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.0, L_18B7
              JNB       Local, L_18B7

;                      Case PRX_Buffer_Cmd_Message^.msByte0 of
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR

;                        0:   LoopTestTimer := 0;
              JNZ       L_18B1
              MOV       LoopTestTimer, A
              MOV       LoopTestTimer+1, A
              SJMP      L_18B7
L_18B1:

;                        else LoopTestTimer := LoopTestTime;
              MOV       LoopTestTimer, #LOW  ($1388)
              MOV       LoopTestTimer+1, #HIGH ($1388)
L_18B7:

;                      end;
;                    If (cfCommTest in PRX_Buffer^.CommandFlags) and (PRX_Buffer_Cmd_Message^.msByte0 = 1) then
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.1, L_1907
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              CJNE      A, #1, L_1907

;                      begin
;                        SetTX_BufferAddresses;
              LCALL     SetTX_BufferAddresses

;                        PTX_Buffer^.Command := Cmd_Message;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #9
              LCALL     sysADD_DPTR_A
              MOV       A, #8
              MOVX      @DPTR, A

;                        PTX_Buffer^.CommandFlags := [cfCommTest];
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOV       A, #2
              MOVX      @DPTR, A

;                        PTX_Buffer_Cmd_Message^.msByte0 := 0;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              CLR       A
              MOVX      @DPTR, A

;                        SendPacketWithDelay (TxBlockDelay);             { Reply }
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                      end;
L_1907:
;                  end;
              RET
L_1908:

;     Cmd_Reset: begin
              CJNE      R2, #6, L_1932

;                  If cfInitEEPROMModuleData in PRX_Buffer^.CommandFlags then Init_EEPROM_ModuleData;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.5, L_191D
              LCALL     Init_EEPROM_ModuleData
L_191D:

;                  If cfInitEEPROMSettings   in PRX_Buffer^.CommandFlags then Init_EEPROM_Settings;
              MOV       DPL, PRX_Buffer
              MOV       DPH, PRX_Buffer+1
              MOV       A, #10
              LCALL     sysADD_DPTR_A
              MOVX      A, @DPTR
              JNB       ACC.4, L_192F
              LCALL     Init_EEPROM_Settings
L_192F:

; 
;                  Asm
;                    LJMP    0
              LJMP      0

;                  end;
;                end;
L_1932:
;     Cmd_Transport: If not Local then
              CJNE      R2, #$0C, L_197B
              JB        Local, L_197B

;                      begin                                                                        { Cmd_Transport from external connection (local FOM3000 }
;                        WDTCN := $A5;
              MOV       $FF, #$A5

;                        DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)
              MOV       R2, #HIGH ($0014)

;                        Repeat
L_1943:
;                        until not Sending_Int and ((RX_Counter_Int = 0) or (DelayTimer = 0));
              JB        Sending_Int, L_1943
              MOV       A, RX_Counter_Int
              JZ        L_194F
              MOV       A, R2
              ORL       A, #LOW  ($0014)
              JNZ       L_1943
L_194F:

;                        Move (RX_Buffer_Ext, TX_Buffer_Int, RX_Buffer_Ext.PacketSize);
              MOV       DPTR, #RX_Buffer_Ext+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       R2, #LOW  (TX_Buffer_Int)
              MOV       R3, #HIGH (TX_Buffer_Int)
              MOV       DPTR, #RX_Buffer_Ext
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                        TX_Counter_Int := PacketHeaderSize;                                        { Start with actual packet }
              MOV       TX_Counter_Int, #$0C

;                        Sending_Int := True;
              SETB      Sending_Int

;                        RS485_Timer          := RS485_Time;
              MOV       RS485_Timer, #1

;                        RS485_Timer_External := RS485_Time_External;
              MOV       RS485_Timer_External, #$15

;                        Ext_RS485_TX := True;
              SETB      P0.7

;                        Ext_RS485_TX_Int := True;
              SETB      P0.6

;                        TX_Int_LedTimer := LedTime;
              MOV       TX_Int_LedTimer, #$1E
              MOV       R2, #1

;                        Repeat
L_1974:
;                        until RS485_Timer <= 1;
              MOV       A, R2
              ADD       A, #-2
              JC        L_1974

;                        TI := True;
              SETB      SCON.1

;                      end;
L_197B:
;   end;
; end;
              RET

; 
; Procedure ProcessCommands_Int;
; Var SavedRelay: Byte;

ProcessCommands_Int:
; begin
;   If not CommandReceived_Int then Exit;
              JB        CommandReceived_Int, L_1980
              RET
L_1980:

; 
;   Case PacketType of
              MOV       R2, PacketType

;     ptTurbo: begin
              MOV       A, R2
              JZ        L_1988
              LJMP      L_1A56
L_1988:

;                 Case RX_Buffer_Int.DestinationAddress of
              MOV       DPTR, #RX_Buffer_Int+3
              MOVX      A, @DPTR
              MOV       R2, A

;                   BroadcastAddress: begin
              CJNE      A, #$7F, L_19C6

;                                       BroadcastReplyTimer_Int := BroadcastReplyTime_Int;
              MOV       BroadcastReplyTimer_Int, BroadcastReplyTime_Int
              MOV       BroadcastReplyTimer_Int+1, BroadcastReplyTime_Int+1

;                                       BlinkTimer := 0;
              CLR       A
              MOV       BlinkTimer, A
              MOV       BlinkTimer+1, A

;                                       If Local then
              JNB       Local, L_19BE

;                                         begin
;                                           Inc (DelayedTXCounter_Ext);
              MOV       R0, #DelayedTXCounter_Ext
              INC       @R0

;                                           TX_Buffer_Delayed_Ext [DelayedTXCounter_Ext] := RX_Buffer_Int;  { Delay and send to remote modules }
              MOV       A, @R0
              MOV       B, #92
              MUL       AB
              ADD       A, #LOW  (TX_Buffer_Delayed_Ext-92)
              MOV       R2, A
              MOV       A, B
              ADDC      A, #HIGH (TX_Buffer_Delayed_Ext-92)
              MOV       R3, A
              MOV       DPTR, #RX_Buffer_Int
              MOV       R4, #LOW  ($005C)
              MOV       R5, #HIGH ($005C)
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                                           BroadcastReplyTimer_Ext := BroadcastReplyTime_Ext;
              MOV       BroadcastReplyTimer_Ext, BroadcastReplyTime_Ext
              MOV       BroadcastReplyTimer_Ext+1, BroadcastReplyTime_Ext+1

;                                         end;
;                                     end;
L_19BE:
              SETB      Source
              LCALL     ProcessCommands
              LJMP      L_1AB5
L_19C6:

;                   Transport_Address,
              XRL       A, #$7B
              JZ        L_19CF
              MOV       A, R2
              ADD       A, #-128
              JNC       L_1A18
L_19CF:

;                   $80..$FF: Case Local and Master of
              JNB       Local, L_1A15
              JNB       Master, L_1A15

;                               True: begin                                   { Send to remote module }
;                                       WDTCN := $A5;
              MOV       $FF, #$A5

;                                       DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)
              MOV       R2, #HIGH ($0014)

;                                       Repeat
L_19E0:
;                                       until not Sending_Ext and ((RX_Counter_Ext = 0) or (DelayTimer = 0));
              JB        Sending_Ext, L_19E0
              MOV       A, RX_Counter_Ext
              JZ        L_19EC
              MOV       A, R2
              ORL       A, #LOW  ($0014)
              JNZ       L_19E0
L_19EC:

;                                       Move (RX_Buffer_Int, TX_Buffer_Ext, RX_Buffer_Int.PacketSize);
              MOV       DPTR, #RX_Buffer_Int+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       R2, #LOW  (TX_Buffer_Ext)
              MOV       R3, #HIGH (TX_Buffer_Ext)
              MOV       DPTR, #RX_Buffer_Int
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                                       TX_Buffer_Ext.DestinationAddress := TX_Buffer_Ext.DestinationAddress and $7F;
              MOV       DPTR, #TX_Buffer_Ext+3
              MOVX      A, @DPTR
              ANL       A, #$7F
              MOVX      @DPTR, A

;                                       ActiveBuffer_Ext := True;
              SETB      ActiveBuffer_Ext

;                                       CommandReceived_Int := False;
              CLR       CommandReceived_Int

; 
;                                       RS485_Timer          := RS485_Time;
              MOV       RS485_Timer, #1

;                                       RS485_Timer_External := RS485_Time_External;
              MOV       RS485_Timer_External, #$15

;                                       Ext_RS485_TX := True;
              SETB      P0.7

;                                       Ext_RS485_TX_Int := True;
              SETB      P0.6

; 
;                                       SendPacket;
              LJMP      SendPacket

;                                       Exit;
;                                     end;
L_1A15:
;                               else  begin                            { Ignore it }
;                                       CommandReceived_Int := False;
              CLR       CommandReceived_Int

;                                       Exit;
              RET

;                                     end;
L_1A18:
;                             end;
;                   $00..$0F: If RX_Buffer_Int.DestinationAddress <> Slot then
              MOV       A, R2
              ADD       A, #-16
              JC        L_1A27
              MOV       A, R2
              XRL       A, Slot
              JZ        L_1A25

;                               begin
;                                 CommandReceived_Int := False;
              CLR       CommandReceived_Int

;                                 Exit;
              RET

;                               end;                                   { Process command, local or remote }
L_1A25:
              SJMP      L_19BE
L_1A27:

;                   else      If not Local and (RX_Buffer_Int.SourceAddress <> PC_AddressSetup) then
              JB        Local, L_19BE
              MOV       DPTR, #RX_Buffer_Int+5
              MOVX      A, @DPTR
              XRL       A, #$7E
              JZ        L_19BE

;                               begin                                  { Send to local module, COM, PC... }
;                                 WDTCN := $A5;
              MOV       $FF, #$A5

;                                 DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)

;                                 Repeat
L_1A3B:
;                                 until not Sending_Ext;
              JB        Sending_Ext, L_1A3B

;                                 Move (RX_Buffer_Int, TX_Buffer_Ext, RX_Buffer_Int.PacketSize);
              MOV       DPTR, #RX_Buffer_Int+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       R2, #LOW  (TX_Buffer_Ext)
              MOV       R3, #HIGH (TX_Buffer_Ext)
              MOV       DPTR, #RX_Buffer_Int
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                                 ActiveBuffer_Ext := True;
              SETB      ActiveBuffer_Ext

;                                 CommandReceived_Int := False;
              CLR       CommandReceived_Int

;                                 SendPacket;
              LJMP      SendPacket

;                                 Exit;
;                               end;
L_1A56:
;                 end;
;                 ProcessCommands (sInternal);                                 { Process broadcast or normal command }
;               end;
;     ptPanasonic: begin
              CJNE      R2, #1, L_1AB5

;                    RX_Buffer_Int.StartByte                := TurboStartByte;
              MOV       DPTR, #RX_Buffer_Int
              MOV       A, #$AA
              MOVX      @DPTR, A

;                    RX_Buffer_Int.Command                  := Cmd_Transport;
              MOV       DPTR, #RX_Buffer_Int+9
              MOV       A, #$0C
              MOVX      @DPTR, A

;                    RX_Buffer_Int.SourceAddress_Frame      := InterFrameAddress;
              CLR       A
              MOV       DPTR, #RX_Buffer_Int+6
              MOVX      @DPTR, A

;                    RX_Buffer_Int.SourceAddress            := Slot;
              MOV       DPTR, #RX_Buffer_Int+5
              MOV       A, Slot
              MOVX      @DPTR, A

;                    RX_Buffer_Int.DestinationAddress       := COM_ModuleAddress;
              MOV       DPTR, #RX_Buffer_Int+3
              MOV       A, #$10
              MOVX      @DPTR, A

;                    RX_Buffer_Int.DestinationAddress_Frame := InterFrameAddress;
              CLR       A
              INC       DPTR
              MOVX      @DPTR, A

;                    RX_Buffer_Int.OriginalAddress          := Slot;
              MOV       DPTR, #RX_Buffer_Int+7
              MOV       A, Slot
              MOVX      @DPTR, A

;                    RX_Buffer_Int.GatewayAddress           := $FF;
              INC       DPTR
              MOV       A, #$FF
              MOVX      @DPTR, A

;                    RX_Buffer_Int.CommandFlags             := [];
              CLR       A
              MOV       DPTR, #RX_Buffer_Int+10
              MOVX      @DPTR, A

;                    RX_Buffer_Int.Spare                    := 0;
              INC       DPTR
              MOVX      @DPTR, A

; 
;                    WDTCN := $A5;
              MOV       $FF, #$A5

;                    DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, A
              MOV       R2, A

;                    Repeat
L_1A93:
;                    until not Sending_Ext and ((RX_Counter_Ext = 0) or (DelayTimer = 0));
              JB        Sending_Ext, L_1A93
              MOV       A, RX_Counter_Ext
              JZ        L_1A9F
              MOV       A, R2
              ORL       A, #LOW  ($0014)
              JNZ       L_1A93
L_1A9F:

;                    Move (RX_Buffer_Int, TX_Buffer_Ext, RX_Buffer_Int.PacketSize);      { Forward from remote module to local module }
              MOV       DPTR, #RX_Buffer_Int+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       R2, #LOW  (TX_Buffer_Ext)
              MOV       R3, #HIGH (TX_Buffer_Ext)
              MOV       DPTR, #RX_Buffer_Int
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                    ActiveBuffer_Ext := True;
              SETB      ActiveBuffer_Ext

;                    SendPacket;
              LCALL     SendPacket

;                  end;
L_1AB5:
;   end;
; 
;   CommandReceived_Int := False;
              CLR       CommandReceived_Int

; end;
              RET

; 
; Procedure ProcessCommands_Ext;

ProcessCommands_Ext:
; begin
;   If not CommandReceived_Ext then Exit;
              JB        CommandReceived_Ext, L_1ABC
              RET
L_1ABC:

; 
;   Case Local of
;     True: begin                                                { LOCAL }
              JNB       Local, L_1B14

;             If Master then                                     { Forward packet from remote module to local module }
              JNB       Master, L_1B12

;               begin
;                 WDTCN := $A5;
              MOV       $FF, #$A5

;                 DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)

;                 Repeat
L_1ACB:
;                 until not Sending_Int;
              JB        Sending_Int, L_1ACB

;                 Move (RX_Buffer_Ext, TX_Buffer_Int, RX_Buffer_Ext.PacketSize);
              MOV       DPTR, #RX_Buffer_Ext+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       R2, #LOW  (TX_Buffer_Int)
              MOV       R3, #HIGH (TX_Buffer_Int)
              MOV       DPTR, #RX_Buffer_Ext
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                 TX_Buffer_Int.GatewayAddress := Slot;                                      { Local FOM3000 is gateway }
              MOV       DPTR, #TX_Buffer_Int+8
              MOV       A, Slot
              MOVX      @DPTR, A

;                 For TempByte := 1 to 16 do
              MOV       TempByte, #0
              MOV       R6, #$10
L_1AEA:
              INC       TempByte

;                   If RemoteSlots [TempByte] = TX_Buffer_Int.SourceAddress then
              MOV       A, TempByte
              ADD       A, #RemoteSlots-1
              MOV       R0, A
              MOV       DPTR, #TX_Buffer_Int+5
              MOVX      A, @DPTR
              XRL       A, @R0
              JNZ       L_1B0D

;                     begin
;                       TX_Buffer_Int.OriginalAddress := TX_Buffer_Int.SourceAddress;
              MOVX      A, @DPTR
              MOV       DPTR, #TX_Buffer_Int+7
              MOVX      @DPTR, A

;                       TX_Buffer_Int.SourceAddress := $80 or (TempByte - 1);                { Translate address back }
              MOV       A, TempByte
              DEC       A
              ORL       A, #$80
              MOV       DPTR, #TX_Buffer_Int+5
              MOVX      @DPTR, A

;                       ActiveBuffer_Ext := False;
              CLR       ActiveBuffer_Ext

;                       SendPacket;
              LCALL     SendPacket

;                       TempByte := 16;                                                      { Break }
              MOV       TempByte, R6

;                     end;
L_1B0D:
              MOV       A, TempByte
              CJNE      A, #$10, L_1AEA

;               end;
L_1B12:
;           end;
              SJMP      L_1B60
L_1B14:

;     else  begin                                                                            { REMOTE }
;             If (RX_Buffer_Ext.DestinationAddress = BroadcastAddress) and (RX_Buffer_Ext.Command = Cmd_ModuleData) then
              MOV       DPTR, #RX_Buffer_Ext+3
              MOVX      A, @DPTR
              CJNE      A, #$7F, L_1B2F
              MOV       DPTR, #RX_Buffer_Ext+9
              MOVX      A, @DPTR
              JNZ       L_1B2F

;               begin
;                 BroadcastReplyTimer_Ext := AdditionalReplyTimeForRemoteLinkModule + BroadcastReplyTime_Int; { It was already delayed for local modules }
              MOV       A, BroadcastReplyTime_Int
              ADD       A, #LOW  (7)
              MOV       BroadcastReplyTimer_Ext, A
              MOV       A, BroadcastReplyTime_Int+1
              ADDC      A, #HIGH (7)
              MOV       BroadcastReplyTimer_Ext+1, A

;                 DelayPacketToExt := True;
              SETB      DelayPacketToExt

;               end;
L_1B2F:
;             If (RX_Buffer_Ext.DestinationAddress <> Transport_Address) and
;               ((RX_Buffer_Ext.DestinationAddress <> Slot) or (RX_Buffer_Ext.DestinationAddress = BroadcastAddress)) then
              MOV       DPTR, #RX_Buffer_Ext+3
              MOVX      A, @DPTR
              XRL       A, #$7B
              JZ        L_1B60
              MOVX      A, @DPTR
              CJNE      A, Slot, L_1B3E
              CJNE      A, #$7F, L_1B60
L_1B3E:

;               begin                                                                        { Forward to other remote modules }
;                 WDTCN := $A5;
              MOV       $FF, #$A5

;                 DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)

;                 Repeat
L_1B47:
;                 until not Sending_Int;
              JB        Sending_Int, L_1B47

;                 Move (RX_Buffer_Ext, TX_Buffer_Int, RX_Buffer_Ext.PacketSize);
              MOV       DPTR, #RX_Buffer_Ext+1
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       R2, #LOW  (TX_Buffer_Int)
              MOV       R3, #HIGH (TX_Buffer_Int)
              MOV       DPTR, #RX_Buffer_Ext
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                 ActiveBuffer_Ext := False;
              CLR       ActiveBuffer_Ext

;                 SendPacket;
              LCALL     SendPacket

;               end;
;           end;
L_1B60:
;   end;
;   If (RX_Buffer_Ext.DestinationAddress = Slot) or
;      (RX_Buffer_Ext.DestinationAddress = BroadcastAddress) or
;      (RX_Buffer_Ext.DestinationAddress = Transport_Address) then
              MOV       DPTR, #RX_Buffer_Ext+3
              MOVX      A, @DPTR
              XRL       A, Slot
              JZ        L_1B71
              MOVX      A, @DPTR
              XRL       A, #$7F
              JZ        L_1B71
              MOVX      A, @DPTR
              CJNE      A, #$7B, L_1B76
L_1B71:

;     ProcessCommands (sExternal);
              CLR       Source
              LCALL     ProcessCommands
L_1B76:

;   DelayPacketToExt := False;
              CLR       DelayPacketToExt

; 
;   CommandReceived_Ext := False;
              CLR       CommandReceived_Ext

; end;
              RET

; 
; Procedure SetTxBufferForLoopTestMessage;

SetTxBufferForLoopTestMessage:
; begin
;   WDTCN := $A5;
              MOV       $FF, #$A5

;   DelayTimer := CommRxEndWaitTime;
              MOV       DelayTimer, #LOW  ($0014)
              MOV       DelayTimer+1, #HIGH ($0014)

;   Repeat
L_1B84:
;   until not Sending_Ext;
              JB        Sending_Ext, L_1B84

;   PTX_Buffer := Addr (TX_Buffer_Ext);
              MOV       PTX_Buffer, #LOW  (TX_Buffer_Ext)
              MOV       PTX_Buffer+1, #HIGH (TX_Buffer_Ext)

;   ActiveBuffer_Ext := True;
              SETB      ActiveBuffer_Ext

;   TX_Buffer_Ext.PacketSize               := PacketHeaderSize;
              MOV       DPTR, #TX_Buffer_Ext+1
              MOV       A, #$0C
              MOVX      @DPTR, A

;   TX_Buffer_Ext.SourceAddress_Frame      := InterFrameAddress;
              CLR       A
              MOV       DPTR, #TX_Buffer_Ext+6
              MOVX      @DPTR, A

;   TX_Buffer_Ext.SourceAddress            := Slot;
              MOV       DPTR, #TX_Buffer_Ext+5
              MOV       A, Slot
              MOVX      @DPTR, A

;   TX_Buffer_Ext.DestinationAddress       := BroadcastAddress;
              MOV       DPTR, #TX_Buffer_Ext+3
              MOV       A, #$7F
              MOVX      @DPTR, A

;   TX_Buffer_Ext.DestinationAddress_Frame := InterFrameAddress;
              CLR       A
              INC       DPTR
              MOVX      @DPTR, A

;   TX_Buffer_Ext.OriginalAddress          := Slot;
              MOV       DPTR, #TX_Buffer_Ext+7
              MOV       A, Slot
              MOVX      @DPTR, A

;   TX_Buffer_Ext.GatewayAddress           := $FF;
              INC       DPTR
              MOV       A, #$FF
              MOVX      @DPTR, A

;   TX_Buffer_Ext.Command                  := Cmd_Message;
              INC       DPTR
              MOV       A, #8
              MOVX      @DPTR, A

;   TX_Buffer_Ext.CommandFlags             := [cfLoopTest];
              INC       DPTR
              MOV       A, #1
              MOVX      @DPTR, A

;   TX_Buffer_Ext.Spare                    := 0;
              CLR       A
              INC       DPTR
              MOVX      @DPTR, A

; end;
              RET

; 
; Procedure SetLinkLed;

SetLinkLed:
; begin
;   Case ExtCommunicationTimer <> 0 of
              MOV       A, ExtCommunicationTimer

;     True: Case Local xor OtherModuleLocal of
              JZ        L_1BD9
              MOV       C, OtherModuleLocal
              CLR       A
              RLC       A
              MOV       R1, A
              MOV       C, Local
              CLR       A
              RLC       A
              XRL       A, R1

;             True: Led_VideoLink := Led_ON;                        { Different modules (local/remote) on each side }
              JZ        L_1BD2
              CLR       $24.1
              RET
L_1BD2:

;             else  Led_VideoLink := Hi (BlinkTimer) and $04 <> 0;  { Same modules (local/remote) on each side }
              MOV       A, BlinkTimer+1
              MOV       C, ACC.2
              MOV       $24.1, C
              RET
L_1BD9:

;           end;
;     else  Led_VideoLink := Blink;
              MOV       C, Blink
              MOV       $24.1, C

;   end;
; end;
              RET


CSEG AT $0000

              LJMP     Example7


RSEG _CODE

Example7:
; 
; begin
              MOV       SP, #StackStart-1
              LCALL     C51F020
              LCALL     E24C32

;   Init;
              LCALL     Init

;   Repeat
L_1BEA:
; 
;     Case ErrorCode of
; {$IFDEF DPS900 }
; {$ELSE}
;       ecTEA6415: Led_Error := Blink;
; {$ENDIF}
;       ecEEPROM:  Led_Error := Led_ON;
              MOV       A, ErrorCode
              CJNE      A, #3, L_1BF3
              CLR       $24.0
              SJMP      L_1BFA
L_1BF3:

;       else begin
;              Led_Error := ErrorLedTimer = 0;
              MOV       A, ErrorLedTimer
              ADD       A, #$FF
              CPL       C
              MOV       $24.0, C

;            end;
L_1BFA:
;     end;
;     WDTCN := $A5;
              MOV       $FF, #$A5

;     WriteScreen;
              LCALL     WriteScreen

;     Overlay (OSD_SYD);
              MOV       C, P2.4
              MOV       OverlayOn, C
              LCALL     Overlay

; 
;     WDTCN := $A5;
              MOV       $FF, #$A5

;     Case TestMode of
;       False: begin
              JNB       TestMode, L_1C10
              LJMP      L_1E49
L_1C10:

;                ProcessCommands_Int;
              LCALL     ProcessCommands_Int

;                WDTCN := $A5;
              MOV       $FF, #$A5

;                ProcessCommands_Ext;
              LCALL     ProcessCommands_Ext

;                WDTCN := $A5;
              MOV       $FF, #$A5

; 
;                Case Blink of
;                  True: begin
              JNB       Blink, L_1C40

;                          Case P0.5 of
;                            True: If I_DET_Counter <> 0 then Dec (I_DET_Counter);  { inactive }
              JNB       P0.5, L_1C2A
              MOV       A, I_DET_Counter
              JZ        L_1C28
              DEC       I_DET_Counter
L_1C28:
              SJMP      L_1C32
L_1C2A:

;                            else  If I_DET_Counter < FilterConstant then Inc (I_DET_Counter);  { active }
              MOV       A, I_DET_Counter
              ADD       A, #-100
              JC        L_1C32
              INC       I_DET_Counter
L_1C32:

;                          end;
;                          I_DET_Active := I_DET_Counter > FilterConstant div 2;
              MOV       A, I_DET_Counter
              ADD       A, #-51
              MOV       I_DET_Active, C

; 
;                          A0 := False;               { Switch to U_DET }
              CLR       P3.2

;                          A1 := True;
              SETB      P3.3

;                          A2 := False;
              CLR       P3.4

;                        end;
              SJMP      L_1C5F
L_1C40:

;                  else
;                          Case P0.5 of
;                            True: If U_DET_Counter <> 0 then Dec (U_DET_Counter);  { inactive }
              JNB       P0.5, L_1C4B
              MOV       A, U_DET_Counter
              JZ        L_1C49
              DEC       U_DET_Counter
L_1C49:
              SJMP      L_1C53
L_1C4B:

;                            else  If U_DET_Counter < FilterConstant then Inc (U_DET_Counter);  { active }
              MOV       A, U_DET_Counter
              ADD       A, #-100
              JC        L_1C53
              INC       U_DET_Counter
L_1C53:

;                          end;
;                          U_DET_Active := U_DET_Counter > FilterConstant div 2;
              MOV       A, U_DET_Counter
              ADD       A, #-51
              MOV       U_DET_Active, C

; 
;                          A0 := True;                { Switch to I_DET }
              SETB      P3.2

;                          A1 := True;
              SETB      P3.3

;                          A2 := False;
              CLR       P3.4
L_1C5F:

;                end;
; 
;                Case RemoteLink of
;                  True: If RemoteLinkCounter <> 0 then Dec (RemoteLinkCounter);  { inactive }
              JNB       P3.7, L_1C6A
              MOV       A, RemoteLinkCounter
              JZ        L_1C68
              DEC       RemoteLinkCounter
L_1C68:
              SJMP      L_1C72
L_1C6A:

;                  else  If RemoteLinkCounter < FilterConstant then Inc (RemoteLinkCounter);  { active }
              MOV       A, RemoteLinkCounter
              ADD       A, #-100
              JC        L_1C72
              INC       RemoteLinkCounter
L_1C72:

;                end;
;                RemoteLinkActive := RemoteLinkCounter > FilterConstant div 2;
              MOV       A, RemoteLinkCounter
              ADD       A, #-51
              MOV       RemoteLinkActive, C

; 
;                Led_PowerSupply_I := not I_DET_Active and Blink;
              JB        I_DET_Active, L_1C7E
              JB        Blink, L_1C82
L_1C7E:
              CLR       P3.0
              SJMP      L_1C84
L_1C82:
              SETB      P3.0
L_1C84:

;                Led_PowerSupply_U := not U_DET_Active and Blink;
              JB        U_DET_Active, L_1C8A
              JB        Blink, L_1C8E
L_1C8A:
              CLR       P3.1
              SJMP      L_1C90
L_1C8E:
              SETB      P3.1
L_1C90:

; 
;                Case Key_Enter of
;                  False: Led_VideoLink := not OSD_SYD and Blink;
              JB        $25.0, L_1CA1
              JB        P2.4, L_1C99
              JB        Blink, L_1C9D
L_1C99:
              CLR       $24.1
              SJMP      L_1CA4
L_1C9D:
              SETB      $24.1
              SJMP      L_1CA4
L_1CA1:

;                  else SetLinkLed;
              LCALL     SetLinkLed
L_1CA4:

;                end;
;                Case Local of                          {  REMOTE  }
; 
;                  False: begin                         { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }
              JNB       Local, L_1CAA
              LJMP      L_1D70
L_1CAA:

;                           Case Key_Up of              { vOut_VideoOut, vOut_OSD_In, vOut_ExtSyncOut, vOut_IO, vOut_VideoOut_BUS, vOut_Optic_TX  }
;                             False: begin
              JB        $25.2, L_1CBA

;                                      VideoXPoint [vOut_VideoOut_BUS]  := vIn_OSD_Out;    { Local test on reomote side }
              MOV       DPTR, #VideoXPoint+4
              MOV       A, #1
              MOVX      @DPTR, A

;                                      VideoXPoint [vOut_VideoOut]      := vIn_OSD_Out;    { Local test on reomote side }
              MOV       DPTR, #VideoXPoint+3
              MOVX      @DPTR, A

;                                    end;
              LJMP      L_1D6E
L_1CBA:

;                             else begin
;                                    VideoXPoint [vOut_VideoOut_BUS] := vIn_NC;
              MOV       DPTR, #VideoXPoint+4
              MOV       A, #6
              MOVX      @DPTR, A

;                                    VideoXPoint [vOut_VideoOut]     := vIn_Optic_RX;
              MOV       DPTR, #VideoXPoint+3
              DEC       A
              MOVX      @DPTR, A

;                                    Case Key_Down of
;                                      False: begin
              JNB       $25.1, L_1CCB
              LJMP      L_1D4A
L_1CCB:

;                                             If LoopTestTimer < 50 then                      { Repeat loop test broadcast }
              MOV       A, LoopTestTimer
              ADD       A, #LOW  (-50)
              MOV       A, LoopTestTimer+1
              ADDC      A, #HIGH (-50)
              JC        L_1CF1

;                                               begin
;                                                 SetTxBufferForLoopTestMessage;
              LCALL     SetTxBufferForLoopTestMessage

;                                                 PTX_Buffer_Cmd_Message^.msByte0 := 1;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, #1
              MOVX      @DPTR, A

;                                                 SendPacket;
              LCALL     SendPacket

;                                                 LoopTestTimer := LoopTestTime;
              MOV       LoopTestTimer, #LOW  ($1388)
              MOV       LoopTestTimer+1, #HIGH ($1388)

;                                               end else begin                                { Test communications }
              SJMP      L_1D48
L_1CF1:

;                                                          Case SlowBlinkTimer and $01 <> 0 of
              MOV       A, SlowBlinkTimer

;                                                            False: CommTestSent := False;
              JB        ACC.0, L_1CFA
              CLR       CommTestSent
              SJMP      L_1D48
L_1CFA:

;                                                            else If not CommTestSent and not Sending_Ext then
              JB        CommTestSent, L_1D48
              JB        Sending_Ext, L_1D48

;                                                                   begin
;                                                                     TX_Buffer_Ext.PacketSize               := DefaultPacketSize;
              MOV       DPTR, #TX_Buffer_Ext+1
              MOV       A, #$2C
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.SourceAddress            := Slot;
              MOV       DPTR, #TX_Buffer_Ext+5
              MOV       A, Slot
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.SourceAddress_Frame      := InterFrameAddress;
              CLR       A
              INC       DPTR
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.DestinationAddress       := COM_ModuleAddress;
              MOV       DPTR, #TX_Buffer_Ext+3
              MOV       A, #$10
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.DestinationAddress_Frame := InterFrameAddress;
              CLR       A
              INC       DPTR
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.OriginalAddress          := Slot;
              MOV       DPTR, #TX_Buffer_Ext+7
              MOV       A, Slot
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.GatewayAddress           := $FF;
              INC       DPTR
              MOV       A, #$FF
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.Command                  := Cmd_Message;
              INC       DPTR
              MOV       A, #8
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.CommandFlags             := [cfCommTest];
              INC       DPTR
              MOV       A, #2
              MOVX      @DPTR, A

;                                                                     TX_Buffer_Ext.Spare                    := 0;
              CLR       A
              INC       DPTR
              MOVX      @DPTR, A

;                                                                     PTX_Buffer := @TX_Buffer_Ext;
              MOV       PTX_Buffer, #LOW  (TX_Buffer_Ext)
              MOV       PTX_Buffer+1, #HIGH (TX_Buffer_Ext)

;                                                                     PTX_Buffer_Cmd_Message^.msByte0        := 1;             { Reply }
              MOV       DPL, #LOW  (TX_Buffer_Ext)
              MOV       DPH, #HIGH (TX_Buffer_Ext)
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              MOV       A, #1
              MOVX      @DPTR, A

;                                                                     ActiveBuffer_Ext := True;
              SETB      ActiveBuffer_Ext

;                                                                     SendPacket;
              LCALL     SendPacket

;                                                                     CommTestSent := True;
              SETB      CommTestSent

;                                                                   end;
;                                                          end;
;                                                        end;
L_1D48:
;                                           end;
              SJMP      L_1D6E
L_1D4A:

;                                      else begin
;                                             If LoopTestTimer <> 0 then
              MOV       A, LoopTestTimer+1
              ORL       A, LoopTestTimer
              JZ        L_1D6E

;                                               begin
;                                                 LoopTestTimer := 0;
              CLR       A
              MOV       LoopTestTimer, A
              MOV       LoopTestTimer+1, A

;                                                 SetTxBufferForLoopTestMessage;
              LCALL     SetTxBufferForLoopTestMessage

;                                                 PTX_Buffer_Cmd_Message^.msByte0 := 0;
              MOV       DPL, PTX_Buffer
              MOV       DPH, PTX_Buffer+1
              MOV       A, #12
              LCALL     sysADD_DPTR_A
              CLR       A
              MOVX      @DPTR, A

;                                                 SendPacket;
              LCALL     SendPacket

;                                                 SendPacketWithDelay (TxBlockDelay);
              MOV       BlockDelay, #$0D
              LCALL     SendPacketWithDelay

;                                               end;
;                                           end;
;                                    end;
;                                  end;
L_1D6E:
;                           end;
;                         end;
              SJMP      L_1D97
L_1D70:

;                  else
;                                                       { LOCAL }
;                         begin
;                           Case LoopTestTimer of
              MOV       R3, LoopTestTimer+1

;                             0:   VideoXPoint [vOut_Optic_TX] := vIn_OSD_Out;                    { 26.11.2005 }
              MOV       A, LoopTestTimer
              JNZ       L_1D80
              CJNE      R3, #0, L_1D80
              MOV       DPTR, #VideoXPoint
              INC       A
              MOVX      @DPTR, A
              SJMP      L_1D86
L_1D80:

;                             else VideoXPoint [vOut_Optic_TX] := vIn_Optic_RX;                   { Send video from remote over local back to remote side }
              MOV       DPTR, #VideoXPoint
              MOV       A, #5
              MOVX      @DPTR, A
L_1D86:

;                           end;
;                           Case Key_Up of              { vOut_VideoOut, vOut_OSD_In, vOut_ExtSyncOut, vOut_IO, vOut_VideoOut_BUS, vOut_Optic_TX  }
;                             False: VideoXPoint [vOut_VideoOut] := vIn_OSD_Out;    { Local test on local side }
              JB        $25.2, L_1D91
              MOV       DPTR, #VideoXPoint+3
              MOV       A, #1
              MOVX      @DPTR, A
              SJMP      L_1D97
L_1D91:

;                             else   VideoXPoint [vOut_VideoOut] := vIn_Optic_RX;
              MOV       DPTR, #VideoXPoint+3
              MOV       A, #5
              MOVX      @DPTR, A

;                           end;
;                         end;
L_1D97:
;                end;
;                WDTCN := $A5;
              MOV       $FF, #$A5

; 
;                If ExtCommunicationTimer = 0 then      { 26.11.2005 }
              MOV       A, ExtCommunicationTimer
              JNZ       L_1DA3

;                  begin
;                   VideoXPoint [vOut_VideoOut] := vIn_OSD_Out;
              MOV       DPTR, #VideoXPoint+3
              INC       A
              MOVX      @DPTR, A

;                  end;
L_1DA3:
; 
;                SetVideoXPoints;
              LCALL     SetVideoXPoints

;                If (DelayedTXCounter_Int <> 0) and (BroadcastReplyTimer_Int = 0) then
              MOV       R0, #DelayedTXCounter_Int
              MOV       A, @R0
              JZ        L_1DF5
              MOV       A, BroadcastReplyTimer_Int+1
              ORL       A, BroadcastReplyTimer_Int
              JNZ       L_1DF5

;                  begin
;                    TempByte := 0;
              MOV       TempByte, A
              MOV       R6, #$A5
              MOV       R7, #92

;                    Repeat
L_1DB7:
;                      WDTCN := $A5;
              MOV       $FF, R6

;                      Repeat
L_1DB9:
;                      until not Sending_Int;
              JB        Sending_Int, L_1DB9

;                      Inc (TempByte);
              INC       TempByte

;                      Move (TX_Buffer_Delayed_Int [TempByte], TX_Buffer_Int, TX_Buffer_Delayed_Int [TempByte].PacketSize);
              MOV       A, TempByte
              MOV       B, R7
              MUL       AB
              ADD       A, #LOW  (TX_Buffer_Delayed_Int-92)
              MOV       DPL, A
              MOV       A, B
              ADDC      A, #HIGH (TX_Buffer_Delayed_Int-92)
              MOV       DPH, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       A, TempByte
              MOV       B, R7
              MUL       AB
              ADD       A, #LOW  (TX_Buffer_Delayed_Int-92)
              MOV       DPL, A
              MOV       A, B
              ADDC      A, #HIGH (TX_Buffer_Delayed_Int-92)
              MOV       DPH, A
              MOV       R2, #LOW  (TX_Buffer_Int)
              MOV       R3, #HIGH (TX_Buffer_Int)
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                      ActiveBuffer_Ext := False;
              CLR       ActiveBuffer_Ext

;                      SendPacket;
              LCALL     SendPacket

;                    until TempByte = DelayedTXCounter_Int;
              MOV       A, TempByte
              MOV       R0, #DelayedTXCounter_Int
              XRL       A, @R0
              JNZ       L_1DB7

;                    DelayedTXCounter_Int := 0;
              MOV       @R0, A

;                  end;
L_1DF5:
;                WDTCN := $A5;
              MOV       $FF, #$A5

;                If (DelayedTXCounter_Ext <> 0) and (BroadcastReplyTimer_Ext = 0) then
              MOV       R0, #DelayedTXCounter_Ext
              MOV       A, @R0
              JZ        L_1E47
              MOV       A, BroadcastReplyTimer_Ext+1
              ORL       A, BroadcastReplyTimer_Ext
              JNZ       L_1E47

;                  begin
;                    TempByte := 0;
              MOV       TempByte, A
              MOV       R6, #$A5
              MOV       R7, #92

;                    Repeat
L_1E09:
;                      WDTCN := $A5;
              MOV       $FF, R6

;                      Repeat
L_1E0B:
;                      until not Sending_Ext;
              JB        Sending_Ext, L_1E0B

;                      Inc (TempByte);
              INC       TempByte

;                      Move (TX_Buffer_Delayed_Ext [TempByte], TX_Buffer_Ext, TX_Buffer_Delayed_Ext [TempByte].PacketSize);
              MOV       A, TempByte
              MOV       B, R7
              MUL       AB
              ADD       A, #LOW  (TX_Buffer_Delayed_Ext-92)
              MOV       DPL, A
              MOV       A, B
              ADDC      A, #HIGH (TX_Buffer_Delayed_Ext-92)
              MOV       DPH, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       R5, #0
              MOV       A, TempByte
              MOV       B, R7
              MUL       AB
              ADD       A, #LOW  (TX_Buffer_Delayed_Ext-92)
              MOV       DPL, A
              MOV       A, B
              ADDC      A, #HIGH (TX_Buffer_Delayed_Ext-92)
              MOV       DPH, A
              MOV       R2, #LOW  (TX_Buffer_Ext)
              MOV       R3, #HIGH (TX_Buffer_Ext)
              LCALL     sysCopyFrom_XDATA_To_XDATA

;                      ActiveBuffer_Ext := True;
              SETB      ActiveBuffer_Ext

;                      SendPacket;
              LCALL     SendPacket

;                    until TempByte = DelayedTXCounter_Ext;
              MOV       A, TempByte
              MOV       R0, #DelayedTXCounter_Ext
              XRL       A, @R0
              JNZ       L_1E09

;                    DelayedTXCounter_Ext := 0;
              MOV       @R0, A

;                  end;
L_1E47:
;              end;
              SJMP      L_1E52
L_1E49:

;       else begin
;              WDTCN := $A5;
;              SetLinkLed;
              LCALL     SetLinkLed

;              ProcessTestKey;
              LCALL     ProcessTestKey

;              SetTestXPoints;
              LCALL     SetTestXPoints

;            end;
L_1E52:
;     end;
;     WDTCN := $A5;
              MOV       $FF, #$A5

;   until False;
              LJMP      L_1BEA

; end.

RSEG _CONST


              END

