{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

{$DEFINE DPS900 }

{$M 0, $10000, $0000, $1000, 0}

Program Example7;

Uses  C51F020,
      TEA6415,
      E24C32,
      KS5520;

{$I CommonData.inc }

Const VersionHi = 0;
      VersionLo = 10;

      SamplesPerPeriod_1kHz   =  8;
      SamplesPerPeriod_100Hz  = 80;

      Sinus_100Hz: Array [0..SamplesPerPeriod_100Hz - 1] of Byte = ({$I Sin100Hz.inc });
      Sinus_1kHz:  Array [0..SamplesPerPeriod_1kHz - 1] of Byte = ({$I Sin_1kHz.inc });

      SignatureLength = 7;

      KeepAliveByte   = $00;
      LocalRemoteFlag = $80;

      STX             = $02;
      ETX             = $03;
      ACK             = $06;

      SignatureOffset = $0010;

      EEPROM_Size    = $1000;
      MaxPacketSize  = PacketHeaderSize + 90;

      EmptyLine30 = '                              ';
      EmptyLine15 = '               ';

{$IFDEF DPS900 }
  {$DEFINE BaudRateExt_19200  }
{$ELSE}
  {$DEFINE BaudRateExt_172800  }
{$ENDIF}


      Const1ms                 = Word (- 22118400 div 12 div 1000);
      BaudRateTimerValue       = Byte (- 22118400 div 12 div 32 div 19200);
      ConversionClock          = Byte ((22118 div 2500) shl 3); { for 2.5 MHz }
      DAC_SampleRateTimerValue = Word (- (22118400 div 8000));


  {$IFDEF BaudRateExt_19200 }
      BaudRateTimerValue1 = Word (- 22118400 div 32 div 19200);
  {$ENDIF}
  {$IFDEF BaudRateExt_38400 }
      BaudRateTimerValue1 = Word (- 22118400 div 32 div 38400);
  {$ENDIF}
  {$IFDEF BaudRateExt_76800 }
      BaudRateTimerValue1 = Word (- 22118400 div 32 div 76800);
  {$ENDIF}
  {$IFDEF BaudRateExt_115200 }
      BaudRateTimerValue1 = Word (- 22118400 div 32 div 115200);
  {$ENDIF}
  {$IFDEF BaudRateExt_172800 }
      BaudRateTimerValue1 = Word (- 22118400 div 32 div 172800);
  {$ENDIF}

      DefaultModeFlags = 0;

      AdditionalReplyTimeForRemoteLinkModule =     7;       { Time needed to transmit broadcast to other remote modules }
      ExtCommunicationTime                   =   250;       { Max time before ext comm confirmation }
      RS485_Time                             =     1;
      RS485_Time_External                    = RS485_Time + 20; { Max time before switch from ext comm to int comm }
      LedTime                                =    30;
      LedTimeExt                             =    10;
      TxBlockDelay                           =    13;
      CommRxEndWaitTime                      =    20;

      FilterConstant = 100;

      Led_OFF   = True;
      Led_ON    = False;
      sInternal = True;
      sExternal = False;

                              { pin5, pin8, pin3, pin20, pin6, pin10, pin1, pin11 }
      PinToInput: Array [TInputPin] of Byte = (3, 5, 2, 8, 4, 6, 1, 7);

      vIn_NC             = pin1;
      vIn_COM_Out        = pin3;    { A22 }
      vIn_NC2            = pin5;    { NC, reserve }
      vIn_IO             = pin6;
      vIn_OSD_Out        = pin8;
      vIn_Optic_RX       = pin10;
      vIn_VideoIn        = pin11;
      vIn_Spare          = pin20;   { Spare, AUX video }

      vOut_VideoOut_BUS  = pin13;
      vOut_OSD_In        = pin14;
      vOut_VideoOut      = pin17;   { REMOTE: ext. sync out, LOCAL: video out  }
      vOut_IO            = pin16;
      vOut_ExtSyncOut    = pin15;
      vOut_Optic_TX      = pin18;


Type TSignature = Array [0..SignatureLength - 1] of Char;

     TPacketType = (ptTurbo, ptPanasonic);

     TErrorCode = (ecNone, ecTEA6415, ecTDA8425, ecEEPROM);

     TBufferArray = Array [0..MaxPacketSize - 1] of Byte;

     PExtendedGeneralPacket = ^TExtendedGeneralPacket XDATA;

     TEEPROM_Data = Record
                      eeSignature:          TSignature;
                      eeSerialNumber:       TSerialNumber;
                      eeComment:            TComment;
                      eeSourceName:         TSourceName;
                      eeMiscFlags:          Byte;
                      eeSourceDescription:  TSourceDescription;
                      eeModeFlags:          Byte;
                      eeRemoteSlots:        TRemoteSlots;
                      eeProtocols:          TProtocolsSet;
                      eeEND:                Byte;
                    end;

Var   Int_RS485_TX:            Boolean absolute P3.6;
      Ext_RS485_TX:            Boolean absolute P0.7;
      Ext_RS485_TX_Int:        Boolean absolute P0.6;
      A0:                      Boolean absolute P3.2;
      A1:                      Boolean absolute P3.3;
      A2:                      Boolean absolute P3.4;
      RemoteLink:              Boolean absolute P3.7;

      Led_PowerSupply_U:       Boolean absolute P3.1;
      Led_PowerSupply_I:       Boolean absolute P3.0;

      KS5520.OSD_SCK:          Boolean absolute P2.7;
      KS5520.OSD_SIN:          Boolean absolute P2.5;
      KS5520.OSD_CSB:          Boolean absolute P2.6;
      OSD_SYD:                 Boolean absolute P2.4;
      I_DET:                   Boolean absolute P1.7;
      U_DET:                   Boolean absolute P1.6;


      LOCK:                    Boolean absolute P3.5;

      KeysAndSlotPort:         Byte absolute P4;
      LedsAndLatchPort:        Byte absolute P5;

      EEPROM_Data:             TEEPROM_Data XDATA absolute 0;

      Leds:                    Byte DATA;      { $24: $20..$27 }
      KeysAndSlot:             Byte DATA;
      IOData:                  Byte DATA;

      Led_Error:               Boolean absolute $24.0;
      Led_VideoLink:           Boolean absolute $24.1;
      Led_TX_Int:              Boolean absolute $22;
      Led_RX_Int:              Boolean absolute $23;
      Led_TX_Ext:              Boolean absolute $24;
      Led_RX_Ext:              Boolean absolute $25;

      Key_Enter:               Boolean absolute $28;
      Key_Down:                Boolean absolute $29;
      Key_Up:                  Boolean absolute $2A;
      SlotBit0:                Boolean absolute $2C;
      SlotBit1:                Boolean absolute $2D;
      SlotBit2:                Boolean absolute $2E;
      SlotBit3:                Boolean absolute $2F;

      DO4:                     Boolean absolute $30;
      DO3:                     Boolean absolute $31;
      DO2:                     Boolean absolute $32;
      DO1:                     Boolean absolute $33;
      Tipka1:                  Boolean absolute $34;
      Tipka2:                  Boolean absolute $35;
      Tipka3:                  Boolean absolute $36;
      Tipka4:                  Boolean absolute $37;

      TempByte:                Byte;
      Counter:                 Byte;
      Slot:                    Byte;
      ErrorLedTimer:           Byte;
      RX_Int_LedTimer:         Byte;
      RX_Ext_LedTimer:         Byte;
      TX_Int_LedTimer:         Byte;
      TX_Ext_LedTimer:         Byte;
      BlinkTimer:              Word;
      ExtCommunicationTimer:   Byte;
      ExtCommKeepAliveCounter: Byte;
      SlowBlinkTimer:          Byte;
      RS485_Timer:             Byte;
      RS485_Timer_External:    Byte;
      TX_Counter_Int:          Byte;
      TX_Counter_Ext:          Byte;
      RX_Counter_Int:          Byte;
      RX_Counter_Ext:          Byte;
      RX_Checksum_Int:         Byte;
      RX_Checksum_Ext:         Byte;
      TestMode:                Boolean;
      KeyPressed:              Boolean;
      TempBoolean:             Boolean;
      Last_I_DET:              Boolean;
      Last_U_DET:              Boolean;
      I_DET_Active:            Boolean;
      U_DET_Active:            Boolean;
      RemoteLinkCounter:       Byte;
      RemoteLinkActive:        Boolean;
      I_DET_Counter:           Byte;
      U_DET_Counter:           Byte;
      IntCommActive:           Boolean;
      ExtCommActive:           Boolean;
      VideoInputPin:           TInputPin DATA;
      OSDVideoInputPin:        TInputPin DATA;
      Row:                     Byte;
      EqState:                 Byte;   { Must be DATA !!! }
      MiscFlags:               Byte;
      ModeFlags:               Byte;
      RemoteSlots:             TRemoteSlots IDATA;
      Int_PacketCounter:       Byte;
      Int_PacketOK_Counter:    Byte;
      Ext_PacketCounter:       Byte;
      Ext_PacketOK_Counter:    Byte;
      IntCommPacketTimer:      Word;
      ExtCommPacketTimer:      Word;
      BroadcastReplyTime_Int:  Word;
      BroadcastReplyTimer_Int: Word;
      BroadcastReplyTime_Ext:  Word;
      BroadcastReplyTimer_Ext: Word;
      DelayTimer:              Word;
      LoopTestTimer:           Word;
      Temperature_L:           Byte;
      Temperature_H:           Byte;
      Temperature:             Word absolute Temperature_L;
      Protocols:               TProtocolsSet IDATA;
      msCounter:               Word;

      ErrorCode:               TErrorCode;
      PacketType:              TPacketType;

      PTX_Buffer:                        ^TExtendedGeneralPacket   XDATA;
      PTX_Buffer_Cmd_ModuleData:         ^TCmd_ModuleData          XDATA absolute PTX_Buffer;
      PTX_Buffer_Cmd_SourceNameAndFlags: ^TCmd_SourceNameAndFlags  XDATA absolute PTX_Buffer;
      PTX_Buffer_Cmd_SourceDescription:  ^TCmd_SourceDescription   XDATA absolute PTX_Buffer;
      PTX_Buffer_Cmd_RemoteSlots:        ^TCmd_RemoteSlots         XDATA absolute PTX_Buffer;
      PTX_Buffer_Cmd_EEPROM:             ^TCmd_EEPROM              XDATA absolute PTX_Buffer;
      PTX_Buffer_Cmd_FrameData:          ^TCmd_FrameData           XDATA absolute PTX_Buffer;
      PTX_Buffer_Cmd_Message:            ^TCmd_Message             XDATA absolute PTX_Buffer;
      PTX_Buffer_Cmd_Protocols:          ^TCmd_Protocols           XDATA absolute PTX_Buffer;

      PRX_Buffer:                        ^TExtendedGeneralPacket   XDATA;
      PRX_Buffer_Cmd_ModuleData:         ^TCmd_ModuleData          XDATA absolute PRX_Buffer;
      PRX_Buffer_Cmd_SourceNameAndFlags: ^TCmd_SourceNameAndFlags  XDATA absolute PRX_Buffer;
      PRX_Buffer_Cmd_SourceDescription:  ^TCmd_SourceDescription   XDATA absolute PRX_Buffer;
      PRX_Buffer_Cmd_RemoteSlots:        ^TCmd_RemoteSlots         XDATA absolute PRX_Buffer;
      PRX_Buffer_Cmd_EEPROM:             ^TCmd_EEPROM              XDATA absolute PRX_Buffer;
      PRX_Buffer_Cmd_FrameData:          ^TCmd_FrameData           XDATA absolute PRX_Buffer;
      PRX_Buffer_Cmd_Message:            ^TCmd_Message             XDATA absolute PRX_Buffer;
      PRX_Buffer_Cmd_Protocols:          ^TCmd_Protocols           XDATA absolute PRX_Buffer;

      TX_Buffer_Int:                  TExtendedGeneralPacket XDATA;
      TX_BufferArray_Int:             TBufferArray absolute TX_Buffer_Int;
      RX_Buffer_Int:                  TExtendedGeneralPacket XDATA;
      RX_BufferArray_Int:             TBufferArray absolute RX_Buffer_Int;

      TX_Buffer_Ext:                  TExtendedGeneralPacket XDATA;
      TX_BufferArray_Ext:             TBufferArray absolute TX_Buffer_Ext;
      RX_Buffer_Ext:                  TExtendedGeneralPacket XDATA;
      RX_BufferArray_Ext:             TBufferArray absolute RX_Buffer_Ext;

      TX_Buffer_Delayed_Int:          Array [1..8] of TExtendedGeneralPacket XDATA;
      TX_Buffer_Delayed_Ext:          Array [1..8] of TExtendedGeneralPacket XDATA;

      DelayedTXCounter_Int:           Byte IDATA;
      DelayedTXCounter_Ext:           Byte IDATA;

      DAC_SampleCounter:              Byte;

      Blink:                          Boolean;
      Sending_Int:                    Boolean;
      Sending_Ext:                    Boolean;
      CommandReceived_Int:            Boolean;
      CommandReceived_Ext:            Boolean;
      Local:                          Boolean;
      Master:                         Boolean;
      KeyPulse:                       Boolean;
      ActiveBuffer_Ext:               Boolean;
      CommTestSent:                   Boolean;
      SendKeepAliveByte:              Boolean;
      ReadyForExternalCommunication:  Boolean;
      DelayPacketToExt:               Boolean;
      OtherModuleLocal:               Boolean;

      Current_ADC:                    Byte;
      Current_DAC:                    Byte;


Procedure _1ms; Interrupt Timer0; Using 1; { 1 ms interrupt }
Var LastTemperature: Word;
begin
  TL0 :=  Lo (Const1ms);
  TH0 :=  Hi (Const1ms);

  LedsAndLatchPort := Leds;
  KeysAndSlot      := KeysAndSlotPort;

  Inc (BlinkTimer);
  KeyPulse := Lo (BlinkTimer) and $7F = 0;
  Blink := Lo (BlinkTimer) and $80 <> 0;

  If ExtCommunicationTimer <> 0 then Dec (ExtCommunicationTimer)
    else begin
           Ext_PacketCounter := 0;
           Ext_PacketOK_Counter := 0;
           OtherModuleLocal := False;
         end;

  If msCounter <> 0 then Dec (msCounter) else
    begin
      msCounter := 1000;
      (*If not AD0BUSY then
        begin
          LastTemperature := Temperature;
          Temperature_L := ADC0L;
          Temperature_H := ADC0H;
          If LastTemperature <> 0 then Temperature := (Temperature + LastTemperature) div 2;    { Average }
          AD0BUSY := True;                         { Start ADC conversion }
        end;*)
    end;

  Last_I_DET := I_DET;
  Last_U_DET := U_DET;
  If Lo (BlinkTimer) = 0 then                           { 12 per Lo (BlinkTimer) = 0 }
    begin
      Dec (SlowBlinkTimer);
    end;

  If IntCommPacketTimer <> 0 then Dec (IntCommPacketTimer) else
    begin
      IntCommPacketTimer   := CommPacketTime;
      Int_PacketCounter    := Int_PacketCounter div 2;
      Int_PacketOK_Counter := Int_PacketOK_Counter div 2;
    end;
  If ExtCommPacketTimer <> 0 then Dec (ExtCommPacketTimer) else
    begin
      ExtCommPacketTimer   := ExtCommunicationTime;
      Ext_PacketCounter    := Ext_PacketCounter div 2;
      Ext_PacketOK_Counter := Ext_PacketOK_Counter div 2;
    end;
  IntCommActive := Int_PacketOK_Counter > 2;
  ExtCommActive := Ext_PacketOK_Counter > 2;

  If EEPROM_Timer <> 0 then Dec (EEPROM_Timer);
  If DelayTimer <> 0 then Dec (DelayTimer);
  If RS485_Timer <> 0 then Dec (RS485_Timer) else
    begin
      Int_RS485_TX := False;
      Ext_RS485_TX := False;
      Ext_RS485_TX_Int := False;
    end;
  If BroadcastReplyTimer_Int <> 0 then Dec (BroadcastReplyTimer_Int);
  If BroadcastReplyTimer_Ext <> 0 then Dec (BroadcastReplyTimer_Ext);
  If LoopTestTimer <> 0 then Dec (LoopTestTimer);

  If RX_Ext_LedTimer <> 0 then Dec (RX_Ext_LedTimer);

{$IFDEF DPS900 }
  Led_RX_Ext := not OSD_SYD;
{$ELSE}
  Led_RX_Ext := RX_Ext_LedTimer = 0;
{$ENDIF}

  If RX_Int_LedTimer <> 0 then Dec (RX_Int_LedTimer);
  Led_RX_Int := RX_Int_LedTimer = 0;

  If TX_Ext_LedTimer <> 0 then Dec (TX_Ext_LedTimer);
  Led_TX_Ext := TX_Ext_LedTimer = 0;

  If TX_Int_LedTimer <> 0 then Dec (TX_Int_LedTimer);
  Led_TX_Int := TX_Int_LedTimer = 0;

  If ErrorLedTimer <> 0 then Dec (ErrorLedTimer);
end;

Procedure Internal_RS485; Interrupt Serial; Using 2;   { Internal RS485 }
Var Ch_Int: Byte DATA;
begin
  If TI then
    begin
      TI := False;
      If TX_Counter_Int < TX_Buffer_Int.PacketSize then
        begin
          TX_Int_LedTimer := LedTime;
          RS485_Timer          := RS485_Time;
          RS485_Timer_External := RS485_Time_External;
          SBUF := TX_BufferArray_Int [TX_Counter_Int];
          Inc (TX_Counter_Int);
        end else begin
                   Ext_RS485_TX := False;
                   Int_RS485_TX := False;
                   Ext_RS485_TX_Int := False;
                   Sending_Int  := False;
                 end;
    end;
  If RI then
    begin
      RI := False;
      RX_Int_LedTimer := LedTime;
      If Sending_Int or CommandReceived_Int then Exit;
      Ch_Int := SBUF;

      Case RX_Counter_Int of
        0: Case Ch_Int of
             TurboStartByte: PacketType := ptTurbo;
             ACK,
             STX: Case Local of
                    False: PacketType := ptPanasonic;                           { Accept Panasonic protocol only on remote module }
                    else Exit;
                  end;
             else begin
                    ErrorLedTimer := 2;                                         { Trash }
                    Exit;
                  end;
           end;
        else
          Case PacketType of
            ptPanasonic: Case Ch_Int of
                           TurboStartByte: begin
                                              ErrorLedTimer := LedTime;
                                              PacketType := ptTurbo;
                                              RX_Counter_Int := 0;
                                              RX_Checksum_Int := 0;
                                            end;
                           else If (Ch_Int >= $80) or (RX_Counter_Int > 80) then
                                  begin
                                    RX_Counter_Int := 0;
                                    RX_Checksum_Int := 0;
                                    ErrorLedTimer := LedTime;
                                    Exit;
                                  end;
                         end;
          end;
      end;

      Case PacketType of
        ptTurbo: begin
                    If (RX_Counter_Int < PacketHeaderSize) or (RX_Buffer_Int.PacketSize <= MaxPacketSize) then
                      RX_BufferArray_Int [RX_Counter_Int] := Ch_Int;
                    RX_Checksum_Int := RX_Checksum_Int xor Ch_Int;
                    Inc (RX_Counter_Int);
                    If (RX_Counter_Int >= PacketHeaderSize) and (RX_Counter_Int = RX_Buffer_Int.PacketSize) then
                      begin
                        Inc (Int_PacketCounter);
                        If RX_Checksum_Int = 0 then
                          begin
                            Inc (Int_PacketOK_Counter);
                            If RX_Buffer_Int.PacketSize <= MaxPacketSize then
                              begin
                                If RX_Buffer_Int.DestinationAddress = BroadcastAddress then CommandReceived_Int := True else
                                  Case Local of
                                    True: Case RX_Buffer_Int.DestinationAddress of
                                            $80..$8F: If Master and (RemoteSlots [RX_Buffer_Int.DestinationAddress and $0F + 1] <> $FF) then
                                                        begin                                                                             { Over optics to remote }
                                                          RX_Buffer_Int.DestinationAddress := RemoteSlots [RX_Buffer_Int.DestinationAddress and $0F + 1] or $80;  { Translate }
                                                          CommandReceived_Int := True;
                                                        end;
                                            Transport_Address: CommandReceived_Int := True;             { Over this local module to remote module and to eq. }
                                            else  If RX_Buffer_Int.DestinationAddress = Slot then CommandReceived_Int := True;     { Over RS485 to this local module }
                                          end;
                                    else  If RX_Buffer_Int.DestinationAddress < $80 then CommandReceived_Int := True; { Over RS485 to this remote module or to local module}
                                  end;
                              end;
                          end else ErrorLedTimer := LedTime;
                        RX_Counter_Int := 0;
                        RX_Checksum_Int := 0;
                      end;
                  end;
        ptPanasonic: begin
                       If RX_Counter_Int <= MaxPacketSize - PacketHeaderSize then
                         RX_BufferArray_Int [RX_Counter_Int + PacketHeaderSize] := Ch_Int else
                           begin
                             RX_Counter_Int := 0;
                             RX_Checksum_Int := 0;
                             Exit;
                           end;
                       Inc (RX_Counter_Int);
                       If (Ch_Int = ETX) or (Ch_Int = ACK) then
                         begin
                           If prPanasonic in Protocols then CommandReceived_Int := True;
                           RX_Buffer_Int.PacketSize := PacketHeaderSize + RX_Counter_Int;
                           RX_Counter_Int  := 0;
                           RX_Checksum_Int := 0;
                         end;
                     end;
      end;

    end;
end;

{$IFDEF DPS900 }
Procedure External_RS485; Interrupt Serial1; Using 3;  { External, direct to camera }
Var Ch_Ext: Byte DATA;
    Saved_Ext_PacketCounter: Byte absolute Ch_Ext;
begin
  If SCON1 and TI1 <> 0 then
    begin
      SCON1 := SCON1 and not TI1;

      If Sending_Ext and (TX_Counter_Ext < TX_Buffer_Ext.PacketSize) then
        begin
          Case TX_Buffer_Ext.Command of
            Cmd_Transport: begin
                             If TX_Counter_Ext = 0 then TX_Counter_Ext := PacketHeaderSize;     { Start with actual packet data }
                             RS485_Timer     := RS485_Time;
                             TX_Ext_LedTimer := LedTimeExt;
                             SBUF1 := TX_BufferArray_Ext [TX_Counter_Ext];
                             Inc (TX_Counter_Ext);
                           end;
            else
                   Sending_Ext := False;
                   ReadyForExternalCommunication := True;        { Ready for packet }
          end;
        end else begin
                   Sending_Ext := False;
                   ReadyForExternalCommunication := True;        { Ready for packet }
                 end;
    end;
  If SCON1 and RI1 <> 0 then SCON1 := SCON1 and not RI1;
end;
{$ELSE}
Procedure External_RS485; Interrupt Serial1; Using 3;  { External }
Var Ch_Ext: Byte DATA;
    Saved_Ext_PacketCounter: Byte absolute Ch_Ext;
begin
  If SCON1 and TI1 <> 0 then
    begin
      SCON1 := SCON1 and not TI1;

      Case SCON1 and TB81 <> 0 of
        True: If Sending_Ext and (TX_Counter_Ext < TX_Buffer_Ext.PacketSize) then
                begin
                  TX_Ext_LedTimer := LedTimeExt;
                  SBUF1 := TX_BufferArray_Ext [TX_Counter_Ext];
                  Inc (TX_Counter_Ext);
                end else begin
                           Sending_Ext := False;
                           If SendKeepAliveByte then begin
                                                       Case ExtCommKeepAliveCounter of
                                                         0:   Case Local of
                                                                True: SBUF1 := LocalRemoteFlag or $01;
                                                                else  SBUF1 := LocalRemoteFlag or $00;
                                                              end;
                                                         else SBUF1 := KeepAliveByte                        { To keep communication over optics alive }
                                                       end;
                                                       Inc (ExtCommKeepAliveCounter);
                                                     end else ReadyForExternalCommunication := True;        { Ready for packet }
                         end;
        else  SBUF1 := Current_ADC;
      end;
      SCON1 := SCON1 xor TB81;           { Toggle ninth bit }
    end;
  If SCON1 and RI1 <> 0 then
    Case SCON1 and RB81 <> 0 of
      True: begin
              SCON1 := SCON1 and not RI1;
              If CommandReceived_Ext then Exit;
              Ch_Ext := SBUF1;

              If RX_Counter_Ext = 0 then
                Case Ch_Ext of
                  KeepAliveByte: Exit;
                  LocalRemoteFlag or $01: begin
                                            ExtCommunicationTimer := ExtCommunicationTime;
                                            OtherModuleLocal := True;
                                            If Ext_PacketCounter <> $FF then
                                              begin
                                                Inc (Ext_PacketCounter);
                                                Inc (Ext_PacketOK_Counter);
                                              end;
                                            Exit;
                                          end;
                  LocalRemoteFlag or $00: begin
                                            ExtCommunicationTimer := ExtCommunicationTime;
                                            OtherModuleLocal := False;
                                            If Ext_PacketCounter <> $FF then
                                              begin
                                                Inc (Ext_PacketCounter);
                                                Inc (Ext_PacketOK_Counter);
                                              end;
                                            Exit;
                                          end;
                  TurboStartByte:
                  else           begin
                                   If Ext_PacketCounter <> $FF then Inc (Ext_PacketCounter);
                                   RX_Ext_LedTimer := 2;
                                   ErrorLedTimer := 2;                   { Trash Byte }
                                   Exit;
                                 end;
                end;

              ExtCommunicationTimer := ExtCommunicationTime;
              RX_Ext_LedTimer := LedTimeExt;
              If (RX_Counter_Ext < PacketHeaderSize) or (RX_Buffer_Ext.PacketSize <= MaxPacketSize) then
                RX_BufferArray_Ext [RX_Counter_Ext] := Ch_Ext;
              RX_Checksum_Ext := RX_Checksum_Ext xor Ch_Ext;
              Inc (RX_Counter_Ext);
              If (RX_Counter_Ext >= PacketHeaderSize) and (RX_Counter_Ext = RX_Buffer_Ext.PacketSize) then
                begin
                  Saved_Ext_PacketCounter := Ext_PacketCounter;
                  If Saved_Ext_PacketCounter < 240 then Inc (Ext_PacketCounter, 12);
                  If RX_Checksum_Ext = 0 then
                    begin
                      If Saved_Ext_PacketCounter < 240 then Inc (Ext_PacketOK_Counter, 12);
                      If RX_Buffer_Ext.PacketSize <= MaxPacketSize then CommandReceived_Ext := True;
                    end else ErrorLedTimer := LedTimeExt;
                  RX_Counter_Ext := 0;
                  RX_Checksum_Ext := 0;
                end;

            end;
      else  begin
              SCON1 := SCON1 and (RI1 xor $FF);
              Current_DAC := SBUF1;
            end;
    end;
end;
{$ENDIF}


Procedure DAC_Interrupt; Interrupt Timer3; Using 3;{ DAC sample interrupt }
Var SamplePointer: Byte DATA;
begin                                              { Should not use R0..R7 !!! }
  Current_ADC := ADC0H;
  TMR3CN := TMR3CN and not TF3;
  Asm
    MOV      DAC1L, #0
    JB       TestMode, @SetTestDac

    MOV      DAC1H, Current_DAC                    { Normal }
    SJMP     @EndDacInterrupt

@SetTestDac:
    MOV      A, EqState
    JNZ      @Check_EqState_1
    MOV      DAC1H, Current_ADC                    { Test 0: Local ADC }
    SJMP     @EndDacInterrupt

@Check_EqState_1:
    DEC      A
    JNZ      @Check_EqState_2
    MOV      DAC1H, #0                             { Test 1: 0 Hz }
    SJMP     @EndDacInterrupt

@Check_EqState_2:
    DEC      A
    JNZ      @EqState_3
    MOV      A, SamplePointer
    INC      A
    MOV      B, #SamplesPerPeriod_100Hz
    DIV      AB
    MOV      A, B
    MOV      SamplePointer, A
    MOV      DPTR, #Sinus_100Hz
    MOVC     A, @A+DPTR                            { Test 2: 100 Hz }
    MOV      DAC1H, A
    SJMP     @EndDacInterrupt

@EqState_3:
    MOV      A, SamplePointer
    INC      A
    MOV      B, #SamplesPerPeriod_1kHz
    DIV      AB
    MOV      A, B
    MOV      SamplePointer, A
    MOV      DPTR, #Sinus_1kHz
    MOVC     A, @A+DPTR
    MOV      DAC1H, A                              { Test 3: 1 kHz }

@EndDacInterrupt:
  end;
end;

Function HexNibble (HexByte: Byte): Char;
begin
  HexByte := HexByte and $0F;
  Case HexByte of
    0..9: HexNibble := Chr (HexByte + $30);
    else  HexNibble := Chr (HexByte + $37);
  end;
end;

Procedure Delay (DelayTime: Word);
begin
  DelayTimer := DelayTime;
  Repeat
    WDTCN := $A5;
  until DelayTimer = 0;
end;

Procedure SetOpticTxXpoint;
begin
  Case MiscFlags and hdReturnVideoFromBus <> 0 of
    True: VideoXPoint [vOut_Optic_TX] := vIn_COM_Out;        { External sync }
    else  VideoXPoint [vOut_Optic_TX] := vIn_VideoIn;
  end;
end;

Procedure SetHardware;
begin
  Local  := ModeFlags and hdLocal <> 0;
  Case Local of
    True: BackgroundColor := bcGreen;
    else  BackgroundColor := bcRed;
  end;
  SetBackground;
  Master := ModeFlags and hdMaster <> 0;
  Case (MiscFlags and hdEqualizerOn) <> 0 of
    True: VideoInputPin := vIn_Spare;     { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }
    else  VideoInputPin := vIn_VideoIn;
  end;
  Case Local of
    True: Case MiscFlags and hdReturnVideoFromBus <> 0 of
            True: SetVideoXPoint (vOut_Optic_TX, vIn_COM_Out);        { External sync }
            else  SetVideoXPoint (vOut_Optic_TX, vIn_VideoIn);
          end;
    else  SetVideoXPoint (vOut_OSD_In, VideoInputPin);
  end;
end;

Procedure SetLedsDuring_EEPROM_Init;
begin
  If TempByte and $20 <> 0 then RX_Ext_LedTimer := LedTime;
  If TempByte and $10 <> 0 then TX_Ext_LedTimer := LedTime;
  Led_VideoLink   := TempByte and $08 <> 0;
  Led_Error       := TempByte and $04 <> 0;
  If TempByte and $02 <> 0 then RX_Int_LedTimer := LedTime;
  If TempByte and $01 <> 0 then TX_Int_LedTimer := LedTime;
  Repeat
    WDTCN := $A5;
  until (TX_Int_LedTimer or RX_Int_LedTimer) = 0;
end;

Procedure Init_EEPROM_Settings;
begin
  SetLedsDuring_EEPROM_Init;
  WriteByteToEEPROM (@EEPROM_Data.eeSourceName [0], 0);
  SetLedsDuring_EEPROM_Init;
  WriteByteToEEPROM (@EEPROM_Data.eeSourceDescription [0], 0);
  SetLedsDuring_EEPROM_Init;
  Case Local of
    True: MiscFlags := hdNameVisible or hdDescrVisible;
    else  MiscFlags :=                  hdDescrVisible;
  end;
  WriteByteToEEPROM (@EEPROM_Data.eeMiscFlags, MiscFlags);
  SetLedsDuring_EEPROM_Init;

  For TempByte := 1 to 16 do RemoteSlots [TempByte] := $FF;

  WriteBytesToEEPROM (@EEPROM_Data.eeRemoteSlots, @RemoteSlots, 16);
  SetLedsDuring_EEPROM_Init;
  ModeFlags := DefaultModeFlags;
  Local  := ModeFlags and hdLocal <> 0;
  Master := ModeFlags and hdMaster <> 0;
  WriteByteToEEPROM (@EEPROM_Data.eeModeFlags, ModeFlags);
  SetLedsDuring_EEPROM_Init;
  Protocols := [prTurbo, prPanasonic];
  WriteByteToEEPROM (@EEPROM_Data.eeProtocols, Byte (Protocols));
  SetLedsDuring_EEPROM_Init;
end;

Procedure Init_EEPROM_ModuleData;
begin
  For TempByte := 0 to SignatureLength - 1 do
    begin
      SetLedsDuring_EEPROM_Init;
      WriteByteToEEPROM (@EEPROM_Data.eeSignature [TempByte], MemCODE [SignatureOffset + TempByte]);
    end;
  SetLedsDuring_EEPROM_Init;
  WriteByteToEEPROM (@EEPROM_Data.eeSerialNumber [0], 0);
  SetLedsDuring_EEPROM_Init;
  WriteByteToEEPROM (@EEPROM_Data.eeComment [0], 0);
  Init_EEPROM_Settings;
  OsdString := 'EEPROM data initialized';
  WriteAtRow (Row);
  Inc (Row);
end;

Function Check_EEPROM_Signature: Boolean;
begin
  Check_EEPROM_Signature := False;
  For TempByte := 0 to SignatureLength - 1 do
    If ReadByteFromEEPROM (@EEPROM_Data.eeSignature [TempByte]) <> MemCODE [SignatureOffset + TempByte] then Exit;
  Check_EEPROM_Signature := True;
end;

Procedure Read_EEPROM;
begin
  If not Check_EEPROM_Signature then Init_EEPROM_ModuleData;
  If (Key_Up = False) and (Key_Down = False) and (Key_Enter = False) then Init_EEPROM_Settings;
  If Check_EEPROM_Signature then
    begin
      OsdString := 'Reading EEPROM ...';
      WriteAtRow (Row);
      Inc (Row);
      MiscFlags := ReadByteFromEEPROM (@EEPROM_Data.eeMiscFlags);
      ModeFlags := ReadByteFromEEPROM (@EEPROM_Data.eeModeFlags);
      ReadBytesFromEEPROM (@EEPROM_Data.eeRemoteSlots, @RemoteSlots, 16);
      Protocols := TProtocolsSet (ReadByteFromEEPROM (@EEPROM_Data.eeProtocols));
    end else begin
               ErrorCode := ecEEPROM;
               OsdString := 'EEPROM data invalid';
               Attribute := $1D00;
               WriteAtRow (Row);
               Attribute := $1C00;
               Inc (Row);
             end;
  SetHardware;
end;

Procedure SetTX_BufferAddresses;
begin
  PTX_Buffer^.PacketSize               := DefaultPacketSize;
  PTX_Buffer^.SourceAddress_Frame      := PRX_Buffer^.DestinationAddress_Frame;
  PTX_Buffer^.SourceAddress            := Slot;
  PTX_Buffer^.DestinationAddress       := PRX_Buffer^.SourceAddress;
  PTX_Buffer^.DestinationAddress_Frame := PRX_Buffer^.SourceAddress_Frame;
  PTX_Buffer^.OriginalAddress          := Slot;
  PTX_Buffer^.GatewayAddress           := $FF;
  PTX_Buffer^.CommandFlags             := [];
  PTX_Buffer^.Spare                    := 0;
end;

Procedure SendPacket;
Var TempChecksum: Byte DATA;
begin
  Case ActiveBuffer_Ext of
    True: begin
            If DelayPacketToExt then
              begin
                Inc (DelayedTXCounter_Ext);
                Move (TX_Buffer_Ext, TX_Buffer_Delayed_Ext [DelayedTXCounter_Ext], TX_Buffer_Ext{TX_Buffer_Delayed_Ext [DelayedTXCounter_Ext]}.PacketSize);
                DelayPacketToExt := False;
                Exit;
              end;
            SendKeepAliveByte := False;                { Stop sending KeepAliveByte }
            WDTCN := $A5;
            DelayTimer := CommRxEndWaitTime;
            Repeat
            until not Sending_Ext and ((RX_Counter_Ext = 0) or (DelayTimer = 0));
            TX_Buffer_Ext.Checksum := 0;
            TempChecksum := 0;
            For TX_Counter_Ext := 0 to TX_Buffer_Ext.PacketSize - 1 do TempChecksum := TempChecksum xor TX_BufferArray_Ext [TX_Counter_Ext];
            TX_Buffer_Ext.Checksum := TempChecksum;
            TX_Counter_Ext := 0;
            WDTCN := $A5;
            Repeat
            until ReadyForExternalCommunication;
            TX_Ext_LedTimer := LedTime;
            Sending_Ext := True;
            SendKeepAliveByte := True;                 { After packet }
            ReadyForExternalCommunication := False;    { Not ready until it will stop sending KeepAliveByte }
            SCON1 := SCON1 or TI1;
          end;
    else  begin
            If BroadcastReplyTimer_Int <> 0 then
              begin
                Inc (DelayedTXCounter_Int);
                Move (TX_Buffer_Int, TX_Buffer_Delayed_Int [DelayedTXCounter_Int], TX_Buffer_Int{TX_Buffer_Delayed_Int [DelayedTXCounter_Int]}.PacketSize);
                Exit;
              end;
            WDTCN := $A5;
            DelayTimer := CommRxEndWaitTime;
            Repeat
            until not Sending_Int and ((RX_Counter_Int = 0) or (DelayTimer = 0));
            Sending_Int := True;
            TX_Buffer_Int.Checksum := 0;
            TempChecksum := 0;
            For TX_Counter_Int := 0 to TX_Buffer_Int.PacketSize - 1 do TempChecksum := TempChecksum xor TX_BufferArray_Int [TX_Counter_Int];
            TX_Buffer_Int.Checksum := TempChecksum;
            TX_Counter_Int := 0;
            RS485_Timer          := RS485_Time;
            RS485_Timer_External := RS485_Time_External;
            Int_RS485_TX := True;
            TX_Int_LedTimer := LedTime;
            WDTCN := $A5;
            Repeat
            until RS485_Timer <= 1;
            TI := True;
          end;
  end;
end;

Procedure SendPacketWithDelay (BlockDelay: Byte);
begin
  Delay (BlockDelay);
  SendPacket;
end;

Procedure SetOsdStringToModuleName;
begin          {123456789012345678901234567890}
  OsdString := 'Module PPS5000 LOCAL   slot 00';
  If Local then
    Case Master of
      True: OsdString [22] := 'M';
      else  OsdString [22] := 'S';
    end else begin
               OsdString [16] := 'R';
               OsdString [17] := 'E';
               OsdString [18] := 'M';
               OsdString [19] := 'O';
               OsdString [20] := 'T';
               OsdString [21] := 'E';
             end;
  OsdString [29] := Chr ((Slot + 1) div 10 + $30);
  OsdString [30] := Chr ((Slot + 1) mod 10 + $30);
end;

Procedure WriteSourceName;
begin
  Case TestMode of
    False: begin
             OsdString := EmptyLine15;
             If MiscFlags and hdNameVisible <> 0 then
               begin
                 TempByte := ReadByteFromEEPROM  (@EEPROM_Data.eeSourceName);
                 If TempByte <> 0 then ReadXBytesFromEEPROM  (Pointer (Word (@EEPROM_Data.eeSourceName) + 1),
                                                              Pointer (Word (@OsdString) + 1 + (15 - TempByte) div 2),
                                                              TempByte);
               end;
           end;
                  { 123456789012345678901234567890 }
    else OsdString := ' MODULE   TEST ';
  end;
  WriteAtRow (0);
end;

Procedure WriteScreen;
Var CommChar: Char;
begin
  WriteSourceName;
  OsdString := 'ALARMS:                       ';
  TempBoolean := False;

  { 123456789012345678901234567890 }
  {'ALARMS: EE UI LINK SYNC  COMM '}

  If NoEEPROM then
    begin
      TempBoolean := True;
      OsdString [9]  := 'E';
      OsdString [10] := 'E';
    end;
  If not OSD_SYD then
    begin
      If not U_DET_Active or not I_DET_Active then TempBoolean := True;
      If not U_DET_Active then OsdString [12] := 'U';
      If not I_DET_Active then OsdString [13] := 'I';
    end;

  Case Local of
    True: If not OSD_SYD and not RemoteLinkActive then   { REMOTE module missing (only if no video) }
            begin
              TempBoolean := True;
              OsdString [15] := 'L';
              OsdString [16] := 'I';
              OsdString [17] := 'N';
              OsdString [18] := 'K';
            end;
    else  If ExtCommunicationTimer = 0 then                   { LOCAL module }
            begin
              TempBoolean := True;
              OsdString [15] := 'L';
              OsdString [16] := 'I';
              OsdString [17] := 'N';
              OsdString [18] := 'K';
            end;
  end;

  { 123456789012345678901234567890 }
  {'ALARMS: EE UI LINK SYNC  COMM '}

  If not OSD_SYD then
    begin
      TempBoolean := True;
      OsdString [20] := 'S';
      OsdString [21] := 'Y';
      OsdString [22] := 'N';
      OsdString [23] := 'C';
    end;
  If (MiscFlags and hdReportCommAlarm <> 0) and not IntCommActive then
    begin
      TempBoolean := True;
      OsdString [26] := 'C';
      OsdString [27] := 'O';
      OsdString [28] := 'M';
      OsdString [29] := 'M';
    end;
  If TempBoolean then
    Case Local of
      True: begin
              Attribute := $1D00;
              WriteAtRow (6);
              Attribute := $1C00;
              SetOsdStringToModuleName;
              WriteAtRow (5);
              OsdString := EmptyLine30;
              WriteAtRow (2);
              WriteAtRow (3);
            end;
      else  begin
              Attribute := $1D00;
              WriteAtRow (3);
              Attribute := $1C00;
              SetOsdStringToModuleName;
              WriteAtRow (2);
              OsdString := EmptyLine30;
              WriteAtRow (5);
              WriteAtRow (6);
            end;
    end;
  OsdString := EmptyLine30;
  If not TempBoolean then
    begin
      WriteAtRow (2);
      WriteAtRow (3);
      WriteAtRow (5);
      WriteAtRow (6);
    end;
  Case not Local and (LoopTestTimer <> 0) of
    True: begin
            OsdString := 'LOOP TEST';
            Attribute := $1D00;
            WriteAtRow (1);
            Attribute := $1C00;
            OsdString := EmptyLine30;
          end;
    else  WriteAtRow (1);
  end;
  WriteAtRow (4);
  WriteAtRow (7);

  Case Local xor OtherModuleLocal of
    True: CommChar := '#';        { Different modules (local/remote) on each side }
    else  CommChar := '';        { Same modules (local/remote) on each side }
  end;

  Case TestMode of
    False: If (Key_Up = False) or (LoopTestTimer <> 0) then
             begin
               If ExtCommActive then
                 begin         { 123456789012345678901234567890 }
                   OsdString := 'OPTIC  COMM:  """"""""""""""""';
                   For TempByte := 15 to Byte ((Word (Ext_PacketOK_Counter) * 16) div Ext_PacketCounter) + 14 do
                     OsdString [TempByte] := CommChar;
                 end else OsdString := 'OPTIC  COMM:                  ';
               WriteAtRow (9);
               If IntCommActive then
                 begin         { 123456789012345678901234567890 }
                   OsdString := 'RS485  COMM:  """"""""""""""""';
                   For TempByte := 15 to Byte ((Word (Int_PacketOK_Counter) * 16) div Int_PacketCounter) + 14 do
                     OsdString [TempByte] := '#';
                 end else OsdString := 'RS485  COMM:                  ';
             end else WriteAtRow (9);                                   { 123456789012345678901234567890 }
    else begin         { 123456789012345678901234567890 }               { OSD In:    Outputs: In    EQ 0 }
           OsdString := '                  DAC:        ';               { Inputs: 0000      DAC: 1000 Hz }
           Case EqState of
             0: begin
                  OsdString [28] := 'A';
                  OsdString [29] := 'D';
                  OsdString [30] := 'C';
                end;
             1: begin
                  OsdString [27] := '0';
                  OsdString [29] := 'H';
                  OsdString [30] := 'z';
                end;
             2: begin
                  OsdString [25] := '1';
                  OsdString [26] := '0';
                  OsdString [27] := '0';
                  OsdString [29] := 'H';
                  OsdString [30] := 'z';
                end;
             else begin
                    OsdString [24] := '1';
                    OsdString [25] := '0';
                    OsdString [26] := '0';
                    OsdString [27] := '0';
                    OsdString [29] := 'H';
                    OsdString [30] := 'z';
                  end;
           end;
           WriteAtRow (9);
                       { 123456789012345678901234567890 }
           OsdString := 'OSD In:    Outputs: In    EQ 0';
           OsdString [9]  := Chr (PinToInput [OSDVideoInputPin] + $30);
           OsdString [23] := Chr (PinToInput [VideoInputPin] + $30);
           OsdString [30] := Chr (EqState + $30);
         end;
  end;
  WriteAtRow (8);
  OsdString := EmptyLine30;
  If MiscFlags and hdDescrVisible <> 0 then
    begin
      TempByte := ReadByteFromEEPROM  (@EEPROM_Data.eeSourceDescription);
      ReadXBytesFromEEPROM  (Pointer (Word (@EEPROM_Data.eeSourceDescription) + 1),
                             Pointer (Word (@OsdString) + 1),
                             TempByte);
    end;
  Case Local of
    True: WriteAtRow (11);
    else  WriteAtRow (10);
  end;
  OsdString := EmptyLine30;
  Case Local of
    True: WriteAtRow (10);
    else  WriteAtRow (11);
  end;
end;

Procedure ProcessTestKey;
begin                                  { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }
  If KeyPressed then
    begin
      If Key_Up and Key_Down and Key_Enter then KeyPressed := False else Exit;
    end;
  If not Key_Up then
    begin
        OSDVideoInputPin := TInputPin ((Ord (OSDVideoInputPin) + 1) and $07);
      If OSDVideoInputPin = vIn_OSD_Out then
        OSDVideoInputPin := TInputPin ((Ord (OSDVideoInputPin) + 1) and $07);
    end;
  If not Key_Down then
    begin
      VideoInputPin := TInputPin ((Ord (VideoInputPin) + 1) and $07);
    end;
  If not Key_Enter then
    EqState := (EqState + 1) and $03;
  KeyPressed := not (Key_Up and Key_Down and Key_Enter);
end;

Procedure SetTestXPoints;
begin
  If (OSDVideoInputPin = vIn_IO) or (VideoInputPin = vIn_IO) then
    VideoXPoint [vOut_IO]  := vIn_NC else
      VideoXPoint [vOut_IO] := VideoInputPin;
  VideoXPoint [vOut_OSD_In]        := OSDVideoInputPin;
  VideoXPoint [vOut_ExtSyncOut]    := VideoInputPin;
  VideoXPoint [vOut_VideoOut_BUS]  := VideoInputPin;
  VideoXPoint [vOut_VideoOut]      := VideoInputPin;
  VideoXPoint [vOut_Optic_TX]      := VideoInputPin;
  SetVideoXPoints;
end;

Procedure Init;
begin
  OSCXCN := $67;
  Asm
@1:
   DJNZ  ACC, @1
@2:
   DJNZ  ACC, @2
  end;
  Repeat until OSCXCN and $80 <> 0; { Wait until external oscillator is stable }
  OSCICN := OSCICN or $08;          { Switch to external oscillator }

  { P0 }

  XBR0 := $05;                      { UART0EN, SMB0EN }
  XBR2 := $04;                      { UART1EN }
  P0MDOUT := %11010001;             { TX0, TX1 Push-Pull, P0.6, P0.7 }

  { P1 }

  P1MDIN  := $00;                   { P1 analog inputs }
  P1MDOUT := $00;                   { P1 as open drain }
  P1 := $FF;                        { High impenance state }
  XBR2    := $44;                   { Enable xbar }

  { P2 }

  { P3 }

  P3MDOUT := %01011111;             { A2, A1, A0 }

  { P4 = KeysAndSlotPort, P5 = LedsAndLatchPort, P6 = LatchDataPort, P7 = IOPort }

  P74OUT := %01111100;              { P7H = In, P7L = Out, P6 = Out, P5 = Out, P4 = In }
  P7 := $F0;                        { IOPort: P7.7 to P7.4 set to high impedance state }
  P4 := $FF;                        { KeysAndSlotPort: all pins are inputs }

  LedsAndLatchPort := $FF;

  AMX0SL := $07;                    { select TEMP sensor as ADC0 input }
  ADC0CF := ConversionClock;        { Set clock and PGA Gain = 1 }
  ADC0CN := %01000101;              { Disable ADC, track mode, Conversion initiated by Timer3 overflow, left-justified data }

  Int_RS485_TX      := False;
  Ext_RS485_TX      := False;
  Ext_RS485_TX_Int  := False;

  P2  := $FF;

  I_DET := True;
  U_DET := True;

  OSD_SCK := False;
  OSD_CSB := False;

  OSD_SYD := True;

  Key_Up    := True;
  Key_Down  := True;
  Key_Enter := True;

  Led_PowerSupply_U := True;
  Led_PowerSupply_I := True;
  RemoteLink        := True;

  RS485_Timer             := 0;
  RS485_Timer_External    := 0;
  Int_PacketCounter       := 0;
  Int_PacketOK_Counter    := 0;
  Ext_PacketCounter       := 0;
  Ext_PacketOK_Counter    := 0;
  IntCommPacketTimer      := CommPacketTime;
  ExtCommPacketTimer      := ExtCommunicationTime;
  TX_Counter_Int          := 0;
  TX_Counter_Ext          := 0;
  RX_Counter_Int          := 0;
  RX_Counter_Ext          := 0;
  RX_Checksum_Int         := 0;
  RX_Checksum_Ext         := 0;
  ErrorLedTimer           := 0;
  TX_Buffer_Int.StartByte := TurboStartByte;
  TX_Buffer_Ext.StartByte := TurboStartByte;
  EqState                 := 0;
  msCounter               := 1000;
  DelayedTXCounter_Int    := 0;
  DelayedTXCounter_Ext    := 0;
  BroadcastReplyTimer_Int := 0;
  BroadcastReplyTimer_Ext := 0;
  LoopTestTimer           := 0;
  Temperature             := 0;
  ExtCommunicationTimer   := 0;
  I_DET_Counter           := 0;
  U_DET_Counter           := 0;
  RemoteLinkCounter       := 0;

  Sending_Int                   := False;
  Sending_Ext                   := False;
  SendKeepAliveByte             := False;
  ReadyForExternalCommunication := True;
  CommandReceived_Int           := False;
  CommandReceived_Ext           := False;
  KeyPulse                      := False;
  DelayPacketToExt              := False;
  OtherModuleLocal              := False;

  TL0     := Lo (Const1ms);
  TH0     := Hi (Const1ms);
  TL1     := BaudRateTimerValue;
  TH1     := BaudRateTimerValue;
  TMR3RLL := Lo (DAC_SampleRateTimerValue);
  TMR3RLH := Hi (DAC_SampleRateTimerValue);
  RCAP4L  := Lo (BaudRateTimerValue1);
  RCAP4H  := Hi (BaudRateTimerValue1);

  REF0CN  := %00000111; { Temperature sensor on, Internal bias generator on, reference buffer on }

  PCON    := $00;       { no IDLE, no POWER DOWN }
{$IFDEF DPS900 }
  SCON1   := %01010000; { Serial Mode 1, Enable Reception }
{$ELSE}
  SCON1   := %11010000; { Serial Mode 3, Enable Reception }
{$ENDIF}
  SCON0   := %01010000; { Serial Mode 1, Enable Reception }
  TMOD    := %00100001; { Timer1: no GATE, Timer,  8 bit timer, autoreload }
                        { Timer0: no GATE, Timer, 16 bit timer }
  TCON    := %01010101; { Timer 1 run, Timer 0 run }
                        { Int1 falling edge, Int0 falling edge }
  TMR3CN  := TR3 or T3M;{ Timer3 for DAC sample rate, Run, SysClk }
  T4CON   := %00110100; { Timer 4 for RX1 and TX1 clock, Timer 4 run, Timer }
  IE      := %10000010; { Timer0 }
  EIE2    := ET3;       { Timer3 }
  EIP2    := PT3;       { Interrupt priority Timer3 }
  DAC0CN  := DAC0EN or UpdateOn_Timer3 or %100;         { Enable DAC0, update on Timer3 overflow, DAC bits 11..4 in DAC0H }
  DAC1CN  := DAC1EN or UpdateOn_Timer3 or %100;         { Enable DAC1, update on Timer3 overflow, DAC bits 11..4 in DAC0H }
  SMB0CR  := 147;       { I2C (SMBus0) clock 100 kHz }
  ENSMB   := True;      { I2C (SMBus0) enabled }
  AD0EN   := True;      { Enable ADC }

  BackgroundColor := bcBlue;
  Attribute := $1C00;
  InitOsd;

  RX_Int_LedTimer := 255;
  RX_Ext_LedTimer := 255;
  TX_Int_LedTimer := 255;
  TX_Ext_LedTimer := 255;
  Led_VideoLink   := Led_ON;
  Led_Error       := Led_ON;
  Repeat
    WDTCN := $A5;
  until RX_Int_LedTimer = 10;
  RX_Int_LedTimer := 255;
  RX_Ext_LedTimer := 255;
  TX_Int_LedTimer := 255;
  TX_Ext_LedTimer := 255;
  Repeat
    WDTCN := $A5;
  until RX_Int_LedTimer = 0;
  Led_VideoLink := Led_OFF;
  Led_Error     := Led_OFF;

  Slot := KeysAndSlotPort shr 4;
  BroadcastReplyTime_Int := Word (Slot + 1) * BroadcastReplyTimeSlot;
  BroadcastReplyTime_Ext := 18 * BroadcastReplyTimeSlot;   { Time for remote FOM3000 to wait before it forwards broadcast and answers }

  TestMode := not Key_Down;
  KeyPressed := False;

  Case TestMode of
    False: OsdString := ' MODULE  RESET ';
    else   OsdString := ' MODULE   TEST ';
  end;
  WriteAtRow (0);
  SetOsdStringToModuleName;
  OsdString [16] := ' ';
  OsdString [17] := ' ';
  OsdString [18] := ' ';
  OsdString [19] := ' ';
  OsdString [20] := ' ';
  OsdString [21] := ' ';
  WriteAtRow (2);
  Row := 3;   { 123456789012345678901234567890 }
  OsdString := 'Firmware version 0.00';
  OsdString [18] := Chr (VersionHi + $30);
  OsdString [20] := Chr (VersionLo div 10 + $30);
  OsdString [21] := Chr (VersionLo mod 10 + $30);
  WriteAtRow (Row);
  Inc (Row);
  Inc (Row);

  If BUSY then
    begin
      OsdString := 'Error: I2C BUSY';
      Attribute := $1D00;
      WriteAtRow (Row);
      While BUSY do
        begin
          ENSMB := False;
          Delay (100);
          Led_Error := Blink;
          WDTCN := $A5;
          ENSMB := True;
          Delay (100);
        end;
      Led_Error := Led_OFF;
      OsdString := EmptyLine30;
      Attribute := $1C00;
      WriteAtRow (Row);
    end;

  ErrorCode := ecNone;
  Case I2C_AddressPresent (I2C_24C32) of
    True: begin
                        { 123456789012345678901234567890 }
            OsdString := '24C32       found';

            NoEEPROM := False;
          end;
    else  begin
            ErrorCode := ecEEPROM;
                        { 123456789012345678901234567890 }
            OsdString := '24C32   not found';
            Attribute := $1D00;
            NoEEPROM := True;
          end;
  end;
  WriteAtRow (Row);
  Attribute := $1C00;
  Inc (Row);
  Case I2C_AddressPresent (I2C_TEA6415) of
    True: begin
                        { 123456789012345678901234567890 }
            OsdString := 'TEA6415     found';
          end;
    else  begin
            ErrorCode := ecTEA6415;
                        { 123456789012345678901234567890 }
            OsdString := 'TEA6415 not found';
            Attribute := $1D00;
          end;
  end;
  WriteAtRow (Row);
  Attribute := $1C00;
  Inc (Row);

  If not NoEEPROM then Read_EEPROM;
  If TestMode then VideoInputPin := vIn_OSD_Out;
  OSDVideoInputPin := vIn_VideoIn;

  { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }

  Case TestMode of
    False: Case Local of
             True: begin
                     VideoXPoint [vOut_IO]           := vIn_NC;

                     VideoXPoint [vOut_OSD_In]       := vIn_VideoIn;

                     VideoXPoint [vOut_VideoOut_BUS] := vIn_NC;

                     VideoXPoint [vOut_VideoOut]     := vIn_Optic_RX;

                     VideoXPoint [vOut_ExtSyncOut]   := vIn_NC;                { Local out not defined }

                     VideoXPoint [vOut_Optic_TX]     := vIn_OSD_Out;
                   end;
             else  begin
                     VideoXPoint [vOut_IO]           := vIn_Optic_RX;          { External sync for remote frame }

                     VideoXPoint [vOut_OSD_In]       := vIn_VideoIn;           { 26.11.2005 }

                     VideoXPoint [vOut_VideoOut_BUS] := vIn_NC;
                     VideoXPoint [vOut_VideoOut]     := vIn_Optic_RX;
                     VideoXPoint [vOut_ExtSyncOut]   := vIn_NC;                { Error in hardware ??? }

                     VideoXPoint [vOut_Optic_TX]     := vIn_OSD_Out;
                   end;
           end;
    else SetTestXPoints;
  end;
  SetVideoXPoints;

  SetOsdStringToModuleName;
  WriteAtRow (2);

  OsdString := 'Initializing module...';
  WriteAtRow (Row);
  Inc (Row);
  Delay (2000);

  Led_Error      := Slot and $01 = 0;
  Led_VideoLink  := Slot and $02 = 0;
  BlinkTimer := 0;
  Repeat
    RX_Ext_LedTimer := 255;                               { Always on during slot address }
    If Slot and $04 <> 0 then TX_Int_LedTimer := 255;
    If Slot and $08 <> 0 then RX_Int_LedTimer := 255;
    WDTCN := $A5;
  until BlinkTimer = $0800;

  Repeat
    WDTCN := $A5;
  until (RX_Int_LedTimer or TX_Int_LedTimer) = 0;
  Led_VideoLink := Led_OFF;
  Led_Error     := Led_OFF;
  ES := True;                { Enable UART  interrupt }
  EIE2 := EIE2 or ES1;       { Enable UART1 interrupt }

  TX_Buffer_Ext.PacketSize               := DefaultPacketSize;
  TX_Buffer_Ext.SourceAddress            := Slot;                     { Send test packet }
  TX_Buffer_Ext.SourceAddress_Frame      := InterFrameAddress;
  Case Local of
    True: TX_Buffer_Ext.DestinationAddress       := 1;
    else  TX_Buffer_Ext.DestinationAddress       := COM_ModuleAddress;
  end;
  TX_Buffer_Ext.DestinationAddress_Frame := InterFrameAddress;
  TX_Buffer_Ext.OriginalAddress          := Slot;
  TX_Buffer_Ext.GatewayAddress           := $FF;
  TX_Buffer_Ext.Spare                    := 0;
  TX_Buffer_Ext.Command                  := Cmd_Message;
  TX_Buffer_Ext.CommandFlags             := [cfCommTest];
  PTX_Buffer := @TX_Buffer_Ext;
  PTX_Buffer_Cmd_Message^.msByte0        := 1;             { Reply }
  ActiveBuffer_Ext := True;
  SendPacket;

  Repeat
    WDTCN := $A5;
  until Key_Up and Key_Down and Key_Enter;
end;

Procedure ProcessCommands (Source: Boolean);
begin
  Case Source of
    sInternal: begin
                 PTX_Buffer := @TX_Buffer_Int;
                 PRX_Buffer := @RX_Buffer_Int;
                 ActiveBuffer_Ext    := False;
               end;
    else       begin
                 PTX_Buffer := @TX_Buffer_Ext;
                 PRX_Buffer := @RX_Buffer_Ext;
                 ActiveBuffer_Ext    := True;
               end;
  end;
  Case PRX_Buffer^.Command of
    Cmd_ModuleData: begin
                      If PRX_Buffer^.CommandFlags * [cfWriteToEEPROM, cfWriteToHW] <> [] then
                        begin
                          WriteXBytesToEEPROM (@EEPROM_Data.eeSerialNumber, @PRX_Buffer_Cmd_ModuleData^.mdSerialNumber, SerialNumberLength + 1);
                          WriteXBytesToEEPROM (@EEPROM_Data.eeComment,      @PRX_Buffer_Cmd_ModuleData^.mdComment, CommentLength + 1);
                        end;

                      If PRX_Buffer^.CommandFlags * [cfReadFromEEPROM, cfReadFromHW] <> [] then
                        begin
                          SetTX_BufferAddresses;
                          PTX_Buffer^.PacketSize := DefaultPacketSize + 2;              { Temperature }
                          PTX_Buffer^.Command                                 := Cmd_ModuleData;
                          Case Local of
                            True: PTX_Buffer_Cmd_ModuleData^.mdModuleType     := mtFOM3000_Local;
                            else  PTX_Buffer_Cmd_ModuleData^.mdModuleType     := mtFOM3000_Remote;
                          end;
                          If OSD_SYD = False then TempByte := $00 else TempByte := mdVideoPresent;
                          If not I2C_AddressPresent (I2C_24C32) then         TempByte := TempByte or mdErrorEEPROM;
                          If not I2C_AddressPresent (I2C_TEA6415) then TempByte := TempByte or mdErrorTEA6415;
                          If U_DET_Active then TempByte := TempByte or mdUDet;
                          If I_DET_Active then TempByte := TempByte or mdIDet;
                          If RemoteLinkActive then TempByte := TempByte or mdLink;
                          If Key_Enter = False then TempByte := TempByte or mdKeyEnter;
                          PTX_Buffer_Cmd_ModuleData^.mdModuleFlags        := TempByte;
                          PTX_Buffer_Cmd_ModuleData^.mdFirmwareVersion    := VersionHi * 256 + VersionLo;
                          ReadXBytesFromEEPROM (@EEPROM_Data.eeSerialNumber,
                                                @PTX_Buffer_Cmd_ModuleData^.mdSerialNumber, SerialNumberLength + 1);
                          ReadXBytesFromEEPROM (@EEPROM_Data.eeComment,
                                                @PTX_Buffer_Cmd_ModuleData^.mdComment, CommentLength + 1);
                          PTX_Buffer_Cmd_ModuleData^.mdTemperature := NoTemperature{Temperature};

                          SendPacketWithDelay (TxBlockDelay);
                        end;
                    end;
    Cmd_SourceNameAndFlags: begin
                              If cfResetHWToEEPROM in PRX_Buffer^.CommandFlags then
                                begin
                                  MiscFlags := ReadByteFromEEPROM (@EEPROM_Data.eeMiscFlags);
                                  SetHardware;
                                end;

                              If cfWriteToHW in PRX_Buffer^.CommandFlags then
                                begin
                                  MiscFlags := PRX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags;
                                  SetHardware;
                                end;

                              If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
                                begin
                                  WriteXBytesToEEPROM (@EEPROM_Data.eeSourceName,
                                                       @PRX_Buffer_Cmd_SourceNameAndFlags^.hdSourceName, SourceNameLength + 1);
                                  WriteByteToEEPROM (@EEPROM_Data.eeMiscFlags, PRX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags);
                                end;

                              If cfReadFromHW in PRX_Buffer^.CommandFlags then
                                begin
                                  SetTX_BufferAddresses;
                                  PTX_Buffer^.Command  := Cmd_SourceNameAndFlags;
                                  ReadXBytesFromEEPROM  (@EEPROM_Data.eeSourceName,
                                                         @PTX_Buffer_Cmd_SourceNameAndFlags^.hdSourceName,
                                                         SourceNameLength + 1);
                                  PTX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags := MiscFlags;
                                  SendPacketWithDelay (TxBlockDelay);
                                end;

                              If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
                                begin
                                  SetTX_BufferAddresses;
                                  PTX_Buffer^.Command                      := Cmd_SourceNameAndFlags;
                                  PTX_Buffer_Cmd_SourceNameAndFlags^.hdMiscFlags := ReadByteFromEEPROM  (@EEPROM_Data.eeMiscFlags);
                                  ReadXBytesFromEEPROM  (@EEPROM_Data.eeSourceName,
                                                         @PTX_Buffer_Cmd_SourceNameAndFlags^.hdSourceName,
                                                         SourceNameLength + 1);
                                  SendPacketWithDelay (TxBlockDelay);
                                end;
                            end;
    Cmd_SourceDescription: begin
                             If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
                               begin
                                 WriteXBytesToEEPROM (@EEPROM_Data.eeSourceDescription,
                                                      @PRX_Buffer_Cmd_SourceDescription^.hdSourceDescription, SourceDescriptionLength + 1);
                               end;

                             If PRX_Buffer^.CommandFlags * [cfReadFromHW, cfReadFromEEPROM] <> [] then
                               begin
                                 SetTX_BufferAddresses;
                                 PTX_Buffer^.Command                      := Cmd_SourceDescription;
                                 ReadXBytesFromEEPROM  (@EEPROM_Data.eeSourceDescription,
                                                        @PTX_Buffer_Cmd_SourceDescription^.hdSourceDescription,
                                                        SourceDescriptionLength + 1);
                                 SendPacketWithDelay (TxBlockDelay);
                               end;
                           end;
    Cmd_RemoteSlots: begin
                       If cfResetHWToEEPROM in PRX_Buffer^.CommandFlags then
                         begin
                           ReadBytesFromEEPROM (@EEPROM_Data.eeRemoteSlots, @RemoteSlots, 16);
                           ModeFlags := ReadByteFromEEPROM (@EEPROM_Data.eeModeFlags);
                           SetHardware;
                         end;

                       If cfWriteToHW in PRX_Buffer^.CommandFlags then
                         begin
                           RemoteSlots := PRX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots;

                           If (ModeFlags and hdLocal = 0) and OtherModuleLocal then      { Don't cange remote modul to local if other module is local }
                             PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags := PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags and not hdLocal;

                           ModeFlags   := PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags;
                           SetHardware;
                         end;

                       If cfReadFromHW in PRX_Buffer^.CommandFlags then
                         begin
                           SetTX_BufferAddresses;
                           PTX_Buffer^.Command                         := Cmd_RemoteSlots;
                           PTX_Buffer^.PacketSize                      := PacketHeaderSize + 17;
                           PTX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots := RemoteSlots;
                           PTX_Buffer_Cmd_RemoteSlots^.hdModeFlags   := ModeFlags;
                           SendPacketWithDelay (TxBlockDelay);
                         end;

                       If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
                         begin
                           WriteXBytesToEEPROM (@EEPROM_Data.eeRemoteSlots, @PRX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots, 16);

                           If (ModeFlags and hdLocal = 0) and OtherModuleLocal then      { Don't cange remote modul to local if other module is local }
                             PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags := PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags and not hdLocal;

                           WriteByteToEEPROM (@EEPROM_Data.eeModeFlags, PRX_Buffer_Cmd_RemoteSlots^.hdModeFlags);
                         end;

                       If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
                         begin
                           SetTX_BufferAddresses;
                           PTX_Buffer^.Command                       := Cmd_RemoteSlots;
                           PTX_Buffer^.PacketSize                    := PacketHeaderSize + 17;
                           ReadXBytesFromEEPROM (@EEPROM_Data.eeRemoteSlots, @PTX_Buffer_Cmd_RemoteSlots^.hdRemoteSlots, 16);
                           PTX_Buffer_Cmd_RemoteSlots^.hdModeFlags := ReadByteFromEEPROM (@EEPROM_Data.eeModeFlags);
                           SendPacketWithDelay (TxBlockDelay);
                         end;
                     end;
    Cmd_Protocols: begin
                     If cfReadFromHW in PRX_Buffer^.CommandFlags then
                       begin
                         SetTX_BufferAddresses;
                         PTX_Buffer^.PacketSize                   := PacketHeaderSize + 1;
                         PTX_Buffer^.Command                      := Cmd_Protocols;
                         PTX_Buffer_Cmd_Protocols^.prProtocols    := Protocols;
                         SendPacketWithDelay (TxBlockDelay);
                       end;

                     If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
                       begin
                         SetTX_BufferAddresses;
                         PTX_Buffer^.PacketSize                   := PacketHeaderSize + 1;
                         PTX_Buffer^.Command                      := Cmd_Protocols;
                         PTX_Buffer_Cmd_Protocols^.prProtocols    := TProtocolsSet (ReadByteFromEEPROM (@EEPROM_Data.eeProtocols));
                         SendPacketWithDelay (TxBlockDelay);
                       end;

                     If cfWriteToHW in PRX_Buffer^.CommandFlags then
                       begin
                         Protocols := PRX_Buffer_Cmd_Protocols^.prProtocols;
                       end;

                     If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
                       begin
                         WriteByteToEEPROM (@EEPROM_Data.eeProtocols, Byte (PRX_Buffer_Cmd_Protocols^.prProtocols));
                       end;
                   end;
    Cmd_EEPROM: begin
                  If cfWriteToEEPROM in PRX_Buffer^.CommandFlags then
                    WriteXBytesToEEPROM  (@PRX_Buffer_Cmd_EEPROM^.eeAddress, @PRX_Buffer_Cmd_EEPROM^.eeData, 16);

                  If cfReadFromEEPROM in PRX_Buffer^.CommandFlags then
                    begin
                      SetTX_BufferAddresses;
                      PTX_Buffer^.PacketSize               := PacketHeaderSize + 22;
                      ReadXBytesFromEEPROM  (@PRX_Buffer_Cmd_EEPROM^.eeAddress, @PTX_Buffer_Cmd_EEPROM^.eeData, 16);
                      PTX_Buffer^.Command                  := Cmd_EEPROM;
                      PTX_Buffer^.CommandFlags             := PRX_Buffer^.CommandFlags;
                      If Word (@PRX_Buffer_Cmd_EEPROM^.eeAddress) >= Word (@EEPROM_Data.eeEND) then
                        PTX_Buffer^.CommandFlags := PTX_Buffer^.CommandFlags + [cfDataEnd];
                      PTX_Buffer_Cmd_EEPROM^.eeAddress     := PRX_Buffer_Cmd_EEPROM^.eeAddress;
                      PTX_Buffer_Cmd_EEPROM^.eeSize        := EEPROM_Size;
                      PTX_Buffer_Cmd_EEPROM^.eeDataSize    := Word (@EEPROM_Data.eeEND);
                      SendPacketWithDelay (TxBlockDelay);
                    end;
                end;
    Cmd_Message: begin
                   If (cfLoopTest in PRX_Buffer^.CommandFlags) and Local {and (PRX_Buffer^.SourceAddress = $80 + Slot)} then
                     Case PRX_Buffer_Cmd_Message^.msByte0 of
                       0:   LoopTestTimer := 0;
                       else LoopTestTimer := LoopTestTime;
                     end;
                   If (cfCommTest in PRX_Buffer^.CommandFlags) and (PRX_Buffer_Cmd_Message^.msByte0 = 1) then
                     begin
                       SetTX_BufferAddresses;
                       PTX_Buffer^.Command := Cmd_Message;
                       PTX_Buffer^.CommandFlags := [cfCommTest];
                       PTX_Buffer_Cmd_Message^.msByte0 := 0;
                       SendPacketWithDelay (TxBlockDelay);             { Reply }
                     end;
                 end;
    Cmd_Reset: begin
                 If cfInitEEPROMModuleData in PRX_Buffer^.CommandFlags then Init_EEPROM_ModuleData;
                 If cfInitEEPROMSettings   in PRX_Buffer^.CommandFlags then Init_EEPROM_Settings;

                 Asm
                   LJMP    0
                 end;
               end;
    Cmd_Transport: If not Local then
                     begin                                                                        { Cmd_Transport from external connection (local FOM3000 }
                       WDTCN := $A5;
                       DelayTimer := CommRxEndWaitTime;
                       Repeat
                       until not Sending_Int and ((RX_Counter_Int = 0) or (DelayTimer = 0));
                       Move (RX_Buffer_Ext, TX_Buffer_Int, RX_Buffer_Ext.PacketSize);
                       TX_Counter_Int := PacketHeaderSize;                                        { Start with actual packet }
                       Sending_Int := True;
                       RS485_Timer          := RS485_Time;
                       RS485_Timer_External := RS485_Time_External;
                       Ext_RS485_TX := True;
                       Ext_RS485_TX_Int := True;
                       TX_Int_LedTimer := LedTime;
                       Repeat
                       until RS485_Timer <= 1;
                       TI := True;
                     end;
  end;
end;

Procedure ProcessCommands_Int;
Var SavedRelay: Byte;
begin
  If not CommandReceived_Int then Exit;

  Case PacketType of
    ptTurbo: begin
                Case RX_Buffer_Int.DestinationAddress of
                  BroadcastAddress: begin
                                      BroadcastReplyTimer_Int := BroadcastReplyTime_Int;
                                      BlinkTimer := 0;
                                      If Local then
                                        begin
                                          Inc (DelayedTXCounter_Ext);
                                          TX_Buffer_Delayed_Ext [DelayedTXCounter_Ext] := RX_Buffer_Int;  { Delay and send to remote modules }
                                          BroadcastReplyTimer_Ext := BroadcastReplyTime_Ext;
                                        end;
                                    end;
                  Transport_Address,
                  $80..$FF: Case Local and Master of
                              True: begin                                   { Send to remote module }
                                      WDTCN := $A5;
                                      DelayTimer := CommRxEndWaitTime;
                                      Repeat
                                      until not Sending_Ext and ((RX_Counter_Ext = 0) or (DelayTimer = 0));
                                      Move (RX_Buffer_Int, TX_Buffer_Ext, RX_Buffer_Int.PacketSize);
                                      TX_Buffer_Ext.DestinationAddress := TX_Buffer_Ext.DestinationAddress and $7F;
                                      ActiveBuffer_Ext := True;
                                      CommandReceived_Int := False;

                                      RS485_Timer          := RS485_Time;
                                      RS485_Timer_External := RS485_Time_External;
                                      Ext_RS485_TX := True;
                                      Ext_RS485_TX_Int := True;

                                      SendPacket;
                                      Exit;
                                    end;
                              else  begin                            { Ignore it }
                                      CommandReceived_Int := False;
                                      Exit;
                                    end;
                            end;
                  $00..$0F: If RX_Buffer_Int.DestinationAddress <> Slot then
                              begin
                                CommandReceived_Int := False;
                                Exit;
                              end;                                   { Process command, local or remote }
                  else      If not Local and (RX_Buffer_Int.SourceAddress <> PC_AddressSetup) then
                              begin                                  { Send to local module, COM, PC... }
                                WDTCN := $A5;
                                DelayTimer := CommRxEndWaitTime;
                                Repeat
                                until not Sending_Ext;
                                Move (RX_Buffer_Int, TX_Buffer_Ext, RX_Buffer_Int.PacketSize);
                                ActiveBuffer_Ext := True;
                                CommandReceived_Int := False;
                                SendPacket;
                                Exit;
                              end;
                end;
                ProcessCommands (sInternal);                                 { Process broadcast or normal command }
              end;
    ptPanasonic: begin
                   RX_Buffer_Int.StartByte                := TurboStartByte;
                   RX_Buffer_Int.Command                  := Cmd_Transport;
                   RX_Buffer_Int.SourceAddress_Frame      := InterFrameAddress;
                   RX_Buffer_Int.SourceAddress            := Slot;
                   RX_Buffer_Int.DestinationAddress       := COM_ModuleAddress;
                   RX_Buffer_Int.DestinationAddress_Frame := InterFrameAddress;
                   RX_Buffer_Int.OriginalAddress          := Slot;
                   RX_Buffer_Int.GatewayAddress           := $FF;
                   RX_Buffer_Int.CommandFlags             := [];
                   RX_Buffer_Int.Spare                    := 0;

                   WDTCN := $A5;
                   DelayTimer := CommRxEndWaitTime;
                   Repeat
                   until not Sending_Ext and ((RX_Counter_Ext = 0) or (DelayTimer = 0));
                   Move (RX_Buffer_Int, TX_Buffer_Ext, RX_Buffer_Int.PacketSize);      { Forward from remote module to local module }
                   ActiveBuffer_Ext := True;
                   SendPacket;
                 end;
  end;

  CommandReceived_Int := False;
end;

Procedure ProcessCommands_Ext;
begin
  If not CommandReceived_Ext then Exit;

  Case Local of
    True: begin                                                { LOCAL }
            If Master then                                     { Forward packet from remote module to local module }
              begin
                WDTCN := $A5;
                DelayTimer := CommRxEndWaitTime;
                Repeat
                until not Sending_Int;
                Move (RX_Buffer_Ext, TX_Buffer_Int, RX_Buffer_Ext.PacketSize);
                TX_Buffer_Int.GatewayAddress := Slot;                                      { Local FOM3000 is gateway }
                For TempByte := 1 to 16 do
                  If RemoteSlots [TempByte] = TX_Buffer_Int.SourceAddress then
                    begin
                      TX_Buffer_Int.OriginalAddress := TX_Buffer_Int.SourceAddress;
                      TX_Buffer_Int.SourceAddress := $80 or (TempByte - 1);                { Translate address back }
                      ActiveBuffer_Ext := False;
                      SendPacket;
                      TempByte := 16;                                                      { Break }
                    end;
              end;
          end;
    else  begin                                                                            { REMOTE }
            If (RX_Buffer_Ext.DestinationAddress = BroadcastAddress) and (RX_Buffer_Ext.Command = Cmd_ModuleData) then
              begin
                BroadcastReplyTimer_Ext := AdditionalReplyTimeForRemoteLinkModule + BroadcastReplyTime_Int; { It was already delayed for local modules }
                DelayPacketToExt := True;
              end;
            If (RX_Buffer_Ext.DestinationAddress <> Transport_Address) and
              ((RX_Buffer_Ext.DestinationAddress <> Slot) or (RX_Buffer_Ext.DestinationAddress = BroadcastAddress)) then
              begin                                                                        { Forward to other remote modules }
                WDTCN := $A5;
                DelayTimer := CommRxEndWaitTime;
                Repeat
                until not Sending_Int;
                Move (RX_Buffer_Ext, TX_Buffer_Int, RX_Buffer_Ext.PacketSize);
                ActiveBuffer_Ext := False;
                SendPacket;
              end;
          end;
  end;
  If (RX_Buffer_Ext.DestinationAddress = Slot) or
     (RX_Buffer_Ext.DestinationAddress = BroadcastAddress) or
     (RX_Buffer_Ext.DestinationAddress = Transport_Address) then
    ProcessCommands (sExternal);
  DelayPacketToExt := False;

  CommandReceived_Ext := False;
end;

Procedure SetTxBufferForLoopTestMessage;
begin
  WDTCN := $A5;
  DelayTimer := CommRxEndWaitTime;
  Repeat
  until not Sending_Ext;
  PTX_Buffer := Addr (TX_Buffer_Ext);
  ActiveBuffer_Ext := True;
  TX_Buffer_Ext.PacketSize               := PacketHeaderSize;
  TX_Buffer_Ext.SourceAddress_Frame      := InterFrameAddress;
  TX_Buffer_Ext.SourceAddress            := Slot;
  TX_Buffer_Ext.DestinationAddress       := BroadcastAddress;
  TX_Buffer_Ext.DestinationAddress_Frame := InterFrameAddress;
  TX_Buffer_Ext.OriginalAddress          := Slot;
  TX_Buffer_Ext.GatewayAddress           := $FF;
  TX_Buffer_Ext.Command                  := Cmd_Message;
  TX_Buffer_Ext.CommandFlags             := [cfLoopTest];
  TX_Buffer_Ext.Spare                    := 0;
end;

Procedure SetLinkLed;
begin
  Case ExtCommunicationTimer <> 0 of
    True: Case Local xor OtherModuleLocal of
            True: Led_VideoLink := Led_ON;                        { Different modules (local/remote) on each side }
            else  Led_VideoLink := Hi (BlinkTimer) and $04 <> 0;  { Same modules (local/remote) on each side }
          end;
    else  Led_VideoLink := Blink;
  end;
end;

begin
  Init;
  Repeat

    Case ErrorCode of
{$IFDEF DPS900 }
{$ELSE}
      ecTEA6415: Led_Error := Blink;
{$ENDIF}
      ecEEPROM:  Led_Error := Led_ON;
      else begin
             Led_Error := ErrorLedTimer = 0;
           end;
    end;
    WDTCN := $A5;
    WriteScreen;
    Overlay (OSD_SYD);

    WDTCN := $A5;
    Case TestMode of
      False: begin
               ProcessCommands_Int;
               WDTCN := $A5;
               ProcessCommands_Ext;
               WDTCN := $A5;

               Case Blink of
                 True: begin
                         Case P0.5 of
                           True: If I_DET_Counter <> 0 then Dec (I_DET_Counter);  { inactive }
                           else  If I_DET_Counter < FilterConstant then Inc (I_DET_Counter);  { active }
                         end;
                         I_DET_Active := I_DET_Counter > FilterConstant div 2;

                         A0 := False;               { Switch to U_DET }
                         A1 := True;
                         A2 := False;
                       end;
                 else
                         Case P0.5 of
                           True: If U_DET_Counter <> 0 then Dec (U_DET_Counter);  { inactive }
                           else  If U_DET_Counter < FilterConstant then Inc (U_DET_Counter);  { active }
                         end;
                         U_DET_Active := U_DET_Counter > FilterConstant div 2;

                         A0 := True;                { Switch to I_DET }
                         A1 := True;
                         A2 := False;
               end;

               Case RemoteLink of
                 True: If RemoteLinkCounter <> 0 then Dec (RemoteLinkCounter);  { inactive }
                 else  If RemoteLinkCounter < FilterConstant then Inc (RemoteLinkCounter);  { active }
               end;
               RemoteLinkActive := RemoteLinkCounter > FilterConstant div 2;

               Led_PowerSupply_I := not I_DET_Active and Blink;
               Led_PowerSupply_U := not U_DET_Active and Blink;

               Case Key_Enter of
                 False: Led_VideoLink := not OSD_SYD and Blink;
                 else SetLinkLed;
               end;
               Case Local of                          {  REMOTE  }

                 False: begin                         { vIn_NC, vIn_COM_Out, vIn_NC2, vIn_IO, vIn_OSD_Out, vIn_Optic_RX, vIn_VideoIn, vIn_Spare }
                          Case Key_Up of              { vOut_VideoOut, vOut_OSD_In, vOut_ExtSyncOut, vOut_IO, vOut_VideoOut_BUS, vOut_Optic_TX  }
                            False: begin
                                     VideoXPoint [vOut_VideoOut_BUS]  := vIn_OSD_Out;    { Local test on reomote side }
                                     VideoXPoint [vOut_VideoOut]      := vIn_OSD_Out;    { Local test on reomote side }
                                   end;
                            else begin
                                   VideoXPoint [vOut_VideoOut_BUS] := vIn_NC;
                                   VideoXPoint [vOut_VideoOut]     := vIn_Optic_RX;
                                   Case Key_Down of
                                     False: begin
                                            If LoopTestTimer < 50 then                      { Repeat loop test broadcast }
                                              begin
                                                SetTxBufferForLoopTestMessage;
                                                PTX_Buffer_Cmd_Message^.msByte0 := 1;
                                                SendPacket;
                                                LoopTestTimer := LoopTestTime;
                                              end else begin                                { Test communications }
                                                         Case SlowBlinkTimer and $01 <> 0 of
                                                           False: CommTestSent := False;
                                                           else If not CommTestSent and not Sending_Ext then
                                                                  begin
                                                                    TX_Buffer_Ext.PacketSize               := DefaultPacketSize;
                                                                    TX_Buffer_Ext.SourceAddress            := Slot;
                                                                    TX_Buffer_Ext.SourceAddress_Frame      := InterFrameAddress;
                                                                    TX_Buffer_Ext.DestinationAddress       := COM_ModuleAddress;
                                                                    TX_Buffer_Ext.DestinationAddress_Frame := InterFrameAddress;
                                                                    TX_Buffer_Ext.OriginalAddress          := Slot;
                                                                    TX_Buffer_Ext.GatewayAddress           := $FF;
                                                                    TX_Buffer_Ext.Command                  := Cmd_Message;
                                                                    TX_Buffer_Ext.CommandFlags             := [cfCommTest];
                                                                    TX_Buffer_Ext.Spare                    := 0;
                                                                    PTX_Buffer := @TX_Buffer_Ext;
                                                                    PTX_Buffer_Cmd_Message^.msByte0        := 1;             { Reply }
                                                                    ActiveBuffer_Ext := True;
                                                                    SendPacket;
                                                                    CommTestSent := True;
                                                                  end;
                                                         end;
                                                       end;
                                          end;
                                     else begin
                                            If LoopTestTimer <> 0 then
                                              begin
                                                LoopTestTimer := 0;
                                                SetTxBufferForLoopTestMessage;
                                                PTX_Buffer_Cmd_Message^.msByte0 := 0;
                                                SendPacket;
                                                SendPacketWithDelay (TxBlockDelay);
                                              end;
                                          end;
                                   end;
                                 end;
                          end;
                        end;
                 else
                                                      { LOCAL }
                        begin
                          Case LoopTestTimer of
                            0:   VideoXPoint [vOut_Optic_TX] := vIn_OSD_Out;                    { 26.11.2005 }
                            else VideoXPoint [vOut_Optic_TX] := vIn_Optic_RX;                   { Send video from remote over local back to remote side }
                          end;
                          Case Key_Up of              { vOut_VideoOut, vOut_OSD_In, vOut_ExtSyncOut, vOut_IO, vOut_VideoOut_BUS, vOut_Optic_TX  }
                            False: VideoXPoint [vOut_VideoOut] := vIn_OSD_Out;    { Local test on local side }
                            else   VideoXPoint [vOut_VideoOut] := vIn_Optic_RX;
                          end;
                        end;
               end;
               WDTCN := $A5;

               If ExtCommunicationTimer = 0 then      { 26.11.2005 }
                 begin
                  VideoXPoint [vOut_VideoOut] := vIn_OSD_Out;
                 end;

               SetVideoXPoints;
               If (DelayedTXCounter_Int <> 0) and (BroadcastReplyTimer_Int = 0) then
                 begin
                   TempByte := 0;
                   Repeat
                     WDTCN := $A5;
                     Repeat
                     until not Sending_Int;
                     Inc (TempByte);
                     Move (TX_Buffer_Delayed_Int [TempByte], TX_Buffer_Int, TX_Buffer_Delayed_Int [TempByte].PacketSize);
                     ActiveBuffer_Ext := False;
                     SendPacket;
                   until TempByte = DelayedTXCounter_Int;
                   DelayedTXCounter_Int := 0;
                 end;
               WDTCN := $A5;
               If (DelayedTXCounter_Ext <> 0) and (BroadcastReplyTimer_Ext = 0) then
                 begin
                   TempByte := 0;
                   Repeat
                     WDTCN := $A5;
                     Repeat
                     until not Sending_Ext;
                     Inc (TempByte);
                     Move (TX_Buffer_Delayed_Ext [TempByte], TX_Buffer_Ext, TX_Buffer_Delayed_Ext [TempByte].PacketSize);
                     ActiveBuffer_Ext := True;
                     SendPacket;
                   until TempByte = DelayedTXCounter_Ext;
                   DelayedTXCounter_Ext := 0;
                 end;
             end;
      else begin
             WDTCN := $A5;
             SetLinkLed;
             ProcessTestKey;
             SetTestXPoints;
           end;
    end;
    WDTCN := $A5;
  until False;
end.
