; Turbo51 version 0.0.0.13, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_CONST        SEGMENT  CODE
_DATA         SEGMENT  DATA
_XDATA        SEGMENT  XDATA
_BIT          SEGMENT  BIT

              PUBLIC   Ch

              PUBLIC   Attribute
              PUBLIC   BackgroundColor
              PUBLIC   OsdString
              PUBLIC   X
              PUBLIC   Y
              PUBLIC   RowY
              PUBLIC   OverlayOn
              PUBLIC   DataWord

              PUBLIC   SendWord
              PUBLIC   InitOsd
              PUBLIC   SetBackground
              PUBLIC   WriteAtXY
              PUBLIC   WriteAtRow
              PUBLIC   Overlay
              PUBLIC   ClearScreen

              EXTRN    CODE  (sysWordMultiplication)

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit KS5520;
; 
; {$XDATA }
; 
; Interface
; 
; Const bcRed     = 0;

RSEG _CONST

;       bcBlue    = 3;
;       bcMagenta = 4;
;       bcYellow  = 5;
;       bcGreen   = 6;
;       bcGray    = 7;
; 
; Var Attribute: Word XDATA;

RSEG _XDATA

Attribute:                      DS       2

;     BackgroundColor: Byte;

RSEG _DATA

BackgroundColor:                DS       1

;     OsdString: String [30] XDATA;

RSEG _XDATA

OsdString:                      DS       31

;     OSD_SCK: Boolean absolute Forward;
              EXTRN    BIT   (OSD_SCK)

;     OSD_SIN: Boolean absolute Forward;
              EXTRN    BIT   (OSD_SIN)

;     OSD_CSB: Boolean absolute Forward;
              EXTRN    BIT   (OSD_CSB)

; 
; {$MP XDATA}
; Procedure InitOsd;
; Procedure SetBackground;
; Procedure WriteAtXY (X, Y: Byte);
X:                              DS       1
Y:                              DS       1

; Procedure WriteAtRow (RowY: Byte);
RowY:                           DS       1

; Procedure Overlay (OverlayOn: Boolean);

RSEG _BIT

OverlayOn:                      DBIT     1

; Procedure ClearScreen;
; 
; Implementation
; 
; Const c_   = '~';

RSEG _CONST

;       s_   = '{';
;       z_   = '`';
;       CC_  = '^';
;       SS_  = '[';
;       ZZ_  = '@';
;       c__  = '}';
;       CC__ = ']';
;       dz   = '|';
;       DZ_  = '\';
; 
;       Low = False;
;       High = True;
; 
;       Ch: Array [' '..''] of Byte = (
Ch:                             
;                 $FF, {   20 }
                                DB        $FF                         ; $FF = 255

;                 $CF, { ! 21 }
                                DB        $CF                         ; $CF = 207

;                 $DA, { " 22 }
                                DB        $DA                         ; $DA = 218

;                 $EE, { # 23 }
                                DB        $EE                         ; $EE = 238

;                 $FF, { $ 24 }
                                DB        $FF                         ; $FF = 255

;                 $FF, { % 25 }
                                DB        $FF                         ; $FF = 255

;                 $CA, { & 26 }
                                DB        $CA                         ; $CA = 202

;                 $FF, { ' 27 }
                                DB        $FF                         ; $FF = 255

;                 $C3, { ( 28 }
                                DB        $C3                         ; $C3 = 195

;                 $C4, { ) 29 }
                                DB        $C4                         ; $C4 = 196

;                 $FF, { * 2A }
                                DB        $FF                         ; $FF = 255

;                 $C5, { + 2B }
                                DB        $C5                         ; $C5 = 197

;                 $CD, { , 2C }
                                DB        $CD                         ; $CD = 205

;                 $C6, { - 2D }
                                DB        $C6                         ; $C6 = 198

;                 $CE, { . 2E }
                                DB        $CE                         ; $CE = 206

;                 $C8, { / 2F }
                                DB        $C8                         ; $C8 = 200

;                 $00, { 0 30 }
                                DB        0                           ; $00 = 0

;                 $01, { 1 31 }
                                DB        1                           ; $01 = 1

;                 $02, { 2 32 }
                                DB        2                           ; $02 = 2

;                 $03, { 3 33 }
                                DB        3                           ; $03 = 3

;                 $04, { 4 34 }
                                DB        4                           ; $04 = 4

;                 $05, { 5 35 }
                                DB        5                           ; $05 = 5

;                 $06, { 6 36 }
                                DB        6                           ; $06 = 6

;                 $07, { 7 37 }
                                DB        7                           ; $07 = 7

;                 $08, { 8 38 }
                                DB        8                           ; $08 = 8

;                 $09, { 9 39 }
                                DB        9                           ; $09 = 9

;                 $CB, { : 3A }
                                DB        $CB                         ; $CB = 203

;                 $FF, { ; 3B }
                                DB        $FF                         ; $FF = 255

;                 $FF, { < 3C }
                                DB        $FF                         ; $FF = 255

;                 $C9, { = 3D }
                                DB        $C9                         ; $C9 = 201

;                 $FF, { > 3E }
                                DB        $FF                         ; $FF = 255

;                 $D0, { ? 3F }
                                DB        $D0                         ; $D0 = 208

;                 $53, { @ 4A } { Z^ }
                                DB        $53                         ; $53 = 83

;                 $0A, { A 41 }
                                DB        $0A                         ; $0A = 10

;                 $0B, { B 42 }
                                DB        $0B                         ; $0B = 11

;                 $0C, { C 43 }
                                DB        $0C                         ; $0C = 12

;                 $0D, { D 44 }
                                DB        $0D                         ; $0D = 13

;                 $0E, { E 45 }
                                DB        $0E                         ; $0E = 14

;                 $0F, { F 46 }
                                DB        $0F                         ; $0F = 15

;                 $10, { G 47 }
                                DB        $10                         ; $10 = 16

;                 $11, { H 48 }
                                DB        $11                         ; $11 = 17

;                 $12, { I 49 }
                                DB        $12                         ; $12 = 18

;                 $13, { J 4A }
                                DB        $13                         ; $13 = 19

;                 $14, { K 4B }
                                DB        $14                         ; $14 = 20

;                 $15, { L 4C }
                                DB        $15                         ; $15 = 21

;                 $16, { M 4D }
                                DB        $16                         ; $16 = 22

;                 $17, { N 4E }
                                DB        $17                         ; $17 = 23

;                 $00, { O 4F }
                                DB        0                           ; $00 = 0

;                 $18, { P 50 }
                                DB        $18                         ; $18 = 24

;                 $19, { Q 51 }
                                DB        $19                         ; $19 = 25

;                 $1A, { R 52 }
                                DB        $1A                         ; $1A = 26

;                 $1B, { S 53 }
                                DB        $1B                         ; $1B = 27

;                 $1C, { T 54 }
                                DB        $1C                         ; $1C = 28

;                 $1D, { U 55 }
                                DB        $1D                         ; $1D = 29

;                 $1E, { V 56 }
                                DB        $1E                         ; $1E = 30

;                 $1F, { W 57 }
                                DB        $1F                         ; $1F = 31

;                 $20, { X 58 }
                                DB        $20                         ; $20 = 32

;                 $21, { Y 59 }
                                DB        $21                         ; $21 = 33

;                 $22, { Z 5A }
                                DB        $22                         ; $22 = 34

;                 $51, { [ 5B } { S^ }
                                DB        $51                         ; $51 = 81

;                 $70, { \ 5C } { DZ }
                                DB        $70                         ; $70 = 112

;                 $7B, { ] 5D } { C' }
                                DB        $7B                         ; $7B = 123

;                 $4C, { ^ 5E } { C^ }
                                DB        $4C                         ; $4C = 76

;                 $FF, { _ 5F }
                                DB        $FF                         ; $FF = 255

;                 $5B, { ` 60 } { z^ }
                                DB        $5B                         ; $5B = 91

;                 $23, { a 61 }
                                DB        $23                         ; $23 = 35

;                 $24, { b 62 }
                                DB        $24                         ; $24 = 36

;                 $25, { c 63 }
                                DB        $25                         ; $25 = 37

;                 $26, { d 64 }
                                DB        $26                         ; $26 = 38

;                 $27, { e 65 }
                                DB        $27                         ; $27 = 39

;                 $28, { f 66 }
                                DB        $28                         ; $28 = 40

;                 $29, { g 67 }
                                DB        $29                         ; $29 = 41

;                 $2A, { h 68 }
                                DB        $2A                         ; $2A = 42

;                 $2B, { i 69 }
                                DB        $2B                         ; $2B = 43

;                 $2C, { j 6A }
                                DB        $2C                         ; $2C = 44

;                 $2D, { k 6B }
                                DB        $2D                         ; $2D = 45

;                 $2E, { l 6C }
                                DB        $2E                         ; $2E = 46

;                 $2F, { m 6D }
                                DB        $2F                         ; $2F = 47

;                 $30, { n 6E }
                                DB        $30                         ; $30 = 48

;                 $31, { o 6F }
                                DB        $31                         ; $31 = 49

;                 $32, { p 70 }
                                DB        $32                         ; $32 = 50

;                 $33, { q 71 }
                                DB        $33                         ; $33 = 51

;                 $34, { r 72 }
                                DB        $34                         ; $34 = 52

;                 $35, { s 73 }
                                DB        $35                         ; $35 = 53

;                 $36, { t 74 }
                                DB        $36                         ; $36 = 54

;                 $37, { u 75 }
                                DB        $37                         ; $37 = 55

;                 $38, { v 76 }
                                DB        $38                         ; $38 = 56

;                 $39, { w 77 }
                                DB        $39                         ; $39 = 57

;                 $3A, { x 78 }
                                DB        $3A                         ; $3A = 58

;                 $3B, { y 79 }
                                DB        $3B                         ; $3B = 59

;                 $3C, { z 7A }
                                DB        $3C                         ; $3C = 60

;                 $59, { { 7B } { s^ }
                                DB        $59                         ; $59 = 89

;                 $76, { | 7C } { dz }
                                DB        $76                         ; $76 = 118

;                 $82, {   7D } { c' }
                                DB        $82                         ; $82 = 130

;                 $54, { ~ 7E } { c^ }
                                DB        $54                         ; $54 = 84

;                 $EC);{  7F } { circle }
                                DB        $EC                         ; $EC = 236

; 
; {$MP XDATA }
; Procedure SendWord (DataWord: Word);

RSEG _XDATA

DataWord:                       DS       2

; Var Bit: Byte;

RSEG _DATA

Bit:                            DS       1

USING 0

SendWord:
; begin
;   For Bit := 0 to 7 do
              MOV       R2, #$FF
L_0002:
              INC       R2

;     begin
;       OSD_SCK := Low;
              CLR       OSD_SCK

;       OSD_SIN := Lo (DataWord) and $01 <> 0;
              MOV       DPTR, #DataWord
              MOVX      A, @DPTR
              RRC       A
              MOV       OSD_SIN, C

;       Asm
;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;       end;
;       OSD_SCK := High;
              SETB      OSD_SCK

;       Asm
;         MOV    DPTR, #DataWord
              MOV       DPTR, #DataWord

;         MOVX   A, @DPTR
              MOVX      A, @DPTR

;         RRC    A
              RRC       A

;         MOVX   @DPTR, A
              MOVX      @DPTR, A

;       end;
;     end;
              CJNE      R2, #7, L_0002

;   For Bit := 0 to 7 do
              MOV       R2, #$FF
L_001D:
              INC       R2

;     begin
;       OSD_SCK := Low;
              CLR       OSD_SCK

;       OSD_SIN := Hi (DataWord) and $01 <> 0;
              MOV       DPTR, #DataWord+1
              MOVX      A, @DPTR
              RRC       A
              MOV       OSD_SIN, C

;       Asm
;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;         NOP
              NOP

;       end;
;       OSD_SCK := High;
              SETB      OSD_SCK

;       Asm
;         MOV    DPTR, #DataWord + 1
              MOV       DPTR, #DataWord+1

;         MOVX   A, @DPTR
              MOVX      A, @DPTR

;         RRC    A
              RRC       A

;         MOVX   @DPTR, A
              MOVX      @DPTR, A

;       end;
;     end;
              CJNE      R2, #7, L_001D

; end;
              RET

; 
; Const            {FEDCBA9876543210}

RSEG _CONST

;       _360     = %0001000001010111;
;       _361     = %0000000001001110;
;       _362     = %0000001100011000;
;       _363     = %0000000000000001;
;       _364     = %0100100010001000;
; 
;       osdInternal = $0400;
;       RAM_Erase   = $4000;
;       DisplayOn   = $2000;
; 
; Procedure InitOsd;

InitOsd:
; begin
;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (362);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($016A)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($016A)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_362 or RAM_Erase or BackgroundColor);
              MOV       A, BackgroundColor
              ORL       A, #LOW  ($4318)
              MOV       R2, A
              MOV       R3, #HIGH ($4318)
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   OSD_CSB := High;
              SETB      OSD_CSB

;   Asm
;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;   end;
;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (362);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($016A)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($016A)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_362 or DisplayOn or BackgroundColor);
              MOV       A, BackgroundColor
              ORL       A, #LOW  ($2318)
              MOV       R2, A
              MOV       R3, #HIGH ($2318)
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   OSD_CSB := High;
              SETB      OSD_CSB

;   Asm
;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;   end;
;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (360);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($0168)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0168)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_360);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($1057)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1057)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_361 or osdInternal);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($044E)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($044E)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_362 or DisplayOn or BackgroundColor);
              MOV       A, BackgroundColor
              ORL       A, #LOW  ($2318)
              MOV       R2, A
              MOV       R3, #HIGH ($2318)
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_363);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  (1)
              MOVX      @DPTR, A
              INC       DPTR
              DEC       A
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_364);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($4888)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($4888)
              MOVX      @DPTR, A
              LCALL     SendWord

;   OSD_CSB := High;
              SETB      OSD_CSB

;   Attribute := $1C00;
              MOV       DPTR, #Attribute
              MOV       A, #LOW  ($1C00)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($1C00)
              MOVX      @DPTR, A

; end;
              RET

; 
; Procedure SetBackground;

SetBackground:
; begin
;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (362);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($016A)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($016A)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_362 or DisplayOn or BackgroundColor);
              MOV       A, BackgroundColor
              ORL       A, #LOW  ($2318)
              MOV       R2, A
              MOV       R3, #HIGH ($2318)
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   OSD_CSB := High;
              SETB      OSD_CSB

; end;
              RET

; 
; Procedure WriteAtXY (X, Y: Byte);

RSEG _DATA

Turbo51_Temp_0000:              DS       1

WriteAtXY:
; begin
;   If Y > 11 then Exit;
              MOV       DPTR, #Y
              MOVX      A, @DPTR
              ADD       A, #-12
              JC        L_017F

;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (Word (Y) * 30 + X);
              MOV       DPTR, #X
              MOVX      A, @DPTR
              MOV       R4, A
              MOV       DPTR, #Y
              MOVX      A, @DPTR
              MOV       R2, A
              MOV       R3, #0
              MOV       R6, #LOW  ($001E)
              MOV       R7, #HIGH ($001E)
              LCALL     sysWordMultiplication
              MOV       A, R2
              ADD       A, R4
              MOV       R2, A
              MOV       A, R3
              ADDC      A, #0
              MOV       R3, A
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   For X := 1 to Length (OsdString) do
              MOV       DPTR, #OsdString
              MOVX      A, @DPTR
              MOV       R0, A
              CLR       A
              MOV       DPTR, #X
              MOVX      @DPTR, A
              MOV       A, R0
              JZ        L_017D
L_0146:
              MOV       DPTR, #X
              MOVX      A, @DPTR
              INC       A
              MOVX      @DPTR, A

;     SendWord (Attribute or Ch [OsdString [X]]);
              MOV       DPTR, #Attribute
              MOVX      A, @DPTR
              MOV       R4, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R5, A
              MOV       DPTR, #X
              MOVX      A, @DPTR
              ADD       A, #LOW  (OsdString)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (OsdString)
              MOV       DPH, A
              MOVX      A, @DPTR
              MOV       DPTR, #Ch-32
              MOVC      A, @A + DPTR
              ORL       A, R4
              MOV       R2, A
              CLR       A
              ORL       A, R5
              MOV       R3, A
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord
              MOV       DPTR, #X
              MOVX      A, @DPTR
              CJNE      A, AR0, L_0146
L_017D:

;   OSD_CSB := High;
              SETB      OSD_CSB

; end;
L_017F:
              RET

; 
; Procedure WriteAtRow (RowY: Byte);
Turbo51_Temp_0001:              DS       1

WriteAtRow:
; begin
;   If RowY > 11 then Exit;
              MOV       DPTR, #RowY
              MOVX      A, @DPTR
              ADD       A, #-12
              JC        L_01E6

;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (Word (RowY) * 30);
              MOVX      A, @DPTR
              MOV       R2, A
              MOV       R3, #0
              MOV       R6, #LOW  ($001E)
              MOV       R7, #HIGH ($001E)
              LCALL     sysWordMultiplication
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   For RowY := 1 to Length (OsdString) do
              MOV       DPTR, #OsdString
              MOVX      A, @DPTR
              MOV       R0, A
              CLR       A
              MOV       DPTR, #RowY
              MOVX      @DPTR, A
              MOV       A, R0
              JZ        L_01E4
L_01AD:
              MOV       DPTR, #RowY
              MOVX      A, @DPTR
              INC       A
              MOVX      @DPTR, A

;     SendWord (Attribute or Ch [OsdString [RowY]]);
              MOV       DPTR, #Attribute
              MOVX      A, @DPTR
              MOV       R4, A
              INC       DPTR
              MOVX      A, @DPTR
              MOV       R5, A
              MOV       DPTR, #RowY
              MOVX      A, @DPTR
              ADD       A, #LOW  (OsdString)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (OsdString)
              MOV       DPH, A
              MOVX      A, @DPTR
              MOV       DPTR, #Ch-32
              MOVC      A, @A + DPTR
              ORL       A, R4
              MOV       R2, A
              CLR       A
              ORL       A, R5
              MOV       R3, A
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord
              MOV       DPTR, #RowY
              MOVX      A, @DPTR
              CJNE      A, AR0, L_01AD
L_01E4:

;   OSD_CSB := High;
              SETB      OSD_CSB

; end;
L_01E6:
              RET

; 
; Procedure Overlay (OverlayOn: Boolean);

Overlay:
; begin
;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (361);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($0169)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($0169)
              MOVX      @DPTR, A
              LCALL     SendWord

;   Case OverlayOn of
;     True: SendWord (_361);
              JNB       OverlayOn, L_0208
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($004E)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($004E)
              MOVX      @DPTR, A
              LCALL     SendWord
              SJMP      L_0215
L_0208:

;     else  SendWord (_361 or osdInternal);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($044E)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($044E)
              MOVX      @DPTR, A
              LCALL     SendWord
L_0215:

;   end;
;   OSD_CSB := High;
              SETB      OSD_CSB

; end;
              RET

; 
; Procedure ClearScreen;

ClearScreen:
; begin
;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (362);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($016A)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($016A)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_362 or DisplayOn or RAM_Erase or BackgroundColor);
              MOV       A, BackgroundColor
              ORL       A, #LOW  ($6318)
              MOV       R2, A
              MOV       R3, #HIGH ($6318)
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   OSD_CSB := High;
              SETB      OSD_CSB

;   Asm
;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;     NOP
              NOP

;   end;
;   OSD_CSB := Low;
              CLR       OSD_CSB

;   SendWord (362);
              MOV       DPTR, #DataWord
              MOV       A, #LOW  ($016A)
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, #HIGH ($016A)
              MOVX      @DPTR, A
              LCALL     SendWord

;   SendWord (_362 or DisplayOn or BackgroundColor);
              MOV       A, BackgroundColor
              ORL       A, #LOW  ($2318)
              MOV       R2, A
              MOV       R3, #HIGH ($2318)
              MOV       DPTR, #DataWord
              MOV       A, R2
              MOVX      @DPTR, A
              INC       DPTR
              MOV       A, R3
              MOVX      @DPTR, A
              LCALL     SendWord

;   OSD_CSB := High;
              SETB      OSD_CSB

; end;
              RET

RSEG _CONST

; 
; end.

              END

