{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit KS5520;

{$XDATA }

Interface

Const bcRed     = 0;
      bcBlue    = 3;
      bcMagenta = 4;
      bcYellow  = 5;
      bcGreen   = 6;
      bcGray    = 7;

Var Attribute: Word XDATA;
    BackgroundColor: Byte;
    OsdString: String [30] XDATA;
    OSD_SCK: Boolean absolute Forward;
    OSD_SIN: Boolean absolute Forward;
    OSD_CSB: Boolean absolute Forward;

{$MP XDATA}
Procedure InitOsd;
Procedure SetBackground;
Procedure WriteAtXY (X, Y: Byte);
Procedure WriteAtRow (RowY: Byte);
Procedure Overlay (OverlayOn: Boolean);
Procedure ClearScreen;

Implementation

Const c_   = '~';
      s_   = '{';
      z_   = '`';
      CC_  = '^';
      SS_  = '[';
      ZZ_  = '@';
      c__  = '}';
      CC__ = ']';
      dz   = '|';
      DZ_  = '\';

      Low = False;
      High = True;

      Ch: Array [' '..''] of Byte = (
                $FF, {   20 }
                $CF, { ! 21 }
                $DA, { " 22 }
                $EE, { # 23 }
                $FF, { $ 24 }
                $FF, { % 25 }
                $CA, { & 26 }
                $FF, { ' 27 }
                $C3, { ( 28 }
                $C4, { ) 29 }
                $FF, { * 2A }
                $C5, { + 2B }
                $CD, { , 2C }
                $C6, { - 2D }
                $CE, { . 2E }
                $C8, { / 2F }
                $00, { 0 30 }
                $01, { 1 31 }
                $02, { 2 32 }
                $03, { 3 33 }
                $04, { 4 34 }
                $05, { 5 35 }
                $06, { 6 36 }
                $07, { 7 37 }
                $08, { 8 38 }
                $09, { 9 39 }
                $CB, { : 3A }
                $FF, { ; 3B }
                $FF, { < 3C }
                $C9, { = 3D }
                $FF, { > 3E }
                $D0, { ? 3F }
                $53, { @ 4A } { Z^ }
                $0A, { A 41 }
                $0B, { B 42 }
                $0C, { C 43 }
                $0D, { D 44 }
                $0E, { E 45 }
                $0F, { F 46 }
                $10, { G 47 }
                $11, { H 48 }
                $12, { I 49 }
                $13, { J 4A }
                $14, { K 4B }
                $15, { L 4C }
                $16, { M 4D }
                $17, { N 4E }
                $00, { O 4F }
                $18, { P 50 }
                $19, { Q 51 }
                $1A, { R 52 }
                $1B, { S 53 }
                $1C, { T 54 }
                $1D, { U 55 }
                $1E, { V 56 }
                $1F, { W 57 }
                $20, { X 58 }
                $21, { Y 59 }
                $22, { Z 5A }
                $51, { [ 5B } { S^ }
                $70, { \ 5C } { DZ }
                $7B, { ] 5D } { C' }
                $4C, { ^ 5E } { C^ }
                $FF, { _ 5F }
                $5B, { ` 60 } { z^ }
                $23, { a 61 }
                $24, { b 62 }
                $25, { c 63 }
                $26, { d 64 }
                $27, { e 65 }
                $28, { f 66 }
                $29, { g 67 }
                $2A, { h 68 }
                $2B, { i 69 }
                $2C, { j 6A }
                $2D, { k 6B }
                $2E, { l 6C }
                $2F, { m 6D }
                $30, { n 6E }
                $31, { o 6F }
                $32, { p 70 }
                $33, { q 71 }
                $34, { r 72 }
                $35, { s 73 }
                $36, { t 74 }
                $37, { u 75 }
                $38, { v 76 }
                $39, { w 77 }
                $3A, { x 78 }
                $3B, { y 79 }
                $3C, { z 7A }
                $59, { { 7B } { s^ }
                $76, { | 7C } { dz }
                $82, {   7D } { c' }
                $54, { ~ 7E } { c^ }
                $EC);{  7F } { circle }

{$MP XDATA }
Procedure SendWord (DataWord: Word);
Var Bit: Byte;
begin
  For Bit := 0 to 7 do
    begin
      OSD_SCK := Low;
      OSD_SIN := Lo (DataWord) and $01 <> 0;
      Asm
        NOP
        NOP
        NOP
        NOP
      end;
      OSD_SCK := High;
      Asm
        MOV    DPTR, #DataWord
        MOVX   A, @DPTR
        RRC    A
        MOVX   @DPTR, A
      end;
    end;
  For Bit := 0 to 7 do
    begin
      OSD_SCK := Low;
      OSD_SIN := Hi (DataWord) and $01 <> 0;
      Asm
        NOP
        NOP
        NOP
        NOP
      end;
      OSD_SCK := High;
      Asm
        MOV    DPTR, #DataWord + 1
        MOVX   A, @DPTR
        RRC    A
        MOVX   @DPTR, A
      end;
    end;
end;

Const            {FEDCBA9876543210}
      _360     = %0001000001010111;
      _361     = %0000000001001110;
      _362     = %0000001100011000;
      _363     = %0000000000000001;
      _364     = %0100100010001000;

      osdInternal = $0400;
      RAM_Erase   = $4000;
      DisplayOn   = $2000;

Procedure InitOsd;
begin
  OSD_CSB := Low;
  SendWord (362);
  SendWord (_362 or RAM_Erase or BackgroundColor);
  OSD_CSB := High;
  Asm
    NOP
    NOP
    NOP
    NOP
  end;
  OSD_CSB := Low;
  SendWord (362);
  SendWord (_362 or DisplayOn or BackgroundColor);
  OSD_CSB := High;
  Asm
    NOP
    NOP
    NOP
    NOP
  end;
  OSD_CSB := Low;
  SendWord (360);
  SendWord (_360);
  SendWord (_361 or osdInternal);
  SendWord (_362 or DisplayOn or BackgroundColor);
  SendWord (_363);
  SendWord (_364);
  OSD_CSB := High;
  Attribute := $1C00;
end;

Procedure SetBackground;
begin
  OSD_CSB := Low;
  SendWord (362);
  SendWord (_362 or DisplayOn or BackgroundColor);
  OSD_CSB := High;
end;

Procedure WriteAtXY (X, Y: Byte);
begin
  If Y > 11 then Exit;
  OSD_CSB := Low;
  SendWord (Word (Y) * 30 + X);
  For X := 1 to Length (OsdString) do
    SendWord (Attribute or Ch [OsdString [X]]);
  OSD_CSB := High;
end;

Procedure WriteAtRow (RowY: Byte);
begin
  If RowY > 11 then Exit;
  OSD_CSB := Low;
  SendWord (Word (RowY) * 30);
  For RowY := 1 to Length (OsdString) do
    SendWord (Attribute or Ch [OsdString [RowY]]);
  OSD_CSB := High;
end;

Procedure Overlay (OverlayOn: Boolean);
begin
  OSD_CSB := Low;
  SendWord (361);
  Case OverlayOn of
    True: SendWord (_361);
    else  SendWord (_361 or osdInternal);
  end;
  OSD_CSB := High;
end;

Procedure ClearScreen;
begin
  OSD_CSB := Low;
  SendWord (362);
  SendWord (_362 or DisplayOn or RAM_Erase or BackgroundColor);
  OSD_CSB := High;
  Asm
    NOP
    NOP
    NOP
    NOP
  end;
  OSD_CSB := Low;
  SendWord (362);
  SendWord (_362 or DisplayOn or BackgroundColor);
  OSD_CSB := High;
end;

end.
