; Turbo51 version 0.0.0.13, Copyright 2000 - 2011 Igor Funa

$REGISTERBANK (0)

_CODE         SEGMENT  CODE
_CONST        SEGMENT  CODE
_XDATA        SEGMENT  XDATA

              PUBLIC   InputData
              PUBLIC   OutputData

              PUBLIC   VideoXPoint
              PUBLIC   VOut
              PUBLIC   VIn
              PUBLIC   TempOutput

              PUBLIC   SetVideoXPoint
              PUBLIC   SetVideoXPoints

; {
;     This file is part of the Turbo51 code examples.
;     Copyright (C) 2008 - 2011 Igor Funa
; 
;     http://turbo51.com/
; 
;     This file is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; }
; 
; Unit TEA6415;
; 
; {$XDATA }
; 
; Interface
; 
; Type  TInputPin  = (pin5, pin8, pin3, pin20, pin6, pin10, pin1, pin11);
;       TOutputPin = (pin18, pin14, pin16, pin17, pin13, pin15);
; 
; Const I2C_TEA6415_GND = $86;

RSEG _CONST

;       I2C_TEA6415_VCC = $06;
;       I2C_TEA6415     = I2C_TEA6415_VCC;
; 
; Var VideoXPoint: Array [TOutputPin] of TInputPin XDATA;

RSEG _XDATA

VideoXPoint:                    DS       6

; 
; {$MP XDATA}
; Procedure SetVideoXPoint (VOut: TOutputPin; VIn: TInputPin);
VOut:                           DS       1
VIn:                            DS       1

; Procedure SetVideoXPoints;
; 
; Implementation
; 
; Uses C51F020;
; 
; Const InputData:  Array [TInputPin]  of Byte = ($0, $4, $2, $6, $1, $5, $3, $7);

RSEG _CONST

InputData:                      DB        0                           ; $00 = 0
                                DB        4                           ; $04 = 4
                                DB        2                           ; $02 = 2
                                DB        6                           ; $06 = 6
                                DB        1                           ; $01 = 1
                                DB        5                           ; $05 = 5
                                DB        3                           ; $03 = 3
                                DB        7                           ; $07 = 7

;       OutputData: Array [TOutputPin] of Byte = ($00, $20, $10, $08, $28, $18);
OutputData:                     DB        0                           ; $00 = 0
                                DB        $20                         ; $20 = 32
                                DB        $10                         ; $10 = 16
                                DB        8                           ; $08 = 8
                                DB        $28                         ; $28 = 40
                                DB        $18                         ; $18 = 24

; 
; Var TempOutput: TOutputPin XDATA;

RSEG _XDATA

TempOutput:                     DS       1

; 
; Procedure SetVideoXPoint (VOut: TOutputPin; VIn: TInputPin);

USING 0

SetVideoXPoint:
; begin
;   VideoXPoint [VOut] := VIn;
              MOV       DPTR, #VIn
              MOVX      A, @DPTR
              MOV       R1, A
              MOV       DPTR, #VOut
              MOVX      A, @DPTR
              ADD       A, #LOW  (VideoXPoint)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (VideoXPoint)
              MOV       DPH, A
              MOV       A, R1
              MOVX      @DPTR, A
              MOV       R2, #$A5

;   Repeat
L_0016:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until not BUSY;
              JB        $C0.7, L_0016

; 
;   STA := True;
              SETB      $C0.5

; 
;   Repeat until SI;
L_001D:
              JNB       $C0.3, L_001D

;   STA := False;
              CLR       $C0.5

;   SMB0DAT := I2C_TEA6415;
              MOV       $C2, #6

;   SI := False;
              CLR       $C0.3

; 
;   Repeat until SI;
L_0027:
              JNB       $C0.3, L_0027

;   SMB0DAT := OutputData [VOut] or InputData [VIn];
              MOV       DPTR, #VIn
              MOVX      A, @DPTR
              MOV       DPTR, #InputData
              MOVC      A, @A + DPTR
              MOV       R1, A
              MOV       DPTR, #VOut
              MOVX      A, @DPTR
              MOV       DPTR, #OutputData
              MOVC      A, @A + DPTR
              ORL       A, R1
              MOV       $C2, A

;   SI := False;
              CLR       $C0.3

; 
;   Repeat until SI;
L_0040:
              JNB       $C0.3, L_0040

; 
;   STO := True;
              SETB      $C0.4

;   SI := False;
              CLR       $C0.3

; end;
              RET

; 
; Procedure SetVideoXPoints;

SetVideoXPoints:
; begin
              MOV       R2, #$A5

;   Repeat
L_004A:
;     WDTCN := $A5;
              MOV       $FF, R2

;   until not BUSY;
              JB        $C0.7, L_004A

; 
;   STA := True;
              SETB      $C0.5

; 
;   Repeat until SI;
L_0051:
              JNB       $C0.3, L_0051

;   STA := False;
              CLR       $C0.5

;   SMB0DAT := I2C_TEA6415;
              MOV       $C2, #6

;   SI := False;
              CLR       $C0.3

; 
;   For TempOutput := pin18 to pin15 do
              MOV       DPTR, #TempOutput
              MOV       A, #$FF
              MOVX      @DPTR, A
L_0061:
              MOV       DPTR, #TempOutput
              MOVX      A, @DPTR
              INC       A
              MOVX      @DPTR, A

;     begin
;       Repeat until SI;
L_0067:
              JNB       $C0.3, L_0067

;       SMB0DAT := OutputData [TempOutput] or InputData [VideoXPoint [TempOutput]];
              MOV       DPTR, #TempOutput
              MOVX      A, @DPTR
              ADD       A, #LOW  (VideoXPoint)
              MOV       DPL, A
              CLR       A
              ADDC      A, #HIGH (VideoXPoint)
              MOV       DPH, A
              MOVX      A, @DPTR
              MOV       DPTR, #InputData
              MOVC      A, @A + DPTR
              MOV       R1, A
              MOV       DPTR, #TempOutput
              MOVX      A, @DPTR
              MOV       DPTR, #OutputData
              MOVC      A, @A + DPTR
              ORL       A, R1
              MOV       $C2, A

;       SI := False;
              CLR       $C0.3

;     end;
              MOV       DPTR, #TempOutput
              MOVX      A, @DPTR
              CJNE      A, #5, L_0061

; 
;   Repeat until SI;
L_0091:
              JNB       $C0.3, L_0091

; 
;   STO := True;
              SETB      $C0.4

;   SI := False;
              CLR       $C0.3

; end;
              RET

RSEG _CONST

; 
; end.

              END

