{
    This file is part of the Turbo51 code examples.
    Copyright (C) 2008 - 2011 Igor Funa

    http://turbo51.com/

    This file is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
}

Unit TEA6415;

{$XDATA }

Interface

Type  TInputPin  = (pin5, pin8, pin3, pin20, pin6, pin10, pin1, pin11);
      TOutputPin = (pin18, pin14, pin16, pin17, pin13, pin15);

Const I2C_TEA6415_GND = $86;
      I2C_TEA6415_VCC = $06;
      I2C_TEA6415     = I2C_TEA6415_VCC;

Var VideoXPoint: Array [TOutputPin] of TInputPin XDATA;

{$MP XDATA}
Procedure SetVideoXPoint (VOut: TOutputPin; VIn: TInputPin);
Procedure SetVideoXPoints;

Implementation

Uses C51F020;

Const InputData:  Array [TInputPin]  of Byte = ($0, $4, $2, $6, $1, $5, $3, $7);
      OutputData: Array [TOutputPin] of Byte = ($00, $20, $10, $08, $28, $18);

Var TempOutput: TOutputPin XDATA;

Procedure SetVideoXPoint (VOut: TOutputPin; VIn: TInputPin);
begin
  VideoXPoint [VOut] := VIn;
  Repeat
    WDTCN := $A5;
  until not BUSY;

  STA := True;

  Repeat until SI;
  STA := False;
  SMB0DAT := I2C_TEA6415;
  SI := False;

  Repeat until SI;
  SMB0DAT := OutputData [VOut] or InputData [VIn];
  SI := False;

  Repeat until SI;

  STO := True;
  SI := False;
end;

Procedure SetVideoXPoints;
begin
  Repeat
    WDTCN := $A5;
  until not BUSY;

  STA := True;

  Repeat until SI;
  STA := False;
  SMB0DAT := I2C_TEA6415;
  SI := False;

  For TempOutput := pin18 to pin15 do
    begin
      Repeat until SI;
      SMB0DAT := OutputData [TempOutput] or InputData [VideoXPoint [TempOutput]];
      SI := False;
    end;

  Repeat until SI;

  STO := True;
  SI := False;
end;

end.
